/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Locale;
import java.util.Properties;

public class FileSystemResourceBundle
extends Properties {
    private static final long serialVersionUID = 1L;

    public static FileSystemResourceBundle getFileSystemResourceBundle(String strBaseName, Locale locale) {
        return FileSystemResourceBundle.getFileSystemResourceBundle(strBaseName, locale.getLanguage(), locale.getCountry(), locale.getVariant());
    }

    public static FileSystemResourceBundle getFileSystemResourceBundle(String strBaseName, String strLang, String strCountry, String strVariant) {
        String ext = ".properties";
        FileSystemResourceBundle stb = null;
        BufferedReader rdr = null;
        String strBaseFile = strBaseName.replace('.', '/');
        int iBaseNameLength = strBaseFile.length();
        StringBuffer sbTable = new StringBuffer();
        sbTable.append(strBaseFile);
        if (strLang != null && strLang.length() > 0) {
            sbTable.append("_");
            sbTable.append(strLang);
            if (strCountry != null && strCountry.length() > 0) {
                sbTable.append("_");
                sbTable.append(strCountry);
                if (strVariant != null && strVariant.length() > 0) {
                    sbTable.append("_");
                    sbTable.append(strVariant);
                }
            }
        }
        if (stb != null) {
            return stb;
        }
        FileSystemResourceBundle prevStb = null;
        FileSystemResourceBundle mainStb = null;
        String strFile = null;
        boolean bDone = false;
        boolean bFound = false;
        do {
            block17: {
                sbTable.append(ext);
                strFile = new String(sbTable);
                try {
                    FileInputStream is = null;
                    try {
                        is = new FileInputStream(new File(strFile));
                    }
                    catch (FileNotFoundException e) {
                    }
                    catch (SecurityException e) {
                        // empty catch block
                    }
                    if (is == null) break block17;
                    rdr = new BufferedReader(new InputStreamReader(is));
                    bFound = true;
                    stb = new FileSystemResourceBundle();
                    if (stb == null) {
                        return null;
                    }
                    try {
                        FileSystemResourceBundle.loadStringTable(rdr, stb);
                        rdr.close();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                        return null;
                    }
                    if (mainStb == null) {
                        mainStb = stb;
                    } else {
                        prevStb.defaults = stb;
                    }
                    prevStb = stb;
                }
                catch (Exception ee) {
                    // empty catch block
                }
            }
            int iNewSize = sbTable.toString().lastIndexOf(95);
            if (iNewSize >= iBaseNameLength) {
                sbTable.setLength(iNewSize);
                continue;
            }
            bDone = true;
        } while (!bDone);
        if (!bFound) {
            return null;
        }
        return mainStb;
    }

    private static void loadStringTable(BufferedReader in, FileSystemResourceBundle stb) throws IOException {
        int buflen = 80;
        char[] buf = new char[buflen];
        int bufindx = 0;
        int ch = in.read();
        block13: while (true) {
            switch (ch) {
                case -1: {
                    return;
                }
                case 33: 
                case 35: {
                    while ((ch = in.read()) >= 0 && ch != 10 && ch != 13) {
                    }
                    continue block13;
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    ch = in.read();
                    continue block13;
                }
            }
            bufindx = 0;
            while (ch >= 0 && ch != 61 && ch != 58 && ch != 32 && ch != 9 && ch != 10 && ch != 13) {
                if (bufindx >= buflen) {
                    char[] nbuf = new char[buflen *= 2];
                    System.arraycopy(buf, 0, nbuf, 0, buf.length);
                    buf = nbuf;
                }
                buf[bufindx++] = (char)ch;
                ch = in.read();
            }
            while (ch == 32 || ch == 9) {
                ch = in.read();
            }
            if (ch == 61 || ch == 58) {
                ch = in.read();
            }
            while (ch == 32 || ch == 9) {
                ch = in.read();
            }
            String key = new String(buf, 0, bufindx);
            bufindx = 0;
            block18: while (ch >= 0 && ch != 10 && ch != 13) {
                int next = 0;
                if (ch != 92) {
                    next = in.read();
                } else {
                    ch = in.read();
                    switch (ch) {
                        case 13: {
                            ch = in.read();
                            if (ch != 10 && ch != 32 && ch != 9) continue block18;
                        }
                        case 10: {
                            while ((ch = in.read()) == 32 || ch == 9) {
                            }
                            continue block18;
                        }
                        case 116: {
                            ch = 9;
                            next = in.read();
                            break;
                        }
                        case 110: {
                            ch = 10;
                            next = in.read();
                            break;
                        }
                        case 114: {
                            ch = 13;
                            next = in.read();
                            break;
                        }
                        case 117: {
                            ch = FileSystemResourceBundle.readUnicodeChar(in);
                            next = in.read();
                            break;
                        }
                        default: {
                            next = in.read();
                        }
                    }
                }
                if (bufindx >= buflen) {
                    char[] nbuf = new char[buflen *= 2];
                    System.arraycopy(buf, 0, nbuf, 0, buf.length);
                    buf = nbuf;
                }
                buf[bufindx++] = (char)ch;
                ch = next;
            }
            String val = new String(buf, 0, bufindx);
            stb.put(key, val);
        }
    }

    private static int readUnicodeChar(BufferedReader in) throws IOException {
        char ch;
        while ((ch = (char)in.read()) == 'u') {
        }
        int d = 0;
        block6: for (int i = 0; i < 4; ++i) {
            switch (ch) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    d = (d << 4) + ch - 48;
                    break;
                }
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    d = (d << 4) + 10 + ch - 97;
                    break;
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': {
                    d = (d << 4) + 10 + ch - 65;
                    break;
                }
                default: {
                    break block6;
                }
            }
            if (i >= 3) continue;
            ch = (char)in.read();
        }
        return d;
    }
}

