/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.DateValue;
import com.novell.admin.ns.HexValue;
import com.novell.admin.ns.IncompatibleComponentException;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.Syntax;
import com.novell.admin.ns.Value;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.ldap.LDAPSyntax;
import com.novell.admin.ns.nds.BackLinkFacade;
import com.novell.admin.ns.nds.CaseIgnoreListFacade;
import com.novell.admin.ns.nds.EmailAddressFacade;
import com.novell.admin.ns.nds.FaxNumberFacade;
import com.novell.admin.ns.nds.HoldFacade;
import com.novell.admin.ns.nds.NDSSyntax;
import com.novell.admin.ns.nds.NetAddressFacade;
import com.novell.admin.ns.nds.ObjectACLFacade;
import com.novell.admin.ns.nds.OctetListFacade;
import com.novell.admin.ns.nds.PathFacade;
import com.novell.admin.ns.nds.PostalAddressFacade;
import com.novell.admin.ns.nds.ReplicaPointerFacade;
import com.novell.admin.ns.nds.TimeStampFacade;
import com.novell.admin.ns.nds.TypedNameFacade;
import com.novell.admin.ns.nds.UnknownFacade;
import com.novell.emframe.dev.DataHandlerHelper;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.XmlUtils;
import com.novell.emframe.dev.eDirAccessServiceException;
import com.novell.emframe.fw.FwUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.jdom.Element;

public class FileUploadHandler
extends DataHandlerHelper {
    ValueComponent vc = null;

    protected void valueComponentToXml(ValueComponent vc, StringBuffer resultValue, String attrName, Syntax syntax) throws eDirAccessServiceException {
        resultValue.append("<value>");
        if (vc instanceof Value) {
            this.vcToXmlSimple(resultValue, vc, attrName);
        } else if (vc instanceof ValueList) {
            this.vcToXmlComplex(syntax, vc, resultValue);
        }
        resultValue.append("</value>");
    }

    public void setString(Object target, String attributeName, String value, MContext context) throws eDirAccessServiceException {
        Enumeration myenum;
        NSObject nsobj;
        ObjectAttribute attribute;
        if (target instanceof NSObject && (attribute = (nsobj = (NSObject)target).getAttribute(attributeName)) != null && (myenum = attribute.getValueComponents()).hasMoreElements()) {
            this.vc = (ValueComponent)myenum.nextElement();
        }
        super.setString(target, attributeName, value, context);
    }

    protected ValueComponent xmlToValueComponent(AttributeDefinition attributeDefinition, Element xml, MContext context) throws ComponentCreationException, IncompatibleComponentException, eDirAccessServiceException {
        String paramName = xml.getAttributeValue("fileParam");
        HttpServletRequest req = context.getRequest();
        String fileName = req.getParameter(paramName);
        if (fileName != null && fileName.length() != 0) {
            try {
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(context.getWebappHome() + "/tempFiles/" + fileName));
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                FwUtils.copyData(in, out);
                return NDSSyntax.SYN_OCTET_STRING.createValueComponent((Object)out.toByteArray());
            }
            catch (IOException e) {
                throw new eDirAccessServiceException(e);
            }
        }
        if (xml.getText().equals("DELETE")) {
            return null;
        }
        return this.vc;
    }

    private final void vcToXmlComplex(Syntax syntax, ValueComponent vc, StringBuffer resultValue) {
        if (syntax == NDSSyntax.SYN_BACK_LINK || syntax == LDAPSyntax.SYN_TAGGED_NAME) {
            long aLong = ((BackLinkFacade)((ValueList)vc).createFacade()).getRemoteId();
            resultValue.append("<remote-id>" + aLong + "</remote-id>");
            String value = ((BackLinkFacade)((ValueList)vc).createFacade()).getObjectName();
            resultValue.append("<object-name>" + XmlUtils.xmlEncode(value) + "</object-name>");
        } else if (syntax == NDSSyntax.SYN_CI_LIST || syntax == LDAPSyntax.SYN_CI_LIST) {
            String[] strList = ((CaseIgnoreListFacade)((ValueList)vc).createFacade()).getStrings();
            if (strList.length > 0) {
                resultValue.append(XmlUtils.xmlEncode(strList[0]));
            }
            for (int i = 1; i < strList.length; ++i) {
                resultValue.append("</value><value>");
                resultValue.append(XmlUtils.xmlEncode(strList[i]));
            }
        } else if (syntax == NDSSyntax.SYN_EMAIL_ADDRESS || syntax == LDAPSyntax.SYN_TAGGED_STRING) {
            String value = ((EmailAddressFacade)((ValueList)vc).createFacade()).getAddress();
            resultValue.append(XmlUtils.xmlEncode(value));
        } else if (syntax == NDSSyntax.SYN_FAX_NUMBER || syntax == LDAPSyntax.SYN_FAX_NUMBER) {
            String value = ((FaxNumberFacade)((ValueList)vc).createFacade()).getTeleNumber();
            resultValue.append(XmlUtils.xmlEncode(value));
        } else if (syntax == NDSSyntax.SYN_HOLD) {
            int aInt = ((HoldFacade)((ValueList)vc).createFacade()).getAmount();
            resultValue.append("<amount>" + aInt + "</amount>");
            String value = ((HoldFacade)((ValueList)vc).createFacade()).getSubject();
            resultValue.append("<subject>" + XmlUtils.xmlEncode(value) + "</subject>");
        } else if (syntax == NDSSyntax.SYN_OBJECT_ACL || syntax == LDAPSyntax.SYN_NDS_ACL) {
            long aLong = ((ObjectACLFacade)((ValueList)vc).createFacade()).getPrivileges();
            resultValue.append("<privileges>" + aLong + "</privileges>");
            String value = ((ObjectACLFacade)((ValueList)vc).createFacade()).getProtectedAttrName();
            resultValue.append("<protected-attr-name>" + XmlUtils.xmlEncode(value) + "</protected-attr-name>");
            value = ((ObjectACLFacade)((ValueList)vc).createFacade()).getSubjectName();
            resultValue.append("<subject>" + XmlUtils.xmlEncode(value) + "</subject>");
        } else if (syntax == LDAPSyntax.SYN_NVDS_ACL) {
            ObjectACLFacade fac = (ObjectACLFacade)((ValueList)vc).createFacade();
            long aLong = fac.getNVDSPrivileges();
            resultValue.append("<nvds-privileges>" + aLong + "</nvds-privileges>");
            aLong = fac.getNVDSModifier();
            resultValue.append("<nvds-modifier>" + aLong + "</nvds-modifier>");
            String value = fac.getNVDSTrustee();
            resultValue.append("<nvds-trustee>" + XmlUtils.xmlEncode(value) + "</nvds-trustee>");
            value = fac.getNVDSFilter();
            resultValue.append("<nvds-filter>" + XmlUtils.xmlEncode(value) + "</nvds-filter>");
            value = fac.getNVDSScope();
            resultValue.append("<nvds-scope>" + XmlUtils.xmlEncode(value) + "</nvds-scope>");
            value = fac.getNVDSClassName();
            resultValue.append("<nvds-classname>" + XmlUtils.xmlEncode(value) + "</nvds-classname>");
            value = fac.getNVDSAttributeName();
            resultValue.append("<nvds-attributename>" + XmlUtils.xmlEncode(value) + "</nvds-attributename>");
        } else if (syntax == NDSSyntax.SYN_OCTET_LIST || syntax == LDAPSyntax.SYN_OCTET_LIST) {
            byte[][] theByteList = ((OctetListFacade)((ValueList)vc).createFacade()).getOctets();
            for (int i = 0; i < theByteList.length; ++i) {
                String value = new String(theByteList[i]);
                resultValue.append("<item>" + XmlUtils.xmlEncode(value) + "</item>");
            }
        } else if (syntax == NDSSyntax.SYN_PATH || syntax == LDAPSyntax.SYN_TAGGED_NAME_AND_STRING) {
            long aLong = ((PathFacade)((ValueList)vc).createFacade()).getType();
            resultValue.append("<type>" + aLong + "</type>");
            String value = ((PathFacade)((ValueList)vc).createFacade()).getVolume();
            resultValue.append("<volume>" + XmlUtils.xmlEncode(value) + "</volume>");
            value = ((PathFacade)((ValueList)vc).createFacade()).getPath();
            resultValue.append("<path>" + XmlUtils.xmlEncode(value) + "</path>");
        } else if (syntax == NDSSyntax.SYN_PO_ADDRESS || syntax == LDAPSyntax.SYN_POSTAL_ADDRESS) {
            String[] strList = ((PostalAddressFacade)((ValueList)vc).createFacade()).getLines();
            for (int i = 0; i < strList.length; ++i) {
                resultValue.append("<item>" + XmlUtils.xmlEncode(strList[i]) + "</item>");
            }
        } else if (syntax == NDSSyntax.SYN_REPLICA_POINTER || syntax == LDAPSyntax.SYN_NDS_REPLICA_POINTER) {
            long aLong = ((ReplicaPointerFacade)((ValueList)vc).createFacade()).getReplicaType();
            resultValue.append("<replica-type>" + aLong + "</replica-type>");
            aLong = ((ReplicaPointerFacade)((ValueList)vc).createFacade()).getReplicaCount();
            resultValue.append("<replica-count>" + aLong + "</replica-count>");
            aLong = ((ReplicaPointerFacade)((ValueList)vc).createFacade()).getReplicaNumber();
            resultValue.append("<replica-number>" + aLong + "</replica-number>");
            String value = ((ReplicaPointerFacade)((ValueList)vc).createFacade()).getServerName();
            resultValue.append("<server-name>" + XmlUtils.xmlEncode(value) + "</server-name>");
            NetAddressFacade nFacade = ((ReplicaPointerFacade)((ValueList)vc).createFacade()).getNetworkAddressHint();
            resultValue.append("<net-address-hint>");
            aLong = nFacade.getAddressType();
            resultValue.append("<address-type>" + aLong + "</address-type>");
            byte[] bytes = nFacade.getAddress();
            value = new String(bytes);
            resultValue.append("<address>" + XmlUtils.xmlEncode(value) + "</address>");
            value = nFacade.getAddressString();
            resultValue.append("<address-string>" + XmlUtils.xmlEncode(value) + "</address-string>");
            resultValue.append("</net-address-hint>");
        } else if (syntax == NDSSyntax.SYN_TIMESTAMP || syntax == LDAPSyntax.SYN_NDS_TIMESTAMP) {
            long aInt = ((TimeStampFacade)((ValueList)vc).createFacade()).getSeconds();
            resultValue.append("<seconds>" + aInt + "</seconds>");
            aInt = ((TimeStampFacade)((ValueList)vc).createFacade()).getReplica();
            resultValue.append("<replica>" + aInt + "</replica>");
            aInt = ((TimeStampFacade)((ValueList)vc).createFacade()).getEvent();
            resultValue.append("<event>" + aInt + "</event>");
        } else if (syntax == NDSSyntax.SYN_TYPED_NAME || syntax == LDAPSyntax.SYN_TYPED_NAME) {
            String value = ((TypedNameFacade)((ValueList)vc).createFacade()).getObject();
            resultValue.append("<distinguished-name>" + XmlUtils.xmlEncode(value) + "</distinguished-name>");
            long aLong = ((TypedNameFacade)((ValueList)vc).createFacade()).getLevel();
            resultValue.append("<level>" + aLong + "</level>");
            aLong = ((TypedNameFacade)((ValueList)vc).createFacade()).getInterval();
            resultValue.append("<interval>" + aLong + "</interval>");
        } else if (syntax == NDSSyntax.SYN_UNKNOWN || syntax == LDAPSyntax.SYN_UNKNOWN) {
            String value = ((UnknownFacade)((ValueList)vc).createFacade()).getAttributeName();
            resultValue.append("<attribute-name>" + XmlUtils.xmlEncode(value) + "</attribute-name>");
            int aInt = ((UnknownFacade)((ValueList)vc).createFacade()).getSyntaxId();
            resultValue.append("<syntax-id>" + aInt + "</syntax-id>");
            byte[] bytes = ((UnknownFacade)((ValueList)vc).createFacade()).getBytes();
            value = new String(bytes);
            resultValue.append("<bytes>" + XmlUtils.xmlEncode(value) + "</bytes>");
        }
    }

    private void vcToXmlSimple(StringBuffer sb, ValueComponent vc, String attrName) throws eDirAccessServiceException {
        String value;
        if (vc instanceof HexValue) {
            byte[] bytes = ((HexValue)vc).getValue();
            StringBuffer hexString = new StringBuffer();
            for (int i = 0; i < bytes.length; ++i) {
                String hex;
                int val = bytes[i];
                if (val < 0) {
                    val += 256;
                }
                if ((hex = Integer.toHexString(val)).length() == 1) {
                    hexString.append("0");
                }
                hexString.append(hex.toUpperCase());
            }
            value = hexString.toString();
        } else if (vc instanceof DateValue) {
            Date theDate = ((DateValue)vc).getValue();
            value = Long.toString(theDate.getTime());
        } else {
            value = vc.toString();
        }
        String encodedValue = XmlUtils.xmlEncode(value);
        sb.append(encodedValue);
    }
}

