/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.ns.AdminNamespace;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.AuthBrokerException;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.GlobalRegistry;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.DirRoleList;
import com.novell.emframe.fw.FwAttr;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.RBSUtil;
import com.novell.emframe.fw.authenticator.DirAuthenticator;
import com.novell.emframe.fw.iManager;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import org.jdom.Document;
import org.jdom.Element;

public class FwDirUtils
extends DirUtils {
    static HashMap sm_hmAvailableImagePathsByImageName = new HashMap();

    public void init(DirAuthenticator dirAuth) {
        this.m_dirAuth = dirAuth;
        AuthenticationBroker broker = this.m_dirAuth.getAuthenticationBroker();
        try {
            this.treeOE = (ObjectEntry)broker.getProtocolObject("AdminNamespace");
        }
        catch (AuthBrokerException e) {
            D.log(e);
        }
        this.m_ns = this.treeOE.getAdminNamespace();
        this.resetInternalSchemaCache();
    }

    public static String getObjectTypeResourceFile(String objectTypeName) {
        return GlobalRegistry.getObjectTypeResourceFile(objectTypeName);
    }

    public static String getAttributeResourceFile(String attributeName) {
        return GlobalRegistry.getAttributeResourceFile(attributeName);
    }

    public static String getAvailableImagePath(String imageName) {
        return (String)sm_hmAvailableImagePathsByImageName.get(imageName);
    }

    public static void populateAvailableImages(File webappHome) {
        File imageHome = new File(webappHome, "/portal/modules/dev/images/dir");
        String[] images = imageHome.list();
        if (images != null) {
            for (int i = 0; i < images.length; ++i) {
                sm_hmAvailableImagePathsByImageName.put(images[i].toLowerCase(), images[i]);
            }
        }
        sm_hmAvailableImagePathsByImageName.put("_partitions_.gif", "PartitionInHistory.gif");
        sm_hmAvailableImagePathsByImageName.put("_root_.gif", "Top.gif");
    }

    public static void updateAccessMode(TaskContext context) {
        DirRoleList roleList;
        String accessMode = null;
        FwAttr.removeFwAuthAttr("Framework.Startup.RBSInstalled", context);
        accessMode = !FwUtils.isRBSEnabled(context) ? "Unrestricted" : ((roleList = RBSUtil.getDirRoleList(context)).isCollectionOwnerMode(context) ? "CollectionOwner" : "Assigned");
        FwAttr.setFwAuthAttribute("User.Mode", accessMode, DirAuthenticator.getDirAuth(context));
    }

    public String getFirstTypeFromASXMLCriterion(String criterion, TaskContext context) {
        String TYPES = eMFrameUtils.getLocalizedString("FwResources", "AS.XML.types", context);
        String ID = eMFrameUtils.getLocalizedString("FwResources", "AS.XML.id", context);
        String ret = null;
        try {
            StringReader r = new StringReader(criterion);
            Document document = iManager.getSaxBuilder().build((Reader)r);
            Element root = document.getRootElement();
            Element type = root.getChild(TYPES);
            ret = type.getChildTextTrim(ID);
        }
        catch (Exception e) {
            D.log(e);
        }
        return ret;
    }

    public static boolean isNVDS(AdminNamespace ns) {
        try {
            return ns.isSupported("NVDS");
        }
        catch (Exception e) {
            D.log(e);
            return false;
        }
    }
}

