/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.common.exceptions.LDAPSPIException;
import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.common.exceptions.UniqueSPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.HexValue;
import com.novell.admin.ns.LongValue;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.SchemaDefinition;
import com.novell.admin.ns.SchemaUtil;
import com.novell.admin.ns.StringValue;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.admin.ns.nds.NDSObjectAttribute;
import com.novell.admin.ns.nds.ObjectFlags;
import com.novell.admin.ns.nds.jclient.NDSNamespaceImpl;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectType;
import com.novell.emframe.authDev.iMgrAuthenticatorImpl;
import com.novell.emframe.dev.AuthBrokerException;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.Chapter;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.EmptyTask;
import com.novell.emframe.dev.GlobalRegistry;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.MappingObject;
import com.novell.emframe.dev.PluginException;
import com.novell.emframe.dev.authenticator.iMgrAuthenticator;
import com.novell.emframe.dev.config.SystemConfig;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.FwAttr;
import com.novell.emframe.fw.FwDirUtils;
import com.novell.emframe.fw.FwTaskContext;
import com.novell.emframe.fw.RBSUtil;
import com.novell.emframe.fw.Registry;
import com.novell.emframe.fw.RoleList;
import com.novell.emframe.fw.VersionInfo;
import com.novell.emframe.fw.authenticator.AuthLoader;
import com.novell.emframe.fw.authenticator.DirAuthenticator;
import com.novell.emframe.fw.authenticator.FwAuthUtils;
import com.novell.emframe.fw.config.ModuleInfo;
import com.novell.emframe.fw.config.ModuleManager;
import com.novell.emframe.fw.config.SystemConfigManager;
import com.novell.emframe.fw.legacySupport.LegacyTask;
import com.novell.emframe.fw.npsCompat.NPSCompatUtils;
import com.novell.emframe.fw.servlet.InterfaceCfg;
import com.novell.emframe.fw.util.InfoFactory;
import com.novell.emframe.fw.util.iManagerJDOMFactory;
import com.novell.emframe.fw.util.infos.RoleInfo;
import com.novell.nps.gadgetManager.DeviceUnsupportedException;
import com.novell.nps.serviceProviders.PortalModuleInstallManager;
import com.novell.rbs.RBSAssociation;
import com.novell.rbs.RBSNVDSRights;
import com.novell.rbs.RBSRights;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.SocketAddress;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipFile;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.JDOMFactory;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class FwUtils {
    private static String[] passwordRestrictionsExclusionList;
    private static String passwordRestrictionsInclusionRegEx;
    public static final String ENABLE_MODULESDOWNLOAD_ENABLE_PROXY = "ModulesDownloadEnableProxy";
    public static final String MODULESDOWNLOAD_PROXYHOST = "ModulesDownloadProxyHost";
    public static final String MODULESDOWNLOAD_PROXYPORT = "ModulesDownloadProxyPort";
    public static final String MODULESDOWNLOAD_PROXY_USERNAME = "ModulesDownloadProxyUserName";
    public static final String MODULESDOWNLOAD_PROXY_PASSWORD = "ModulesDownloadProxyPassword";
    static final char REPLACE_CHAR = '_';
    public static final String DEVICES_SETTING = "Devices";
    public static final String SPECIAL_STYLESHEET_DEVICES_SETTING = "SpecialStylesheetDevices";
    public static final String PORTAL_SESSION_ATTR_NAME = "PORTAL_SESSION";
    public static final String USERDN = "USERDN";
    public static final String USERCN = "USERCN";
    public static final String USER_EMAIL = "USER_EMAIL_ADDR";
    public static final String BROWSER_LOCALES_STRING = "BROWSER_LOCALES_STRING";
    public static final String BROWSER_LOCALES = "BROWSER_LOCALES";
    public static final String LANGUAGES_FOR_TRANSLATION = "FwUtils.LanguagesForTranslation";
    public static final String[] LANGUAGES_FOR_TRANSLATION_DEFAULT;
    private static final String SINGLE_GADGET_DEVICE = "SingGadDev";
    private static final String SPECIAL_STYLE_SHEET = "SpecialSS";
    private static final String CONTENT_TYPE = "ContentType";
    private static final String DEFAULT_CONTENT_TYPE = "text/html; charset=UTF-8";
    private static final String RENDER = "System.SessionManager.Render";
    private static final String RENDER_OVERRIDE = "System.SessionManager.RenderOverride";
    private static final String LOGIN_TIME = "System.SessionManager.LoginTime";
    public static final String SINGLE_GADGET_DEVICES_SETTING = "SingleGadgetDevices";
    private static final String SYSTEM_SKIN_NAME = "SystemSkinName";
    private static HashSet sm_singleGadgetDevices;
    private static HashSet sm_specialStylesheetDevices;
    private static String m_contentType;
    private static Boolean B_TRUE;
    private static Boolean B_FALSE;
    private static long applicationStartTime;
    private static final String sDontWarn = "FwUtils.DontWarn";
    public static boolean sm_showDeprecatedAttributeWarnings;
    public static boolean sm_checkedShowDeprecatedAttributeWarnings;

    public static void readPasswordRestrictionsFile(String prFileName) {
        File prFile = new File(prFileName);
        if (prFile.exists()) {
            try {
                int i;
                SAXBuilder saxBuilder = new SAXBuilder(false);
                saxBuilder.setFactory((JDOMFactory)iManagerJDOMFactory.getInstance());
                Document doc = saxBuilder.build(prFile);
                Element root = doc.getRootElement();
                passwordRestrictionsInclusionRegEx = root.getChild("inclusion-regular-expression").getTextTrim();
                List excludeList = root.getChildren("exclude-item");
                passwordRestrictionsExclusionList = new String[excludeList.size()];
                for (i = 0; i < excludeList.size(); ++i) {
                    Element e = (Element)excludeList.get(i);
                    FwUtils.passwordRestrictionsExclusionList[i] = e.getTextTrim();
                }
                if (passwordRestrictionsInclusionRegEx == null) {
                    passwordRestrictionsInclusionRegEx = "";
                }
                D.log("eMFrameUtils:: inclusion reg ex = " + FwUtils.getPasswordRestrictionsRegEx());
                D.log("eMFrameUtils:: exclude list = ");
                for (i = 0; i < passwordRestrictionsExclusionList.length; ++i) {
                    D.log("      " + passwordRestrictionsExclusionList[i]);
                }
            }
            catch (Exception e) {
                passwordRestrictionsInclusionRegEx = null;
                passwordRestrictionsExclusionList = null;
                D.log(e);
                D.log("Error processing password restriction xml file, not using extended password restrictions.");
            }
        }
    }

    public static String[] getPasswordRestrictionsExclusionList() {
        return passwordRestrictionsExclusionList;
    }

    public static String getPasswordRestrictionsRegEx() {
        return passwordRestrictionsInclusionRegEx;
    }

    public static RBSRights[] getPagesRights(String[] pageIds) {
        return FwUtils.getPagesRights(pageIds, null);
    }

    public static RBSRights[] getPagesRights(String[] pageIds, ObjectEntry oe) {
        Object[] rights;
        if (pageIds == null || pageIds.length < 1) {
            return null;
        }
        Vector vRights = new Vector();
        for (int index = 0; index < pageIds.length; ++index) {
            Document d = GlobalRegistry.getPluginDocument(pageIds[index]);
            if (d != null) {
                vRights.addAll(FwUtils.getTaskRights(d, oe));
                continue;
            }
            D.log("Error on Install: page doesn't exist [" + pageIds[index] + "]");
        }
        if (oe != null && FwDirUtils.isNVDS(oe.getAdminNamespace())) {
            rights = new RBSNVDSRights[vRights.size()];
            vRights.copyInto(rights);
        } else {
            rights = new RBSRights[vRights.size()];
            vRights.copyInto(rights);
        }
        return rights;
    }

    public static Vector getTaskRights(Document doc) {
        return FwUtils.getTaskRights(doc, null);
    }

    public static Vector getTaskRights(Document doc, ObjectEntry oe) {
        Vector<Object> vRights = new Vector<Object>();
        List elRights = doc.getRootElement().getChildren("rights-assignment");
        if (elRights != null && elRights.size() > 0) {
            for (int index = 0; index < elRights.size(); ++index) {
                Element current = (Element)elRights.get(index);
                if (current.getChildren().isEmpty()) continue;
                String attrName = current.getChildTextTrim("attribute-name");
                if (oe != null) {
                    attrName = SchemaUtil.translateNDAPAttr((ObjectEntry)oe, (String)attrName);
                }
                List lPriv = current.getChildren("privilege");
                String[] aPrivs = new String[lPriv.size()];
                for (int privIndex = 0; privIndex < lPriv.size(); ++privIndex) {
                    Element priv = (Element)lPriv.get(privIndex);
                    aPrivs[privIndex] = priv.getTextTrim();
                }
                if (oe != null && FwDirUtils.isNVDS(oe.getAdminNamespace())) {
                    vRights.add(new RBSNVDSRights(null, null, null, null, attrName, 0L, aPrivs));
                    continue;
                }
                vRights.add(new RBSRights(null, attrName, aPrivs));
            }
        }
        return vRights;
    }

    public static boolean isParamTrue(String parameter, MContext context) {
        String paramValue = context.getRequest().getParameter(parameter);
        return paramValue != null && paramValue.equalsIgnoreCase("true");
    }

    public static String[] getContainerTypes(MContext context) {
        return context.getDirUtils().getContainerTypes();
    }

    public static ArrayList getObjectEntryInheritedTypes(ObjectEntry oe) {
        ArrayList<String> types = new ArrayList<String>();
        ObjectType oeType = oe.getObjectType();
        types.add(oeType.getName());
        FwUtils.getInheritedTypes(oeType, types);
        return types;
    }

    public static void getInheritedTypes(ObjectType type, ArrayList list) {
        ObjectType[] parents = type.getParentTypes();
        if (parents != null) {
            for (int i = 0; i < parents.length; ++i) {
                if (parents[i] == null) {
                    D.log("A parent is null for ObjectType " + type.getName());
                    return;
                }
                if (!list.contains(parents[i].getName())) {
                    list.add(parents[i].getName());
                }
                FwUtils.getInheritedTypes(parents[i], list);
            }
        }
    }

    public static Document getRoleInfo(String roleId, MContext context) {
        Document doc = null;
        RoleInfo roleInfo = null;
        RoleList roleList = RoleList.getInstance(context);
        if (roleList != null) {
            roleInfo = roleList.getRole(roleId);
        }
        doc = roleInfo != null ? roleInfo.getDocument() : Registry.getRegistry("Install").getPluginDocument(roleId);
        return doc;
    }

    public static Document getTaskDocument(MContext context, String taskId) {
        RoleList roleList;
        Document doc = GlobalRegistry.getPluginDocument(taskId = FwUtils.getTaskId(taskId));
        if (doc == null && (roleList = RoleList.getInstance(context)) != null) {
            doc = roleList.getTaskDocument(taskId);
        }
        if (doc == null) {
            doc = Registry.getRegistry("Install").getPluginDocument(taskId);
        }
        return doc;
    }

    public static String getSafeName(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        char[] chars = string.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (Character.isLetterOrDigit(chars[i])) continue;
            chars[i] = 95;
        }
        if (Character.isDigit(chars[0])) {
            chars[0] = 95;
        }
        return new String(chars);
    }

    public static String[] getAllPageIds(MContext context, String[] strTypes) throws NamespaceException, SPIException {
        String[] selectableContainerTypes;
        int index;
        if (strTypes == null || strTypes.length < 1) {
            return null;
        }
        Vector v = new Vector();
        boolean found = false;
        for (index = 0; index < strTypes.length; ++index) {
            if (!strTypes[index].equalsIgnoreCase("[containers]")) continue;
            found = true;
            break;
        }
        if (!found && (selectableContainerTypes = context.getDirUtils().getSelectableContainerTypes()) != null) {
            for (int i = 0; i < selectableContainerTypes.length; ++i) {
                String selectableType = selectableContainerTypes[i];
                for (int j = 0; j < strTypes.length; ++j) {
                    if (!selectableType.equalsIgnoreCase(strTypes[j])) continue;
                    found = true;
                    eMFrameUtils.addUnique(v, FwUtils.getAllPageIdsForType(context, "[containers]"));
                    break;
                }
                if (found) break;
            }
        }
        for (index = 0; index < strTypes.length; ++index) {
            eMFrameUtils.addUnique(v, FwUtils.getAllPageIdsForType(context, strTypes[index]));
        }
        String[] ret = null;
        if (v != null && v.size() > 0) {
            ret = v.toArray(new String[v.size()]);
        }
        return ret;
    }

    public static Chapter[] getChapterIds(MContext context, String type) throws NamespaceException, SPIException {
        ArrayList<Chapter> chapters = new ArrayList<Chapter>();
        Document[] docs = FwUtils.getAllPageDocsForType(context, type);
        if (docs != null) {
            for (int j = 0; j < docs.length; ++j) {
                Element tmp = docs[j].getRootElement().getChild("chapter");
                if (tmp == null) continue;
                String chapterId = tmp.getChildTextTrim("id");
                String chapterKey = tmp.getChildTextTrim("display-name-key");
                String chapterFile = tmp.getChildTextTrim("resource-properties-file");
                Chapter chapter = Chapter.createChapter(chapterId, chapterFile, chapterKey);
                if (chapter == null || chapters.contains(chapter)) continue;
                chapters.add(chapter);
            }
        }
        if (chapters.size() > 0) {
            return chapters.toArray(new Chapter[chapters.size()]);
        }
        return null;
    }

    private static String[] getAllPageIdsForType(MContext context, String type) throws NamespaceException, SPIException {
        Document[] docs = FwUtils.getAllPageDocsForType(context, type);
        if (docs != null) {
            String[] ids = new String[docs.length];
            for (int i = 0; i < docs.length; ++i) {
                ids[i] = docs[i].getRootElement().getChildTextTrim("id");
            }
            return ids;
        }
        return null;
    }

    private static Document[] getAllPageDocsForType(MContext context, String type) throws NamespaceException, SPIException {
        if (type.equalsIgnoreCase("[containers]")) {
            ArrayList docs = new ArrayList();
            eMFrameUtils.addUnique(docs, GlobalRegistry.getPageDocs(type));
            eMFrameUtils.addUnique(docs, GlobalRegistry.getPrivatePageDocs(type));
            if (docs.size() > 0) {
                return docs.toArray(new Document[docs.size()]);
            }
            return null;
        }
        AuthenticationBroker broker = context.getAuthenticationBroker();
        ObjectEntry treeOE = null;
        try {
            treeOE = (ObjectEntry)broker.getProtocolObject("AdminNamespace");
        }
        catch (AuthBrokerException e) {
            D.log(e);
            return null;
        }
        AdminNamespace ns = treeOE.getAdminNamespace();
        SchemaDefinition schema = ns.getSchemaDefinition(treeOE);
        ClassDefinition classDefinition = schema.getClassDefinition(type);
        String[] classes = classDefinition.getSuperClasses();
        ArrayList docs = new ArrayList();
        eMFrameUtils.addUnique(docs, GlobalRegistry.getPageDocs(type));
        eMFrameUtils.addUnique(docs, GlobalRegistry.getPrivatePageDocs(type));
        for (int index = 0; index < classes.length; ++index) {
            eMFrameUtils.addUnique(docs, GlobalRegistry.getPageDocs(classes[index]));
        }
        if (docs.size() > 0) {
            return docs.toArray(new Document[docs.size()]);
        }
        return null;
    }

    public static String getWebappUrl(MContext context) {
        return context.getContextPath();
    }

    public static String getDefaulteGuideLocation(MContext context) {
        HttpServletRequest req = context.getRequest();
        String url = req.getScheme() + "://" + req.getServerName() + "/eGuide/servlet/eGuide";
        return url;
    }

    public static ArrayList getOVTypes(MContext context) {
        return FwUtils.getOVTypes(context, !FwUtils.isRBSEnabled(context));
    }

    public static boolean isRBSEnabled(MContext context) {
        return RBSUtil.isRBSInstalled(context);
    }

    public static ArrayList getOVTasksForObjects(String[] objectNames, MContext context) throws Exception {
        return FwUtils.getOVTasksForObjects(objectNames, context, !FwUtils.isRBSEnabled(context));
    }

    public static ArrayList getOVTypes(MContext context, boolean showAllTasks) {
        ArrayList<String> typeNames = new ArrayList<String>();
        if (showAllTasks) {
            typeNames.add("[root],*");
            return typeNames;
        }
        Hashtable tasksByType = (Hashtable)FwAttr.getFwAuthAttr("fw.tasksByType", context);
        if (tasksByType != null) {
            typeNames.addAll(tasksByType.keySet());
        }
        return typeNames;
    }

    public static ArrayList getOVTasksForObjects(String[] objectNames, MContext context, boolean showAllTasks) throws Exception {
        ArrayList<Object> aTasks = new ArrayList();
        if (context != null && objectNames != null && objectNames.length > 0) {
            boolean bMultipleObjects;
            ObjectEntry treeOE = null;
            AdminNamespace namespace = null;
            try {
                AuthenticationBroker broker = context.getAuthenticationBroker();
                treeOE = (ObjectEntry)broker.getProtocolObject("AdminNamespace");
                namespace = treeOE.getAdminNamespace();
            }
            catch (Exception e) {
                D.log("getOVTasksForObjects:  Couldn't find an namespace object");
                throw e;
            }
            ArrayList<ObjectType> ota = new ArrayList<ObjectType>();
            ObjectEntry oe = null;
            boolean bIsRootInArray = false;
            boolean bAllPartitions = true;
            boolean bAllNonPartitionedContainers = true;
            for (int i = 0; i < objectNames.length; ++i) {
                try {
                    if (treeOE.getName().equals(objectNames[i])) {
                        oe = treeOE;
                        bIsRootInArray = true;
                    } else {
                        oe = namespace.getObjectEntry(treeOE, objectNames[i]);
                        String objectType = oe.getObjectType().getName();
                        ota.add(oe.getObjectType());
                        if (objectType.equalsIgnoreCase("File") || objectType.equalsIgnoreCase("Directory") || objectType.equalsIgnoreCase("NetWare Volume")) {
                            bAllPartitions = false;
                            bAllNonPartitionedContainers = false;
                        }
                    }
                    if (!bAllPartitions && !bAllNonPartitionedContainers) continue;
                    long flags = oe.getObjectFlags();
                    boolean isPartition = ObjectFlags.isPartition((long)flags);
                    boolean isContainer = ObjectFlags.isContainer((long)flags);
                    if (!isPartition) {
                        bAllPartitions = false;
                    }
                    if (isContainer && !isPartition) continue;
                    bAllNonPartitionedContainers = false;
                    continue;
                }
                catch (Exception e) {
                    D.log("getOVTasksForObjects:  Couldn't find an ot for '" + objectNames[i] + "'");
                    D.log(e);
                    throw e;
                }
            }
            if (objectNames.length == 0) {
                bAllPartitions = false;
            }
            boolean bl = bMultipleObjects = objectNames.length > 1;
            if (ota.size() != 0 || bIsRootInArray) {
                Map commonTasks = null;
                int startIndex = 0;
                if (bIsRootInArray) {
                    commonTasks = FwUtils.getRootTasks(bMultipleObjects, showAllTasks, context);
                } else if (ota.size() != 0) {
                    commonTasks = FwUtils.getOVTasksForObject((ObjectType)ota.get(0), context, bMultipleObjects, showAllTasks);
                    startIndex = 1;
                }
                if (ota.size() != 0) {
                    Map tasksByType = null;
                    for (int i = startIndex; i < ota.size() && commonTasks != null && commonTasks.size() > 0; ++i) {
                        tasksByType = FwUtils.getOVTasksForObject((ObjectType)ota.get(i), context, bMultipleObjects, showAllTasks);
                        if (tasksByType == null) continue;
                        commonTasks.keySet().retainAll(tasksByType.keySet());
                    }
                }
                if (bAllPartitions) {
                    HashMap partitionTasks = new HashMap();
                    Map tasksByType = FwUtils.getTasksByTypeTable(showAllTasks, context);
                    HashMap tasksRegToLeaf = (HashMap)tasksByType.get("[partitions]");
                    if (tasksRegToLeaf != null) {
                        FwUtils.addValidTasks(partitionTasks, tasksRegToLeaf, bMultipleObjects, context);
                    }
                    if (partitionTasks != null) {
                        commonTasks.putAll(partitionTasks);
                    }
                } else if (bAllNonPartitionedContainers) {
                    HashMap nonPartitionTasks = new HashMap();
                    Map tasksByType = FwUtils.getTasksByTypeTable(showAllTasks, context);
                    Map tasksRegToLeaf = (Map)tasksByType.get("[non-partitions]");
                    if (tasksRegToLeaf != null) {
                        FwUtils.addValidTasks(nonPartitionTasks, tasksRegToLeaf, bMultipleObjects, context);
                    }
                    if (nonPartitionTasks != null) {
                        commonTasks.putAll(nonPartitionTasks);
                    }
                }
                if (commonTasks.size() > 0) {
                    aTasks = new ArrayList(commonTasks.values());
                }
            }
        }
        return aTasks;
    }

    private static Map getRootTasks(boolean bMultipleObjects, boolean showAllTasks, MContext context) {
        HashMap tasksById = new HashMap();
        Map tasksByType = FwUtils.getTasksByTypeTable(showAllTasks, context);
        if (tasksByType != null) {
            Map tasksRegToRoot = (Map)tasksByType.get("[root]");
            if (tasksRegToRoot != null) {
                FwUtils.addValidTasks(tasksById, tasksRegToRoot, bMultipleObjects, context);
            }
            if ((tasksRegToRoot = (Map)tasksByType.get("Tree Root")) != null) {
                FwUtils.addValidTasks(tasksById, tasksRegToRoot, bMultipleObjects, context);
            }
        }
        return tasksById;
    }

    private static ArrayList ensureObjectsAreInTasksScopes(String[] objectNames, ArrayList aTasks, boolean showAllTasks, MContext context) {
        if (showAllTasks) {
            return aTasks;
        }
        ArrayList<Document> ret = new ArrayList<Document>();
        Hashtable rbsaByTask = (Hashtable)context.getAuthAttribute("fw.RBSAssociationsByTask");
        if (rbsaByTask != null) {
            Iterator it = aTasks.iterator();
            while (it.hasNext()) {
                Document doc = (Document)it.next();
                String id = doc.getRootElement().getChildTextTrim("id");
                if (id == null) continue;
                ArrayList rbsas = (ArrayList)rbsaByTask.get(id);
                boolean addTask = false;
                if (rbsas == null) continue;
                Iterator it2 = rbsas.iterator();
                while (it2.hasNext()) {
                    RBSAssociation rbsAssociation = (RBSAssociation)it2.next();
                    ObjectEntry scope = rbsAssociation.getScope();
                    String inherited = rbsAssociation.getInheritanceScope();
                    boolean allInScope = true;
                    for (int i = 0; i < objectNames.length; ++i) {
                        String objectName = objectNames[i];
                        if (FwUtils.isInScope(objectName, scope, Boolean.getBoolean(inherited))) continue;
                        allInScope = false;
                        break;
                    }
                    if (!allInScope) continue;
                    addTask = true;
                    break;
                }
                if (!addTask) continue;
                ret.add(doc);
            }
        }
        return ret;
    }

    private static boolean isInScope(String objectName, ObjectEntry scope, boolean inherited) {
        AdminNamespace ns = scope.getAdminNamespace();
        String scopeName = ns.getUnrootedName(scope);
        return objectName.endsWith(scopeName);
    }

    private static Map getOVTasksForObject(ObjectType ot, MContext context, boolean bMultipleObjects, boolean showAllTasks) {
        HashMap tasks = new HashMap();
        Map tasksByType = FwUtils.getTasksByTypeTable(showAllTasks, context);
        if (tasksByType != null) {
            FwUtils.addTasksForType(tasks, ot, tasksByType, bMultipleObjects, context);
            String objectType = ot.getName();
            if (!(objectType.equalsIgnoreCase("File") || objectType.equalsIgnoreCase("Directory") || objectType.equalsIgnoreCase("NetWare Volume"))) {
                Map tasksRegToAll = (Map)tasksByType.get("*");
                if (tasksRegToAll != null) {
                    FwUtils.addValidTasks(tasks, tasksRegToAll, bMultipleObjects, context);
                }
                if (context.getDirUtils().isContainer(ot.getName())) {
                    Map tasksRegToCont = (Map)tasksByType.get("[containers]");
                    if (tasksRegToCont != null) {
                        FwUtils.addValidTasks(tasks, tasksRegToCont, bMultipleObjects, context);
                    }
                } else {
                    Map tasksRegToLeaf = (Map)tasksByType.get("[non-containers]");
                    if (tasksRegToLeaf != null) {
                        FwUtils.addValidTasks(tasks, tasksRegToLeaf, bMultipleObjects, context);
                    }
                }
            }
        }
        return tasks;
    }

    private static Map getTasksByTypeTable(boolean showAllTasks, MContext context) {
        Hashtable tasksByType = null;
        tasksByType = showAllTasks ? Registry.getRegistry((String)"Install").m_tasksByType : (Hashtable)FwAttr.getFwAuthAttr("fw.tasksByType", context.getRequest());
        return tasksByType;
    }

    private static void addTasksForType(Map tasks, ObjectType ot, Map tasksByType, boolean bMultipleObjects, MContext context) {
        if (tasks != null && ot != null && tasksByType != null) {
            ObjectType[] parents;
            String otName = ot.getName();
            Map tasksRegToType = (Map)tasksByType.get(otName);
            if (tasksRegToType != null) {
                FwUtils.addValidTasks(tasks, tasksRegToType, bMultipleObjects, context);
            }
            if ((parents = ot.getParentTypes()) != null) {
                for (int i = 0; i < parents.length; ++i) {
                    FwUtils.addTasksForType(tasks, parents[i], tasksByType, bMultipleObjects, context);
                }
            }
        }
    }

    private static void addValidTasks(Map dest, Map toAdd, boolean bAddMultiple, MContext context) {
        Iterator iterator = toAdd.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Document doc = (Document)entry.getValue();
            if (FwUtils.checkTask(doc, (String)entry.getKey(), context) != null || bAddMultiple && !FwUtils.isMooEnabled(doc)) continue;
            dest.put(doc.getRootElement().getChildTextTrim("id"), doc);
        }
    }

    private static boolean isMooEnabled(Document doc) {
        Element root = doc.getRootElement();
        List list = root.getChildren("url-param");
        ListIterator iterator = list.listIterator();
        while (iterator.hasNext()) {
            String value;
            Element el = (Element)iterator.next();
            String key = el.getChildTextTrim("param-key");
            if (key == null || !key.equals("mooEnabled") || !(value = el.getChildTextTrim("param-value")).equals("true")) continue;
            return true;
        }
        return false;
    }

    public static ArrayList getAllClassesInOrder(NSObject nsobj) {
        ClassDefinition[] allClasses = nsobj.getClassDefinitions();
        ArrayList<String> auxClasses = new ArrayList<String>();
        ArrayList<String> classes = new ArrayList<String>();
        if (allClasses != null) {
            int j = 0;
            String[] superClasses = null;
            for (int i = 0; i < allClasses.length; ++i) {
                if (allClasses[i].isAuxiliary()) {
                    auxClasses.add(allClasses[i].getName());
                    superClasses = allClasses[i].getSuperClasses();
                    if (superClasses == null) continue;
                    for (j = 0; j < superClasses.length; ++j) {
                        if (auxClasses.contains(superClasses[j])) continue;
                        auxClasses.add(superClasses[j]);
                    }
                    continue;
                }
                classes.add(allClasses[i].getName());
                superClasses = allClasses[i].getSuperClasses();
                if (superClasses == null) continue;
                for (j = 0; j < superClasses.length; ++j) {
                    if (classes.contains(superClasses[j])) continue;
                    classes.add(superClasses[j]);
                }
            }
        }
        eMFrameUtils.addUnique(classes, auxClasses);
        return classes;
    }

    public static String getDynamicSearchType(MContext context) {
        String dynamicGroupSearchType = "";
        String dynamicGroupEnabled = SystemConfig.getSystemConfig(context).getSetting("Provider.eMFrame.DynamicGroup.enable");
        if (dynamicGroupEnabled == null || !dynamicGroupEnabled.equalsIgnoreCase("false") && !dynamicGroupEnabled.equalsIgnoreCase("true")) {
            D.log("PrincipalRoleList:: Provider.eMFrame.DynamicGroup.enable not valid in config file, dynamic groups will not be used for role discovery, value is:" + dynamicGroupEnabled);
            return dynamicGroupSearchType;
        }
        dynamicGroupSearchType = SystemConfig.getSystemConfig(context).getSetting("Provider.eMFrame.DynamicGroup.Searchtype");
        if (dynamicGroupSearchType == null || !dynamicGroupSearchType.equalsIgnoreCase("DynamicGroupObjectsOnly") && !dynamicGroupSearchType.equalsIgnoreCase("DynamicGroupObjects&AuxClasses")) {
            D.log("PrincipalRoleList:: Provider.eMFrame.DynamicGroup.Searchtype not valid in config file, setting to DynamicGroupObjectsOnly, value is:" + dynamicGroupSearchType);
            dynamicGroupSearchType = "DynamicGroupObjectsOnly";
        }
        return dynamicGroupSearchType;
    }

    public static String getCookie(HttpServletRequest req, String label) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null && cookies.length != 0) {
            for (int c = 0; c < cookies.length; ++c) {
                if (!cookies[c].getName().equalsIgnoreCase(label)) continue;
                return cookies[c].getValue();
            }
        }
        return null;
    }

    public static String getDocStr(Document doc) {
        ByteArrayOutputStream targetStream = new ByteArrayOutputStream();
        XMLOutputter outputter = new XMLOutputter("   ", true);
        try {
            outputter.setEncoding("UTF-8");
            outputter.output(doc, (OutputStream)targetStream);
            return targetStream.toString("UTF-8");
        }
        catch (IOException e) {
            D.log(e);
            return "";
        }
    }

    public static String getDocStr(org.w3c.dom.Document doc) {
        try {
            DOMSource source = new DOMSource(doc);
            ByteArrayOutputStream targetStream = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(targetStream);
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            transformer.transform(source, result);
            return targetStream.toString();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String[] extractAttributesForEDAS(Element root) {
        List rights = root.getChildren("rights-assignment");
        if (rights != null) {
            ArrayList<String> list = new ArrayList<String>();
            Iterator iter = rights.iterator();
            while (iter.hasNext()) {
                Element element = (Element)iter.next();
                String attributeName = element.getChildTextTrim("attribute-name");
                if (attributeName == null || attributeName.charAt(0) == '[' || attributeName.equals("Password Management")) continue;
                list.add(attributeName);
            }
            return list.toArray(new String[list.size()]);
        }
        return new String[0];
    }

    public static void extractCustomDataHandlers(Properties customHandlers, Document doc) {
        Properties properties = eMFrameUtils.getUrlParams(doc);
        Enumeration<Object> myenum = properties.keys();
        while (myenum.hasMoreElements()) {
            String key = (String)myenum.nextElement();
            if (!key.endsWith("CustomHandler")) continue;
            String attributeName = key.substring(0, key.length() - "CustomHandler".length());
            customHandlers.put(attributeName, properties.getProperty(key));
        }
    }

    public static void dispatchJsp(String jspPage, HttpServletRequest req, HttpServletResponse response) {
        FwUtils.dispatchJspImpl(jspPage, req, response);
    }

    private static void dispatchJspImpl(String jspPage, HttpServletRequest request, HttpServletResponse response) {
        String merge;
        if (jspPage == null && (merge = request.getParameter("merge")) != null) {
            jspPage = merge.replace('.', '/') + ".jsp";
        }
        String resourceURI = NPSCompatUtils.getPath(request, jspPage);
        D.log("JSP: " + jspPage + " -> " + resourceURI);
        try {
            RequestDispatcher dispatcher = request.getRequestDispatcher(resourceURI);
            response.setContentType("text/html");
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
            if (request.getAttribute("SaveTaskURL") != null) {
                FwUtils.saveOSRequest(request);
            }
        }
        catch (Exception ex) {
            Throwable t = eMFrameUtils.discoverRootException(ex);
            t.printStackTrace();
            FwUtils.printStackTractToResponse(t, response);
        }
    }

    public static void printStackTractToResponse(Throwable t, HttpServletResponse response) {
        try {
            t.printStackTrace(new PrintWriter((OutputStream)response.getOutputStream()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void resetPIdentity(MContext tcontext, String new_PIdentity) throws PluginException {
        DirAuthenticator dirAuth = DirAuthenticator.getDirAuth(tcontext);
        AuthenticationBroker broker = tcontext.getAuthenticationBroker();
        dirAuth.resetPIdentity(new_PIdentity);
        NPSCompatUtils.setConnectionPassword(new_PIdentity, broker);
    }

    public static void savePortalSession(HttpSession session, HttpSession portalSession) {
        session.setAttribute(PORTAL_SESSION_ATTR_NAME, (Object)portalSession);
    }

    public static String getBrowserId(HttpSession session) {
        return (String)session.getAttribute("Browser.id");
    }

    public static void setDeviceType(HttpSession session) {
        FwUtils.setIsSingleGadgetDevice(session);
        FwUtils.setIsSpecialStylesheetDevice(session);
    }

    private static void setIsSingleGadgetDevice(HttpSession session) {
        String deviceType = FwUtils.getDeviceType(session);
        if (deviceType != null && sm_singleGadgetDevices != null) {
            if (sm_singleGadgetDevices.contains(deviceType)) {
                session.setAttribute(SINGLE_GADGET_DEVICE, (Object)B_TRUE);
            } else {
                session.setAttribute(SINGLE_GADGET_DEVICE, (Object)B_FALSE);
            }
        }
    }

    private static void setIsSpecialStylesheetDevice(HttpSession session) {
        String deviceType = FwUtils.getDeviceType(session);
        if (deviceType != null && sm_singleGadgetDevices != null) {
            if (sm_specialStylesheetDevices.contains(deviceType)) {
                session.setAttribute(SPECIAL_STYLE_SHEET, (Object)B_TRUE);
            } else {
                session.setAttribute(SPECIAL_STYLE_SHEET, (Object)B_FALSE);
            }
        }
    }

    public static boolean isSingleGadgetDevice(HttpSession session) {
        Boolean b = (Boolean)session.getAttribute(SINGLE_GADGET_DEVICE);
        return b;
    }

    public static String getDeviceType(HttpSession session) {
        return (String)session.getAttribute("DeviceType");
    }

    public static String getContentType(HttpSession session) {
        String sDev = (String)session.getAttribute("DeviceType");
        InterfaceCfg cfg = InterfaceCfg.getInstance();
        return cfg.getContentType(sDev);
    }

    public static void setSpecialStylesheetDevices(SystemConfig config) {
        HashSet<String> specialStylesheetDevicesTemp = new HashSet<String>();
        String[] specialStylesheetDevicesArray = config.getSettings(SPECIAL_STYLESHEET_DEVICES_SETTING);
        if (specialStylesheetDevicesArray != null) {
            for (int i = 0; i < specialStylesheetDevicesArray.length; ++i) {
                specialStylesheetDevicesTemp.add(specialStylesheetDevicesArray[i]);
            }
        }
        sm_specialStylesheetDevices = specialStylesheetDevicesTemp;
    }

    public static Locale instantiateLocale(String sLocale) {
        String sLang = "";
        String sCountry = "";
        sLang = sLocale.substring(0, 2);
        if (sLocale.length() > 2) {
            sCountry = sLocale.substring(3, 5);
        }
        return new Locale(sLang, sCountry);
    }

    public static Locale getCurrentLocale(HttpSession session) {
        Locale[] locales = FwUtils.getLocales(session);
        if (locales != null && locales.length > 0) {
            return locales[0];
        }
        return null;
    }

    public static void setLocales(HttpSession session, Locale[] locs) {
        session.setAttribute(BROWSER_LOCALES, (Object)locs);
    }

    public static String getLocaleString(HttpSession session) {
        String currentLocales = (String)session.getAttribute(BROWSER_LOCALES_STRING);
        return currentLocales;
    }

    public static String[] getAvailableLanguages() {
        String[] saRet = new SystemConfig().getSettings(LANGUAGES_FOR_TRANSLATION);
        if (saRet == null || saRet.length == 0) {
            saRet = LANGUAGES_FOR_TRANSLATION_DEFAULT;
        }
        return saRet;
    }

    public static String getLanguageString(Locale thisLoc, String sLanguageCode) {
        Locale tempLoc = FwUtils.instantiateLocale(sLanguageCode);
        return tempLoc.getDisplayLanguage(thisLoc);
    }

    public static String getLocalLanguageSring(Locale locale, String countryCode) {
        String retValue = countryCode;
        if (countryCode.equals("de")) {
            retValue = eMFrameUtils.getLocalizedString("FwResources", "CustomSchemaName.German", locale);
        } else if (countryCode.equals("en")) {
            retValue = eMFrameUtils.getLocalizedString("FwResources", "CustomSchemaName.English", locale);
        } else if (countryCode.equals("es")) {
            retValue = eMFrameUtils.getLocalizedString("FwResources", "CustomSchemaName.Spanish", locale);
        } else if (countryCode.equals("fr")) {
            retValue = eMFrameUtils.getLocalizedString("FwResources", "CustomSchemaName.French", locale);
        } else if (countryCode.equals("it")) {
            retValue = eMFrameUtils.getLocalizedString("FwResources", "CustomSchemaName.Italian", locale);
        } else if (countryCode.equals("ja")) {
            retValue = eMFrameUtils.getLocalizedString("FwResources", "CustomSchemaName.Japanese", locale);
        } else if (countryCode.equals("pt")) {
            retValue = eMFrameUtils.getLocalizedString("FwResources", "CustomSchemaName.Portugese", locale);
        } else if (countryCode.equals("ru")) {
            retValue = eMFrameUtils.getLocalizedString("FwResources", "CustomSchemaName.Russian", locale);
        } else if (countryCode.equals("pl")) {
            retValue = eMFrameUtils.getLocalizedString("FwResources", "CustomSchemaName.Polish", locale);
        } else if (countryCode.equals("zh_CN")) {
            retValue = eMFrameUtils.getLocalizedString("FwResources", "CustomSchemaName.Chinese_CN", locale);
        } else if (countryCode.equals("zh_TW")) {
            retValue = eMFrameUtils.getLocalizedString("FwResources", "CustomSchemaName.Chinese_TW", locale);
        } else if (countryCode.equals("cs")) {
            retValue = eMFrameUtils.getLocalizedString("FwResources", "CustomSchemaName.Czech", locale);
        } else if (countryCode.equals("hu")) {
            retValue = eMFrameUtils.getLocalizedString("FwResources", "CustomSchemaName.Hungarian", locale);
        } else if (countryCode.equals("sk")) {
            retValue = eMFrameUtils.getLocalizedString("FwResources", "CustomSchemaName.Slovak", locale);
        }
        return retValue + "(" + countryCode + ")";
    }

    public static Locale[] getLocales(HttpSession session) {
        return (Locale[])session.getAttribute(BROWSER_LOCALES);
    }

    public static Date getLoginTime(HttpSession session) {
        return (Date)session.getAttribute(LOGIN_TIME);
    }

    public static void setLoginTime(HttpSession session, Date date) {
        session.setAttribute(LOGIN_TIME, (Object)date);
    }

    public static void clearLoginTime(HttpSession session) {
        session.removeAttribute(LOGIN_TIME);
    }

    public static void setSkin(HttpSession session, String skinName) {
        session.setAttribute(SYSTEM_SKIN_NAME, (Object)skinName);
    }

    public static String getSkin(HttpSession session) {
        return (String)session.getAttribute(SYSTEM_SKIN_NAME);
    }

    public static ArrayList difference(Collection list1, Collection list2) {
        ArrayList list = new ArrayList();
        Iterator iter = list1.iterator();
        while (iter.hasNext()) {
            Object object = iter.next();
            if (list2.contains(object)) continue;
            list.add(object);
        }
        return list;
    }

    public static void setLocalizedMessage(String mode, String resourceFile, String titleKey, String bodyKey, MContext context) {
        String title = eMFrameUtils.getLocalizedString(resourceFile, titleKey, context);
        String body = eMFrameUtils.getLocalizedString(resourceFile, bodyKey, context);
        eMFrameUtils.setMessage(mode, title, body, context);
    }

    public static String getUniqueSPIMessage(UniqueSPIException e) {
        int iErrCode = e.getErrorCode();
        String sHexErrCode = Integer.toHexString(iErrCode);
        int iLen = sHexErrCode.length();
        if (iLen < 8) {
            StringBuffer sbErr = new StringBuffer(sHexErrCode);
            for (int i = iLen; i < 8; ++i) {
                sbErr.insert(0, '0');
            }
            sHexErrCode = sbErr.toString();
        } else if (iLen > 8) {
            sHexErrCode = sHexErrCode.substring(iLen - 8);
        }
        return sHexErrCode;
    }

    public static String getLDAPSPIMessage(LDAPSPIException e) {
        int iErrCode = e.getErrorCode();
        String sHexErrCode = Integer.toHexString(iErrCode);
        int iLen = sHexErrCode.length();
        if (iLen < 8) {
            StringBuffer sbErr = new StringBuffer(sHexErrCode);
            for (int i = iLen; i < 8; ++i) {
                sbErr.insert(0, '0');
            }
            sHexErrCode = sbErr.toString();
        } else if (iLen > 8) {
            sHexErrCode = sHexErrCode.substring(iLen - 8);
        }
        return sHexErrCode;
    }

    public static long getAppUpTime() {
        return System.currentTimeMillis() - applicationStartTime;
    }

    public static void init() {
        applicationStartTime = System.currentTimeMillis();
    }

    public static String getTaskInstanceId(HttpServletRequest req) {
        String preAuthURL;
        String sID = null;
        sID = req.getParameter("NPService");
        if (!(sID != null && sID.length() != 0 || (sID = req.getParameter("taskId")) != null && sID.length() != 0 || (sID = req.getParameter("GI_ID")) != null && sID.length() != 0 || (preAuthURL = (String)FwAttr.getFwSessionAttribute("AuthenticatorServlet.UrlAfterLogin", req.getSession())) == null || (sID = FwUtils.getParamFromURLString(preAuthURL, "NPService")) != null && sID.length() != 0 || (sID = FwUtils.getParamFromURLString(preAuthURL, "taskId")) != null && sID.length() != 0)) {
            sID = FwUtils.getParamFromURLString(preAuthURL, "GI_ID");
        }
        return sID;
    }

    private static String getParamFromURLString(String sUrl, String param) {
        String sTemp = sUrl;
        StringTokenizer tok = new StringTokenizer(sTemp, "&");
        while (tok.hasMoreTokens()) {
            StringTokenizer paramTok = new StringTokenizer(tok.nextToken(), "=");
            if (!paramTok.hasMoreTokens() || !paramTok.nextToken().equals(param)) continue;
            if (paramTok.hasMoreTokens()) {
                return paramTok.nextToken();
            }
            return null;
        }
        return null;
    }

    public static String getTaskId(String taskInstanceId) {
        int index = taskInstanceId.indexOf("~");
        if (index == -1) {
            return taskInstanceId;
        }
        return taskInstanceId.substring(0, index);
    }

    public static void verifyRbsInstalled(HttpServletRequest req, String sServiceName) throws Exception {
        FwUtils.taskShouldRunImpl(req, sServiceName);
        MContext context = FwUtils.getMContext(req);
        if (!RBSUtil.isRBSInstalled(context)) {
            throw new Exception(eMFrameUtils.getLocalizedString("FwResources", "Configure.RBSNotInstalled", context));
        }
    }

    public static Object removeFwSessionAttribute(String key, HttpSession session) {
        return FwAttr.removeFwSessionAttribute(key, session);
    }

    public static Object removeFwAuthAttribute(String key, iMgrAuthenticator auth) {
        return FwAttr.removeFwAuthAttribute(key, auth);
    }

    public static String getAttributeDisplayName(String attributeName, Locale locale, String defaultValue) {
        String key = "Attribute." + FwUtils.getSafeName(attributeName);
        String translatedString = eMFrameUtils.getLocalizedString("FwResources", key, locale, sDontWarn);
        if (translatedString != sDontWarn) {
            return translatedString;
        }
        String resourceFile = FwDirUtils.getAttributeResourceFile(attributeName);
        if (resourceFile != null && (translatedString = eMFrameUtils.getLocalizedString(resourceFile, key, locale, defaultValue)) != null) {
            return translatedString;
        }
        return defaultValue;
    }

    public static byte[] getRootCertificate(MContext context) throws PluginException {
        AuthenticationBroker broker = context.getAuthenticationBroker();
        ObjectEntry treeOE = null;
        try {
            treeOE = (ObjectEntry)broker.getProtocolObject("AdminNamespace");
        }
        catch (AuthBrokerException ae) {
            String teMsg = eMFrameUtils.getLocalizedString("FwResources", "FWConsts.CERT_PROTOCOL_UNAVAILABLE", context);
            String errMsg = MessageFormat.format(teMsg, ae.toString());
            throw new PluginException(null, errMsg);
        }
        AdminNamespace ans = treeOE.getAdminNamespace();
        if (!(ans instanceof NDSNamespace)) {
            return new byte[0];
        }
        byte[] rootCertArray = null;
        try {
            ObjectEntry securityOE = ans.getObjectEntry(treeOE, "Security");
            ObjectAttribute CADNAttr = ans.getAttribute(securityOE, "NDSPKI:Tree CA DN");
            String CADNName = ((StringValue)CADNAttr.getValueComponents().nextElement()).getValue();
            ObjectEntry CADN_OE = ans.getObjectEntry(treeOE, CADNName);
            ObjectAttribute rootCertAttr = ans.getAttribute(CADN_OE, "Cross Certificate Pair");
            Enumeration rootCertSet = rootCertAttr.getValueComponents();
            while (rootCertSet.hasMoreElements()) {
                HexValue thv = (HexValue)rootCertSet.nextElement();
                rootCertArray = thv.getValue();
            }
        }
        catch (SPIException spie) {
            PluginException plexp = new PluginException((Exception)((Object)spie));
            throw plexp;
        }
        return rootCertArray;
    }

    public static long copyData(InputStream source, OutputStream dest) throws IOException {
        int bCnt;
        long totalCount = 0L;
        byte[] data = new byte[100];
        while ((bCnt = source.read(data, 0, 100)) != -1) {
            dest.write(data, 0, bCnt);
            totalCount += (long)bCnt;
        }
        return totalCount;
    }

    public static boolean canConfigureiManager(HttpServletRequest req) {
        block11: {
            try {
                StringBuffer sbPath = new StringBuffer();
                sbPath.append(eMFrameUtils.getRealPath("/"));
                sbPath.append("WEB-INF");
                sbPath.append("/configiman.properties");
                String sPath = sbPath.toString();
                File fConfig = new File(sPath);
                Properties props = new Properties();
                if (fConfig != null && fConfig.exists()) {
                    String sAllUsers;
                    Object sTemp = null;
                    FileInputStream fis = new FileInputStream(fConfig);
                    if (fis != null) {
                        props.load(fis);
                        fis.close();
                    }
                    if ((sAllUsers = props.getProperty("AllUsers", "false")).equalsIgnoreCase("true")) {
                        return true;
                    }
                    MContext context = FwUtils.getMContext(req);
                    ArrayList<String> authvals = new ArrayList<String>();
                    String sHost = DirAuthenticator.getDirAuth(context).getConnectionProfile(context.getRequest()).getUniqueHostId();
                    String sFullUser = (String)FwAttr.getFwAuthAttr("User.FDN", req);
                    String sFullUserTree = null;
                    if (sFullUser != null) {
                        sFullUser = FwUtils.removeBeginingAndTrailingDot(sFullUser);
                        sFullUserTree = null != (sHost = FwUtils.removeBeginingAndTrailingDot(sHost)) && sHost.length() > 0 ? sFullUser + "." + sHost : sFullUser;
                        Enumeration<Object> eprops = props.keys();
                        String sKey = null;
                        while (eprops.hasMoreElements()) {
                            sKey = (String)eprops.nextElement();
                            authvals.add(sKey);
                            if (!sFullUserTree.equalsIgnoreCase(sKey)) continue;
                            return true;
                        }
                        AuthenticationBroker br = context.getAuthenticationBroker();
                        ObjectEntry treeOE = (ObjectEntry)br.getAPIObject("NDSNamespace");
                        NDSNamespace ns = (NDSNamespace)treeOE.getNamespace();
                        ObjectAttribute[] oaGroupMembership = ns.getAttributes(ns.getObjectEntry(sFullUser), new String[]{"Group Membership"}, 1, null, null);
                        if (oaGroupMembership != null && oaGroupMembership.length > 0 && oaGroupMembership[0] != null && null != sHost && sHost.length() > 0) {
                            Enumeration GroupMembershipEnum = oaGroupMembership[0].getValueComponents();
                            ArrayList<String> gmvals = new ArrayList<String>();
                            while (GroupMembershipEnum.hasMoreElements()) {
                                String val = ((StringValue)GroupMembershipEnum.nextElement()).getValue();
                                gmvals.add(val + "." + sHost);
                            }
                            if (gmvals.size() > 0) {
                                gmvals.retainAll(authvals);
                                if (gmvals.size() > 0) {
                                    return true;
                                }
                            }
                        }
                    }
                    break block11;
                }
                D.log("Security Concern:: configiman.properties file not found at path: " + sPath + "  All users will have the ability to install plugin modules and configure iManager.  To Rectify this go to the configure view and configure iManager security to specify authorized users.", 1);
                return true;
            }
            catch (Exception e) {
                D.log(e);
            }
        }
        return false;
    }

    private static String removeBeginingAndTrailingDot(String sInput) {
        if (sInput != null && sInput.length() > 0 && sInput.substring(sInput.length() - 1).equalsIgnoreCase(".")) {
            sInput = sInput.substring(0, sInput.length() - 1);
        }
        if (sInput != null && sInput.length() > 0 && sInput.substring(0).equalsIgnoreCase(".")) {
            sInput = sInput.substring(1, sInput.length());
        }
        return sInput;
    }

    public static void refreshCRTCategories(MContext context) {
        FwAttr.removeFwAuthAttr("CRT.categoriesCached", context);
    }

    public static final Throwable callVerifyForDeviceMethod(MContext context, Document doc) {
        String id;
        Object tableVal;
        String taskType = doc.getRootElement().getChildTextTrim("type");
        if (taskType != null && taskType.equals("url")) {
            return null;
        }
        String classname = eMFrameUtils.getClassName(doc);
        if (classname == null || classname.length() < 1) {
            return new Exception(eMFrameUtils.getLocalizedString("FwResources", "PluginError.InvalidClassname", context));
        }
        if (!FwUtils.isPluginSupportedByAnyAuths(doc, context)) {
            return new Exception(eMFrameUtils.getLocalizedString("FwResources", "PluginError.NotSupportedByCurrentAuthenticators", context));
        }
        Hashtable<String, Object> calledTable = (Hashtable<String, Object>)context.getAuthenticator().getAttribute("fw.PluginsAvailableTable");
        if (calledTable == null) {
            calledTable = new Hashtable<String, Object>();
            context.getAuthenticator().setAttribute("fw.PluginsAvailableTable", calledTable);
        }
        if ((tableVal = calledTable.get(id = doc.getRootElement().getChildTextTrim("id"))) != null) {
            if (tableVal instanceof Throwable) {
                return (Throwable)tableVal;
            }
            return null;
        }
        Class[] methodParams = new Class[2];
        try {
            methodParams[0] = Class.forName("javax.servlet.http.HttpServletRequest");
            methodParams[1] = Class.forName("java.lang.String");
        }
        catch (Exception e) {
            D.log(e);
        }
        Throwable realException = null;
        Class<?> c = null;
        try {
            c = Class.forName(classname);
            Method m = c.getMethod("shouldRun", methodParams);
            Object[] params = new Object[]{context.getRequest(), id};
            m.invoke(null, params);
            calledTable.put(id, id);
            return null;
        }
        catch (InvocationTargetException e) {
            realException = e.getTargetException();
        }
        catch (ClassNotFoundException e) {
            D.log("====================================================");
            D.log("Class not found for installed snapin; class=" + classname);
            D.log("====================================================");
            realException = new PluginException("", eMFrameUtils.getLocalizedString("FwResources", "PluginError.PluginNotInstalled", context));
        }
        catch (Throwable t) {
            if (t instanceof NoSuchMethodException) {
                return null;
            }
            D.log(t);
            realException = t;
        }
        calledTable.put(classname, realException);
        return realException;
    }

    public static boolean isPluginSupportedByAnyAuths(Document doc, MContext context) {
        if (FwAuthUtils.getSupportedAuthenticatorNamesForPlugin(doc).contains("any")) {
            return true;
        }
        iMgrAuthenticatorImpl[] auths = AuthLoader.getSupportedAuthenticatorsForPlugin(context, doc);
        for (int i = 0; i < auths.length; ++i) {
            iMgrAuthenticatorImpl auth = auths[i];
            if (!auth.isPluginAvailable(context, doc)) continue;
            return true;
        }
        return false;
    }

    public static ArrayList getSupportedDeviceTypes(Document doc) {
        ArrayList<String> supportedDevicesArray = new ArrayList<String>();
        Element root = doc.getRootElement();
        ListIterator iterator = root.getChildren("supported-device-type").listIterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            String supportedDeviceType = element.getTextTrim();
            supportedDevicesArray.add(supportedDeviceType);
        }
        if (supportedDevicesArray.size() == 0) {
            supportedDevicesArray.addAll(Registry.getDefaultDevices());
        }
        return supportedDevicesArray;
    }

    public static void taskShouldRunImpl(HttpServletRequest req, String taskId) throws Exception {
        String sDeviceType;
        HttpSession session = req.getSession();
        ArrayList al = FwUtils.getSupportedDeviceTypes(FwUtils.getTaskDocument(FwUtils.getMContext(req), taskId));
        if (al != null && al.size() != 0 && (sDeviceType = FwUtils.getDeviceType(session)) != null) {
            String sSupportedType = null;
            boolean bFoundDeviceType = false;
            for (int i = 0; i < al.size(); ++i) {
                sSupportedType = (String)al.get(i);
                if (!sDeviceType.equalsIgnoreCase(sSupportedType)) continue;
                bFoundDeviceType = true;
                break;
            }
            if (!bFoundDeviceType) {
                String sExceptionMessage = null;
                sExceptionMessage = eMFrameUtils.getLocalizedString("FwResources", "PluginError.DeviceNotSupported", FwUtils.getCurrentLocale(session));
                if (sExceptionMessage != null && sExceptionMessage.length() != 0) {
                    throw new DeviceUnsupportedException(sExceptionMessage);
                }
                throw new DeviceUnsupportedException();
            }
        }
    }

    public static MContext getMContext(HttpServletRequest req) {
        FwTaskContext context = (FwTaskContext)FwAttr.getFwRequestAttribute("fw.Context", req);
        if (context == null) {
            LegacyTask bgi = (LegacyTask)req.getAttribute("BGI");
            if (bgi == null) {
                context = (FwTaskContext)FwAttr.getFwRequestAttribute("FakeTaskContext", req);
                if (context == null) {
                    context = new FwTaskContext(req, (LegacyTask)((Object)new EmptyTask()), true);
                }
            } else {
                context = new FwTaskContext(req, bgi, false);
                FwAttr.setFwRequestAttribute("fw.Context", context, req);
            }
        }
        return context;
    }

    public static void saveOSRequest(HttpServletRequest req) {
        if (req != null) {
            DirAuthenticator dirAuth = DirAuthenticator.getDirAuth(req);
            dirAuth.removeAttribute("OS.Anchor");
            if (req.getRequestURI() != null) {
                dirAuth.setAttribute("LastTaskURI", req.getRequestURI());
            }
            dirAuth.setAttribute("LastTaskParams", FwUtils.buildParamTable(req));
        }
    }

    private static Hashtable buildParamTable(HttpServletRequest tReq) {
        Hashtable<String, String> htTaskParams = new Hashtable<String, String>();
        Enumeration names = tReq.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String[] values = tReq.getParameterValues(name);
            if (values == null || values.length <= 0) continue;
            htTaskParams.put(name, values[0]);
        }
        return htTaskParams;
    }

    public static HttpServletRequest getRequest(HttpSession session) {
        return (HttpServletRequest)FwAttr.getFwSessionAttribute("Request", session);
    }

    public static void setRequestInSession(HttpServletRequest req, HttpSession session) {
        FwAttr.setFwSessionAttribute("Request", req, session);
    }

    public static void removeRequestFromSession(HttpSession session) {
        FwAttr.removeFwSessionAttribute("Request", session);
    }

    public static void sortLinkedHashMapByValue(LinkedHashMap someMap, Comparator comparator) {
        ArrayList mapKeys = new ArrayList(someMap.keySet());
        ArrayList mapValues = new ArrayList(someMap.values());
        ArrayList sortedArray = new ArrayList();
        sortedArray.addAll(mapValues);
        someMap.clear();
        if (comparator == null) {
            Collections.sort(sortedArray);
        } else {
            Collections.sort(sortedArray, comparator);
        }
        int size = sortedArray.size();
        for (int i = 0; i < size; ++i) {
            someMap.put(mapKeys.get(mapValues.indexOf(sortedArray.get(i))), sortedArray.get(i));
        }
    }

    public static Throwable checkTask(Document taskDoc, String taskId, MContext context) {
        Throwable error = null;
        if (error == null && !InfoFactory.versionOk(taskId, taskDoc)) {
            D.log("createSnapinTaskDoc Version of plugin in file system is later than version in DS, not using task: " + taskId);
            error = new PluginException(null, eMFrameUtils.getLocalizedString("FwResources", "PluginError.IncorrectVersion", context));
        }
        if (error == null && !InfoFactory.requiredVersionOk(taskDoc)) {
            D.log("createSnapinTaskDoc Required version of plugin is later than current iManager, not using task: " + taskId);
            error = new PluginException(null, eMFrameUtils.getLocalizedString("FwResources", "PluginError.IncorrectRequiredVersion", context));
        }
        if (error == null && !InfoFactory.expiredVersionOk(taskDoc)) {
            D.log("createSnapinTaskDoc Expired version of plugin requires prior version of iManager, not using task: " + taskId);
            error = new PluginException(null, eMFrameUtils.getLocalizedString("FwResources", "PluginError.ExpiredVersion", context));
        }
        if (error == null) {
            error = FwUtils.callVerifyForDeviceMethod(context, taskDoc);
        }
        return error;
    }

    public static void setBGI(HttpServletRequest req, LegacyTask task) {
        LegacyTask oldLegacyTask = (LegacyTask)req.getAttribute("BGI");
        D.assrt(oldLegacyTask == null || oldLegacyTask == task, "setting BGI to '" + task + "' but it was already set to '" + oldLegacyTask + "'");
        req.setAttribute("BGI", (Object)task);
        FwTaskContext context = (FwTaskContext)FwAttr.getFwRequestAttribute("fw.Context", req);
        if (context != null) {
            LegacyTask oldSavedLegacyTask = (LegacyTask)FwAttr.getFwRequestAttribute("", req);
            D.assrt(oldSavedLegacyTask == null || oldSavedLegacyTask == task, "setting savedBGI to '" + task + "' but it was already set to '" + oldSavedLegacyTask + "'");
            FwAttr.setFwRequestAttribute("fw.Context", context, req);
        }
    }

    public static void resetBGI(LegacyTask task, HttpServletRequest req) {
        req.setAttribute("BGI", (Object)task);
        FwTaskContext context = (FwTaskContext)FwAttr.getFwRequestAttribute("fw.Context", req);
        if (context != null) {
            FwAttr.setFwRequestAttribute("fw.Context", context, req);
        }
    }

    public static boolean showDeveloperWarnings() {
        if (!sm_checkedShowDeprecatedAttributeWarnings) {
            return false;
        }
        return sm_showDeprecatedAttributeWarnings;
    }

    public static void checkShowDeveloperWarnings() {
        Registry reg = Registry.getRegistry("Global");
        Document doc = reg.getPluginDocument("sdk.DeveloperView");
        if (doc != null) {
            sm_showDeprecatedAttributeWarnings = true;
        }
        if (!sm_showDeprecatedAttributeWarnings) {
            String value = new SystemConfig().getSetting("System.Logging.ShowDeveloperWarnings", "false");
            if (Boolean.TRUE.toString().equals(value)) {
                sm_showDeprecatedAttributeWarnings = true;
            }
        }
        sm_checkedShowDeprecatedAttributeWarnings = true;
    }

    public static boolean doesPageIdsExistForType(MContext context, String type) throws NamespaceException, SPIException {
        Document[] docs = FwUtils.getAllPageDocsForType(context, type);
        return docs != null;
    }

    public static String getiManagerPlatform() {
        String platform = "Server";
        String workstationPath = eMFrameUtils.getRealPath("/") + "WEB-INF/workstation.txt";
        File workstationFile = new File(workstationPath);
        if (workstationFile.exists()) {
            platform = "Workstation";
        }
        return platform;
    }

    public static Hashtable getDependsonCriteria(ModuleInfo mInfo) {
        Object element1;
        Iterator itr;
        LinkedHashSet<ModuleInfo> setAvailable = new LinkedHashSet<ModuleInfo>();
        LinkedHashSet<String> setNotAvailable = new LinkedHashSet<String>();
        LinkedHashSet<ModuleInfo> setInstalled = new LinkedHashSet<ModuleInfo>();
        String[] arrModules = null;
        setAvailable.add(mInfo);
        Iterator it = setAvailable.iterator();
        Object element = null;
        int count = 0;
        while (it.hasNext()) {
            int i;
            element = it.next();
            mInfo = element;
            if (mInfo.isLocal()) {
                arrModules = mInfo.getDependsOn();
            } else if (mInfo.getUrl().startsWith("http") || mInfo.getUrl().startsWith("ftp")) {
                arrModules = mInfo.getDependsOn();
            } else {
                setNotAvailable.add(mInfo.getModuleID());
            }
            Hashtable htModulestoinstall = ModuleManager.getModulesToInstall();
            Hashtable htModulesinstalled = ModuleManager.getAllInstalledModules();
            if (arrModules.length != 0) {
                for (i = 0; i < arrModules.length; ++i) {
                    ModuleInfo moduleInfo = null;
                    if (htModulestoinstall.containsKey(arrModules[i])) {
                        moduleInfo = (ModuleInfo)htModulestoinstall.get(arrModules[i]);
                        setAvailable.add(moduleInfo);
                        continue;
                    }
                    if (htModulesinstalled.containsKey(arrModules[i])) {
                        moduleInfo = (ModuleInfo)htModulesinstalled.get(arrModules[i]);
                        setInstalled.add(moduleInfo);
                        continue;
                    }
                    setNotAvailable.add(arrModules[i]);
                }
            }
            it = setAvailable.iterator();
            ++count;
            for (i = 0; i < count; ++i) {
                if (!it.hasNext()) continue;
                it.next();
            }
        }
        if (setNotAvailable.isEmpty()) {
            itr = setAvailable.iterator();
            while (itr.hasNext()) {
                element1 = itr.next();
                ModuleInfo mInfo1 = (ModuleInfo)element1;
                D.log(mInfo1.getModuleID());
            }
        } else {
            itr = setNotAvailable.iterator();
            while (itr.hasNext()) {
                element1 = itr.next();
            }
            Iterator itr1 = setAvailable.iterator();
            while (itr1.hasNext()) {
                Object element12 = itr1.next();
                ModuleInfo mInfo1 = (ModuleInfo)element12;
                if (mInfo1 == null) continue;
                D.log(mInfo1.getModuleID());
            }
        }
        Hashtable<String, LinkedHashSet<Object>> ht_dependencies = new Hashtable<String, LinkedHashSet<Object>>();
        ht_dependencies.put("availablemodules", setAvailable);
        ht_dependencies.put("nonavailablemodules", setNotAvailable);
        ht_dependencies.put("installedmodules", setInstalled);
        return ht_dependencies;
    }

    public static boolean doesModuleMeetCriteria(ModuleInfo newInfo, VersionInfo iManVersion, String osString, String platform) {
        String validVersion;
        boolean meetsCriteria = true;
        D.log("----------------------------------------------------------------------------------------------");
        FwUtils.logiManagerInfo(iManVersion, osString, platform);
        FwUtils.logManifestInfo(newInfo);
        D.log("=== Does this Module Meet Criteria? ===");
        if (newInfo.getModuleID() != null && newInfo.getModuleID().length() > 0) {
            D.log("Module-ID: " + newInfo.getModuleID() + " (OK)");
        } else {
            meetsCriteria = false;
            D.log("Module-ID:  Is missing, this is a required field that must be set in the manifest file.");
        }
        if (newInfo.getModuleTitle() != null && newInfo.getModuleTitle().length() > 0) {
            D.log("Implementation-Title: " + newInfo.getModuleTitle() + " (OK)");
        } else {
            meetsCriteria = false;
            D.log("Implementation-Title:  Is missing, this is a required field that must be set in the manifest file.");
        }
        if (newInfo.getModuleVersion() != null && newInfo.getModuleVersion().length() > 0) {
            VersionInfo vInfo = new VersionInfo();
            validVersion = vInfo.setVersionFromVersionString(newInfo.getModuleVersion());
            if (validVersion == null) {
                newInfo.setModuleVersion(vInfo.getVersionString());
                D.log("Implementation-Version: " + newInfo.getModuleVersion() + " (OK)");
            } else {
                D.log("Implementation-Version:  " + validVersion + ".  Version numbers can only contain these characters: '.0123456789'");
                meetsCriteria = false;
            }
        } else {
            meetsCriteria = false;
            D.log("Implementation-Version:  Is missing, this is a required field that must be set in the manifest file.");
        }
        if (newInfo.getMinRequiredVersion() != null && newInfo.getMinRequiredVersion().length() > 0) {
            VersionInfo minVersion = new VersionInfo();
            validVersion = minVersion.setVersionFromVersionString(newInfo.getMinRequiredVersion());
            if (validVersion == null) {
                if (iManVersion.compareTo(minVersion) >= 0) {
                    newInfo.setMinRequiredVersion(minVersion.getVersionString());
                    D.log("Min-iManager-Version: " + newInfo.getMinRequiredVersion() + " (OK)");
                } else {
                    meetsCriteria = false;
                    D.log("Min-iManager-Version: " + minVersion.getVersionString() + " This module doesn't meet the minimum version requirement.");
                }
            } else {
                D.log("Min-iManager-Version:  " + validVersion + ".  Version numbers can only contain these characters: '.0123456789'");
                meetsCriteria = false;
            }
        } else {
            meetsCriteria = false;
            D.log("Min-iManager-Version:  Is missing, this is a required field that must be set in the manifest file.");
        }
        if (newInfo.getMaxRequiredVersion() != null && newInfo.getMaxRequiredVersion().length() > 0) {
            VersionInfo maxVersion = new VersionInfo();
            validVersion = maxVersion.setVersionFromVersionString(newInfo.getMaxRequiredVersion());
            if (validVersion == null) {
                if (iManVersion.compareTo(maxVersion) <= 0) {
                    newInfo.setMaxRequiredVersion(maxVersion.getVersionString());
                    D.log("Max-iManager-Version: " + newInfo.getMaxRequiredVersion() + " (OK)");
                } else {
                    meetsCriteria = false;
                    D.log("Max-iManager-Version: " + maxVersion.getVersionString() + " iManager Version: " + iManVersion.getVersionString() + " ,Warning:Update the MANIFEST.MF file accordingly");
                }
            } else {
                D.log("Max-iManager-Version:  " + validVersion + ".  Version numbers can only contain these characters: '.0123456789'");
                meetsCriteria = false;
            }
        } else {
            D.log("Max-iManager-Version: Has not been set. (OK)");
        }
        String os = "";
        if (osString.toLowerCase().indexOf("windows") != -1) {
            os = "Windows";
        } else if (osString.toLowerCase().indexOf("linux") != -1) {
            os = GlobalRegistry.isOES() && !platform.equals("Workstation") ? "OES" : "Linux";
        } else if (osString.toLowerCase().indexOf("netware") != -1) {
            os = "NetWare";
        }
        if (newInfo.isSupportedOSType(os + platform)) {
            D.log("OS Supported: " + os + platform + " (YES)");
        } else {
            meetsCriteria = false;
            D.log("OS Supported: " + os + platform + " (NO)");
        }
        if (meetsCriteria) {
            D.log("-----------------------------------------");
            D.log("Keeping: Module Meets Criteria.");
        } else {
            D.log("--------------------------------------------------------");
            D.log("Discarding: Module DOESN'T Meet Criteria!");
        }
        return meetsCriteria;
    }

    private static void logiManagerInfo(VersionInfo iManVersion, String os, String platform) {
        D.log("=== iManager Information ===");
        D.log("iManager Version: " + iManVersion.getVersionString());
        D.log("iManager OS: " + os);
        D.log("iManager Platform: " + platform);
        String shouldDownload = "true";
        shouldDownload = SystemConfigManager.getSingleSetting(null, "ShouldModuleDownload", shouldDownload);
        String whichShouldDownload = "Partial";
        whichShouldDownload = SystemConfigManager.getSingleSetting(null, "WhichModuleToDownload", whichShouldDownload);
        if (shouldDownload != null && shouldDownload.equals("true")) {
            D.log("Config Setting: Search Packages directory and Download.xml file.");
        } else {
            D.log("Config Setting: Search Packages directory Only.");
        }
        if (whichShouldDownload != null && whichShouldDownload.equalsIgnoreCase("All")) {
            D.log("Config Setting: Getting all available NPMs.");
        } else {
            D.log("Config Setting: Getting Only Updates.");
        }
    }

    private static void logManifestInfo(ModuleInfo mInfo) {
        D.log("=== Manifest Information (* = Required fields) ===");
        D.log("* Manifest Module-ID: " + mInfo.getModuleID());
        D.log("* Manifest Implementation Title: " + mInfo.getModuleTitle());
        D.log("* Manifest Implementation Version: " + mInfo.getModuleVersion());
        D.log("* Manifest Min-iManager-Version: " + mInfo.getMinRequiredVersion());
        D.log("Manifest Max-iManager-Version: " + mInfo.getMaxRequiredVersion());
        D.log("Manifest Supported-OS: " + mInfo.getSupportedOSTypes());
        if (mInfo.isLocal()) {
            D.log("Location: local package directory");
        } else {
            D.log("Location: download.xml file");
            String sDescriptorUrl = SystemConfigManager.getSingleSetting(null, "ModuleDownloadDescriptorURL");
            D.log("Download URL: " + sDescriptorUrl);
        }
    }

    public static final String[] unpackNoDecode(String s, MContext context) {
        if (null == s) {
            return new String[0];
        }
        if (s.equals("PP")) {
            return new String[0];
        }
        if (!s.startsWith("P:") || !s.endsWith("P")) {
            return new String[]{s};
        }
        s = s.substring(2, s.length() - 1);
        String[] ret = eMFrameUtils.split(s, ":");
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = eMFrameUtils.urlDecode(ret[i], context);
        }
        return ret;
    }

    public static InputStream getiManInputStreamBasedOnProxy(String urlString) throws Throwable {
        URL moduleUrl = new URL(urlString);
        Object urlconn = null;
        String sEnableModulesDownloadProxy = new SystemConfig().getSetting(ENABLE_MODULESDOWNLOAD_ENABLE_PROXY, "false");
        if (sEnableModulesDownloadProxy.equalsIgnoreCase("true")) {
            String proxyHost = new SystemConfig().getSetting(MODULESDOWNLOAD_PROXYHOST, "127.0.0.1");
            String proxyPort = new SystemConfig().getSetting(MODULESDOWNLOAD_PROXYPORT, "80");
            Authenticator.setDefault(new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(new SystemConfig().getSetting(FwUtils.MODULESDOWNLOAD_PROXY_USERNAME, ""), new SystemConfig().getSetting(FwUtils.MODULESDOWNLOAD_PROXY_PASSWORD, "").toCharArray());
                }
            });
            InetSocketAddress socketAddress = new InetSocketAddress(proxyHost, Integer.parseInt(proxyPort));
            try {
                int j;
                Class<?> proxy = Class.forName("java.net.Proxy");
                Class<?> proxyType = Class.forName("java.net.Proxy$Type");
                Class<?> basicClass = Class.forName("java.lang.Class");
                Method getEnumConstMethod = basicClass.getDeclaredMethod("getEnumConstants", null);
                Object[] proxyTypeEnumConstants = (Object[])getEnumConstMethod.invoke(proxyType, null);
                for (j = 0; j < proxyTypeEnumConstants.length && !proxyTypeEnumConstants[j].toString().equalsIgnoreCase("HTTP"); ++j) {
                }
                Object[] paramsProxy = new Object[]{proxyTypeEnumConstants[j], socketAddress};
                Constructor<?> proxyConstructor = proxy.getConstructor(proxyType, SocketAddress.class);
                Class[] proxyClass = new Class[]{proxy};
                Object[] urlConnParams = new Object[]{proxyConstructor.newInstance(paramsProxy)};
                Method urlConnetionMethod = URL.class.getDeclaredMethod("openConnection", proxyClass);
                urlconn = urlConnetionMethod.invoke((Object)moduleUrl, urlConnParams);
            }
            catch (Throwable ex) {
                if (ex instanceof ClassNotFoundException) {
                    System.setProperty("proxySet", "true");
                    System.setProperty("http.proxyHost", proxyHost);
                    System.setProperty("http.proxyPort", proxyPort);
                    urlconn = moduleUrl.openConnection();
                }
                D.log(ex.toString());
                throw ex;
            }
        } else {
            urlconn = moduleUrl.openConnection();
        }
        Object[] timeout = new Object[]{new Integer(60000)};
        try {
            Method[] method = Class.forName("java.net.URLConnection").getDeclaredMethods();
            for (int i = 0; i < method.length; ++i) {
                if (method[i].getName().equalsIgnoreCase("setConnectTimeout")) {
                    method[i].invoke(urlconn, timeout);
                }
                if (!method[i].getName().equalsIgnoreCase("setReadTimeout")) continue;
                method[i].invoke(urlconn, timeout);
            }
        }
        catch (Exception ex) {
            D.log("The Exception occured while getting input stream is:::" + ex.toString());
            ex.printStackTrace();
        }
        return ((URLConnection)urlconn).getInputStream();
    }

    public static byte[] authenticateAndGetServerCertificate(String LOGIN_DN, String HOST, String PASSWORD) {
        NDSNamespaceImpl ns = null;
        byte[] rootCertArray = null;
        int port = 0;
        String ip = null;
        String intport = null;
        String LdapName = LOGIN_DN;
        LOGIN_DN = MappingObject.LDAPNameToNDSName(LdapName);
        try {
            Enumeration ldnValues;
            NDSObjectAttribute ldapSSLAttr;
            Enumeration ldnValues2;
            ns = new NDSNamespaceImpl();
            ns.authenticate(LOGIN_DN, HOST, PASSWORD);
            ObjectEntry authenticatedOE = ns.getObjectEntry(LOGIN_DN);
            ObjectEntry treeOE = authenticatedOE.getRoot();
            ObjectEntry securityOE = ns.getObjectEntry(treeOE, "Security");
            ObjectAttribute CADNAttr = ns.getAttribute(securityOE, "NDSPKI:Tree CA DN");
            String CADNName = ((StringValue)CADNAttr.getValueComponents().nextElement()).getValue();
            ObjectEntry CADN_OE = ns.getObjectEntry(treeOE, CADNName);
            ObjectAttribute rootCertAttr = ns.getAttribute(CADN_OE, "Cross Certificate Pair");
            Enumeration rootCertSet = rootCertAttr.getValueComponents();
            while (rootCertSet.hasMoreElements()) {
                HexValue thv = (HexValue)rootCertSet.nextElement();
                rootCertArray = thv.getValue();
            }
            String serverDN = ((NDSNamespace)ns).getDefaultServerDN(treeOE);
            String defaultServerIp = ((NDSNamespace)ns).getDefaultIpAddress(treeOE);
            ObjectEntry serverOE = ((NDSNamespace)ns).getObjectEntry(treeOE, serverDN);
            ObjectEntry ldapServerOE = null;
            NDSObjectAttribute ldapServerAttr = (NDSObjectAttribute)((NDSNamespace)ns).getAttribute(serverOE, "LDAP Server");
            if (ldapServerAttr != null && (ldnValues2 = ldapServerAttr.getValueComponents()).hasMoreElements()) {
                String ldapServerDN = ((StringValue)ldnValues2.nextElement()).getValue();
                ldapServerOE = ((NDSNamespace)ns).getObjectEntry(serverOE.getRoot(), ldapServerDN);
            }
            String ldapInterface = null;
            NDSObjectAttribute ldapInterfaces = (NDSObjectAttribute)((NDSNamespace)ns).getAttribute(ldapServerOE, "ldapInterfaces");
            if (ldapInterfaces != null) {
                Enumeration ldnValues3 = ldapInterfaces.getValueComponents();
                if (ldnValues3.hasMoreElements()) {
                    while (ldnValues3.hasMoreElements()) {
                        ldapInterface = ((StringValue)ldnValues3.nextElement()).getValue();
                        if (ldapInterface.toLowerCase().indexOf("ldaps://") == -1) continue;
                        ip = ldapInterface;
                        break;
                    }
                }
                if (ip != null) {
                    int portindex = ip.substring("ldaps://".length()).indexOf(58);
                    if (portindex != -1) {
                        intport = ip.substring("ldaps://".length() + portindex + 1);
                        port = Integer.parseInt(intport);
                        ip = ip.substring("ldaps://".length(), "ldaps://".length() + portindex);
                    } else {
                        ip = ip.substring("ldaps://".length());
                        port = 636;
                    }
                }
            }
            if (ip == null && (ldapSSLAttr = (NDSObjectAttribute)((NDSNamespace)ns).getAttribute(ldapServerOE, "LDAP SSL Port")) != null && (ldnValues = ldapSSLAttr.getValueComponents()).hasMoreElements()) {
                port = (int)((LongValue)ldnValues.nextElement()).getValue();
                ip = HOST;
            }
            PortalModuleInstallManager.setSchemaDetails(ip, (String)LdapName, (String)PASSWORD, (boolean)true, (String)String.valueOf(port));
        }
        catch (SPIException e) {
            e.printStackTrace();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return rootCertArray;
    }

    public static Hashtable getDependencyModulesForExternalInstall(File sWebAppContextPath, File npmFile) {
        LinkedHashSet<ModuleInfo> setAvailableLocally = new LinkedHashSet<ModuleInfo>();
        LinkedHashSet<Object> setNotAvailableLocally = new LinkedHashSet<Object>();
        LinkedHashSet<ModuleInfo> setInstalled = new LinkedHashSet<ModuleInfo>();
        Hashtable ht_localModules = FwUtils.readmodulesPackagesForExternalInstall(sWebAppContextPath);
        Hashtable ht_installedModules = ModuleManager.getAllInstalledModules();
        try {
            String npmPath = npmFile.getAbsolutePath();
            ZipFile zipFile = new ZipFile(npmPath);
            String zipName = zipFile.getName();
            ModuleInfo mInfo = new ModuleInfo();
            ModuleManager.getNPMInfo(zipName, mInfo);
            mInfo.setFilename(npmFile.getName());
            mInfo.setIsLocal(true);
            mInfo.setUrl("file://" + npmFile.getAbsolutePath(), 0);
            setAvailableLocally.add(mInfo);
            Iterator itr = setAvailableLocally.iterator();
            int count = 0;
            String[] arrayDepModules = null;
            while (itr.hasNext()) {
                int i;
                ModuleInfo tempMInfo = (ModuleInfo)itr.next();
                if (tempMInfo.isLocal()) {
                    arrayDepModules = tempMInfo.getDependsOn();
                } else {
                    arrayDepModules = null;
                    setNotAvailableLocally.add(tempMInfo);
                }
                if (arrayDepModules != null && arrayDepModules.length > 0) {
                    for (i = 0; i < arrayDepModules.length; ++i) {
                        if (ht_localModules.containsKey(arrayDepModules[i])) {
                            if (ht_installedModules.containsKey(arrayDepModules[i])) {
                                setInstalled.add((ModuleInfo)ht_localModules.get(arrayDepModules[i]));
                                continue;
                            }
                            setAvailableLocally.add((ModuleInfo)ht_localModules.get(arrayDepModules[i]));
                            continue;
                        }
                        if (arrayDepModules[i].equals(mInfo.getModuleID())) continue;
                        setNotAvailableLocally.add(arrayDepModules[i]);
                    }
                }
                itr = setAvailableLocally.iterator();
                ++count;
                for (i = 0; i < count; ++i) {
                    if (!itr.hasNext()) continue;
                    itr.next();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Hashtable<String, LinkedHashSet<Object>> ht_dependencies = new Hashtable<String, LinkedHashSet<Object>>();
        ht_dependencies.put("availablemodules", setAvailableLocally);
        ht_dependencies.put("nonavailablemodules", setNotAvailableLocally);
        ht_dependencies.put("installedmodules", setInstalled);
        return ht_dependencies;
    }

    public static Hashtable readmodulesPackagesForExternalInstall(File sWebAppContextPath) {
        String[] sPackages;
        Hashtable<String, ModuleInfo> ht_localModules = new Hashtable<String, ModuleInfo>();
        File packagesDir = new File(sWebAppContextPath.getAbsolutePath() + File.separator + "packages");
        if (packagesDir != null && (sPackages = packagesDir.list()) != null) {
            for (int i = 0; i < sPackages.length; ++i) {
                String sPackage = sPackages[i];
                int iExt = sPackage.lastIndexOf(46) + 1;
                if (iExt == 0 || !sPackage.substring(iExt).equalsIgnoreCase("npm")) continue;
                ModuleInfo mInfo = new ModuleInfo();
                ModuleManager.getNPMInfo(packagesDir.getAbsolutePath() + File.separator + sPackage, mInfo);
                if (mInfo.getModuleID().length() > 0 && mInfo.getModuleVersion().length() > 0) {
                    mInfo.setFilename(sPackage);
                    mInfo.setIsLocal(true);
                    mInfo.setUrl("file://" + packagesDir.getAbsolutePath() + File.separator + sPackage, 0);
                    ht_localModules.put(mInfo.getModuleID(), mInfo);
                    continue;
                }
                D.log("\n<<<-------------------------------------------------------------------------");
                D.log("WARNING: \nMissing required fields like Module-ID/Implementation-Version in the NPM's manifest file!");
                D.log("WARNING: \nCheck the manifest file for this NPM:  " + sPackage);
                D.log(">>>------------------------------------------------------------------------- \n");
            }
        }
        return ht_localModules;
    }

    static {
        LANGUAGES_FOR_TRANSLATION_DEFAULT = new String[]{"de", "en", "es", "fr", "it", "ja", "pt", "ru", "pl", "zh_CN", "zh_TW", "cs", "hu", "sk"};
        sm_singleGadgetDevices = new HashSet();
        sm_specialStylesheetDevices = new HashSet();
        m_contentType = DEFAULT_CONTENT_TYPE;
        B_TRUE = new Boolean(true);
        B_FALSE = new Boolean(false);
        applicationStartTime = 0L;
    }
}

