/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.NvdsLdapExtensions.DMITaskInfo;
import com.novell.NvdsLdapExtensions.EnforcementData;
import com.novell.NvdsLdapExtensions.NVDSException;
import com.novell.NvdsLdapExtensions.NvdsLdapExtensions;
import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.NamespaceException;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.fw.RBSUtil;
import com.novell.emframe.fw.VersionInfo;
import com.novell.rbs.RBSAssociatedObject;
import com.novell.rbs.RBSCollection;
import com.novell.rbs.RBSModule;
import com.novell.rbs.RBSRole;
import com.novell.rbs.RBSTask;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.naming.NamingException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;

public class GenerateDMITaskDocument {
    private MContext m_context;
    private AdminNamespace m_ns;
    private Document m_doc;

    GenerateDMITaskDocument(MContext context, AdminNamespace ns, Document doc) {
        this.m_context = context;
        this.m_ns = ns;
        this.m_doc = doc;
    }

    public Document getDocument() throws JDOMException, IOException, NamingException, SPIException, NamespaceException, NVDSException {
        DMITaskInfo[] dmiTaskInfo;
        if (!this.m_ns.isSupported("NVDS")) {
            return null;
        }
        Element oldRootElement = this.m_doc.getRootElement();
        Element newRootElement = new Element("install");
        Element oldModuleElement = oldRootElement.getChild("module");
        if (oldModuleElement != null) {
            newRootElement.addContent((Element)oldModuleElement.clone());
            Element newModuleElement = newRootElement.getChild("module");
            Element moduleVersion = newModuleElement.getChild("version");
            if (moduleVersion != null) {
                newModuleElement.removeChild("version");
                moduleVersion = new Element("version");
                moduleVersion.setText("2.0.0");
                newModuleElement.addContent(moduleVersion);
            } else {
                moduleVersion = new Element("version");
                moduleVersion.setText("2.0.0");
                newModuleElement.addContent(moduleVersion);
            }
        }
        if ((dmiTaskInfo = NvdsLdapExtensions.getAllDMITaskOperations((AdminNamespace)this.m_ns)) != null) {
            for (int iCount = 0; iCount < dmiTaskInfo.length; ++iCount) {
                String taskID = "NVDSServerMgmt." + dmiTaskInfo[iCount].getOperationName();
                Element taskElement = new Element("task");
                Element idElement = new Element("id");
                idElement.addContent(taskID);
                taskElement.addContent(idElement);
                Element versionElement = new Element("version");
                versionElement.addContent(dmiTaskInfo[iCount].getVersionSuffix());
                taskElement.addContent(versionElement);
                Element requiredVersionElement = new Element("required-version");
                requiredVersionElement.addContent("2.6.0");
                taskElement.addContent(requiredVersionElement);
                Element classNameElement = new Element("class-name");
                classNameElement.addContent("com.novell.admin.nvdsservermgmt.DMITask");
                taskElement.addContent(classNameElement);
                Element urlParamElement = new Element("url-param");
                Element paramKeyElement = new Element("param-key").setText("operationID");
                urlParamElement.addContent(paramKeyElement);
                Element paramValueElement = new Element("param-value").setText(dmiTaskInfo[iCount].getOperationID());
                urlParamElement.addContent(paramValueElement);
                taskElement.addContent(urlParamElement);
                EnforcementData[] enforcementData = dmiTaskInfo[iCount].getEnforcementData();
                if (enforcementData != null) {
                    Element secondaryRightsElement = new Element("secondary-rights");
                    for (int jCount = 0; jCount < enforcementData.length; ++jCount) {
                        Element secondarySetElement = new Element("secondary-set");
                        Element contextPathElement = new Element("context-path");
                        contextPathElement.addContent(enforcementData[jCount].getEntry());
                        secondarySetElement.addContent(contextPathElement);
                        Element rightsAssignment = new Element("rights-assignment");
                        Element attributeNameElement = new Element("attribute-name");
                        attributeNameElement.addContent(enforcementData[jCount].getAttribute());
                        rightsAssignment.addContent(attributeNameElement);
                        String[] permissions = enforcementData[jCount].getPermissionsStrings();
                        if (permissions != null) {
                            for (int kCount = 0; kCount < permissions.length; ++kCount) {
                                Element permissionElement = new Element("privilege");
                                permissionElement.addContent(permissions[kCount]);
                                rightsAssignment.addContent(permissionElement);
                            }
                            secondarySetElement.addContent(rightsAssignment);
                        }
                        secondaryRightsElement.addContent(secondarySetElement);
                    }
                    taskElement.addContent(secondaryRightsElement);
                }
                taskElement.addContent(this.getAuthAssignmentElement());
                taskElement.addContent(this.getDMIAuthAssignmentElement());
                String roleName = dmiTaskInfo[iCount].getServiceName();
                if (roleName.length() > 0) {
                    this.createRoleElement(newRootElement, roleName);
                    Element roleElement = new Element("role-assignment").setText(roleName);
                    taskElement.addContent(roleElement);
                }
                newRootElement.addContent(taskElement);
            }
        }
        this.setModuleVersionNumber(newRootElement);
        return new Document(newRootElement);
    }

    private Element getAuthAssignmentElement() {
        Element authAssignmentElement = new Element("auth-assignment");
        Element idElement = new Element("id");
        idElement.addContent("dir");
        authAssignmentElement.addContent(idElement);
        Element reqElement = new Element("required");
        reqElement.addContent("true");
        authAssignmentElement.addContent(reqElement);
        Element settingElement = new Element("setting");
        Element nameElement = new Element("name");
        nameElement.addContent("system");
        settingElement.addContent(nameElement);
        Element valueElement = new Element("value");
        valueElement.addContent("NVDS");
        settingElement.addContent(valueElement);
        authAssignmentElement.addContent(settingElement);
        return authAssignmentElement;
    }

    private Element getDMIAuthAssignmentElement() {
        Element authAssignmentElement = new Element("auth-assignment");
        Element idElement = new Element("id");
        idElement.addContent("dmi");
        authAssignmentElement.addContent(idElement);
        Element reqElement = new Element("required");
        reqElement.addContent("true");
        authAssignmentElement.addContent(reqElement);
        return authAssignmentElement;
    }

    private void createRoleElement(Element rootElement, String roleName) {
        boolean found = false;
        List list = rootElement.getChildren("role");
        if (list.size() > 0) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                Element roleElement = (Element)iter.next();
                String roleID = roleElement.getChild("id").getTextTrim();
                if (!roleID.equalsIgnoreCase(roleName)) continue;
                found = true;
                break;
            }
        }
        if (!found) {
            Element roleElement = new Element("role");
            Element idElement = new Element("id");
            idElement.addContent(roleName);
            roleElement.addContent(idElement);
            Element versionElement = new Element("version");
            versionElement.addContent("2.0.0");
            roleElement.addContent(versionElement);
            Element requiredVersionElement = new Element("required-version");
            requiredVersionElement.addContent("2.6.0");
            roleElement.addContent(requiredVersionElement);
            roleElement.addContent(this.getAuthAssignmentElement());
            roleElement.addContent(this.getDMIAuthAssignmentElement());
            Element categoryElement = new Element("role-category-assignment");
            categoryElement.addContent("Virtual Directory");
            roleElement.addContent(categoryElement);
            rootElement.addContent(roleElement);
        }
    }

    private void setModuleVersionNumber(Element rootElement) throws SPIException, JDOMException, IOException, NamespaceException {
        ObjectEntry treeOE = RBSUtil.getTreeOE(this.m_context);
        ObjectEntry whoami = this.m_ns.getAuthenticatedIdentity(treeOE);
        RBSAssociatedObject rbsAssociatedObject = new RBSAssociatedObject(whoami);
        RBSCollection[] rbsCollections = rbsAssociatedObject.getAllOwnedCollections2();
        if (rbsCollections != null) {
            Element moduleElement = rootElement.getChild("module");
            String moduleID = moduleElement.getChild("id").getTextTrim();
            List roleList = rootElement.getChildren("role");
            List taskList = rootElement.getChildren("task");
            Vector<String> moduleVersion = new Vector<String>();
            block0: for (int iCount = 0; iCount < rbsCollections.length; ++iCount) {
                String fileVesion;
                Iterator iter;
                boolean keepLooking = true;
                ObjectEntry collectionOE = rbsCollections[iCount].getObjectEntry();
                if (!this.m_ns.doesExist(collectionOE, "cn=" + moduleID)) continue;
                ObjectEntry moduleOE = this.m_ns.getObjectEntry(collectionOE, "cn=" + moduleID);
                RBSModule rbsModule = new RBSModule(moduleOE);
                String moduleOjectVersion = RBSUtil.getVersionFromElement(rbsModule.getrbsXMLInfo("version"));
                if (moduleOjectVersion == null) {
                    D.log("The version element for " + this.m_ns.getUnrootedName(moduleOE) + " has not been set.  Initializing to 0.0.0.");
                    moduleOjectVersion = "0.0.0";
                }
                moduleVersion.add(moduleOjectVersion);
                if (taskList.size() > 0) {
                    iter = taskList.iterator();
                    while (iter.hasNext()) {
                        Element taskElement = (Element)iter.next();
                        String taskID = taskElement.getChild("id").getTextTrim();
                        fileVesion = taskElement.getChild("version").getTextTrim();
                        String taskName = taskID.substring(taskID.indexOf(".") + 1);
                        if (this.m_ns.doesExist(moduleOE, "cn=" + taskName)) {
                            VersionInfo fileVersionInfo = new VersionInfo(fileVesion);
                            ObjectEntry taskOE = this.m_ns.getObjectEntry(moduleOE, "cn=" + taskName);
                            RBSTask rbsTask = new RBSTask(taskOE);
                            String paramaters = rbsTask.getParameters();
                            String objectVersion = RBSUtil.getVersionFromParameters(paramaters);
                            VersionInfo objectVersionInfo = new VersionInfo(objectVersion);
                            int value = fileVersionInfo.compareTo(objectVersionInfo);
                            if (value <= 0) continue;
                            moduleVersion.add(this.incrementRevisionNumber(moduleOjectVersion));
                            keepLooking = false;
                            break;
                        }
                        moduleVersion.add(this.incrementRevisionNumber(moduleOjectVersion));
                        keepLooking = false;
                        break;
                    }
                }
                if (roleList.size() <= 0 || !keepLooking) continue;
                iter = roleList.iterator();
                while (iter.hasNext()) {
                    Element roleElement = (Element)iter.next();
                    String roleID = roleElement.getChild("id").getTextTrim();
                    fileVesion = roleElement.getChild("version").getTextTrim();
                    if (this.m_ns.doesExist(collectionOE, "cn=" + roleID)) {
                        VersionInfo fileVersionInfo = new VersionInfo(fileVesion);
                        ObjectEntry roleOE = this.m_ns.getObjectEntry(collectionOE, "cn=" + roleID);
                        RBSRole rbsRole = new RBSRole(roleOE);
                        String paramaters = rbsRole.getParameters();
                        String objectVersion = RBSUtil.getVersionFromParameters(paramaters);
                        VersionInfo objectVersionInfo = new VersionInfo(objectVersion);
                        int value = fileVersionInfo.compareTo(objectVersionInfo);
                        if (value <= 0) continue;
                        moduleVersion.add(this.incrementRevisionNumber(moduleOjectVersion));
                        continue block0;
                    }
                    moduleVersion.add(this.incrementRevisionNumber(moduleOjectVersion));
                    continue block0;
                }
            }
            if (moduleVersion.size() > 0) {
                String moduleVersionString = (String)moduleVersion.get(0);
                for (int jCount = 1; jCount < moduleVersion.size(); ++jCount) {
                    VersionInfo oldVersionInfo = new VersionInfo(moduleVersionString);
                    VersionInfo newVersionInfo = new VersionInfo((String)moduleVersion.get(jCount));
                    if (newVersionInfo.compareTo(oldVersionInfo) <= 0) continue;
                    moduleVersionString = (String)moduleVersion.get(jCount);
                }
                Element versionElement = moduleElement.getChild("version");
                versionElement.setText(moduleVersionString);
            }
        }
    }

    private String incrementRevisionNumber(String versionNumber) {
        VersionInfo versionInfo = new VersionInfo(versionNumber);
        Integer rev = versionInfo.getRev();
        int intValue = rev + 1;
        rev = new Integer(intValue);
        versionInfo.setRev(rev);
        return versionInfo.getVersionString();
    }
}

