/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.SchemaDefinition;
import com.novell.admin.ns.SchemaUtil;
import com.novell.admin.ns.ldap.LDAPNamespace;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.JobData;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.UiHandler;
import com.novell.emframe.dev.UiHandlerContext;
import com.novell.emframe.dev.eDirAccessService;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.EdasRightsData;
import com.novell.emframe.fw.FakeRightsCache;
import com.novell.emframe.fw.iManager;
import com.novell.emframe.fw.studio.CreateCustomPlugin;
import com.novell.emframe.fw.studio.TemplateBuilder;
import com.novell.emframe.fw.uihandlers.CreateContextTextfield;
import com.novell.emframe.fw.uihandlers.TextfieldUiHandler;
import com.novell.nps.gadgetManager.GadgetInstance;
import com.novell.webaccess.common.I18NServletRequest;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.ResourceBundle;

public class GenericCreator
extends Task {
    private static final long serialVersionUID = 1L;
    public static final String HTMLPARAM_CONTEXT = "ObjectContext";
    public static final String HTMLPARAM_OBJECT_TYPES = "objectTypeName";
    public static final String HTMLPARAM_SELECTEDCLASS = "SelectedClass";
    public static final String HTMLPARAM_TRANSLATEDCLASS = "TranslatedClass";
    public static final String HTMLPARAM_GIFNAME = "GifName";
    I18NServletRequest m_req;
    TaskContext m_context;
    Properties m_resultStrings;
    ResourceBundle m_rBundle;
    ObjectEntry m_treeOE;
    AdminNamespace m_namespace;
    AttributeDefinition[] m_naming;
    AttributeDefinition[] m_mandatory;
    String m_strObjectClass;
    String m_namingAttribute;
    private String m_sShowModify;

    public boolean execute(TaskContext context, Properties resultStrings) {
        this.m_context = context;
        this.m_resultStrings = resultStrings;
        this.m_req = (I18NServletRequest)context.getRequest();
        String nextState = this.m_req.getParameter("nextState");
        if (nextState.equalsIgnoreCase("initialState")) {
            AttributeDefinition[] attributeDefinitions;
            String className = this.m_req.getParameter(HTMLPARAM_SELECTEDCLASS);
            Object client = this.m_req.getSession().getAttribute("DeviceType");
            AuthenticationBroker broker = this.m_context.getAuthenticationBroker();
            this.m_sShowModify = this.m_req.getParameter("ShowModifyObject");
            if (null == this.m_sShowModify || this.m_sShowModify.length() == 0) {
                this.m_sShowModify = "true";
            }
            try {
                this.m_treeOE = (ObjectEntry)broker.getProtocolObject("AdminNamespace");
                this.m_namespace = this.m_treeOE.getAdminNamespace();
                SchemaDefinition schemaDef = this.m_namespace.getSchemaDefinition(this.m_treeOE);
                AttributeDefinition[] mandatory = schemaDef.getMandatoryAttributes(className);
                ClassDefinition[] containment = schemaDef.getContainmentClasses(className);
                String bestNamingAttr = CreateCustomPlugin.findBestNamingAttribute(schemaDef, className);
                AttributeDefinition bestNamingAttrDef = schemaDef.getAttributeDefinition(bestNamingAttr);
                this.buildSearchFilter(containment);
                attributeDefinitions = this.PutRequiredAttributes(this.m_treeOE, mandatory, bestNamingAttrDef);
                if (null == attributeDefinitions) {
                    D.log("Generic Creator does not know how to create this type of object.\nThere was no naming attribute for this object type.");
                    String strTitle = eMFrameUtils.getLocalizedString("FwResources", "FwConsts.RES_CREATEOBJECT_FAILURE", this.m_context);
                    String strBody = eMFrameUtils.getLocalizedString("FwResources", "FwConsts.RES_NO_REGISTRATION", this.m_context);
                    eMFrameUtils.setMessage("error", strTitle, strBody, context);
                    this.setUIPage("dev/GenErr.jsp");
                    return false;
                }
            }
            catch (Exception e) {
                D.log(e);
                this.m_resultStrings.put("GeneralMsg.MsgBodyId", eMFrameUtils.getExceptionMessage(e, this.m_context));
                return false;
            }
            try {
                String[] superClasses = this.m_context.getDirUtils().getSuperClasses(className);
                UiHandler[] uihandlers = TemplateBuilder.getDefaultHandlers(this.m_context, attributeDefinitions, (String)client, className, superClasses, false, true);
                ArrayList<UiHandler> resizeList = new ArrayList<UiHandler>(Arrays.asList(uihandlers));
                CreateContextTextfield uihandler = new CreateContextTextfield();
                UiHandlerContext uiHandlerContext = new UiHandlerContext("context", "context", "Case Exact String", (String)client, false, true, false, 0L, 0L, false, "eDir$target", null, false);
                uihandler.init(uiHandlerContext);
                resizeList.add(uihandler);
                uihandlers = resizeList.toArray(new UiHandler[resizeList.size()]);
                String customLabel = "<%= eMFrameUtils.toScript(c.formatMessage(c.string(\"Creator.NamePrompt\"), new String[]{c.var(\"TranslatedClass\")} ) )%>";
                for (int i = 0; i < uihandlers.length; ++i) {
                    if (uihandlers[i].getAttributeName().equals(this.m_namingAttribute)) {
                        uihandlers[i].setParameterValue("customLabel", customLabel);
                    }
                    if (!(uihandlers[i] instanceof TextfieldUiHandler)) continue;
                    ((TextfieldUiHandler)uihandlers[i]).setMakeFieldSubmitable(true);
                }
                String tempDir = iManager.getAbsModulesPath() + "/temp/skins/default/devices/" + client + "/";
                String sProtocol = this.m_namespace.getUniqueID();
                String sDirectory = null;
                if (this.m_namespace instanceof NDSNamespace) {
                    sDirectory = broker.getAuthNdapAccessDomain();
                } else if (this.m_namespace instanceof LDAPNamespace) {
                    sDirectory = broker.getAuthLdapAccessDomain();
                }
                DirUtils dirUtils = context.getDirUtils();
                String safeclassName = dirUtils.getSafeName(sProtocol + sDirectory + "creator" + className + TemplateBuilder.getVersionString(context));
                File file = new File(tempDir + safeclassName + ".jsp");
                if (!file.exists()) {
                    TemplateBuilder.createTemplate(context, uihandlers, (String)client, true, "TemplateBuilder_skeletonCreate.jsp", null, true, "temp", file.getName(), true);
                }
                this.setUIPage("temp/" + file.getName());
                this.m_req.setAttribute("edasRights", new EdasRightsData(new FakeRightsCache()));
            }
            catch (IOException e) {
                D.log(e);
                this.m_resultStrings.put("GeneralMsg.MsgBodyId", eMFrameUtils.getExceptionMessage(e, this.m_context));
                return false;
            }
            catch (NamespaceException e) {
                D.log(e);
                this.m_resultStrings.put("GeneralMsg.MsgBodyId", eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.m_context));
                return false;
            }
            this.m_resultStrings.put(HTMLPARAM_GIFNAME, this.m_context.getDirUtils().getObjectTypeImageName(className));
            String strBody = eMFrameUtils.getLocalizedString("FwResources", "Creator.Create", this.m_context);
            String strDisplayTask = eMFrameUtils.formatMessage(strBody, new String[]{this.m_context.getDirUtils().getObjectTypeDisplayName(className, this.m_context)});
            this.m_resultStrings.put("Task.displayName", strDisplayTask);
            this.m_resultStrings.put("createClassName", className);
            return true;
        }
        if (nextState.equalsIgnoreCase("eDasServiceAccess")) {
            eDirAccessService edas = new eDirAccessService();
            boolean edasFlag = edas.execute(this.m_context, this.m_resultStrings);
            if (edasFlag) {
                this.m_resultStrings.put("GeneralMsg.ShowModifyObject", this.m_sShowModify);
            }
            resultStrings.put("dev.refreshOV", "true");
            JobData data = JobData.getJobData((GadgetInstance)this);
            if (null != data) {
                data.setObjectNames(new String[]{this.m_req.getParameter("eDir$target") + "." + this.m_req.getParameter("eDir$target$createContext")});
            }
            return edasFlag;
        }
        return false;
    }

    private AttributeDefinition[] PutRequiredAttributes(ObjectEntry oe, AttributeDefinition[] mandatory, AttributeDefinition namingAttrDef) {
        ArrayList<AttributeDefinition> list = new ArrayList<AttributeDefinition>();
        if (namingAttrDef == null) {
            return null;
        }
        list.add(namingAttrDef);
        String namingAttr = namingAttrDef.getName();
        for (int i = 0; i < mandatory.length; ++i) {
            if (mandatory[i].getName().equals(SchemaUtil.translateNDAPAttr((ObjectEntry)oe, (String)"Object Class")) || mandatory[i].getName().equals(namingAttr)) continue;
            list.add(mandatory[i]);
        }
        AttributeDefinition[] aDefinitions = list.toArray(new AttributeDefinition[list.size()]);
        for (int cntr = 0; cntr < aDefinitions.length; ++cntr) {
            String temp = this.m_context.getDirUtils().getSafeName(aDefinitions[cntr].getName()) + "DisplayName";
            this.m_resultStrings.put(temp, this.m_context.getDirUtils().getAttributeDisplayName(aDefinitions[cntr].getName(), this.m_context));
        }
        this.m_namingAttribute = this.m_context.getDirUtils().getSafeName(namingAttrDef.getName());
        this.m_resultStrings.put("createNamingAttribute", this.m_namingAttribute);
        return aDefinitions;
    }

    private void buildSearchFilter(ClassDefinition[] containment) {
        StringBuffer creatorFilter = new StringBuffer();
        for (int m = 0; m < containment.length; ++m) {
            if (containment[m].getName().equals("Top")) continue;
            if (creatorFilter.length() > 0) {
                creatorFilter.append(",");
            }
            if (containment[m].getName().equals("Tree Root")) {
                creatorFilter.append("[root]");
                continue;
            }
            creatorFilter.append(containment[m].getName());
        }
        if (creatorFilter.length() == 0) {
            creatorFilter.append("*");
        }
        this.m_resultStrings.put("CreatorSearchFilter", creatorFilter.toString());
    }
}

