/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.ns.AdminNamespace;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.SnapinException;
import com.novell.emframe.dev.AuthBrokerException;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.GlobalRegistry;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.MTask;
import com.novell.emframe.dev.XmlUtils;
import com.novell.emframe.dev.config.ConfigException;
import com.novell.emframe.dev.config.UserConfig;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.FwAttr;
import com.novell.emframe.fw.OrderComparator;
import com.novell.emframe.fw.Registry;
import com.novell.emframe.fw.ViewAdminTask;
import com.novell.emframe.fw.authenticator.DirAuthenticator;
import com.novell.emframe.fw.authenticator.FwAuthUtils;
import com.novell.emframe.fw.servlet.AuthenticatorServlet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jdom.Document;
import org.jdom.Element;

public class HeaderTask
extends MTask {
    private boolean m_bShowLogins = false;
    private UserConfig m_uc = null;

    public void execute(MContext context) {
        this.m_uc = HeaderTask.readViewFlags(context);
        HttpServletRequest req = context.getRequest();
        if (req.getParameter("SHOW_LOGINS") != null) {
            this.m_bShowLogins = true;
        }
        this.doWork(context, req);
    }

    private static UserConfig readViewFlags(MContext context) {
        String sValue;
        boolean bReadParent = true;
        UserConfig uc = UserConfig.getUserConfig("fwViewAdmin", context);
        if (uc != null && (sValue = uc.getSetting(ViewAdminTask.READ_PARENT_OBJECTS)) != null) {
            try {
                int iValue = Integer.parseInt(sValue);
                if (iValue == 0) {
                    bReadParent = false;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (!DirAuthenticator.getDirAuth(context).isAuthenticated(context.getRequest())) {
            return uc;
        }
        try {
            ObjectEntry oeGrandparent;
            ObjectEntry oeParent;
            AuthenticationBroker ab = context.getAuthenticationBroker();
            if (ab == null) {
                return uc;
            }
            AdminNamespace namespace = null;
            ObjectEntry oeRoot = (ObjectEntry)ab.getProtocolObject("AdminNamespace");
            AdminNamespace nsAuth = namespace = oeRoot.getAdminNamespace();
            ObjectEntry oeAuth = nsAuth.getAuthenticatedIdentity(oeRoot);
            while (bReadParent && (oeParent = oeAuth.getParent()) != null && (oeGrandparent = oeParent.getParent()) != null) {
                String sValue2;
                String sObjectDN = namespace.getUnrootedName(oeParent);
                UserConfig ucParent = UserConfig.getUserConfig("fwViewAdmin", sObjectDN, context);
                if (ucParent != null) {
                    String[] saNames = ucParent.getSettingNames();
                    for (int i = 0; i < saNames.length; ++i) {
                        try {
                            uc.setSetting(saNames[i], ucParent.getSetting(saNames[i]));
                            continue;
                        }
                        catch (ConfigException e) {
                            // empty catch block
                        }
                    }
                }
                if ((sValue2 = ucParent.getSetting(ViewAdminTask.READ_PARENT_OBJECTS)) != null) {
                    try {
                        int iValue = Integer.parseInt(sValue2);
                        if (iValue == 0) {
                            bReadParent = false;
                        }
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                oeAuth = oeParent;
            }
        }
        catch (SnapinException e) {
            D.log(e);
        }
        catch (AuthBrokerException e) {
            D.log(e);
        }
        return uc;
    }

    private void doWork(MContext context, HttpServletRequest req) {
        StringBuffer sbXml = new StringBuffer(500);
        sbXml.append("<iManagerHeader>");
        HttpSession session = req.getSession();
        try {
            String userMode;
            String fullname;
            if (this.m_bShowLogins) {
                sbXml.append("<SHOW_LOGINS>SHOW_LOGINS</SHOW_LOGINS>");
                this.m_bShowLogins = false;
            }
            if (D.isDebugEnabled()) {
                sbXml.append("<eMFrame.Debug.enable>true</eMFrame.Debug.enable>");
            }
            if (session.getAttribute("NETIDENTITY_CREDENTIAL") == null && AuthenticatorServlet.isLoggedIn(req)) {
                sbXml.append("<ShowLogout>true</ShowLogout>");
            }
            sbXml.append("<SessionAutoRefresh>").append(session.getMaxInactiveInterval()).append("</SessionAutoRefresh>");
            String sUserName = FwAuthUtils.getUserId(req);
            if (sUserName != null) {
                sbXml.append("<userName>");
                sbXml.append(XmlUtils.xmlEncode(sUserName));
                sbXml.append("</userName>");
            }
            if ((fullname = FwAuthUtils.getUserFullId(req) + "." + FwAuthUtils.getFriendlyHostName(req)) != null) {
                sbXml.append("<fullUserName>");
                sbXml.append(XmlUtils.xmlEncode(fullname));
                sbXml.append("</fullUserName>");
                sbXml.append("<TreeName>");
                sbXml.append(XmlUtils.xmlEncode(fullname.substring(fullname.lastIndexOf(".") + 1)));
                sbXml.append("</TreeName>");
            }
            if ((userMode = eMFrameUtils.getAccessMode(context)) != null) {
                sbXml.append("<User.Mode>").append(userMode).append("</User.Mode>");
            }
            boolean disconnectedMode = false;
            boolean bIsInstalledTree = false;
            boolean bLoggedIn = true;
            bIsInstalledTree = true;
            String currentDevice = (String)session.getAttribute("DeviceType");
            sbXml.append("<DeviceType>").append(currentDevice).append("</DeviceType>");
            ArrayList views = GlobalRegistry.getViews();
            ArrayList viewsToShow = new ArrayList();
            String primaryViewId = "";
            try {
                primaryViewId = context.getPersistentData("fwPrefs", "fw.primaryViewId");
            }
            catch (Throwable t) {
                // empty catch block
            }
            Collections.sort(views, new OrderComparator(primaryViewId));
            for (int j = 0; j < views.size(); ++j) {
                Document viewDoc = (Document)views.get(j);
                bLoggedIn = this.addView(viewDoc, currentDevice, bIsInstalledTree, disconnectedMode, userMode, sUserName, bLoggedIn, primaryViewId, context, sbXml, viewsToShow);
            }
            FwAttr.setFwSessionAttribute("ViewIdList", viewsToShow, session);
            this.writeDefaultView(session, sbXml, userMode, bLoggedIn, primaryViewId, context);
        }
        catch (Exception e) {
            D.log(e);
        }
        sbXml.append("</iManagerHeader>");
        req.setAttribute("xmlData", (Object)sbXml.toString());
    }

    private boolean addView(Document viewDoc, String currentDevice, boolean bIsInstalledTree, boolean disconnectedMode, String userMode, String sUserName, boolean bLoggedIn, String primaryViewId, MContext context, StringBuffer sbXml, ArrayList viewsToShow) {
        Element rootEl = viewDoc.getRootElement();
        String viewId = rootEl.getChildTextTrim("id");
        boolean showView = HeaderTask.supportsDevice(rootEl, currentDevice);
        if (showView) {
            String sOnlyInstalledTree = rootEl.getChildTextTrim("only-installed-tree");
            if (sOnlyInstalledTree != null && sOnlyInstalledTree.equalsIgnoreCase("true") && !bIsInstalledTree) {
                showView = false;
            }
            if (disconnectedMode) {
                if (rootEl.getChildTextTrim("disconnected-enabled") == null) {
                    showView = false;
                }
            } else {
                StringBuffer sb = new StringBuffer();
                sb.append("iManagerView:").append(viewId);
                String setting = this.m_uc.getSetting(sb.toString(), String.valueOf(ViewAdminTask.SHOW));
                if (setting != null) {
                    showView = setting.equalsIgnoreCase(String.valueOf(ViewAdminTask.SHOW));
                }
            }
            if (viewId.equalsIgnoreCase("fw.ConfigureView") && userMode != null && userMode.equalsIgnoreCase("CollectionOwner") && bIsInstalledTree) {
                showView = true;
            }
        }
        if (showView) {
            this.writeView(viewId, primaryViewId, rootEl, context, sbXml);
            viewsToShow.add(viewId);
        }
        return bLoggedIn;
    }

    private void writeDefaultView(HttpSession session, StringBuffer out, String userMode, boolean bLoggedIn, String primaryViewId, MContext context) {
        ArrayList views = GlobalRegistry.getViews();
        int iViewIdx = HeaderTask.getDefaultViewIdx(views, userMode, session, bLoggedIn, primaryViewId, context);
        if (iViewIdx != -1) {
            Document viewDoc = (Document)views.get(iViewIdx);
            Element rootEl = viewDoc.getRootElement();
            String sDefView = rootEl.getChildTextTrim("id");
            String sDefURL = rootEl.getChildTextTrim("url");
            if (sDefView != null) {
                out.append("<defaultView>").append(sDefView).append("</defaultView>");
            }
            if (sDefURL != null) {
                out.append("<defaultViewurl>").append(eMFrameUtils.urlEncode(sDefURL)).append("</defaultViewurl>");
            }
        }
    }

    private void writeView(String viewId, String primaryViewId, Element rootEl, MContext context, StringBuffer sbXml) {
        sbXml.append("<iManView id=\"").append(viewId).append("\" order=");
        if (primaryViewId != null && primaryViewId.equals(viewId)) {
            sbXml.append("\"301\">");
        } else {
            sbXml.append("\"").append(rootEl.getChildTextTrim("order")).append("\">");
        }
        sbXml.append("<url><![CDATA[").append(rootEl.getChildTextTrim("url")).append("]]></url>");
        sbXml.append("<header-normal-icon>").append(rootEl.getChildTextTrim("header-normal-icon")).append("</header-normal-icon>");
        sbXml.append("<header-mouseover-icon>").append(rootEl.getChildTextTrim("header-mouseover-icon")).append("</header-mouseover-icon>");
        sbXml.append("<header-selected-icon>").append(rootEl.getChildTextTrim("header-selected-icon")).append("</header-selected-icon>");
        String resBundle = rootEl.getChildTextTrim("resource-properties-file");
        String s = eMFrameUtils.getLocalizedString(resBundle, rootEl.getChildTextTrim("header-hint-text-key"), context.getLocale());
        sbXml.append("<header-hint-text><![CDATA[").append(s).append("]]></header-hint-text>");
        s = eMFrameUtils.getLocalizedString(resBundle, rootEl.getChildTextTrim("header-hint-text-selected-key"), context.getLocale());
        sbXml.append("<header-hint-text-selected><![CDATA[").append(s).append("]]></header-hint-text-selected>");
        String target = rootEl.getChildTextTrim("target-frame");
        if (target != null) {
            sbXml.append("<target-frame>").append(target).append("</target-frame>");
        } else {
            sbXml.append("<target-frame>Mainscreen</target-frame>");
        }
        sbXml.append("</iManView>");
    }

    public static int getDefaultViewIdx(ArrayList views, String userMode, HttpSession session, boolean bLoggedIn, String primaryViewId, MContext context) {
        int iViewIdx = -1;
        int iDefaultPriority = Integer.MAX_VALUE;
        String currentDevice = (String)session.getAttribute("DeviceType");
        UserConfig uc = HeaderTask.readViewFlags(context);
        for (int j = 0; j < views.size(); ++j) {
            Document viewDoc = (Document)views.get(j);
            Element rootEl = viewDoc.getRootElement();
            boolean showView = true;
            if (!HeaderTask.supportsDevice(rootEl, currentDevice)) {
                showView = false;
            }
            String viewId = rootEl.getChildTextTrim("id");
            StringBuffer sb = new StringBuffer();
            sb.append("iManagerView:").append(viewId);
            String setting = uc.getSetting(sb.toString(), String.valueOf(ViewAdminTask.SHOW));
            if (setting != null) {
                showView = setting.equalsIgnoreCase(String.valueOf(ViewAdminTask.SHOW));
            }
            if (viewId.equalsIgnoreCase("fw.ConfigureView") && userMode != null && userMode.equalsIgnoreCase("CollectionOwner")) {
                showView = true;
            }
            if (!bLoggedIn && !viewId.equalsIgnoreCase("fw.LoginToDiffTree")) {
                showView = false;
            }
            if (!showView) continue;
            String sOrder = rootEl.getChildTextTrim("order");
            if (primaryViewId != null && primaryViewId.equals(viewId)) {
                sOrder = "301";
            }
            if (sOrder == null || sOrder.length() == 0) continue;
            String sCanBeDefault = rootEl.getChildTextTrim("can-be-default");
            if (sCanBeDefault == null || sCanBeDefault.length() == 0) {
                sCanBeDefault = "true";
            }
            try {
                int iOrder = Integer.parseInt(sOrder);
                if (iOrder >= iDefaultPriority || !sCanBeDefault.equalsIgnoreCase("true")) continue;
                iViewIdx = j;
                iDefaultPriority = iOrder;
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return iViewIdx;
    }

    private static boolean supportsDevice(Element rootEl, String currentDevice) {
        boolean supportsDevice = false;
        List supportedDeviceList = rootEl.getChildren("supported-device-type");
        if (supportedDeviceList.isEmpty()) {
            return Registry.getDefaultDevices().contains(currentDevice);
        }
        Iterator i = supportedDeviceList.iterator();
        while (i.hasNext()) {
            Element element = (Element)i.next();
            String s = element.getTextTrim();
            if (s == null || !s.equalsIgnoreCase(currentDevice)) continue;
            supportsDevice = true;
            break;
        }
        return supportsDevice;
    }
}

