/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.ldap.LDAPNamespace;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.AuthBrokerException;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.PluginException;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.HiddenPluginsInfo;
import com.novell.rbs.RBSAssociatedObject;
import com.novell.rbs.RBSCollection;
import java.util.ArrayList;
import java.util.Properties;
import org.jdom.Document;

public class HiddenPluginsInfoTask
extends Task {
    private static final long serialVersionUID = 1L;
    AdminNamespace ns = null;
    ObjectEntry treeOE = null;
    ObjectEntry userOE = null;

    public boolean execute(TaskContext context, Properties resultStrings) {
        RBSCollection[] usersCollection = null;
        usersCollection = this.getUsersCollection(context);
        ArrayList array = (ArrayList)context.getAuthAttribute("fw.HiddenTasks");
        String update = "false";
        if (array == null) {
            array = new ArrayList();
        }
        int count = 0;
        for (int i = 0; i < array.size(); ++i) {
            try {
                HiddenPluginsInfo hti = (HiddenPluginsInfo)array.get(i);
                Document doc = hti.getDoc();
                String displayName = eMFrameUtils.getDisplayName(doc, (MContext)context);
                String id = doc.getRootElement().getChildTextTrim("id");
                String collection = doc.getRootElement().getChildTextTrim("collection");
                String error = this.getReason(hti);
                resultStrings.put("Task." + count + ".id", id);
                if (collection != null) {
                    if (usersCollection != null) {
                        for (int x = 0; x < usersCollection.length; ++x) {
                            ObjectEntry oe = usersCollection[x].getObjectEntry();
                            String name = this.ns.getUnrootedName(oe);
                            if (!collection.equalsIgnoreCase(name)) continue;
                            update = "true";
                            break;
                        }
                    }
                    resultStrings.put("Task." + count + ".update", update);
                    resultStrings.put("Task." + count + ".collection", collection);
                }
                resultStrings.put("Task." + count + ".role", hti.getRoleName());
                resultStrings.put("Task." + count + ".name", displayName);
                resultStrings.put("Task." + count + ".error", error);
                ++count;
                continue;
            }
            catch (Exception e) {
                D.log(e);
            }
        }
        resultStrings.put("Task.count", Integer.toString(count));
        return true;
    }

    private String getReason(HiddenPluginsInfo hti) {
        String error = null;
        error = hti.getError() instanceof PluginException ? ((PluginException)hti.getError()).getBody() : hti.getError().getLocalizedMessage();
        if (hti.getError() instanceof ClassNotFoundException) {
            error = "ClassNotFoundException - " + error;
        } else if (hti.getError() instanceof NoClassDefFoundError) {
            error = "NoClassDefFoundError - " + error;
        }
        if (error == null) {
            error = "";
        }
        return error;
    }

    private RBSCollection[] getUsersCollection(TaskContext context) {
        RBSCollection[] rbsCollection = null;
        try {
            AuthenticationBroker broker = context.getAuthenticationBroker();
            this.treeOE = (ObjectEntry)broker.getProtocolObject("AdminNamespace");
            this.ns = (AdminNamespace)this.treeOE.getNamespace();
            this.userOE = this.ns.getUniqueID().equals("NDS") ? ((NDSNamespace)this.ns).getAuthenticatedIdentity(this.treeOE) : ((LDAPNamespace)this.ns).getAuthenticatedIdentity(this.treeOE);
            RBSAssociatedObject rbsAssociatedObject = new RBSAssociatedObject(this.userOE);
            rbsCollection = rbsAssociatedObject.getAllOwnedCollections2();
        }
        catch (SPIException spie) {
            D.log(spie);
        }
        catch (NamespaceException nse) {
            D.log(nse);
        }
        catch (AuthBrokerException abe) {
            D.log(abe);
        }
        return rbsCollection;
    }
}

