/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.emframe.dev.D;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameFactory;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.Registry;
import com.novell.emframe.fw.config.ModuleInfo;
import com.novell.emframe.fw.config.ModuleManager;
import com.novell.nps.WebappUtil;
import com.novell.nps.utils.Log;
import java.io.File;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class InstalledNPM
extends Task {
    private static final long serialVersionUID = 1L;
    private TaskContext m_context;
    private HttpServletRequest m_req;
    public static String DT = "InstalledNPM";
    private String[] m_arrModules = null;
    private static String FRAME_WORK = "fw";
    private static String BASE_PLUGIN = "base";
    private static String SUPPORT_PACK = "iman_supportpack";

    public boolean execute(TaskContext context, Properties properties) {
        this.m_context = context;
        this.m_req = context.getRequest();
        if (!FwUtils.canConfigureiManager(this.m_req)) {
            eMFrameUtils.setMessage("error", eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context), eMFrameUtils.getLocalizedString("FwResources", "Configure.UserNotAuthorizedToConfigureiManager", this.m_context), this.m_context);
            return false;
        }
        if (this.m_req != null) {
            String sAction = this.m_req.getParameter("moduleaction");
            if (sAction == null || sAction.length() == 0) {
                sAction = "Refresh";
            }
            if (sAction.equalsIgnoreCase("Refresh")) {
                ModuleManager.readModules();
                this.setUIPage("fw/InstalledNPM.jsp");
                Hashtable installedNPM = ModuleManager.getAllInstalledModules();
                this.setModules(installedNPM);
            } else if (sAction.equalsIgnoreCase("Delete")) {
                String sPackedModule = this.m_req.getParameter("selectedItems");
                this.m_arrModules = eMFrameUtils.unpack(sPackedModule, this.m_context);
                if (this.m_arrModules.length == 1 && this.m_arrModules[0].toString().equals(FRAME_WORK)) {
                    this.setModules(ModuleManager.getAllInstalledModules());
                    eMFrameUtils.setMessage("warning", eMFrameUtils.getLocalizedString("FwResources", "Warning", this.m_context), eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "ModulesToInstall.CannotDelete", this.m_context), new String[]{this.m_arrModules[0].toString()}), this.m_context);
                    this.setUIPage("fw/InstalledNPM.jsp");
                    return true;
                }
                if (this.m_arrModules != null && this.m_arrModules.length == 0) {
                    this.setModules(ModuleManager.getAllInstalledModules());
                    eMFrameUtils.setMessage("warning", eMFrameUtils.getLocalizedString("FwResources", "Warning", this.m_context), eMFrameUtils.getLocalizedString("FwResources", "ModulesToInstall.NoModulesSelected", this.m_context), this.m_context);
                    this.setUIPage("fw/InstalledNPM.jsp");
                    return true;
                }
                for (int i = 0; i < this.m_arrModules.length; ++i) {
                    String sModuleID = this.m_arrModules[i].toString();
                    if (sModuleID.equals(FRAME_WORK)) continue;
                    this.deleteModule(sModuleID);
                }
                ModuleManager.readModules();
                this.setUIPage("fw/InstalledNPM.jsp");
                this.setModules(ModuleManager.getAllInstalledModules());
            } else if (sAction.equalsIgnoreCase("Uninstall")) {
                String moduleID;
                String sPackedModule = this.m_req.getParameter("selectedItems");
                this.m_arrModules = eMFrameUtils.unpack(sPackedModule, this.m_context);
                if (this.m_arrModules != null && this.m_arrModules.length == 0) {
                    this.setModules(ModuleManager.getAllInstalledModules());
                    eMFrameUtils.setMessage("warning", eMFrameUtils.getLocalizedString("FwResources", "Warning", this.m_context), eMFrameUtils.getLocalizedString("FwResources", "ModulesToInstall.NoModulesSelected", this.m_context), this.m_context);
                    this.setUIPage("fw/InstalledNPM.jsp");
                    return true;
                }
                if (this.m_arrModules.length == 1 && ((moduleID = this.m_arrModules[0].toString()).equalsIgnoreCase(FRAME_WORK) || moduleID.equalsIgnoreCase(BASE_PLUGIN) || moduleID.equalsIgnoreCase(SUPPORT_PACK))) {
                    Hashtable htModules = ModuleManager.getAllInstalledModules();
                    ModuleInfo mInfo = (ModuleInfo)htModules.get(moduleID);
                    String title = mInfo.getModuleTitle();
                    this.setModules(ModuleManager.getAllInstalledModules());
                    eMFrameUtils.setMessage("warning", eMFrameUtils.getLocalizedString("FwResources", "Warning", this.m_context), eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "ModulesToInstall.CannotDelete", this.m_context), new String[]{title}), this.m_context);
                    this.setUIPage("fw/InstalledNPM.jsp");
                    return true;
                }
                if (this.m_arrModules.length == 2) {
                    String moduleID1 = this.m_arrModules[0].toString();
                    String moduleID2 = this.m_arrModules[1].toString();
                    if (moduleID1.equalsIgnoreCase(FRAME_WORK) && moduleID2.equalsIgnoreCase(BASE_PLUGIN) || moduleID2.equalsIgnoreCase(FRAME_WORK) && moduleID1.equalsIgnoreCase(BASE_PLUGIN) || moduleID1.equalsIgnoreCase(SUPPORT_PACK) || moduleID2.equalsIgnoreCase(SUPPORT_PACK)) {
                        Hashtable htModules = ModuleManager.getAllInstalledModules();
                        ModuleInfo mInfo1 = (ModuleInfo)htModules.get(moduleID1);
                        String title1 = mInfo1.getModuleTitle();
                        ModuleInfo mInfo2 = (ModuleInfo)htModules.get(moduleID2);
                        String title2 = mInfo2.getModuleTitle();
                        this.setModules(ModuleManager.getAllInstalledModules());
                        String title = title1 + ", " + title2;
                        eMFrameUtils.setMessage("warning", eMFrameUtils.getLocalizedString("FwResources", "Warning", this.m_context), eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "ModulesToInstall.CannotDelete", this.m_context), new String[]{title}), this.m_context);
                        this.setUIPage("fw/InstalledNPM.jsp");
                        return true;
                    }
                }
                String sModuleID = null;
                boolean success = true;
                for (int i = 0; i < this.m_arrModules.length && success; ++i) {
                    Hashtable htModules = ModuleManager.getAllInstalledModules();
                    ModuleInfo mInfo = (ModuleInfo)htModules.get(this.m_arrModules[i]);
                    sModuleID = mInfo.getModuleID();
                    if (sModuleID.equalsIgnoreCase(FRAME_WORK) || sModuleID.equalsIgnoreCase(BASE_PLUGIN) || sModuleID.equalsIgnoreCase(SUPPORT_PACK)) {
                        D.log("Cannot uninstall the " + mInfo.getModuleTitle() + " plug-in module.  It is a required part of iManager.");
                        continue;
                    }
                    success = this.uninstallModule(sModuleID);
                }
                ModuleManager.readModules();
                this.setModules(ModuleManager.getAllInstalledModules());
                this.setUIPage("fw/InstalledNPM.jsp");
                if (!success) {
                    eMFrameUtils.setMessage("error", eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context), eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "InstalledModules.FileNotFound", this.m_context), new String[]{sModuleID}), this.m_context);
                    this.setUIPage("fw/InstalledNPM.jsp");
                } else {
                    this.setUIPage("fw/ModulesToConfirm.jsp");
                    this.m_req.setAttribute("ConfirmMessageTitle", (Object)eMFrameUtils.getLocalizedString("FwResources", "InstalledModules.ConfirmMessageTitle", this.m_context));
                    this.m_req.setAttribute("ConfirmMessage", (Object)eMFrameUtils.getLocalizedString("FwResources", "InstalledModules.ConfirmMessage", this.m_context));
                    this.m_req.setAttribute("ConfirmBody", (Object)(eMFrameUtils.getLocalizedString("FwResources", "InstalledModules.ConfirmBody", this.m_context) + eMFrameUtils.getLocalizedString("FwResources", "InstalledModules.UninstallOnWinMessage", this.m_context)));
                    Registry.refreshInstallRegistry();
                }
            }
        }
        return true;
    }

    private void deleteModule(String sModuleID) {
        File fModuleDir;
        String webAppBase = WebappUtil.getRealPath((String)"/");
        ModuleInfo tempModuleConfig = ModuleManager.getModule(sModuleID);
        if (tempModuleConfig != null) {
            ModuleManager.moveModuleToDeleted(ModuleManager.getModulePackageName(sModuleID));
        }
        if ((fModuleDir = new File(webAppBase + "portal/modules/" + sModuleID)) != null && fModuleDir.exists()) {
            InstalledNPM.deleteDir(fModuleDir);
        }
        try {
            File fJSPDir;
            Object oTempDir;
            ServletContext servletContext = null;
            try {
                servletContext = WebappUtil.getStaticServletContext();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            if (null != servletContext) {
                oTempDir = servletContext.getAttribute("javax.servlet.context.tempdir");
            } else {
                oTempDir = null;
                Log.log((String)DT, (int)1, (String)"Path for precompiled JSPs was not specified!!!");
            }
            if (null != oTempDir && oTempDir instanceof File && (fJSPDir = new File((File)oTempDir, "portal/modules/" + sModuleID)) != null && fJSPDir.exists()) {
                InstalledNPM.deleteDir(fJSPDir);
            }
        }
        catch (Throwable t) {
            Log.log((String)DT, (int)2, (Throwable)t);
        }
    }

    private boolean uninstallModule(String sModuleID) {
        try {
            String sNpmfile = ModuleManager.getNpmFileName(sModuleID);
            if (null == sNpmfile) {
                return false;
            }
            ModuleManager.externalUninstall(new File(WebappUtil.getRealPath((String)"/")), sNpmfile);
        }
        catch (Throwable t) {
            D.log(t);
            return false;
        }
        return true;
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = InstalledNPM.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static void shouldRun(HttpServletRequest req, String sServiceName) throws Exception {
        Task.shouldRun(req, sServiceName);
        if (!FwUtils.canConfigureiManager(req)) {
            TaskContext context = eMFrameFactory.getTaskContext(req);
            throw new Exception(eMFrameUtils.getLocalizedString("FwResources", "Configure.UserNotAuthorizedToConfigureiManager", context));
        }
    }

    private void setModules(Hashtable htModules) {
        ArrayList<ModuleInfo> ar = new ArrayList<ModuleInfo>();
        if (htModules != null) {
            Collection modCollection = htModules.values();
            Iterator iter = modCollection.iterator();
            while (iter.hasNext()) {
                ar.add((ModuleInfo)iter.next());
            }
        }
        Collections.sort(ar, new ModuleInfoCompare(this.m_context));
        this.m_req.setAttribute("InstalledNPM", ar);
    }

    public class ModuleInfoCompare
    implements Comparator {
        Collator m_collator = null;

        public ModuleInfoCompare(TaskContext context) {
            this.m_collator = Collator.getInstance(context.getLocale());
        }

        public int compare(Object obj1, Object obj2) {
            ModuleInfo mInfo1 = (ModuleInfo)obj1;
            String str1 = mInfo1.getModuleTitle();
            ModuleInfo mInfo2 = (ModuleInfo)obj2;
            String str2 = mInfo2.getModuleTitle();
            return this.m_collator.compare(str1, str2);
        }
    }
}

