/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.Value;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.CustomTargetChooser;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.PluginException;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.util.StudioUtils;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import org.jdom.Document;
import org.jdom.Element;

public class ListTargetChooser
extends CustomTargetChooser {
    public String showTargetChooser(TaskContext context, Document taskDescriptor) throws PluginException {
        Properties params = eMFrameUtils.getUrlParams(taskDescriptor);
        String eDirSearch = params.getProperty("eDirSearch");
        eDirSearch = context.getDirUtils().getRealName(eDirSearch);
        String[] classNames = new String[]{eDirSearch};
        eMFrameUtils.setupTargetChooser(classNames, context);
        Element pluginParams = taskDescriptor.getRootElement().getChild("rbs-xml-info").getChild("plugin-params-compressed");
        if (pluginParams != null) {
            try {
                pluginParams = StudioUtils.unCompressPluginParams(pluginParams);
            }
            catch (Exception e) {
                D.log(e);
            }
        }
        String listObject = pluginParams.getChild("custom-target-chooser").getChildTextTrim("list-object");
        context.getRequest().setAttribute("targets", (Object)this.discoverTarget(listObject, context));
        return "fw.ListTargetChooser";
    }

    private String[] discoverTarget(String listObject, TaskContext context) throws PluginException {
        ObjectEntry treeOE = (ObjectEntry)context.getAuthenticationBroker().getAPIObject("NDSNamespace");
        NDSNamespace ns = (NDSNamespace)treeOE.getNamespace();
        ObjectAttribute attrib = null;
        try {
            ObjectEntry oe = ns.getObjectEntry(listObject);
            attrib = ns.getAttribute(oe, "Member");
        }
        catch (SPIException e) {
            throw new PluginException((Exception)((Object)e));
        }
        ArrayList<String> list = new ArrayList<String>();
        if (attrib != null) {
            Enumeration myenum = attrib.getValueComponents();
            while (myenum.hasMoreElements()) {
                Value value = (Value)myenum.nextElement();
                list.add(value.toString());
            }
        }
        String[] array = list.toArray(new String[list.size()]);
        return array;
    }
}

