/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.SchemaDefinition;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.BookInfo;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.RBSUtil;
import com.novell.rbs.RBSBook;
import com.novell.rbs.RBSRights;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.jdom.Document;
import org.jdom.Element;

public class ModifyBookPageListTask
extends Task {
    private static final long serialVersionUID = 1L;
    private HttpServletRequest req;
    private TaskContext context;
    private Properties resultStrings;
    private AdminNamespace namespace;
    private ObjectEntry treeOE;

    public static void shouldRun(HttpServletRequest req, String sServiceName) throws Exception {
        FwUtils.verifyRbsInstalled(req, sServiceName);
    }

    public boolean execute(TaskContext context, Properties resultStrings) {
        this.context = context;
        this.resultStrings = resultStrings;
        this.req = context.getRequest();
        this.treeOE = RBSUtil.getTreeOE(context);
        this.namespace = this.treeOE.getAdminNamespace();
        String nextState = this.req.getParameter("nextState");
        if (nextState == null || nextState.equalsIgnoreCase("initialState")) {
            return this.showInitialForm();
        }
        if (nextState.equalsIgnoreCase("showBookPageList")) {
            return this.showBookPageList();
        }
        if (nextState.equalsIgnoreCase("saveBookPageList")) {
            return this.saveBookPageList();
        }
        return false;
    }

    private boolean showInitialForm() {
        this.resultStrings.put("DisplayNameTitle", eMFrameUtils.getLocalizedString("FwResources", "ModifyBookPageList", this.context));
        this.resultStrings.put("Merge.Template", "fw.ModifyBookPageList");
        this.resultStrings.put("Next.State", "showBookPageList");
        return true;
    }

    private boolean showBookPageList() {
        String bookDisplayName;
        SchemaDefinition schemaDef = null;
        BookInfo bookInfo = new BookInfo();
        String selectedContext = this.req.getParameter("BookName");
        String[] strings = eMFrameUtils.unpack(selectedContext, this.context);
        selectedContext = strings[0];
        String[] pageIds = null;
        try {
            schemaDef = this.namespace.getSchemaDefinition(this.treeOE);
            ObjectEntry bookOE = this.namespace.getObjectEntry(this.treeOE, selectedContext);
            bookInfo.setContextOE(bookOE);
            bookInfo.setContext(selectedContext);
            bookDisplayName = RBSUtil.getLocalizedDisplayName(this.context, bookOE);
            String objectType = bookOE.getObjectType().getName();
            if (!objectType.equals("rbsBook2")) {
                this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "Error", this.context));
                this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString("FwResources", "GetBookName.WrongClass", this.context));
                return false;
            }
            this.context.addToHistory(bookOE);
            RBSBook rbsBook = new RBSBook(bookOE);
            String[] assignedObjectTypes = rbsBook.getTargetObjectType();
            if (assignedObjectTypes != null) {
                if (assignedObjectTypes.length == 1 && assignedObjectTypes[0].equals("*")) {
                    this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "Warning", this.context));
                    this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString("FwResources", "Book.CannotModifyPages", this.context));
                    return false;
                }
                bookInfo.setAssignedObjectTypes(assignedObjectTypes);
                Element pageOrdersElement = rbsBook.getrbsXMLInfo("pageOrders");
                if (pageOrdersElement != null) {
                    String pageOrders = pageOrdersElement.getTextTrim();
                    if (pageOrders != null && pageOrders != "") {
                        String[] pages = pageOrders.split(",");
                        bookInfo.setAssignedPages(pages);
                    } else {
                        bookInfo.setAssignedPages(rbsBook.getPageMemebership());
                    }
                } else {
                    bookInfo.setAssignedPages(rbsBook.getPageMemebership());
                }
                pageIds = FwUtils.getAllPageIds(this.context, bookInfo.getAssignedObjectTypes());
            }
        }
        catch (Exception e) {
            D.log(e);
            eMFrameUtils.setErrorMessage(e, this.context);
            return false;
        }
        if (pageIds != null) {
            Vector<String> availablePagesV = new Vector<String>();
            for (int i = 0; i < pageIds.length; ++i) {
                boolean add = true;
                RBSRights[] rights = FwUtils.getPagesRights(new String[]{pageIds[i]}, this.treeOE);
                if (rights != null) {
                    for (int j = 0; j < rights.length; ++j) {
                        if (rights[j].getProtectedAttrName().equalsIgnoreCase("[Entry Rights]") || rights[j].getProtectedAttrName().equalsIgnoreCase("[All Attributes Rights]") || rights[j].getProtectedAttrName().equalsIgnoreCase("[No Self Rights Assignment]") || schemaDef.isAttributeDefined(rights[j].getProtectedAttrName())) continue;
                        D.log("--  Discarding page: " + pageIds[i] + " attribute undefined: " + rights[j].getProtectedAttrName());
                        add = false;
                        break;
                    }
                }
                if (!add) continue;
                availablePagesV.addElement(pageIds[i]);
            }
            if (availablePagesV.size() > 0) {
                pageIds = availablePagesV.toArray(new String[availablePagesV.size()]);
            }
        }
        bookInfo.setAvailablePages(RBSUtil.removeAssignedFromAvailable(pageIds, bookInfo.getAssignedPages()));
        RBSUtil.putAvailablePages(bookInfo, this.resultStrings, this.context);
        RBSUtil.putAssignedPages(bookInfo, this.resultStrings, this.context);
        this.resultStrings.put("BookName_Value", bookDisplayName);
        this.context.setAuthAttribute("BookInfo", bookInfo);
        return true;
    }

    private boolean saveBookPageList() {
        this.resultStrings.put("TaskAfterGenConf", "fw.HomePage");
        this.resultStrings.put("MergeAfterGenConf", "fw.HomePage");
        BookInfo bookInfo = (BookInfo)this.context.getAuthAttribute("BookInfo");
        String formChanged = this.req.getParameter("BookPageFormChanged");
        if (formChanged.equals("true")) {
            RBSUtil.getAssignedPages(bookInfo, this.req);
            RBSBook rbsBook = new RBSBook(bookInfo.getContextOE());
            try {
                rbsBook.setPageMembership(bookInfo.getAssignedPages());
                RBSRights[] rights = FwUtils.getPagesRights(bookInfo.getAssignedPages(), this.treeOE);
                rbsBook.setRights(rights);
                String dynamicGroupSearchType = FwUtils.getDynamicSearchType(this.context);
                rbsBook.setContentMembership(rbsBook.getContentMembership(), dynamicGroupSearchType);
                String[] pages = bookInfo.getAssignedPages();
                String pageOrders = null;
                if (pages != null) {
                    pageOrders = pages[0];
                    for (int i = 1; i < pages.length; ++i) {
                        pageOrders = pageOrders + "," + pages[i];
                    }
                }
                Element pageOrdersElement = new Element("pageOrders");
                pageOrdersElement.addContent(pageOrders);
                Document doc = rbsBook.getrbsXMLInfo();
                if (doc == null) {
                    rbsBook.setrbsXMLInfo(pageOrdersElement);
                } else {
                    rbsBook.setrbsXMLInfo(pageOrdersElement);
                }
                rbsBook.update();
                this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "ModifyBookPageList", this.context));
                this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString("FwResources", "GetBookName.ADD_PAGE_RBSBOOK", this.context));
            }
            catch (Exception e) {
                D.log(e);
                eMFrameUtils.setErrorMessage(e, this.context);
                return false;
            }
        } else {
            this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "ModifyBookPageList", this.context));
            this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString("FwResources", "GetBookName.NO_UPDATE_PAGE_RBSBOOK", this.context));
        }
        return true;
    }
}

