/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.SchemaDefinition;
import com.novell.admin.ns.ldap.LDAPSchemaDefinition;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectType;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.config.SystemConfig;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.AssociationObjectComparator;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.ModifyMemberAssociationObject;
import com.novell.emframe.fw.RBSUtil;
import com.novell.emframe.fw.iManager;
import com.novell.rbs.RBSAssociatedObject;
import com.novell.rbs.RBSAssociation;
import com.novell.rbs.RBSObject;
import com.novell.rbs.RBSRole;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public class ModifyMemberAssignedRolesTask
extends Task {
    private static final long serialVersionUID = 1L;
    private HttpServletRequest req;
    private TaskContext context;
    private Properties resultStrings;
    private AdminNamespace namespace;
    private ObjectEntry treeOE;
    private String modifyMemberTableChanged = "false";
    private int totalObjects = 0;
    private boolean bNVDS;

    public static void shouldRun(HttpServletRequest req, String sServiceName) throws Exception {
        FwUtils.verifyRbsInstalled(req, sServiceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(TaskContext context, Properties resultStrings) {
        boolean controlPreviouslySet = true;
        try {
            this.context = context;
            this.resultStrings = resultStrings;
            this.req = context.getRequest();
            this.treeOE = RBSUtil.getTreeOE(context);
            this.namespace = this.treeOE.getAdminNamespace();
            String nextState = this.req.getParameter("nextState");
            resultStrings.put("modifyMemberTableChangesNotSaved", "false");
            this.bNVDS = this.isNVDS();
            controlPreviouslySet = RBSUtil.setAliasControl(this.namespace);
            if (nextState == null || nextState.equalsIgnoreCase("initialState")) {
                boolean bl = this.showInitialForm();
                return bl;
            }
            if (nextState.equalsIgnoreCase("initializeAssociationObjects")) {
                boolean bl = this.initializeAssociationObjects();
                return bl;
            }
            if (nextState.equalsIgnoreCase("addRolesToTable")) {
                boolean bl = this.addRolesToTable();
                return bl;
            }
            if (nextState.equalsIgnoreCase("deleteMembersFromTable")) {
                boolean bl = this.deleteMembersFromTable();
                return bl;
            }
            if (nextState.equalsIgnoreCase("addScopeToTable")) {
                boolean bl = this.addScopeToTable();
                return bl;
            }
            if (nextState.equalsIgnoreCase("addRoleAndScopeToTable")) {
                boolean bl = this.addRoleAndScopeToTable();
                return bl;
            }
            if (nextState.equalsIgnoreCase("modifyMemberScopeInTable")) {
                boolean bl = this.modifyMemberScopeInTable();
                return bl;
            }
            if (nextState.equalsIgnoreCase("updateMemberAssociations")) {
                boolean bl = this.updateMemberAssociations();
                return bl;
            }
            if (nextState.equalsIgnoreCase("apply")) {
                this.updateMemberAssociations();
                this.setUIPage("fw/ModifyMemberAssignedRolesPage.jsp");
                boolean bl = this.initializeAssociationObjects();
                return bl;
            }
            if (nextState.equalsIgnoreCase("refresh")) {
                context.getRequest().setAttribute("isRefreshing", (Object)"true");
                this.updateMemberAssociations();
                this.setUIPage("fw/ModifyMemberAssignedRolesPage.jsp");
                boolean bl = this.initializeAssociationObjects();
                return bl;
            }
            boolean bl = this.showInitialForm();
            return bl;
        }
        finally {
            RBSUtil.clearAliasControl(this.namespace, controlPreviouslySet);
        }
    }

    private boolean showInitialForm() {
        this.clearTreeSet();
        if (!this.isCollectionOwner()) {
            return false;
        }
        this.setRoleMemberTypesFilter();
        return true;
    }

    private void clearTreeSet() {
        if (this.context.getAuthAttribute("ModifyMemberTreeNodes") != null) {
            this.context.removeAuthAttribute("ModifyMemberTreeNodes");
        }
    }

    private TreeSet getTreeSet() {
        TreeSet nodes = null;
        if (this.context.getAuthAttribute("ModifyMemberTreeNodes") != null) {
            nodes = (TreeSet)this.context.getAuthAttribute("ModifyMemberTreeNodes");
        } else {
            nodes = new TreeSet(new AssociationObjectComparator());
            this.context.setAuthAttribute("ModifyMemberTreeNodes", nodes);
        }
        return nodes;
    }

    private boolean initializeAssociationObjects() {
        String selectedMember = this.req.getParameter("MemberName");
        String sHasDynGroupAux = "false";
        TreeSet treeNodes = this.getTreeSet();
        ObjectEntry memberOE = null;
        RBSAssociatedObject rbsAssociatedObject = null;
        RBSAssociation[] rbsAssociations = null;
        int iRoleCount = 0;
        ObjectEntry whoamiOE = null;
        boolean err = false;
        ArrayList<String[]> alErrors = new ArrayList<String[]>();
        try {
            if (selectedMember == null) {
                selectedMember = (String)this.context.getAuthAttribute("SelectedMember");
            }
            memberOE = this.namespace.getObjectEntry(this.treeOE, selectedMember);
            sHasDynGroupAux = this.hasDynamicGroupAux(memberOE);
            if (memberOE != null) {
                String dynamicGroupSearchType;
                if (!this.isValidMemberType(memberOE)) {
                    this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "Error", this.context));
                    this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString("FwResources", "GetMemberName.NotValidMemberObject", this.context));
                    return false;
                }
                whoamiOE = this.namespace.getAuthenticatedIdentity(this.treeOE);
                if (!RBSUtil.preCheckMemberRights(whoamiOE, memberOE, dynamicGroupSearchType = FwUtils.getDynamicSearchType(this.context))) {
                    alErrors.add(new String[]{selectedMember, eMFrameUtils.getLocalizedString("FwResources", "Insufficient.Rights", this.context), eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "MemberNoDisplayMember.InsufficientRights", this.context), new String[]{selectedMember}), ""});
                    String strTitle = eMFrameUtils.getLocalizedString("FwResources", "RBSManagement.ModifyRoleScopeTitle", this.context);
                    String strBody = eMFrameUtils.getLocalizedString("FwResources", "ModifyRBSObjectDescription.Failed", this.context);
                    eMFrameUtils.setMooErrorMessage(this.resultStrings, strTitle, strBody, alErrors);
                    this.setUIPage("dev/MooGenErr.jsp");
                    return false;
                }
                boolean dynamicGroupAuxObject = this.isDynamicGroupOrAuxObject(memberOE);
                boolean dynamicGroupFlagEnabled = this.getDynamicGroupFlag();
                if (dynamicGroupAuxObject) {
                    if (!dynamicGroupFlagEnabled) {
                        this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "ModifyMemberAssignedRoles.ModifyRoles", this.context));
                        this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString("FwResources", "ModifyMemberAssignedRoles.DynamicGroupsNotEnabled", this.context));
                        return false;
                    }
                    if (FwUtils.getDynamicSearchType(this.context).equals("DynamicGroupObjectsOnly") && sHasDynGroupAux.equals("true")) {
                        this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "ModifyMemberAssignedRoles.ModifyRoles", this.context));
                        this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString("FwResources", "ModifyRoleAssociations.DynamicGroupsAuxClassNotEnabled", this.context));
                        return false;
                    }
                }
                rbsAssociatedObject = new RBSAssociatedObject(memberOE);
                rbsAssociations = rbsAssociatedObject.getDirectRoleAssociations2();
            }
            if (rbsAssociations != null) {
                String strRoleName = "";
                String strInheritable = "";
                String strAssignRights = "";
                String strScopeName = "";
                ObjectEntry scopeOE = null;
                for (int i = 0; i < rbsAssociations.length; ++i) {
                    String scopeName;
                    String secondaryStr;
                    strRoleName = this.namespace.getUnrootedName(rbsAssociations[i].getRole().getObjectEntry());
                    strInheritable = rbsAssociations[i].getInheritanceScope();
                    strAssignRights = String.valueOf(rbsAssociations[i].isRightsSet());
                    strScopeName = "";
                    scopeOE = rbsAssociations[i].getScope();
                    if (scopeOE.getObjectType().getName().equalsIgnoreCase("Top")) {
                        if (this.bNVDS) {
                            if (strScopeName.equalsIgnoreCase("")) {
                                strScopeName = "[root]";
                            }
                        } else {
                            strScopeName = scopeOE.getFullName();
                        }
                    } else {
                        strScopeName = this.namespace.getUnrootedName(scopeOE);
                    }
                    String roleName = this.namespace.getUnrootedName(rbsAssociations[i].getRole().getObjectEntry());
                    RBSRole role = rbsAssociations[i].getRole();
                    RBSObject[] tasksArray = role.getContent();
                    if (!this.isNameInArrayList(alErrors, roleName) && (secondaryStr = RBSUtil.preCheckSecondaryRights(this.context, whoamiOE, tasksArray)) != null) {
                        err = true;
                        alErrors.add(new String[]{roleName, eMFrameUtils.getLocalizedString("FwResources", "Insufficient.Rights", this.context), eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "MemberNoDisplaySecondary.InsufficientRights", this.context), new String[]{secondaryStr, roleName}), ""});
                    }
                    if (!this.isNameInArrayList(alErrors, scopeName = this.namespace.getUnrootedName(rbsAssociations[i].getScope())) && !RBSUtil.preCheckScopeRights(whoamiOE, rbsAssociations[i].getScope())) {
                        err = true;
                        alErrors.add(new String[]{scopeName, eMFrameUtils.getLocalizedString("FwResources", "Insufficient.Rights", this.context), eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "MemberNoDisplayScope.InsufficientRights", this.context), new String[]{scopeName}), ""});
                    }
                    ModifyMemberAssociationObject associationObject = new ModifyMemberAssociationObject(selectedMember, strRoleName, strScopeName, strInheritable, strAssignRights);
                    treeNodes.add(associationObject);
                    ++iRoleCount;
                }
                if (err) {
                    String strTitle = eMFrameUtils.getLocalizedString("FwResources", "RBSManagement.ModifyRoleScopeTitle", this.context);
                    String strBody = eMFrameUtils.getLocalizedString("FwResources", "ModifyRBSObjectDescription.Failed", this.context);
                    eMFrameUtils.setMooErrorMessage(this.resultStrings, strTitle, strBody, alErrors);
                    this.setUIPage("dev/MooGenErr.jsp");
                    return false;
                }
            }
        }
        catch (Exception e) {
            D.log(e);
            String strException = eMFrameUtils.getExceptionMessage(e, this.context);
            String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.context);
            eMFrameUtils.setMessage("error", strTitle, strException, this.context);
            return false;
        }
        if (rbsAssociatedObject != null) {
            this.context.setAuthAttribute("rbsAssociatedObject", rbsAssociatedObject);
        }
        this.context.setAuthAttribute("ModifyMemberTreeNodes", treeNodes);
        this.context.setAuthAttribute("SelectedMember", selectedMember);
        this.resultStrings.put("RBSSelectedMember", selectedMember);
        this.resultStrings.put("Member.Role.Count", Integer.toString(iRoleCount));
        this.resultStrings.put("ModifyMemberAssignedRoles.DynamicGroupAux", sHasDynGroupAux);
        this.resultStrings.put("ModifyMemberAssignedRoles.TreeName", this.treeOE.getName());
        if (memberOE != null) {
            this.context.addToHistory(memberOE);
        }
        this.loadTableData();
        return true;
    }

    private boolean loadTableData() {
        TreeSet treeNodes = (TreeSet)this.context.getAuthAttribute("ModifyMemberTreeNodes");
        String selectedMember = this.req.getParameter("RBSSelectedMember");
        int iRoleCount = 0;
        if (treeNodes != null) {
            Object[] treeNodeArray = treeNodes.toArray();
            String roleName = "";
            String scopeDisplayName = "";
            String scopeFullName = "";
            String inheritable = "true";
            String assignRights = "true";
            String rbsAdmin_RoleType = "iManager";
            ObjectEntry roleOE = null;
            RBSRole role = null;
            Object[] aclScopeValueArray = this.getAclScopeValues();
            for (int j = 0; j < aclScopeValueArray.length; ++j) {
                this.resultStrings.put("Role.AclScopeValue" + j, aclScopeValueArray[j]);
            }
            this.resultStrings.put("Role.AclScopeValues.Count", String.valueOf(aclScopeValueArray.length));
            for (int i = 0; i < treeNodeArray.length; ++i) {
                ModifyMemberAssociationObject associationObject = (ModifyMemberAssociationObject)treeNodeArray[i];
                roleName = associationObject.getRoleName();
                scopeDisplayName = associationObject.getScopeName();
                scopeFullName = associationObject.getScopeName();
                inheritable = associationObject.getInheritable();
                assignRights = associationObject.getAssignRights();
                rbsAdmin_RoleType = "iManager";
                if (scopeFullName.equalsIgnoreCase(this.treeOE.getName())) {
                    scopeDisplayName = "[root]";
                    if (this.bNVDS && scopeFullName.equalsIgnoreCase("")) {
                        scopeFullName = "[root]";
                    }
                }
                try {
                    roleOE = this.namespace.getObjectEntry(this.treeOE, roleName);
                    role = new RBSRole(roleOE);
                    if (this.isSelfProvisioningEguideRole(role)) {
                        boolean thisEnabled = iManager.isThisEnabled();
                        if (!thisEnabled) continue;
                        scopeDisplayName = "[Self-Management]";
                        rbsAdmin_RoleType = "self-provisioning";
                    }
                }
                catch (SPIException e) {
                    D.log(e);
                    String strException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.context);
                    this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "Error", this.context));
                    this.resultStrings.put("GeneralMsg.MsgBody", strException);
                    return false;
                }
                this.resultStrings.put("Member.Role." + iRoleCount + ".FullName", roleName);
                this.resultStrings.put("Member.Role." + iRoleCount + ".ScopeFullName", scopeFullName);
                this.resultStrings.put("Member.Role." + iRoleCount + ".ScopeDisplayName", scopeDisplayName);
                this.resultStrings.put("Member.Role." + iRoleCount + ".Inheritable", inheritable);
                this.resultStrings.put("Member.Role." + iRoleCount + ".AssignRights", assignRights);
                this.resultStrings.put("Member.Role." + iRoleCount + ".roleType", rbsAdmin_RoleType);
                ++iRoleCount;
            }
        }
        if (selectedMember == null) {
            selectedMember = (String)this.context.getAuthAttribute("SelectedMember");
        }
        this.resultStrings.put("rbs_isNVDS", String.valueOf(this.bNVDS));
        this.resultStrings.put("RBSXMLAttributeDefined", this.isRBSXMLAttrDefined(this.treeOE));
        this.resultStrings.put("RBSSelectedMember", selectedMember);
        this.resultStrings.put("Member.Role.Count", Integer.toString(iRoleCount));
        this.resultStrings.put("ModifyMemberAssignedRoles.Type", this.getObjectTypeFromString(selectedMember));
        return true;
    }

    private boolean addRolesToTable() {
        TreeSet treeNodes = (TreeSet)this.context.getAuthAttribute("ModifyMemberTreeNodes");
        String inheritanceChanged = this.req.getParameter("MemberInheritanceChanged");
        String assignRightsChanged = this.req.getParameter("MemberAssignRightsChanged");
        String selectedMember = this.req.getParameter("RBSSelectedMember");
        String newRoleMembers = this.req.getParameter("NewRoleMembers");
        String newRoleName = "";
        ArrayList<String[]> alErrors = new ArrayList<String[]>();
        ObjectEntry newRoleOE = null;
        boolean bSelfProvisioningRole = false;
        boolean err = false;
        ObjectEntry whoamiOE = null;
        try {
            whoamiOE = this.namespace.getAuthenticatedIdentity(this.treeOE);
        }
        catch (SPIException e) {
            D.log(e);
            String strException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.context);
            String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.context);
            eMFrameUtils.setMessage("error", strTitle, strException, this.context);
            return false;
        }
        String[] newMemberArray = this.spliceJavaScriptString(newRoleMembers, "$");
        for (int i = 0; i < newMemberArray.length; ++i) {
            RBSObject[] tasksArray;
            newRoleName = eMFrameUtils.urlDecode(newMemberArray[i], this.context);
            newRoleOE = this.getObjectEntryFromString(newRoleName);
            if (newRoleName.equalsIgnoreCase("[root]") || newRoleName.equalsIgnoreCase(this.treeOE.getName())) {
                err = true;
                D.log("Tree or Root is not a valid role member. - " + newRoleName);
                if (this.isNameInArrayList(alErrors, newRoleName)) continue;
                alErrors.add(new String[]{newRoleName, eMFrameUtils.getLocalizedString("FwResources", "ModifyRoleAssociations.ModifyRole", this.context), eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.TREE_NOT_VALID_MEMBER", this.context), ""});
                continue;
            }
            if (newRoleOE == null) {
                err = true;
                D.log("Member name not valid. - " + newRoleName);
                if (this.isNameInArrayList(alErrors, newRoleName)) continue;
                alErrors.add(new String[]{newRoleName, eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.OBJECT_NOT_FOUND_TITLE", this.context), eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.OBJECT_NOT_FOUND", this.context), new String[]{newRoleName}), ""});
                continue;
            }
            String sNewMemberType = this.getObjectTypeFromString(newRoleName);
            if (sNewMemberType != null && !sNewMemberType.equalsIgnoreCase("rbsRole2")) {
                err = true;
                D.log("Member object type is not in the list. - " + sNewMemberType);
                if (this.isNameInArrayList(alErrors, newRoleName)) continue;
                alErrors.add(new String[]{newRoleName, eMFrameUtils.getLocalizedString("FwResources", "ModifyRoleAssociations.ModifyRole", this.context), eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.NOT_VALID_MEMBER_TYPE", this.context), new String[]{newRoleName}), ""});
                continue;
            }
            RBSRole role = new RBSRole(newRoleOE);
            try {
                tasksArray = role.getContent();
            }
            catch (SPIException e) {
                D.log(e);
                String strException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.context);
                String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.context);
                eMFrameUtils.setMessage("error", strTitle, strException, this.context);
                return false;
            }
            String secondaryStr = RBSUtil.preCheckSecondaryRights(this.context, whoamiOE, tasksArray);
            if (secondaryStr != null) {
                err = true;
                alErrors.add(new String[]{newRoleName, eMFrameUtils.getLocalizedString("FwResources", "Insufficient.Rights", this.context), eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "MemberSecondary.InsufficientRights", this.context), new String[]{secondaryStr, newRoleName}), ""});
                continue;
            }
            bSelfProvisioningRole = this.isSelfProvisioningEguideRole(newRoleOE);
            if (bSelfProvisioningRole) {
                boolean thisEnabled = iManager.isThisEnabled();
                if (!thisEnabled) {
                    err = true;
                    D.log("This is not enabled. Can't add Self-Management role to member." + newRoleName);
                    alErrors.add(new String[]{newRoleName, eMFrameUtils.getLocalizedString("FwResources", "ModifyRoleAssociations.ModifyRole", this.context), eMFrameUtils.getLocalizedString("FwResources", "RBSManagement.SelfmanagementNotEnabled", this.context), ""});
                    continue;
                }
                try {
                    ObjectEntry selectedMemberOE = this.namespace.getObjectEntry(this.treeOE, selectedMember);
                    ObjectType objectType = selectedMemberOE.getObjectType();
                    if (!objectType.isContainer()) {
                        err = true;
                        D.log("Member object type is not a container." + objectType.getName());
                        if (this.isNameInArrayList(alErrors, selectedMemberOE.getName())) continue;
                        alErrors.add(new String[]{selectedMemberOE.getName(), eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.MEMBER_ROLE_ASSIGNMENT", this.context), eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.LEAF_CANNOT_BE_ASSIGNED", this.context), new String[]{selectedMemberOE.getName()}), ""});
                        continue;
                    }
                }
                catch (SPIException e) {
                    D.log(e);
                    String strException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.context);
                    String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.context);
                    eMFrameUtils.setMessage("error", strTitle, strException, this.context);
                }
            }
            this.addRoleToTree(treeNodes, newRoleName, selectedMember);
            if (newMemberArray.length < 10) {
                this.addObjectToHistory(newRoleOE);
            }
            this.modifyMemberTableChanged = "true";
            ++this.totalObjects;
        }
        if (inheritanceChanged != null && inheritanceChanged.equalsIgnoreCase("true")) {
            this.modifyMemberInheritanceInTable();
            this.modifyMemberTableChanged = "true";
        }
        if (assignRightsChanged != null && assignRightsChanged.equalsIgnoreCase("true")) {
            this.modifyMemberAssignRightsInTable();
            this.modifyMemberTableChanged = "true";
        }
        this.context.setAuthAttribute("ModifyMemberTableChanged", this.modifyMemberTableChanged);
        if (this.modifyMemberTableChanged.equals("true")) {
            this.resultStrings.put("modifyMemberTableChangesNotSaved", "true");
        }
        this.loadTableData();
        if (err) {
            return this.setErrorMessageURL(this.totalObjects, alErrors);
        }
        return true;
    }

    private boolean addScopeToTable() {
        String inheritanceChanged = this.req.getParameter("MemberInheritanceChanged");
        String assignRightsChanged = this.req.getParameter("MemberAssignRightsChanged");
        String selectedMember = this.req.getParameter("RBSSelectedMember");
        String modifyScopeList = this.req.getParameter("ModifyScopeList");
        String inheritance = "true";
        String assignRights = "true";
        String newRoleName = "";
        String newScopeName = "";
        String nameScopeString = "";
        ArrayList<String[]> alErrors = new ArrayList<String[]>();
        ObjectEntry newRoleOE = null;
        ObjectEntry newScopeOE = null;
        boolean err = false;
        boolean validRoleObject = true;
        boolean validScopeObject = true;
        Hashtable<String, ObjectEntry> scopeObjectEntryTable = new Hashtable<String, ObjectEntry>();
        Hashtable<String, String> scopeInvalidTable = new Hashtable<String, String>();
        ObjectEntry whoamiOE = null;
        try {
            whoamiOE = this.namespace.getAuthenticatedIdentity(this.treeOE);
        }
        catch (SPIException e) {
            D.log(e);
            String strException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.context);
            String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.context);
            eMFrameUtils.setMessage("error", strTitle, strException, this.context);
            return false;
        }
        String[] memberScopeArray = this.spliceJavaScriptString(modifyScopeList, "$");
        for (int i = 0; i < memberScopeArray.length; ++i) {
            nameScopeString = memberScopeArray[i];
            validRoleObject = true;
            validScopeObject = true;
            String[] nameScopeArray = this.spliceJavaScriptString(nameScopeString, ";");
            newRoleName = eMFrameUtils.urlDecode(nameScopeArray[0], this.context);
            newRoleOE = this.getObjectEntryFromString(newRoleName);
            if (newRoleOE == null) {
                validRoleObject = false;
                err = true;
                D.log("Member name not valid. - " + newRoleName);
                if (this.isNameInArrayList(alErrors, newRoleName)) continue;
                alErrors.add(new String[]{newRoleName, eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.OBJECT_NOT_FOUND_TITLE", this.context), eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.OBJECT_NOT_FOUND", this.context), new String[]{newRoleName}), ""});
                continue;
            }
            newScopeName = eMFrameUtils.urlDecode(nameScopeArray[1], this.context);
            if (newScopeName.equalsIgnoreCase("[root]")) {
                newScopeName = this.treeOE.getName();
            }
            if ((newScopeOE = (ObjectEntry)scopeObjectEntryTable.get(newScopeName.toLowerCase())) == null) {
                newScopeOE = this.getObjectEntryFromString(newScopeName);
                if (newScopeOE == null) {
                    validScopeObject = false;
                    err = true;
                    D.log("Member scope not valid. - " + newScopeName);
                    if (this.isNameInArrayList(alErrors, newScopeName)) continue;
                    alErrors.add(new String[]{newScopeName, eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.OBJECT_NOT_FOUND_TITLE", this.context), eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.SCOPE_NOT_FOUND_IN_TREE", this.context), new String[]{newScopeName}), ""});
                    continue;
                }
                if (!this.isValidScope(newScopeOE)) {
                    validScopeObject = false;
                    err = true;
                    D.log("Scope type not valid. - " + newScopeName);
                    if (this.isNameInArrayList(alErrors, newScopeName)) continue;
                    alErrors.add(new String[]{newScopeName, eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.OBJECT_NOT_FOUND_TITLE", this.context), eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.MODIFY_MEMBER_ASSIGNED_ROLE", this.context), new String[]{newScopeName}), ""});
                    continue;
                }
                scopeObjectEntryTable.put(newScopeName.toLowerCase(), newScopeOE);
                if (!RBSUtil.preCheckScopeRights(whoamiOE, newScopeOE)) {
                    scopeInvalidTable.put(newScopeName.toLowerCase(), newScopeName.toLowerCase());
                    validScopeObject = false;
                    err = true;
                    if (this.isNameInArrayList(alErrors, newScopeName)) continue;
                    alErrors.add(new String[]{newScopeName, eMFrameUtils.getLocalizedString("FwResources", "Insufficient.Rights", this.context), eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "ScopeCheck.InsufficientRights", this.context), new String[]{newScopeName}), ""});
                    continue;
                }
            } else if (scopeInvalidTable.get(newScopeName.toLowerCase()) != null) {
                validScopeObject = false;
            }
            if (!validRoleObject || !validScopeObject) continue;
            try {
                ObjectEntry roleOE = this.namespace.getObjectEntry(this.treeOE, newRoleName);
                RBSRole role = new RBSRole(roleOE);
                if (!this.isSelfProvisioningEguideRole(role)) {
                    this.addRoleAndScopeToTree(newRoleName, newScopeName, inheritance, selectedMember, assignRights);
                    if (memberScopeArray.length < 10) {
                        this.addObjectToHistory(newScopeOE);
                    }
                    this.modifyMemberTableChanged = "true";
                    ++this.totalObjects;
                    continue;
                }
                err = true;
                if (this.isNameInArrayList(alErrors, roleOE.getName())) continue;
                alErrors.add(new String[]{roleOE.getName(), eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.MODIFY_MEMBER_ASSIGNED_ROLE_TITLE", this.context), eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.UNABLE_TO_ADD_SCOPE", this.context), new String[]{roleOE.getName()}), ""});
                continue;
            }
            catch (SPIException e) {
                D.log(e);
                String strException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.context);
                this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "Error", this.context));
                this.resultStrings.put("GeneralMsg.MsgBody", strException);
            }
        }
        if (inheritanceChanged.equalsIgnoreCase("true")) {
            this.modifyMemberInheritanceInTable();
            this.modifyMemberTableChanged = "true";
        }
        if (assignRightsChanged != null && assignRightsChanged.equalsIgnoreCase("true")) {
            this.modifyMemberAssignRightsInTable();
            this.modifyMemberTableChanged = "true";
        }
        this.context.setAuthAttribute("ModifyMemberTableChanged", this.modifyMemberTableChanged);
        if (this.modifyMemberTableChanged.equals("true")) {
            this.resultStrings.put("modifyMemberTableChangesNotSaved", "true");
        }
        this.loadTableData();
        if (err) {
            return this.setErrorMessageURL(this.totalObjects, alErrors);
        }
        return true;
    }

    private boolean addRoleAndScopeToTable() {
        TreeSet treeNodes = (TreeSet)this.context.getAuthAttribute("ModifyMemberTreeNodes");
        String inheritanceChanged = this.req.getParameter("MemberInheritanceChanged");
        String assignRightsChanged = this.req.getParameter("MemberAssignRightsChanged");
        String selectedMember = this.req.getParameter("RBSSelectedMember");
        String newMemberAndScope = this.req.getParameter("NewMemberAndScope");
        String inheritance = "true";
        String assignRights = "true";
        String roleName = "";
        String scopeName = "";
        String nameScopeString = "";
        ArrayList<String[]> alErrors = new ArrayList<String[]>();
        ObjectEntry roleOE = null;
        ObjectEntry scopeOE = null;
        ObjectEntry selectedMemberOE = null;
        ObjectType objectType = null;
        boolean err = false;
        boolean validRoleAndScope = true;
        ObjectEntry whoamiOE = null;
        Hashtable<String, ObjectEntry> scopeObjectEntryTable = new Hashtable<String, ObjectEntry>();
        try {
            whoamiOE = this.namespace.getAuthenticatedIdentity(this.treeOE);
        }
        catch (SPIException e) {
            D.log(e);
            String strException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.context);
            String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.context);
            eMFrameUtils.setMessage("error", strTitle, strException, this.context);
            return false;
        }
        String[] memberScopeArray = this.spliceJavaScriptString(newMemberAndScope, "$");
        for (int i = 0; i < memberScopeArray.length; ++i) {
            nameScopeString = memberScopeArray[i];
            validRoleAndScope = true;
            String[] nameScopeArray = this.spliceJavaScriptString(nameScopeString, ";");
            for (int j = 0; j < nameScopeArray.length; ++j) {
                String strRoleType;
                RBSObject[] tasksArray;
                roleName = eMFrameUtils.urlDecode(nameScopeArray[j++], this.context);
                scopeName = eMFrameUtils.urlDecode(nameScopeArray[j], this.context);
                roleOE = this.getObjectEntryFromString(roleName);
                if (selectedMember.equalsIgnoreCase("[root]") || selectedMember.equalsIgnoreCase(this.treeOE.getName())) {
                    validRoleAndScope = false;
                    err = true;
                    D.log("Tree or Root is not a valid role member. - " + selectedMember);
                    if (this.isNameInArrayList(alErrors, selectedMember)) continue;
                    alErrors.add(new String[]{selectedMember, eMFrameUtils.getLocalizedString("FwResources", "ModifyRoleAssociations.ModifyRole", this.context), eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.TREE_NOT_VALID_MEMBER", this.context), ""});
                    continue;
                }
                if (scopeName.equalsIgnoreCase("[root]") && !this.bNVDS) {
                    scopeName = this.treeOE.getName();
                }
                if (roleOE == null) {
                    validRoleAndScope = false;
                    err = true;
                    D.log("Member name not valid. - " + roleName);
                    if (this.isNameInArrayList(alErrors, roleName)) continue;
                    alErrors.add(new String[]{roleName, eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.OBJECT_NOT_FOUND_TITLE", this.context), eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.OBJECT_NOT_FOUND", this.context), new String[]{roleName}), ""});
                    continue;
                }
                RBSRole role = new RBSRole(roleOE);
                try {
                    tasksArray = role.getContent();
                }
                catch (SPIException e) {
                    D.log(e);
                    String strException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.context);
                    String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.context);
                    eMFrameUtils.setMessage("error", strTitle, strException, this.context);
                    return false;
                }
                String secondaryStr = RBSUtil.preCheckSecondaryRights(this.context, whoamiOE, tasksArray);
                if (secondaryStr != null) {
                    validRoleAndScope = false;
                    err = true;
                    alErrors.add(new String[]{roleName, eMFrameUtils.getLocalizedString("FwResources", "Insufficient.Rights", this.context), eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "MemberSecondary.InsufficientRights", this.context), new String[]{secondaryStr, roleName}), ""});
                    break;
                }
                scopeOE = (ObjectEntry)scopeObjectEntryTable.get(scopeName.toLowerCase());
                if (scopeOE == null) {
                    scopeOE = this.getObjectEntryFromString(scopeName);
                    if (scopeOE == null) {
                        validRoleAndScope = false;
                        err = true;
                        D.log("Member scope not valid. - " + scopeName);
                        if (this.isNameInArrayList(alErrors, scopeName)) continue;
                        alErrors.add(new String[]{scopeName, eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.OBJECT_NOT_FOUND_TITLE", this.context), eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.SCOPE_NOT_FOUND_IN_TREE", this.context), new String[]{scopeName}), ""});
                        continue;
                    }
                    if (!this.isValidScope(scopeOE)) {
                        validRoleAndScope = false;
                        err = true;
                        D.log("Scope name not valid. - " + scopeName);
                        if (this.isNameInArrayList(alErrors, scopeName)) continue;
                        alErrors.add(new String[]{scopeName, eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.OBJECT_NOT_FOUND_TITLE", this.context), eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.MODIFY_MEMBER_ASSIGNED_ROLE", this.context), new String[]{scopeName}), ""});
                        continue;
                    }
                    scopeObjectEntryTable.put(scopeName.toLowerCase(), scopeOE);
                    if (!RBSUtil.preCheckScopeRights(whoamiOE, scopeOE)) {
                        validRoleAndScope = false;
                        err = true;
                        if (this.isNameInArrayList(alErrors, scopeName)) continue;
                        alErrors.add(new String[]{scopeName, eMFrameUtils.getLocalizedString("FwResources", "Insufficient.Rights", this.context), eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "ScopeCheck.InsufficientRights", this.context), new String[]{scopeName}), ""});
                        continue;
                    }
                }
                if ((strRoleType = roleOE.getObjectType().getName()) != null && !strRoleType.equalsIgnoreCase("rbsRole2")) {
                    validRoleAndScope = false;
                    err = true;
                    D.log("Member object type is not in the list. - " + strRoleType);
                    if (this.isNameInArrayList(alErrors, roleName)) continue;
                    alErrors.add(new String[]{roleName, eMFrameUtils.getLocalizedString("FwResources", "ModifyRoleAssociations.ModifyRole", this.context), eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.NOT_VALID_MEMBER_TYPE", this.context), new String[]{roleName}), ""});
                    continue;
                }
                boolean bSelfProvisioningRole = this.isSelfProvisioningEguideRole(roleOE);
                if (!bSelfProvisioningRole) continue;
                boolean thisEnabled = iManager.isThisEnabled();
                if (!thisEnabled) {
                    validRoleAndScope = false;
                    err = true;
                    D.log("This is not enabled. Can't add Self-Management role to member." + roleName);
                    alErrors.add(new String[]{roleName, eMFrameUtils.getLocalizedString("FwResources", "ModifyRoleAssociations.ModifyRole", this.context), eMFrameUtils.getLocalizedString("FwResources", "RBSManagement.SelfmanagementNotEnabled", this.context), ""});
                    continue;
                }
                try {
                    selectedMemberOE = this.namespace.getObjectEntry(this.treeOE, selectedMember);
                    objectType = selectedMemberOE.getObjectType();
                    if (!objectType.isContainer()) {
                        validRoleAndScope = false;
                        err = true;
                        D.log("Member object type is not a container." + objectType.getName());
                        if (this.isNameInArrayList(alErrors, selectedMemberOE.getName())) continue;
                        alErrors.add(new String[]{selectedMemberOE.getName(), eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.MEMBER_ROLE_ASSIGNMENT", this.context), eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.LEAF_CANNOT_BE_ASSIGNED", this.context), new String[]{selectedMemberOE.getName()}), ""});
                        continue;
                    }
                    this.addRoleToTree(treeNodes, roleName, selectedMember);
                    this.addObjectToHistory(roleOE);
                    this.modifyMemberTableChanged = "true";
                    ++this.totalObjects;
                    validRoleAndScope = false;
                    err = true;
                    if (this.isNameInArrayList(alErrors, selectedMemberOE.getName())) continue;
                    alErrors.add(new String[]{selectedMemberOE.getName(), eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.MEMBER_ROLE_ASSIGNMENT", this.context), eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.UNABLE_TO_USE_SCOPE", this.context), new String[]{roleName}), ""});
                    continue;
                }
                catch (SPIException e) {
                    D.log(e);
                    String strException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.context);
                    String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.context);
                    eMFrameUtils.setMessage("error", strTitle, strException, this.context);
                }
            }
            if (!validRoleAndScope) continue;
            if (this.bNVDS) {
                inheritance = "wholeSubtree";
            }
            this.addRoleAndScopeToTree(roleName, scopeName, inheritance, selectedMember, assignRights);
            this.modifyMemberTableChanged = "true";
            if (memberScopeArray.length >= 10) continue;
            this.addObjectToHistory(roleOE);
            this.addObjectToHistory(scopeOE);
        }
        if (inheritanceChanged.equalsIgnoreCase("true")) {
            this.modifyMemberInheritanceInTable();
            this.modifyMemberTableChanged = "true";
        }
        if (assignRightsChanged != null && assignRightsChanged.equalsIgnoreCase("true")) {
            this.modifyMemberAssignRightsInTable();
            this.modifyMemberTableChanged = "true";
        }
        this.context.setAuthAttribute("ModifyMemberTableChanged", this.modifyMemberTableChanged);
        if (this.modifyMemberTableChanged.equals("true")) {
            this.resultStrings.put("modifyMemberTableChangesNotSaved", "true");
        }
        this.loadTableData();
        if (err) {
            return this.setErrorMessageURL(this.totalObjects, alErrors);
        }
        return true;
    }

    private boolean deleteMembersFromTable() {
        TreeSet treeNodes = (TreeSet)this.context.getAuthAttribute("ModifyMemberTreeNodes");
        String strDeleteList = this.req.getParameter("DeleteMemberFromRoleList");
        String inheritanceChanged = this.req.getParameter("MemberInheritanceChanged");
        String assignRightsChanged = this.req.getParameter("MemberAssignRightsChanged");
        String strRoleScopePair = "";
        String roleName = "";
        String scopeName = "";
        String[] strDeleteItems = this.spliceJavaScriptString(strDeleteList, "$");
        if (inheritanceChanged.equalsIgnoreCase("true")) {
            this.modifyMemberInheritanceInTable();
            this.modifyMemberTableChanged = "true";
        }
        if (assignRightsChanged != null && assignRightsChanged.equalsIgnoreCase("true")) {
            this.modifyMemberAssignRightsInTable();
            this.modifyMemberTableChanged = "true";
        }
        for (int i = 0; i < strDeleteItems.length; ++i) {
            strRoleScopePair = eMFrameUtils.urlDecode(strDeleteItems[i], this.context);
            String[] roleScopeArray = this.spliceJavaScriptString(strRoleScopePair, ";");
            roleName = roleScopeArray[0];
            if (roleScopeArray.length > 1) {
                scopeName = roleScopeArray[1];
            }
            this.removeRoleAndScopeFromTree(treeNodes, roleName, scopeName);
            this.modifyMemberTableChanged = "true";
        }
        this.context.setAuthAttribute("ModifyMemberTableChanged", this.modifyMemberTableChanged);
        if (this.modifyMemberTableChanged.equals("true")) {
            this.resultStrings.put("modifyMemberTableChangesNotSaved", "true");
        }
        this.loadTableData();
        return true;
    }

    private boolean updateMemberAssociations() {
        String inheritanceChanged = this.req.getParameter("MemberInheritanceChanged");
        String assignRightsChanged = this.req.getParameter("MemberAssignRightsChanged");
        String formChanged = (String)this.context.getAuthAttribute("ModifyMemberTableChanged");
        if (inheritanceChanged.equalsIgnoreCase("true")) {
            this.modifyMemberInheritanceInTable();
            formChanged = "true";
        }
        if (assignRightsChanged != null && assignRightsChanged.equalsIgnoreCase("true")) {
            this.modifyMemberAssignRightsInTable();
            formChanged = "true";
        }
        if (formChanged != null && formChanged.equalsIgnoreCase("true")) {
            RBSAssociatedObject rbsAssociatedObject = (RBSAssociatedObject)this.context.getAuthAttribute("rbsAssociatedObject");
            TreeSet treeNodes = (TreeSet)this.context.getAuthAttribute("ModifyMemberTreeNodes");
            RBSAssociation[] rbsroles = new RBSAssociation[treeNodes.size()];
            Object[] treeNodeArray = treeNodes.toArray();
            ModifyMemberAssociationObject associationObject = null;
            String strRoleName = "";
            String strScopeName = "";
            String strInheritable = "";
            String strAssignRights = "";
            ObjectEntry scopeOE = null;
            ObjectEntry memberOE = null;
            RBSRole role = null;
            boolean assignRights = true;
            this.modifyMemberTableChanged = "false";
            this.context.setAuthAttribute("ModifyMemberTableChanged", "false");
            for (int i = 0; i < treeNodeArray.length; ++i) {
                associationObject = (ModifyMemberAssociationObject)treeNodeArray[i];
                strRoleName = associationObject.getRoleName();
                strScopeName = associationObject.getScopeName();
                strInheritable = associationObject.getInheritable();
                strAssignRights = associationObject.getAssignRights();
                scopeOE = null;
                try {
                    scopeOE = this.treeOE.getName().equalsIgnoreCase(strScopeName) ? this.treeOE : this.namespace.getObjectEntry(this.treeOE, strScopeName);
                    role = new RBSRole(this.namespace.getObjectEntry(this.treeOE, strRoleName));
                    memberOE = rbsAssociatedObject.getObjectEntry();
                    assignRights = Boolean.valueOf(strAssignRights);
                    rbsroles[i] = new RBSAssociation(memberOE, role, scopeOE, -1L, strInheritable, assignRights);
                    continue;
                }
                catch (SPIException e) {
                    D.log(e);
                    String strException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.context);
                    this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "Error", this.context));
                    this.resultStrings.put("GeneralMsg.MsgBody", strException);
                    this.clearTreeSet();
                    return false;
                }
            }
            try {
                String dynamicGroupSearchType = FwUtils.getDynamicSearchType(this.context);
                rbsAssociatedObject.setDirectRoleAssociations2(rbsroles, dynamicGroupSearchType);
                if (this.context.getRequest().getAttribute("isRefreshing") == null) {
                    rbsAssociatedObject.update();
                }
                this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "ModifyMemberAssignedRoles.MODIFY_MEMBER_TITLE", this.context));
                this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString("FwResources", "ModifyMemberAssignedRoles.MODIFY_MEMBER_SUCCESS", this.context));
            }
            catch (Exception e) {
                D.log(e);
                String strException = eMFrameUtils.getExceptionMessage(e, this.context);
                this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "Error", this.context));
                this.resultStrings.put("GeneralMsg.MsgBody", strException);
                this.clearTreeSet();
                return false;
            }
        } else {
            this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "ModifyMemberAssignedRoles.Title", this.context));
            this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString("FwResources", "ModifyMemberAssignedRoles.NO_MEMBER_ASSOCIATION_CHANGES", this.context));
        }
        this.resultStrings.put("GeneralMsg.Url.default", "true");
        this.clearTreeSet();
        return true;
    }

    private void modifyMemberAssignRightsInTable() {
        TreeSet treeNodes = (TreeSet)this.context.getAuthAttribute("ModifyMemberTreeNodes");
        String MemberAssignRightsList = this.req.getParameter("MemberAssignRightsList");
        String[] memberAssignRightsArray = this.spliceJavaScriptString(MemberAssignRightsList, "$");
        for (int i = 0; i < memberAssignRightsArray.length; ++i) {
            String[] nameScopeAssignRightsArray = this.spliceJavaScriptString(memberAssignRightsArray[i], ";");
            String roleName = eMFrameUtils.urlDecode(nameScopeAssignRightsArray[0], this.context);
            String scopeName = eMFrameUtils.urlDecode(nameScopeAssignRightsArray[1], this.context);
            String assignRights = eMFrameUtils.urlDecode(nameScopeAssignRightsArray[2], this.context);
            this.updateScopeAssignRights(treeNodes, roleName, scopeName, assignRights);
        }
    }

    private void modifyMemberInheritanceInTable() {
        TreeSet treeNodes = (TreeSet)this.context.getAuthAttribute("ModifyMemberTreeNodes");
        String MemberInheritanceList = this.req.getParameter("MemberInheritanceList");
        String[] memberInheritanceArray = this.spliceJavaScriptString(MemberInheritanceList, "$");
        for (int i = 0; i < memberInheritanceArray.length; ++i) {
            String[] nameScopeInheritanceArray = this.spliceJavaScriptString(memberInheritanceArray[i], ";");
            String roleName = eMFrameUtils.urlDecode(nameScopeInheritanceArray[0], this.context);
            String scopeName = eMFrameUtils.urlDecode(nameScopeInheritanceArray[1], this.context);
            String inheritance = eMFrameUtils.urlDecode(nameScopeInheritanceArray[2], this.context);
            this.updateScopeInheritance(treeNodes, roleName, scopeName, inheritance);
        }
    }

    private boolean modifyMemberScopeInTable() {
        TreeSet treeNodes = (TreeSet)this.context.getAuthAttribute("ModifyMemberTreeNodes");
        String inheritanceChanged = this.req.getParameter("MemberInheritanceChanged");
        String assignRightsChanged = this.req.getParameter("MemberAssignRightsChanged");
        String modifyScopeList = this.req.getParameter("ModifyScopeList");
        String newRoleName = "";
        String newScopeName = "";
        String oldScopeName = "";
        ArrayList<String[]> alErrors = new ArrayList<String[]>();
        ObjectEntry newScopeOE = null;
        boolean roleScopeChanged = false;
        boolean err = false;
        String[] memberScopeArray = this.spliceJavaScriptString(modifyScopeList, "$");
        if (memberScopeArray != null && memberScopeArray.length > 0) {
            ObjectEntry whoamiOE;
            String nameScopeString = memberScopeArray[0];
            String[] nameScopeArray = this.spliceJavaScriptString(nameScopeString, ";");
            newRoleName = eMFrameUtils.urlDecode(nameScopeArray[0], this.context);
            oldScopeName = eMFrameUtils.urlDecode(nameScopeArray[1], this.context);
            newScopeName = eMFrameUtils.urlDecode(nameScopeArray[2], this.context);
            if (newScopeName.equalsIgnoreCase("[root]")) {
                newScopeName = this.treeOE.getName();
            }
            if ((newScopeOE = this.getObjectEntryFromString(newScopeName)) == null) {
                if (!this.isNameInArrayList(alErrors, newScopeName)) {
                    alErrors.add(new String[]{newScopeName, eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.OBJECT_NOT_FOUND_TITLE", this.context), eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.SCOPE_NOT_FOUND_IN_TREE", this.context), ""});
                }
                String strTitle = eMFrameUtils.getLocalizedString("FwResources", "RBSManagement.ModifyRoleScopeTitle", this.context);
                String strBody = eMFrameUtils.getLocalizedString("BaseResources", "ModifyRBSObjectDescription.Failure", this.context);
                eMFrameUtils.setMooErrorMessage(this.resultStrings, strTitle, eMFrameUtils.formatMessage(strBody, new String[]{Integer.toString(this.totalObjects)}), alErrors);
                this.setUIPage("dev/MooGenErr.jsp");
                return false;
            }
            try {
                whoamiOE = this.namespace.getAuthenticatedIdentity(this.treeOE);
            }
            catch (SPIException e) {
                D.log(e);
                String strException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.context);
                String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.context);
                eMFrameUtils.setMessage("error", strTitle, strException, this.context);
                return false;
            }
            if (!this.isNameInArrayList(alErrors, newScopeName) && !RBSUtil.preCheckScopeRights(whoamiOE, newScopeOE)) {
                err = true;
                alErrors.add(new String[]{newScopeName, eMFrameUtils.getLocalizedString("FwResources", "Insufficient.Rights", this.context), eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "ScopeCheck.InsufficientRights", this.context), new String[]{newScopeName}), ""});
            }
            if (!err) {
                roleScopeChanged = this.replaceExistingScopeObject(treeNodes, newRoleName, newScopeName, oldScopeName);
            }
            if (roleScopeChanged) {
                this.modifyMemberTableChanged = "true";
            }
        }
        if (inheritanceChanged.equalsIgnoreCase("true")) {
            this.modifyMemberInheritanceInTable();
            this.modifyMemberTableChanged = "true";
        }
        if (assignRightsChanged != null && assignRightsChanged.equalsIgnoreCase("true")) {
            this.modifyMemberAssignRightsInTable();
            this.modifyMemberTableChanged = "true";
        }
        this.context.setAuthAttribute("ModifyMemberTableChanged", this.modifyMemberTableChanged);
        if (this.modifyMemberTableChanged.equals("true")) {
            this.resultStrings.put("modifyMemberTableChangesNotSaved", "true");
        }
        this.loadTableData();
        if (err) {
            String strTitle = eMFrameUtils.getLocalizedString("FwResources", "RBSManagement.ModifyRoleScopeTitle", this.context);
            String strBody = eMFrameUtils.getLocalizedString("FwResources", "ModifyRBSObjectDescription.Failed", this.context);
            eMFrameUtils.setMooErrorMessage(this.resultStrings, strTitle, strBody, alErrors);
            this.setUIPage("dev/MooGenErr.jsp");
            return false;
        }
        return true;
    }

    private boolean updateScopeInheritance(TreeSet treeNodes, String roleName, String scopeName, String inheritance) {
        Iterator treeNodesIterator = treeNodes.iterator();
        while (treeNodesIterator.hasNext()) {
            ModifyMemberAssociationObject associationObject = (ModifyMemberAssociationObject)treeNodesIterator.next();
            if (!associationObject.getRoleName().equalsIgnoreCase(roleName) || !associationObject.getScopeName().equalsIgnoreCase(scopeName)) continue;
            associationObject.setInheritable(inheritance);
            break;
        }
        return true;
    }

    private boolean updateScopeAssignRights(TreeSet treeNodes, String roleName, String scopeName, String assignRights) {
        Iterator treeNodesIterator = treeNodes.iterator();
        while (treeNodesIterator.hasNext()) {
            ModifyMemberAssociationObject associationObject = (ModifyMemberAssociationObject)treeNodesIterator.next();
            if (!associationObject.getRoleName().equalsIgnoreCase(roleName) || !associationObject.getScopeName().equalsIgnoreCase(scopeName)) continue;
            associationObject.setAssignRights(assignRights);
            break;
        }
        return true;
    }

    private boolean addRoleToTree(TreeSet treeNodes, String roleName, String selectedMember) {
        String scopeName = "";
        String inheritable = "true";
        String assignRights = "true";
        boolean inTree = false;
        if (this.isSelfProvisioningEguideRole(roleName)) {
            scopeName = selectedMember;
        }
        ModifyMemberAssociationObject associationObject = new ModifyMemberAssociationObject(selectedMember, roleName, scopeName, inheritable, assignRights);
        if (treeNodes != null) {
            inTree = treeNodes.contains(associationObject);
        }
        if (!inTree) {
            treeNodes.add(associationObject);
        }
        return true;
    }

    private boolean addRoleAndScopeToTree(String roleName, String newScopeName, String inheritable, String selectedMember, String assignRights) {
        ModifyMemberAssociationObject associationObject = new ModifyMemberAssociationObject(selectedMember, roleName, newScopeName, inheritable, assignRights);
        TreeSet treeNodes = (TreeSet)this.context.getAuthAttribute("ModifyMemberTreeNodes");
        boolean inTree = treeNodes.contains(associationObject);
        if (!inTree) {
            String oldScopeName = "";
            boolean nullScope = this.isScopeNull(treeNodes, roleName);
            if (nullScope) {
                this.replaceExistingScopeObject(treeNodes, roleName, newScopeName, oldScopeName);
            } else {
                treeNodes.add(associationObject);
            }
            return true;
        }
        return false;
    }

    private boolean replaceExistingScopeObject(TreeSet treeNodes, String roleName, String newScopeName, String oldScopeName) {
        Object[] treeNodeArray = treeNodes.toArray();
        boolean bRoleScopeAssociation = this.doesRoleScopeAssociationExist(treeNodeArray, roleName, newScopeName);
        if (!bRoleScopeAssociation) {
            for (int i = 0; i < treeNodeArray.length; ++i) {
                ModifyMemberAssociationObject associationObject = (ModifyMemberAssociationObject)treeNodeArray[i];
                if (!associationObject.getRoleName().equalsIgnoreCase(roleName) || !associationObject.getScopeName().equalsIgnoreCase(oldScopeName)) continue;
                associationObject.setScopeName(newScopeName);
                break;
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean doesRoleScopeAssociationExist(Object[] treeNodeArray, String roleName, String newScopeName) {
        for (int i = 0; i < treeNodeArray.length; ++i) {
            ModifyMemberAssociationObject associationObject = (ModifyMemberAssociationObject)treeNodeArray[i];
            if (!associationObject.getRoleName().equalsIgnoreCase(roleName) || !associationObject.getScopeName().equalsIgnoreCase(newScopeName)) continue;
            return true;
        }
        return false;
    }

    private boolean isScopeNull(TreeSet treeNodes, String roleName) {
        String emptyScope = "";
        Object[] treeNodeArray = treeNodes.toArray();
        for (int i = 0; i < treeNodeArray.length; ++i) {
            ModifyMemberAssociationObject associationObject = (ModifyMemberAssociationObject)treeNodeArray[i];
            if (!associationObject.getRoleName().equalsIgnoreCase(roleName) || !associationObject.getScopeName().equalsIgnoreCase(emptyScope)) continue;
            return !this.bNVDS;
        }
        return false;
    }

    private boolean removeRoleAndScopeFromTree(TreeSet treeNodes, String roleName, String scopeName) {
        Object[] treeNodeArray = treeNodes.toArray();
        for (int i = 0; i < treeNodeArray.length; ++i) {
            ModifyMemberAssociationObject associationObject = (ModifyMemberAssociationObject)treeNodeArray[i];
            if (!associationObject.getRoleName().equalsIgnoreCase(roleName) || !associationObject.getScopeName().equalsIgnoreCase(scopeName)) continue;
            treeNodes.remove(associationObject);
            break;
        }
        return true;
    }

    private boolean isValidScope(ObjectEntry objectEntry) {
        ObjectType objectType = objectEntry.getObjectType();
        if (!objectType.isContainer()) {
            this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.MODIFY_MEMBER_ASSIGNED_ROLE_TITLE", this.context));
            this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.MODIFY_MEMBER_ASSIGNED_ROLE", this.context));
            return false;
        }
        return true;
    }

    private boolean isValidMemberType(ObjectEntry objectEntry) throws NamespaceException, SPIException {
        String roleMemberObjectTypes = RBSUtil.getRoleMemberObjectTypes(this.context, this.namespace, false);
        if (roleMemberObjectTypes == null) {
            return false;
        }
        String[] validMemberTypes = RBSUtil.tokenizeObjectTypes(roleMemberObjectTypes);
        ObjectType objecttype = objectEntry.getObjectType();
        boolean validType = true;
        for (int i = 0; i < validMemberTypes.length; ++i) {
            if (objecttype.getName().equals("rbsScope")) {
                return false;
            }
            if (DirUtils.isOfType(objecttype, validMemberTypes[i], true)) {
                validType = true;
                break;
            }
            validType = false;
        }
        if (!validType && this.getDynamicGroupFlag() && this.hasDynamicGroupAux(objectEntry).equals("true")) {
            validType = true;
        }
        return validType;
    }

    private String isRBSXMLAttrDefined(ObjectEntry treeOE) {
        SchemaDefinition schemaDef = null;
        boolean rbsXmlAttrDefined = true;
        String xmlAttrDefined = "false";
        try {
            schemaDef = this.namespace.getSchemaDefinition(treeOE);
            rbsXmlAttrDefined = schemaDef.isAttributeDefined("rbsXMLInfo");
            if (rbsXmlAttrDefined) {
                xmlAttrDefined = "true";
            }
        }
        catch (SPIException e) {
            D.log(e);
            String strException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.context);
            String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.context);
            eMFrameUtils.setMessage("error", strTitle, strException, this.context);
        }
        return xmlAttrDefined;
    }

    private boolean isSelfProvisioningEguideRole(String roleName) {
        try {
            ObjectEntry roleOE = this.namespace.getObjectEntry(this.treeOE, roleName);
            RBSRole role = new RBSRole(roleOE);
            return this.isSelfProvisioningEguideRole(role);
        }
        catch (SPIException e) {
            return false;
        }
    }

    private boolean isSelfProvisioningEguideRole(ObjectEntry objectEntry) {
        RBSRole role = new RBSRole(objectEntry);
        return this.isSelfProvisioningEguideRole(role);
    }

    private boolean isSelfProvisioningEguideRole(RBSRole role) {
        try {
            String paramString;
            String paramStr = role.getParameters();
            return paramStr != null && (paramString = this.getSelfProvisioningFromParameters(paramStr)) != null && paramString.equalsIgnoreCase("true");
        }
        catch (SPIException e) {
            return false;
        }
    }

    private boolean isNameInArrayList(ArrayList alErrors, String memberScopeName) {
        Object[] errorArray = alErrors.toArray();
        String[] arrayItem = null;
        for (int i = 0; i < errorArray.length; ++i) {
            arrayItem = (String[])errorArray[i];
            if (!memberScopeName.equalsIgnoreCase(arrayItem[0])) continue;
            return true;
        }
        return false;
    }

    private boolean isDynamicGroupOrAuxObject(ObjectEntry objectEntry) {
        boolean bDynamicGroup;
        block3: {
            AdminNamespace namespace = this.treeOE.getAdminNamespace();
            bDynamicGroup = false;
            try {
                Enumeration myenum;
                ObjectAttribute oa = namespace.getAttribute(objectEntry, "Object Class");
                if (oa == null || (myenum = oa.getValueComponents()) == null) break block3;
                while (myenum.hasMoreElements()) {
                    String value = myenum.nextElement().toString();
                    if (!value.equals("dynamicGroup") && !value.equals("dynamicGroupAux")) continue;
                    bDynamicGroup = true;
                    break;
                }
            }
            catch (SPIException e) {
                D.log(e);
                String strException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.context);
                String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.context);
                eMFrameUtils.setMessage("error", strTitle, strException, this.context);
            }
        }
        return bDynamicGroup;
    }

    private String hasDynamicGroupAux(ObjectEntry objectEntry) {
        String dynamicGroupAux;
        block3: {
            AdminNamespace namespace = this.treeOE.getAdminNamespace();
            dynamicGroupAux = "false";
            try {
                Enumeration myenum;
                ObjectAttribute oa = namespace.getAttribute(objectEntry, "Object Class");
                if (oa == null || (myenum = oa.getValueComponents()) == null) break block3;
                while (myenum.hasMoreElements()) {
                    String value = myenum.nextElement().toString();
                    if (!value.equals("dynamicGroupAux")) continue;
                    dynamicGroupAux = "true";
                    break;
                }
            }
            catch (SPIException e) {
                D.log(e);
                String strException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.context);
                String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.context);
                eMFrameUtils.setMessage("error", strTitle, strException, this.context);
            }
        }
        return dynamicGroupAux;
    }

    private boolean getDynamicGroupFlag() {
        SystemConfig systemConfig = SystemConfig.getSystemConfig(this.context);
        String dynamicGroupEnabled = systemConfig.getSetting("Provider.eMFrame.DynamicGroup.enable");
        return dynamicGroupEnabled != null && dynamicGroupEnabled.equalsIgnoreCase("true");
    }

    private String getSelfProvisioningFromParameters(String paramStr) {
        Properties parameters = eMFrameUtils.parseParameters(paramStr, ";");
        return (String)parameters.get("self-provisioning");
    }

    private String[] spliceJavaScriptString(String joinedString, String delimiter) {
        StringTokenizer tokenIzer = new StringTokenizer(joinedString, delimiter, false);
        String[] stringArray = new String[tokenIzer.countTokens()];
        int tokenCount = 0;
        while (tokenIzer.hasMoreTokens()) {
            stringArray[tokenCount] = tokenIzer.nextToken();
            ++tokenCount;
        }
        return stringArray;
    }

    private String getObjectTypeFromString(String objectName) {
        AdminNamespace namespace = this.treeOE.getAdminNamespace();
        ObjectEntry objectEntry = null;
        String sTypeName = null;
        try {
            objectEntry = namespace.getObjectEntry(this.treeOE, objectName);
        }
        catch (SPIException e) {
            D.log(e);
        }
        if (objectEntry != null) {
            sTypeName = objectEntry.getObjectType().getName();
        }
        return sTypeName;
    }

    private ObjectEntry getObjectEntryFromString(String objectName) {
        ObjectEntry objectEntry = null;
        AdminNamespace namespace = this.treeOE.getAdminNamespace();
        try {
            objectEntry = this.treeOE.getName().equalsIgnoreCase(objectName) ? this.treeOE : namespace.getObjectEntry(this.treeOE, objectName);
        }
        catch (SPIException e) {
            D.log(e);
        }
        return objectEntry;
    }

    private boolean setErrorMessageURL(int totalObjects, ArrayList alErrors) {
        String sTitle = eMFrameUtils.getLocalizedString("FwResources", "ModifyMemberAssignedRoles.MODIFY_MEMBER_TITLE", this.context);
        String sBody = eMFrameUtils.getLocalizedString("FwResources", "ModifyRBSObjectDescription.Failure", this.context);
        eMFrameUtils.setMooErrorMessage(this.resultStrings, sTitle, eMFrameUtils.formatMessage(sBody, new String[]{Integer.toString(totalObjects)}), alErrors);
        String sTaskId = this.req.getParameter("taskId");
        String sUserContext = this.req.getParameter("User.context");
        String sNextState = "initializeAssociationObjects";
        String sMerge = "fw.ModifyMemberAssignedRolesPage";
        String sUrl = "webacc?taskId=";
        sUrl = sUrl + sTaskId;
        sUrl = sUrl + "&merge=";
        sUrl = sUrl + sMerge;
        sUrl = sUrl + "&nextState=";
        sUrl = sUrl + sNextState;
        sUrl = sUrl + "&User.context=";
        sUrl = sUrl + sUserContext;
        this.resultStrings.put("GeneralMsg.Url", sUrl);
        return false;
    }

    private void addObjectToHistory(ObjectEntry objectEntry) {
        if (objectEntry != null) {
            if (objectEntry.getObjectType().getName().equalsIgnoreCase("Top")) {
                this.context.addToHistory("Top", objectEntry.getName());
            } else {
                this.context.addToHistory(objectEntry);
            }
        }
    }

    private void setRoleMemberTypesFilter() {
        String roleMemberFilter = "";
        try {
            roleMemberFilter = RBSUtil.getRoleMemberObjectTypes(this.context, this.namespace, false);
        }
        catch (Exception exc) {
            D.log(exc);
        }
        this.resultStrings.put("RoleMemberFilter", roleMemberFilter);
    }

    private boolean isNVDS() {
        boolean rval = false;
        try {
            rval = this.namespace.isSupported("NVDS");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rval;
    }

    private Object[] getAclScopeValues() {
        Vector<String> scopeVector = new Vector<String>(2);
        scopeVector.addElement("baseObject");
        scopeVector.addElement("wholeSubtree");
        String[] aclScopes = null;
        if (this.isNVDS()) {
            try {
                SchemaDefinition sd = this.namespace.getSchemaDefinition(this.treeOE);
                aclScopes = ((LDAPSchemaDefinition)sd).aclScopes();
            }
            catch (SPIException e) {
                D.log(e);
                String strException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.context);
                String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.context);
                eMFrameUtils.setMessage("error", strTitle, strException, this.context);
            }
            if (aclScopes != null) {
                for (int i = 0; i < aclScopes.length; ++i) {
                    if (aclScopes[i].equalsIgnoreCase("inheritedRightsFilterWholeSubtree") || aclScopes[i].equalsIgnoreCase("inheritedRightsFilterSubordinateSubtree") || scopeVector.contains(aclScopes[i])) continue;
                    scopeVector.addElement(aclScopes[i]);
                }
            }
        }
        Object[] aclScopeValueArray = scopeVector.toArray();
        return aclScopeValueArray;
    }

    private boolean isCollectionOwner() {
        try {
            ObjectEntry whoamiOE = this.namespace.getAuthenticatedIdentity(this.treeOE);
            RBSAssociatedObject rbsAssociatedObject = new RBSAssociatedObject(whoamiOE);
            if (rbsAssociatedObject.getAllOwnedCollections2() == null) {
                String msg = eMFrameUtils.getLocalizedString("FwResources", "RBSConfiguration.IsCollectionOwner", this.context.getLocale());
                String strTitle = eMFrameUtils.getLocalizedString("FwResources", "RBSConfiguration.IsCollectionOwnerTitle", this.context.getLocale());
                eMFrameUtils.setMessage("error", strTitle, msg, this.context);
                return false;
            }
        }
        catch (Exception exc) {
            String strException = eMFrameUtils.getExceptionMessage(exc, this.context);
            String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.context.getLocale());
            eMFrameUtils.setMessage("error", strTitle, strException, this.context);
            return false;
        }
        return true;
    }
}

