/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.ns.AdminNamespace;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.BookInfo;
import com.novell.emframe.fw.BookRoleInfo;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.RBSUtil;
import com.novell.rbs.RBSRole;
import com.novell.rbs.RBSTask;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;

public class ModifyTaskRoleAssignmentTask
extends Task {
    private static final long serialVersionUID = 1L;
    private HttpServletRequest req;
    private TaskContext context;
    private Properties resultStrings;
    private AdminNamespace namespace;
    private ObjectEntry treeOE;

    public static void shouldRun(HttpServletRequest req, String sServiceName) throws Exception {
        FwUtils.verifyRbsInstalled(req, sServiceName);
    }

    public boolean execute(TaskContext context, Properties resultStrings) {
        this.context = context;
        this.resultStrings = resultStrings;
        this.req = context.getRequest();
        this.treeOE = RBSUtil.getTreeOE(context);
        this.namespace = this.treeOE.getAdminNamespace();
        String nextState = this.req.getParameter("nextState");
        if (nextState == null || nextState.equalsIgnoreCase("initialState")) {
            return this.showInitialForm();
        }
        if (nextState.equalsIgnoreCase("showTaskRoleAssignment")) {
            return this.showTaskRoleAssignment();
        }
        if (nextState.equalsIgnoreCase("saveTaskRoleAssignment")) {
            return this.saveTaskRoleAssignment();
        }
        return this.showInitialForm();
    }

    private boolean showInitialForm() {
        this.resultStrings.put("DisplayNameTitle", eMFrameUtils.getLocalizedString("FwResources", "ModifyTaskRoleAssignment", this.context));
        this.resultStrings.put("Merge.Template", "fw.ModifyTaskRoleAssignment");
        this.resultStrings.put("Next.State", "showTaskRoleAssignment");
        return true;
    }

    private boolean showTaskRoleAssignment() {
        BookInfo bookInfo = new BookInfo();
        String selectedContext = this.req.getParameter("TaskName");
        String[] strings = eMFrameUtils.unpack(selectedContext, this.context);
        selectedContext = strings[0];
        try {
            ObjectEntry taskOE = this.namespace.getObjectEntry(this.treeOE, selectedContext);
            bookInfo.setContextOE(taskOE);
            bookInfo.setContext(selectedContext);
            String objectType = taskOE.getObjectType().getName();
            if (!objectType.equals("rbsTask2")) {
                this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "Error", this.context));
                this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString("FwResources", "GetTaskName.WrongClass", this.context));
                return false;
            }
            this.context.addToHistory(taskOE);
            RBSTask rbsTask = new RBSTask(taskOE);
            String taskType = RBSUtil.getTypeFromParameters(rbsTask.getParameters());
            bookInfo.setBookType(taskType);
            RBSRole[] rbsRoles = rbsTask.getContentMembership();
            BookRoleInfo[] bookAssignedRoleInfo = RBSUtil.readAssignedRoleInfo(rbsRoles, this.namespace, this.context);
            bookInfo.setAssignedRoles(bookAssignedRoleInfo);
            BookRoleInfo[] bookAvailableRoleInfo = RBSUtil.readAvailableRoles(bookInfo, this.treeOE, this.context);
            bookInfo.setAvailableRoles(bookAvailableRoleInfo);
        }
        catch (Exception e) {
            D.log(e);
            eMFrameUtils.setErrorMessage(e, this.context);
            return false;
        }
        bookInfo.setAvailableRoles(RBSUtil.removeAssignedRolesFromAvailableRoles(bookInfo.getAvailableRoles(), bookInfo.getAssignedRoles()));
        RBSUtil.putAvailableRoles(bookInfo, this.resultStrings);
        RBSUtil.putAssignedRoles(bookInfo, this.resultStrings);
        this.resultStrings.put("TaskName_Value", bookInfo.getContext());
        this.context.setAuthAttribute("BookInfo", bookInfo);
        return true;
    }

    private boolean saveTaskRoleAssignment() {
        this.resultStrings.put("TaskAfterGenConf", "fw.HomePage");
        this.resultStrings.put("MergeAfterGenConf", "fw.HomePage");
        BookInfo bookInfo = (BookInfo)this.context.getAuthAttribute("BookInfo");
        String formChanged = this.req.getParameter("TaskRoleFormChanged");
        if (formChanged.equals("true")) {
            RBSUtil.getAssignedRoles(bookInfo, this.req);
            RBSTask rbsTask = new RBSTask(bookInfo.getContextOE());
            try {
                BookRoleInfo[] roleList = bookInfo.getAssignedRoles();
                RBSRole[] roles = null;
                if (roleList != null && roleList.length > 0) {
                    roles = new RBSRole[roleList.length];
                    for (int i = 0; i < roleList.length; ++i) {
                        String roleName = roleList[i].getFullName();
                        ObjectEntry roleOE = this.namespace.getObjectEntry(roleName);
                        roles[i] = new RBSRole(roleOE);
                    }
                }
                String dynamicGroupSearchType = FwUtils.getDynamicSearchType(this.context);
                rbsTask.setContentMembership(roles, dynamicGroupSearchType);
                rbsTask.update();
                this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "ModifyTaskRoleAssignment", this.context));
                this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString("FwResources", "GetTaskName.ADD_ROLE_RBSTASK", this.context));
            }
            catch (Exception e) {
                D.log(e);
                eMFrameUtils.setErrorMessage(e, this.context);
                return false;
            }
        } else {
            this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "ModifyTaskRoleAssignment", this.context));
            this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString("FwResources", "GetBookName.NO_UPDATE_PAGE_RBSBOOK", this.context));
        }
        return true;
    }
}

