/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.common.exceptions.UniqueSPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.Replica;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.nds.BackLinkFacade;
import com.novell.admin.ns.nds.NDSAttributeDefinition;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.admin.ns.nds.NDSObjectAttribute;
import com.novell.admin.ns.nds.NDSObjectRights;
import com.novell.admin.ns.nds.NDSPartitionService;
import com.novell.admin.ns.nds.NDSSyntax;
import com.novell.admin.ns.nds.ObjectFlags;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.SnapinVetoException;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.JobData;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.nps.gadgetManager.GadgetInstance;
import com.novell.webaccess.common.I18NServletRequest;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public class MoveSubtreeTask
extends Task {
    private static final long serialVersionUID = 1L;
    public static final String HTMLPARAM_FORMNAME = "MoveObjectForm";
    public static final String HTMLPARAM_NEWCONTEXT = "MoveObjectContext";
    public static final String HTMLPARAM_SRCOBJECT = "MoveObjectName";
    public static final String HTMLPARAM_ENABLECREATEALIAS = "EnableCreateAlias";
    private static final String ALIAS_CLASS_NAME = "Alias";
    private static final String OBJECT_CLASS_ATTR_NAME = "Object Class";
    private static final String ALIAS_ATTR_NAME = "Aliased Object Name";
    private static final String BACK_LINK = "Back Link";
    HttpServletRequest req;
    TaskContext m_context;
    Properties m_resultStrings;
    Vector m_vServers = new Vector();
    ArrayList m_info = new ArrayList();
    private String m_createAlias = null;
    private ObjectEntry m_destOE = null;
    private ObjectEntry m_srcObjectOE = null;
    private boolean m_serverError = false;
    private boolean m_fatalError = false;
    private ReportThread thread;
    private boolean stopThread;
    private boolean threadDone;
    private long foundServersCount;
    private String serversMessage = "";

    public boolean execute(TaskContext context, Properties resultStrings) {
        D.log("MoveSubtreeTask::execute start");
        this.m_context = context;
        this.m_resultStrings = resultStrings;
        this.req = this.m_context.getRequest();
        String nextState = this.req.getParameter("nextState");
        D.log("nextState = " + nextState);
        if (nextState == null || nextState.equalsIgnoreCase("initialState")) {
            eMFrameUtils.setupTargetChooser(null, context);
            return this.showInitialForm();
        }
        if (nextState.equalsIgnoreCase("doShortReport")) {
            try {
                D.log("doShortReport");
                String srcObject = this.req.getParameter(HTMLPARAM_SRCOBJECT);
                String newContext = this.req.getParameter(HTMLPARAM_NEWCONTEXT);
                this.m_createAlias = this.req.getParameter(HTMLPARAM_ENABLECREATEALIAS);
                return this.doShortReport(newContext, srcObject, this.m_createAlias);
            }
            catch (Exception e) {
                D.log(e);
                return false;
            }
        }
        if (nextState.equalsIgnoreCase("doMoveObject")) {
            try {
                D.log("doMoveObject");
                return this.doMoveObject(this.m_destOE, this.m_srcObjectOE, this.m_createAlias);
            }
            catch (Exception e) {
                D.log(e);
                return false;
            }
        }
        if (nextState.equalsIgnoreCase("refresh")) {
            return this.refresh();
        }
        if (nextState.equalsIgnoreCase("cancel")) {
            return this.cancel();
        }
        if (nextState.equalsIgnoreCase("error")) {
            return this.error();
        }
        D.log("Task received invalid state " + nextState);
        return this.showInitialForm();
    }

    private boolean showInitialForm() {
        return true;
    }

    private boolean doShortReport(String strContext, String strObjectName, String enableCreateAlias) {
        Object of = null;
        long objFlags = 0L;
        boolean success = false;
        String strException = null;
        AdminNamespace adminns = null;
        AuthenticationBroker broker = this.m_context.getAuthenticationBroker();
        ObjectEntry treeOE = (ObjectEntry)broker.getAPIObject("NDSNamespace");
        NDSNamespace namespace = (NDSNamespace)treeOE.getNamespace();
        if (0 == strContext.indexOf("\\")) {
            strContext = strContext.substring(1);
        }
        D.log("MoveSubtreeTask: Moving: Name: " + strObjectName + ", To Context: " + strContext);
        try {
            this.m_destOE = strContext.equalsIgnoreCase(treeOE.getName()) ? namespace.getObjectEntry(strContext) : namespace.getObjectEntry(treeOE, strContext);
            NDSObjectRights objRights = (NDSObjectRights)namespace.getObjectEffectiveRights(this.m_destOE, namespace.getAuthenticatedIdentity(treeOE));
            if (!objRights.hasAddRights()) {
                String strTitle = eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.Failure", this.m_context);
                String strBody = eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.InsufficientRights", this.m_context);
                eMFrameUtils.setMessage("error", strTitle, eMFrameUtils.formatMessage(strBody, new String[]{strContext}), this.m_context);
                return false;
            }
            this.m_context.addToHistory(this.m_destOE);
        }
        catch (SPIException e) {
            D.log(e);
            String strTitle = eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.Failure", this.m_context);
            String strBody = eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.ContainerNotFound", this.m_context);
            eMFrameUtils.setMessage("error", strTitle, eMFrameUtils.formatMessage(strBody, new String[]{strContext}), this.m_context);
            return false;
        }
        try {
            this.m_srcObjectOE = namespace.getObjectEntry(treeOE, strObjectName);
        }
        catch (SPIException e) {
            D.log(e);
            String strTitle = eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.Failure", this.m_context);
            String strBody = eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.NotFound", this.m_context);
            eMFrameUtils.setMessage("error", strTitle, eMFrameUtils.formatMessage(strBody, new String[]{strObjectName}), this.m_context);
            return false;
        }
        try {
            adminns = (AdminNamespace)this.m_srcObjectOE.getObjectType().getNamespace();
            ClassDefinition cd = adminns.getClassDefinition(this.m_srcObjectOE, this.m_srcObjectOE.getObjectType().getName());
            objFlags = this.m_srcObjectOE.getObjectFlags();
            if (!cd.canBeContainedBy(this.m_destOE.getObjectType().getName())) {
                String strTitle = eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.Failure", this.m_context);
                String strBody = eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.NotContainment", this.m_context);
                eMFrameUtils.setMessage("error", strTitle, eMFrameUtils.formatMessage(strBody, new String[]{strContext}), this.m_context);
                return false;
            }
            if (this.m_srcObjectOE.getObjectType().isContainer() && !ObjectFlags.isAlias((long)objFlags)) {
                if (!ObjectFlags.isPartition((long)objFlags)) {
                    String strTitle = eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.Failure", this.m_context);
                    String strBody = eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.NotPartition", this.m_context);
                    eMFrameUtils.setMessage("error", strTitle, eMFrameUtils.formatMessage(strBody, new String[]{strObjectName}), this.m_context);
                    return false;
                }
                this.setupProgress();
            }
        }
        catch (NamespaceException nse) {
            D.log(nse);
            strException = eMFrameUtils.getExceptionMessage((Exception)((Object)nse), this.m_context);
        }
        catch (SPIException spie) {
            D.log(spie);
            strException = eMFrameUtils.getExceptionMessage((Exception)((Object)spie), this.m_context);
        }
        if (null != strException) {
            String strTitle = eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.Failure", this.m_context);
            String strBody = strException;
            eMFrameUtils.setMessage("error", strTitle, strBody, this.m_context);
            return false;
        }
        D.log("MoveSubtreeTask::Short Report of server status succeeded");
        return true;
    }

    private boolean doMoveObject(ObjectEntry m_destOE, ObjectEntry m_srcObjectOE, String enableCreateAlias) {
        String strNewObject;
        Object of = null;
        long objFlags = 0L;
        boolean success = false;
        String strException = null;
        AdminNamespace adminns = null;
        AuthenticationBroker broker = this.m_context.getAuthenticationBroker();
        ObjectEntry treeOE = (ObjectEntry)broker.getAPIObject("NDSNamespace");
        NDSNamespace namespace = (NDSNamespace)treeOE.getNamespace();
        adminns = (AdminNamespace)m_srcObjectOE.getObjectType().getNamespace();
        try {
            success = DirUtils.MoveObject(m_srcObjectOE, m_destOE, false);
        }
        catch (NamespaceException nse) {
            D.log(nse);
            strException = eMFrameUtils.getExceptionMessage((Exception)((Object)nse), this.m_context);
        }
        catch (SPIException spie) {
            D.log(spie);
            strException = eMFrameUtils.getExceptionMessage((Exception)((Object)spie), this.m_context);
        }
        catch (SnapinVetoException sve) {
            D.log(sve);
            strException = eMFrameUtils.getExceptionMessage((Exception)((Object)sve), this.m_context);
        }
        if (m_destOE.getObjectType().getName().equalsIgnoreCase("top")) {
            strNewObject = m_srcObjectOE.getName() + m_destOE.getFullName();
            this.m_context.addToHistory(m_srcObjectOE.getObjectType().getName(), m_srcObjectOE.getName());
        } else {
            strNewObject = m_srcObjectOE.getName() + "." + m_destOE.getFullName();
            this.m_context.addToHistory("[partitions]", m_srcObjectOE.getName() + "." + namespace.getUnrootedName(m_destOE));
        }
        this.m_context.removeFromHistory(namespace.getUnrootedName(m_srcObjectOE));
        JobData data = JobData.getJobData((GadgetInstance)this);
        if (null != data) {
            data.setObjectNames(new String[]{m_srcObjectOE.getName() + "." + namespace.getUnrootedName(m_destOE)});
        }
        boolean createAliasFailed = false;
        if (null != enableCreateAlias && !this.createAlias(strNewObject, m_srcObjectOE, adminns)) {
            createAliasFailed = true;
        }
        if (null != strException || !success) {
            String strTitle = eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.Failure", this.m_context);
            String strBody = strException;
            eMFrameUtils.setMessage("error", strTitle, strBody, this.m_context);
            return false;
        }
        String strTitle = eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.Success", this.m_context);
        String strBody = eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.SuccessForSubtreeObject", this.m_context);
        if (createAliasFailed) {
            strBody = eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.SuccessForObjectNoAlias", this.m_context);
        }
        eMFrameUtils.setMessage("success", strTitle, eMFrameUtils.formatMessage(strBody, new String[]{strNewObject}), this.m_context);
        D.log("MoveSubtreeTask::Move Object succeeded");
        return true;
    }

    private boolean createAlias(String newObjectName, ObjectEntry oldOE, AdminNamespace adminns) {
        ObjectEntry newOE = null;
        NSObject aliasObj = null;
        AuthenticationBroker broker = this.m_context.getAuthenticationBroker();
        ObjectEntry treeOE = (ObjectEntry)broker.getAPIObject("NDSNamespace");
        NDSNamespace ns = (NDSNamespace)treeOE.getNamespace();
        for (int i = 0; i < 6; ++i) {
            try {
                Thread.sleep(2000L);
                newOE = ns.getObjectEntry(newObjectName);
                break;
            }
            catch (Exception e) {
                D.log(e);
                if (!(e instanceof UniqueSPIException) || ((UniqueSPIException)e).getErrorCode() != -601) {
                    return false;
                }
                D.log(i + " Delaying for 2 seconds to get the new object!!!");
                continue;
            }
        }
        try {
            ValueComponent aliasNameVal = NDSSyntax.SYN_CLASS_NAME.createValueComponent((Object)ALIAS_CLASS_NAME);
            ValueComponent[] aliasNameVals = new ValueComponent[]{aliasNameVal};
            NDSObjectAttribute objClassAttr = new NDSObjectAttribute((AttributeDefinition)((NDSAttributeDefinition)ns.getAttributeDefinition(newOE, OBJECT_CLASS_ATTR_NAME)), aliasNameVals);
            ValueComponent distNameVal = NDSSyntax.SYN_DIST_NAME.createValueComponent((Object)ns.getUnrootedName(newOE));
            ValueComponent[] distNameVals = new ValueComponent[]{distNameVal};
            NDSObjectAttribute aliasNameAttr = new NDSObjectAttribute((AttributeDefinition)((NDSAttributeDefinition)ns.getAttributeDefinition(newOE, ALIAS_ATTR_NAME)), distNameVals);
            Vector<NDSObjectAttribute> attrNDSOV = new Vector<NDSObjectAttribute>();
            attrNDSOV.addElement(aliasNameAttr);
            attrNDSOV.addElement(objClassAttr);
            ObjectEntry aliasObjectEntry = ns.createObjectEntry(oldOE.getParent(), oldOE.getName(), ALIAS_CLASS_NAME);
            aliasObj = adminns.createNSObject(aliasObjectEntry, attrNDSOV);
        }
        catch (SPIException e) {
            D.log(e);
            return false;
        }
        catch (ComponentCreationException e) {
            D.log(e);
            return false;
        }
        catch (NamespaceException e) {
            D.log(e);
            return false;
        }
        for (int i = 0; i < 6; ++i) {
            try {
                Thread.sleep(2000L);
                ns.create(aliasObj);
                break;
            }
            catch (Exception e) {
                D.log(e);
                if (!(e instanceof UniqueSPIException) || ((UniqueSPIException)e).getErrorCode() != -606) {
                    return false;
                }
                D.log(i + " Delaying for 2 seconds to create the alias!!!");
                continue;
            }
        }
        return true;
    }

    private boolean areServersInReplicaRingUp(ObjectEntry oe) throws SPIException {
        boolean redFlag = false;
        boolean findParentPart = true;
        NDSNamespace ndsns = (NDSNamespace)oe.getObjectType().getNamespace();
        NDSPartitionService partService = (NDSPartitionService)ndsns.getPartitionService(oe);
        ObjectEntry partObjEntry = oe;
        while (partObjEntry != null) {
            if (ObjectFlags.isPartition((long)partObjEntry.getObjectFlags())) {
                Replica[] replicas = partService.getPartitionReplicaList(partObjEntry, null);
                if (replicas == null || replicas.length <= 0) continue;
                ObjectEntry servObj = null;
                for (int i = 0; i < replicas.length; ++i) {
                    String strBody;
                    String strTitle;
                    servObj = replicas[i].getStoredOnServer();
                    if (this.m_vServers.contains(servObj.getFullName())) continue;
                    if (!ndsns.isServerUp(servObj)) {
                        this.m_vServers.addElement(servObj.getFullName());
                        strTitle = eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.RingErrTitle", this.m_context);
                        strBody = eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.RingErrBody", this.m_context);
                        this.m_info.add(new String[]{servObj.getFullName(), "down", "ring", strTitle, eMFrameUtils.formatMessage(strBody, new String[]{partObjEntry.getName()})});
                        redFlag = true;
                        continue;
                    }
                    this.m_vServers.addElement(servObj.getFullName());
                    strTitle = eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.RingTitle", this.m_context);
                    strBody = eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.RingBody", this.m_context);
                    this.m_info.add(new String[]{servObj.getFullName(), "up", "ring", strTitle, eMFrameUtils.formatMessage(strBody, new String[]{partObjEntry.getName()})});
                }
                break;
            }
            partObjEntry = partObjEntry.getParent();
        }
        return redFlag;
    }

    public boolean readBacklinkAttr(ObjectEntry oe) {
        boolean redFlag = false;
        ObjectEntry servObj = null;
        NSObject nsObj = null;
        AuthenticationBroker broker = this.m_context.getAuthenticationBroker();
        ObjectEntry treeOE = (ObjectEntry)broker.getAPIObject("NDSNamespace");
        NDSNamespace ndsns = (NDSNamespace)treeOE.getNamespace();
        for (ObjectEntry partObjEntry = oe; partObjEntry != null; partObjEntry = partObjEntry.getParent()) {
            if (!ObjectFlags.isPartition((long)partObjEntry.getObjectFlags())) continue;
            try {
                nsObj = ndsns.getDetails(oe);
            }
            catch (SPIException spie) {
                D.log(spie);
                return true;
            }
            NDSObjectAttribute attrib = null;
            attrib = (NDSObjectAttribute)nsObj.getAttribute(BACK_LINK);
            BackLinkFacade blFacade = null;
            if (attrib == null) break;
            Enumeration valueSet = attrib.getValueComponents();
            int i = this.m_vServers.size();
            while (valueSet.hasMoreElements()) {
                String strBody;
                String strTitle;
                blFacade = (BackLinkFacade)((ValueList)valueSet.nextElement()).createFacade();
                try {
                    servObj = ndsns.getObjectEntry(treeOE, blFacade.getObjectName());
                }
                catch (SPIException e) {
                    D.log(e);
                    this.m_vServers.addElement(blFacade.getObjectName());
                    String strTitle2 = eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.BacklinkErrTitle", this.m_context);
                    String strBody2 = eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.BacklinkUknownBody", this.m_context);
                    this.m_info.add(new String[]{blFacade.getObjectName(), "unknown", "backlink", strTitle2, eMFrameUtils.formatMessage(strBody2, new String[]{partObjEntry.getName()})});
                    ++i;
                    redFlag = true;
                    continue;
                }
                if (this.m_vServers.contains(servObj.getFullName())) continue;
                if (!ndsns.isServerUp(servObj)) {
                    this.m_vServers.addElement(servObj.getFullName());
                    strTitle = eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.BacklinkErrTitle", this.m_context);
                    strBody = eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.BacklinkErrBody", this.m_context);
                    this.m_info.add(new String[]{servObj.getFullName(), "down", "backlink", strTitle, eMFrameUtils.formatMessage(strBody, new String[]{partObjEntry.getName()})});
                    ++i;
                    redFlag = true;
                    continue;
                }
                this.m_vServers.addElement(servObj.getFullName());
                strTitle = eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.BacklinkTitle", this.m_context);
                strBody = eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.BacklinkBody", this.m_context);
                this.m_info.add(new String[]{servObj.getFullName(), "up", "backlink", strTitle, eMFrameUtils.formatMessage(strBody, new String[]{partObjEntry.getName()})});
                ++i;
            }
            break;
        }
        return redFlag;
    }

    public void updateReportData() {
        if (this.m_serverError) {
            this.m_resultStrings.put("GeneralMsg.Icon", "dev/error32.gif");
            this.m_resultStrings.put("ServerList.Error", "true");
        } else {
            this.m_resultStrings.put("ServerList.Error", "false");
            this.m_resultStrings.put("GeneralMsg.Icon", "dev/notice32.gif");
        }
        this.m_resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.ReportTitle", this.m_context));
        this.m_resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.ReportBody", this.m_context));
        int count = this.m_info.size();
        this.m_resultStrings.put("ServerList.Count", Integer.toString(count));
        for (int i = 0; i < count; ++i) {
            String[] error = (String[])this.m_info.get(i);
            this.m_resultStrings.put("ServerList." + i + ".Name", error[0]);
            this.m_resultStrings.put("ServerList." + i + ".Status", error[1]);
            this.m_resultStrings.put("ServerList." + i + ".Type", error[2]);
            this.m_resultStrings.put("ServerList." + i + ".ErrorMsgTitle", error[3]);
            this.m_resultStrings.put("ServerList." + i + ".ErrorMsgBody", error[4]);
        }
    }

    public boolean setupProgress() {
        String taskId = this.req.getParameter("taskId");
        String userContext = this.req.getParameter("User.context");
        this.serversMessage = eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.SourceRing", this.m_context);
        String url = new String("webacc?taskId=" + eMFrameUtils.urlEncode(taskId, this.m_context) + "&merge=fw.MoveSubtreeProgress&User.context=" + userContext + "&nextState=refresh" + "&foundServersCount=" + this.foundServersCount + "&serversMessage=" + this.serversMessage);
        this.m_resultStrings.put("UrlTask.url", url);
        ((I18NServletRequest)this.req).setParameter("merge", "fw.UrlTask");
        this.stopThread = false;
        this.threadDone = false;
        this.thread = new ReportThread();
        this.thread.start();
        return true;
    }

    private boolean refresh() {
        String taskId = this.req.getParameter("taskId");
        String userContext = this.req.getParameter("User.context");
        D.log("refresh state");
        if (this.m_fatalError) {
            String url = new String("webacc?taskId=" + eMFrameUtils.urlEncode(taskId, this.m_context) + "&merge=dev.GenMsg&User.context=" + userContext + "&nextState=error" + "&GeneralMsg.Mode=error");
            this.m_resultStrings.put("UrlTask.url", url);
            ((I18NServletRequest)this.req).setParameter("merge", "fw.UrlTask");
        } else if (!this.threadDone) {
            this.m_resultStrings.put("foundServersCount", new Long(this.foundServersCount).toString());
            this.m_resultStrings.put("serversMessage", this.serversMessage);
        } else {
            ((I18NServletRequest)this.req).setParameter("merge", "fw.MoveSubtreeReport");
            this.updateReportData();
        }
        return true;
    }

    private boolean cancel() {
        D.log("cancel state");
        this.stopThread = true;
        ((I18NServletRequest)this.req).setParameter("merge", "fw.MoveSubtree");
        return true;
    }

    private boolean error() {
        D.log("error state");
        String strTitle = eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.Failure", this.m_context);
        String strBody = eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.MoveFatalDSError", this.m_context);
        D.log(strBody);
        eMFrameUtils.setMessage("error", strTitle, strBody, this.m_context);
        return true;
    }

    private boolean startConnecting() throws SPIException {
        boolean err1 = false;
        boolean err2 = false;
        boolean err3 = false;
        boolean err4 = false;
        boolean err5 = false;
        boolean err6 = false;
        if (!this.stopThread) {
            err1 = this.areServersInReplicaRingUp(this.m_srcObjectOE);
            this.serversMessage = eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.SourceRing", this.m_context);
            this.foundServersCount = this.m_vServers.size();
        }
        if (!this.stopThread) {
            err2 = this.areServersInReplicaRingUp(this.m_srcObjectOE.getParent());
            this.serversMessage = eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.ParentRing", this.m_context);
            this.foundServersCount = this.m_vServers.size();
        }
        if (!this.stopThread) {
            err3 = this.areServersInReplicaRingUp(this.m_destOE);
            this.serversMessage = eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.DestRing", this.m_context);
            this.foundServersCount = this.m_vServers.size();
        }
        if (!this.stopThread) {
            err4 = this.readBacklinkAttr(this.m_srcObjectOE);
            this.serversMessage = eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.SourceBacklink", this.m_context);
            this.foundServersCount = this.m_vServers.size();
        }
        if (!this.stopThread) {
            err5 = this.readBacklinkAttr(this.m_srcObjectOE.getParent());
            this.serversMessage = eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.ParentBacklink", this.m_context);
            this.foundServersCount = this.m_vServers.size();
        }
        if (!this.stopThread) {
            err6 = this.readBacklinkAttr(this.m_destOE);
            this.serversMessage = eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.DestBacklink", this.m_context);
            this.foundServersCount = this.m_vServers.size();
        }
        boolean err = err1 | err2 | err3 | err4 | err5 | err6;
        return err;
    }

    class ReportThread
    extends Thread {
        public ReportThread() {
            this.setPriority(4);
            this.setDaemon(true);
        }

        public void run() {
            try {
                if (MoveSubtreeTask.this.m_serverError = MoveSubtreeTask.this.startConnecting()) {
                    D.log("Servers in the replica ring and back link may not be up and running.");
                }
            }
            catch (SPIException spe) {
                MoveSubtreeTask.this.m_fatalError = true;
                MoveSubtreeTask.this.threadDone = true;
                D.log(spe);
            }
            MoveSubtreeTask.this.threadDone = true;
        }
    }
}

