/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.common.exceptions.UniqueSPIException;
import com.novell.admin.ns.AdminNamespaceFactory;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.AuthBrokerAuthenticator;
import com.novell.emframe.dev.AuthBrokerException;
import com.novell.emframe.dev.AuthBrokerReport;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.ManagementServiceSet;
import com.novell.emframe.dev.config.SystemConfig;
import com.novell.emframe.dev.eMFrameUtils;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class NDSNamespaceAuthenticator
extends AuthBrokerAuthenticator {
    private static Class AdminNamespaceFactoryClass = null;
    private static final int MAX_DN_CHARS = 256;
    private static String NDSNS_PROTOCOLID = "NDSNamespace";

    public static String getTreeNameFromID(String treeAddressID) {
        try {
            String rStr = AdminNamespaceFactory.getNDSTreeNameFromID((String)treeAddressID);
            return rStr;
        }
        catch (SPIException spie) {
            D.log("Unable to determine tree name for " + treeAddressID + " (" + spie.toString() + ")\n", 1);
            return null;
        }
    }

    public static String getConnectedAddressFromID(String treeAddressID) {
        try {
            String rStr = AdminNamespaceFactory.getNDSConnectedAddressFromID((String)treeAddressID);
            return rStr;
        }
        catch (SPIException spie) {
            D.log("Unable to determine connected address for " + treeAddressID + " (" + spie.toString() + ")\n", 1);
            return null;
        }
    }

    public static String getDefaultIPAddress(ObjectEntry nsOE) {
        NDSNamespace ndsns = (NDSNamespace)nsOE.getNamespace();
        try {
            String defIPStr = ndsns.getDefaultIpAddress(nsOE);
            return defIPStr;
        }
        catch (SPIException spie) {
            D.log("Unable to determine connection address for " + nsOE.getFullName() + " (" + spie.toString() + ")\n", 1);
            return null;
        }
    }

    public static boolean init() {
        if (AdminNamespaceFactoryClass == null) {
            AdminNamespaceFactoryClass = AdminNamespaceFactory.class;
        }
        return true;
    }

    public Object login(String name, String password, String accessDomain, ManagementServiceSet manageSS) throws AuthBrokerException {
        if (name.length() > 256) {
            String message = eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.RES_AUTHENTICATE_INVALID_DN", manageSS.getLocale());
            if (message == null) {
                message = "";
            }
            throw new AuthBrokerException(message);
        }
        NDSNamespace ndsns = null;
        try {
            ndsns = (NDSNamespace)AdminNamespaceFactory.createAdminNamespace((int)2);
            SystemConfig sc = new SystemConfig();
            String secureNCPTrees = sc.getSetting("Security.SecureNCP.TreeList", "");
            if (secureNCPTrees.length() > 0) {
                String[] secureNCPTreeListArr = this.parseSecureNCPTreeList(secureNCPTrees);
                AdminNamespaceFactory.initializeSecureNCPTrees((boolean)true, (NDSNamespace)ndsns, (String[])secureNCPTreeListArr);
            }
        }
        catch (SPIException spie) {
            throw new AuthBrokerException((Exception)((Object)spie));
        }
        String nfoundNSVersion = ndsns.getNamespaceVersion();
        String expectedNSVersion = "1.3.6.1";
        if (!expectedNSVersion.equals(nfoundNSVersion)) {
            String message = eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.RES_INVALID_NSVERSION", manageSS.getLocale());
            message = eMFrameUtils.formatMessage(message, new String[]{expectedNSVersion, nfoundNSVersion});
            throw new AuthBrokerException(message);
        }
        int abrep_type = 1;
        Integer abrep_userData = null;
        AuthBrokerException abrep_aeInst = null;
        ObjectEntry abrep_oeTree = null;
        try {
            String forceMaster = (String)manageSS.getAttribute("forceMaster");
            if (forceMaster != null && forceMaster.equalsIgnoreCase("true")) {
                D.log("All eDirectory access being forced to master replicas.", 1);
                ndsns.setAccessConfidence(2);
            }
            try {
                ndsns.authenticate(name, accessDomain, password);
            }
            catch (SPIException spe) {
                if (spe instanceof UniqueSPIException && ((UniqueSPIException)spe).getErrorCode() == -223) {
                    abrep_type = 3;
                    abrep_userData = new Integer(((UniqueSPIException)spe).getErrorCode());
                    String sMsg2 = eMFrameUtils.getLocalizedString("FwResources", "Authenticate.Warn.GraceLogin", manageSS.getLocale());
                    String sMsg = ((UniqueSPIException)spe).getMessage() + "\n\n" + sMsg2;
                    int iErrCode = ((UniqueSPIException)spe).getErrorCode();
                    String sErrCode = String.valueOf(iErrCode);
                    Object[] sArgs = new String[]{sErrCode};
                    String sTitle = eMFrameUtils.getLocalizedString("DevResources", "GeneralMsg.NDSWarning", manageSS.getLocale());
                    sTitle = eMFrameUtils.formatMessage(sTitle, sArgs);
                    abrep_aeInst = new AuthBrokerException(sTitle, sMsg);
                }
                throw spe;
            }
            ObjectEntry[] ioes = ndsns.getInitialObjectEntries();
            if (ioes.length <= 0) {
                String message = eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.RES_AUTHENTICATE_NOTREE", manageSS.getLocale());
                if (message == null) {
                    message = "";
                }
                throw new AuthBrokerException(message);
            }
            abrep_oeTree = ioes[0];
            return new AuthBrokerReport(abrep_type, NDSNS_PROTOCOLID, abrep_oeTree, abrep_userData, abrep_aeInst);
        }
        catch (Exception e) {
            throw new AuthBrokerException(e);
        }
    }

    public void logout(Object in_apiObject) {
        try {
            Object apiObject = in_apiObject instanceof AuthBrokerReport ? ((AuthBrokerReport)in_apiObject).getLoginAPIObject() : in_apiObject;
            ObjectEntry oeTree = (ObjectEntry)apiObject;
            NDSNamespace namespace = (NDSNamespace)oeTree.getNamespace();
            ObjectEntry userOE = namespace.getAuthenticatedIdentity(oeTree);
            if (namespace != null && userOE != null) {
                try {
                    namespace.unAuthenticate(userOE, "");
                    D.log("NDSNamespaceAuthenticator::Logout successful for: " + userOE.getFullName());
                }
                catch (SPIException e) {
                    D.log("Failed UnAuthentication: error=" + e.toString() + ": " + userOE.getFullName(), 1);
                    D.log(e);
                }
            }
        }
        catch (Exception e) {
            D.log(e);
        }
    }

    public static void destroy() {
    }

    private String[] parseSecureNCPTreeList(String inSecureNCPTreeListStr) {
        ArrayList<String> tTreeList = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(inSecureNCPTreeListStr, ", \t\n\r\f");
        while (st.hasMoreTokens()) {
            String secureNCPTreename = st.nextToken();
            tTreeList.add(secureNCPTreename);
        }
        String[] secureNCPTreeArr = new String[tTreeList.size()];
        secureNCPTreeArr = tTreeList.toArray(secureNCPTreeArr);
        return secureNCPTreeArr;
    }
}

