/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.ns.nds.ObjectFlags;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectType;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.eMFrameUtils;
import org.jdom.Element;

public class ObjectEntryNode {
    public static final int ENTRY_LEVEL_NODE = 0;
    public static final int ENTRY_LEVEL_CURRENT = 1;
    public static final int ENTRY_LEVEL_PARENT = 2;
    protected ObjectEntry m_oe;
    protected MContext m_context;
    protected int m_level = 0;

    public ObjectEntryNode(ObjectEntry oe, MContext context) {
        this.m_oe = oe;
        this.m_context = context;
    }

    public ObjectEntry getObjectEntry() {
        return this.m_oe;
    }

    public String getFullName() {
        return this.m_oe.getFullName();
    }

    public String getDN() {
        String dn = null;
        dn = this.m_oe.getObjectType().getName().equals("Top") ? this.m_oe.getName() : this.m_oe.getAdminNamespace().getUnrootedName(this.m_oe);
        return dn;
    }

    public String getName() {
        String name = this.m_oe.getName();
        if (this.m_level == 2) {
            name = "..";
        } else if (this.m_level == 1) {
            name = eMFrameUtils.getLocalizedString("FwResources", "OV.Browser.CurrentLevel", this.m_context.getLocale());
        }
        return name;
    }

    public Element getRecordElement() {
        int count;
        Element element = new Element("object-entry");
        element.setAttribute("display-name", this.getObjectTypeDisplayName(this.m_context));
        element.setAttribute("icon-name", this.getObjectTypeIconName(this.m_context));
        element.setAttribute("is-container", this.isContainer());
        element.setAttribute("is-partition", this.isPartition());
        element.setAttribute("is-alias", this.isAlias());
        element.setAttribute("is-junction", this.isJunctionFile());
        element.setAttribute("object-type", this.getObjectTypeName());
        element.setAttribute("object-dn", this.getDN());
        element.setAttribute("is-current", this.isCurrent());
        element.setAttribute("is-parent", this.isParent());
        if (this.m_oe.getObjectType().isContainer() && this.isParent().equalsIgnoreCase("false") && this.isCurrent().equalsIgnoreCase("false") && (count = this.m_oe.getSubordinateCount()) > 0) {
            element.setAttribute("subordinate-count", new Long(count).toString());
        }
        element.setText(this.getName());
        return element;
    }

    public ObjectType getObjectType() {
        return this.m_oe.getObjectType();
    }

    public String getObjectTypeName() {
        return this.getObjectType().getName();
    }

    public String getObjectTypeDisplayName(MContext context) {
        String oeTypeDisplayName = null;
        oeTypeDisplayName = this.isParent().equalsIgnoreCase("true") ? eMFrameUtils.getLocalizedString("FwResources", "OV.Browser.UpOneLevel.alt", this.m_context.getLocale()) : context.getDirUtils().getObjectTypeDisplayName(this.getObjectTypeName(), context);
        return oeTypeDisplayName;
    }

    public String getObjectTypeIconName(MContext context) {
        String oeIconName = null;
        oeIconName = this.isParent().equalsIgnoreCase("true") ? "uplevel.gif" : context.getDirUtils().getObjectEntryImageName(this.m_oe);
        return oeIconName;
    }

    public String isContainer() {
        String isContainer = "false";
        if (this.m_oe.getObjectType().isContainer()) {
            isContainer = "true";
        }
        return isContainer;
    }

    public String isPartition() {
        String isPartition = "false";
        if (ObjectFlags.isPartition((long)this.m_oe.getObjectFlags())) {
            isPartition = "true";
        }
        return isPartition;
    }

    public String isAlias() {
        String isAlias = "false";
        if (ObjectFlags.isAlias((long)this.m_oe.getObjectFlags())) {
            isAlias = "true";
        }
        return isAlias;
    }

    public String isJunctionFile() {
        String isJunctionFile = "false";
        if (ObjectFlags.isJunctionFile((long)this.m_oe.getObjectFlags())) {
            isJunctionFile = "true";
        }
        return isJunctionFile;
    }

    public Element getBreadCrumbElement() {
        Element element = new Element("bread-crumb");
        element.setAttribute("display-name", this.getName());
        if (this.m_oe.getObjectType().getName().equals("Top")) {
            element.setAttribute("object-dn", "");
        } else {
            element.setAttribute("object-dn", this.getDN());
        }
        return element;
    }

    public void setLevel(int level) {
        this.m_level = level;
    }

    public int getLevel() {
        return this.m_level;
    }

    public String isParent() {
        String isParent = "false";
        int level = this.getLevel();
        if ((level &= 2) == 2) {
            isParent = "true";
        }
        return isParent;
    }

    public String isCurrent() {
        String isCurrent = "false";
        int level = this.getLevel();
        if ((level &= 1) == 1) {
            isCurrent = "true";
        }
        return isCurrent;
    }
}

