/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.FilterResultModifier;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.admin.ns.nds.ObjectFlags;
import com.novell.application.console.snapin.BrowserObjectEntryEnumeration;
import com.novell.application.console.snapin.DefaultIndexedObjectEntryEnumeration;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectEntryEnumeration;
import com.novell.application.console.snapin.ObjectType;
import com.novell.application.console.snapin.ResultModifier;
import com.novell.application.console.snapin.ResultModifierFilterEntry;
import com.novell.application.console.snapin.SnapinException;
import com.novell.emframe.dev.AuthBrokerException;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.Anchor;
import com.novell.emframe.fw.FwDirUtils;
import com.novell.emframe.fw.ObjectSelectorFinish;
import com.novell.emframe.fw.SearchObjectContext;
import com.novell.emframe.fw.authenticator.DirAuthenticator;
import com.novell.webaccess.common.I18NServletRequest;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;

public class ObjectSelector
extends Task {
    private static final long serialVersionUID = 1L;
    public static final String SEARCH_CMD_CONTEXTID = "Search.ContextId";
    public static final String SEARCH_CMD_MOVEMENT = "Movement";
    public static final String SEARCH_CMD_PARENTCONTAINER = "Search.ParentContainer";
    public static final String SEARCH_CMD_PSEUDOOBJECTS = "Search.PseudoObjects";
    public static final String SEARCH_CMD_SHOWRESULTSET = "Search.ShowResultSet";
    public static final String SEARCH_CMD_TOKEN_PARAM = "SearchToken";
    public static final String SEARCH_CMD_TREENAME = "Search.TreeName";
    public static final String SEARCH_MOVEMENT_NEXT = "Next";
    public static final String SEARCH_MOVEMENT_PREV = "Prev";
    public static final String SEARCH_TOKEN_INIT = "SearchTokenInit";
    public static final String SEARCH_TOKEN_POST = "SearchTokenPost";
    public static final String SEARCH_TOKEN_UPDATE = "SearchTokenUpdate";
    public static final String SEARCH_TOKEN_SELECT_ALL = "SearchTokenSelectAll";
    public static final String SEARCH_TOKEN_RESTART = "SearchTokenRestart";
    private static final int DEFAULT_ENTRIES_PER_PAGECOUNT = 14;
    private static final int MAX_ENTRIES_PER_PAGECOUNT = 500;
    private String m_strContainer;
    private boolean m_bCurrentContextSelectable;
    private boolean m_bMovementNext;
    private boolean m_bMovementPrev;
    private String m_strNameFilter;
    private String[] m_arStrTypeFilter;
    private String m_strTypeFilter;
    private HashSet m_hsTypeFilter;
    private HashSet m_hsAuxTypeFilterEntries;
    private Hashtable m_hAdvSelCriterion;
    private boolean m_bSearchOnStartup;
    private boolean m_bSearchSubContainers;
    private boolean m_bShowAuxClasses;
    private boolean m_bShowSubClasses;
    private boolean m_bShowGlue;
    private boolean m_bRootSelectable;
    private boolean m_bThisSelectable;
    private boolean m_bPublicSelectable;
    private boolean m_bBrowseMode;
    private boolean m_bExcludeMode;
    private boolean m_bMatchAllTypes;
    private boolean m_bMatchAllContainers;
    private boolean m_bMatchLeafObjects;
    private boolean m_bMatchNonPartitionedContainers;
    private boolean m_bMatchAllPartitions;
    private boolean m_bMultiSelect;
    private boolean m_bAdvancedSelection;
    private int m_iMaxEntriesPerPage;
    private int m_iNumPseudoObjects;
    private String m_strContextId;
    private String m_strCmdToken;
    private TaskContext m_taskContext;
    private Properties m_resultStrings;
    private HttpServletRequest m_req;
    private AdminNamespace m_namespace;
    private ObjectEntry m_treeOE;
    private Hashtable m_authContext;
    private StringBuffer m_dbgOSState;
    private StringBuffer m_dbgExecuteInfo;
    private String m_PostError;
    private boolean m_showSubordinateCount;
    private boolean m_bShowFileSystemDirectory;
    private boolean m_bShowFileSystemFile;
    private boolean m_bShowFileSystemNetwareVolume;
    private boolean m_bFileSystemBrowseVolume;
    private boolean m_bShowVolumeObjectForFileSystem;
    static final String[] m_osParms = new String[]{"OS.AnchorDocState", "OS.AdvancedSelection", "OS.AdvSelCriteria", "OS.AdvSelCriteriaCallBack", "OS.AuthName", "OS.CallBack", "OS.Container", "OS.Control", "OS.IconName", "OS.InitialContext", "OS.InitialCriterion", "OS.IsOSAllowed", "OS.Mode", "OS.MultiSelect", "OS.NameFilter", "OS.Results", "OS.ResultsPerPage", "OS.ReturningToAnchor", "OS.SearchSubContainers", "OS.SearchOnStartup", "OS.ShowSubClasses", "OS.TypeFilter", "OS.ShowSubordinateCount"};
    static HashSet m_osParmsSet = new HashSet();
    static boolean bIsDebugEnabled;
    static int uniqueStringCtr;

    public static void saveOSState(HttpServletRequest req, String mode) {
        String tmp = (String)req.getAttribute("SaveTaskURL");
        if (tmp == null || tmp.length() == 0) {
            req.setAttribute("SaveTaskURL", (Object)"true");
        }
    }

    private boolean isOSSpecificParm(String parmName) {
        return m_osParmsSet.contains(parmName.toLowerCase());
    }

    private void dOut(StringBuffer sb, String s) {
        if (bIsDebugEnabled) {
            D.log("OS: " + s);
        }
        sb.append(s).append("\n");
    }

    private String getStackTrace(Throwable t) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(bos);
        t.printStackTrace(pw);
        pw.close();
        return bos.toString();
    }

    private String buildQueryString(HttpServletRequest req) {
        StringBuffer buf = new StringBuffer();
        Enumeration names = req.getParameterNames();
        if (names != null) {
            ArrayList<String> tmp = new ArrayList<String>();
            String name = null;
            String[] values = null;
            while (names.hasMoreElements()) {
                name = (String)names.nextElement();
                if (name == null || name.length() == 0 || (values = req.getParameterValues(name)).length <= 0 || values[0] == null) continue;
                tmp.add(name + "=" + values[0]);
            }
            Collections.sort(tmp);
            boolean first = true;
            String param = null;
            for (int i = 0; i < tmp.size(); ++i) {
                param = (String)tmp.get(i);
                if (param == null || param.length() == 0) continue;
                buf.append("\n    ");
                if (first) {
                    buf.append("?");
                    first = false;
                } else {
                    buf.append("&");
                }
                if (param.startsWith("OS.AnchorDocState")) {
                    buf.append("OS.AnchorDocState=");
                    int len = "OS.AnchorDocState".length();
                    if (param.length() <= len + 1) continue;
                    param = param.substring(len + 1);
                    buf.append(this.formatAnchorDocState(param));
                    buf.append("\n       Unformatted:  ");
                    buf.append(param);
                    continue;
                }
                buf.append(param);
            }
        }
        return buf.toString();
    }

    private String[] split(String s, String ch) {
        ArrayList<String> a = new ArrayList<String>();
        int begin = 0;
        int end = 0;
        while (begin < s.length() && (end = s.indexOf(ch, begin)) != -1) {
            a.add(s.substring(begin, end));
            begin = end + 1;
        }
        if (begin < s.length()) {
            a.add(s.substring(begin));
        }
        return a.toArray(new String[a.size()]);
    }

    private String formatAnchorDocState(String param) {
        if (param == null || param.length() == 0) {
            return "";
        }
        StringBuffer docState = new StringBuffer();
        String[] p = this.split(param, "$");
        for (int i = 0; i < p.length; ++i) {
            docState.append("\n       $");
            docState.append("<" + p[i] + ">");
        }
        return docState.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(TaskContext context, Properties resultStrings) {
        boolean bPostSuccess;
        boolean bRet;
        block37: {
            block36: {
                block35: {
                    block34: {
                        boolean bl;
                        D.log("--->>> ObjectSelector: entering execute....");
                        this.m_dbgExecuteInfo = new StringBuffer(1024);
                        bRet = false;
                        bPostSuccess = false;
                        try {
                            if (context != null && resultStrings != null) break block34;
                            this.dOut(this.m_dbgExecuteInfo, "ERROR!  No TaskContext or Properties object found (context or resultString == null).");
                            bl = bRet;
                            Object var10_8 = null;
                            this.dOut(this.m_dbgExecuteInfo, "Cache size on exit = " + this.m_authContext.size());
                        }
                        catch (Throwable throwable) {
                            Object var10_13 = null;
                            this.dOut(this.m_dbgExecuteInfo, "Cache size on exit = " + this.m_authContext.size());
                            D.log("<<<--- ObjectSelector: exiting execute.  returning " + bRet);
                            if (!bRet) {
                                String errMsgTitle = null;
                                String errMsgDesc = null;
                                if (!bPostSuccess) {
                                    errMsgTitle = eMFrameUtils.getLocalizedString("FwResources", "OS.DirectorySearchErrorTitle", context);
                                    errMsgDesc = this.m_PostError;
                                } else {
                                    errMsgTitle = eMFrameUtils.getLocalizedString("FwResources", "OS.InternalErrorTitle", context);
                                    errMsgDesc = eMFrameUtils.getLocalizedString("FwResources", "OS.InternalErrorDesc", context);
                                }
                                this.m_resultStrings.setProperty("GeneralMsg.suppressButtons", "true");
                                eMFrameUtils.setMessage("error", errMsgTitle, errMsgDesc, null, eMFrameUtils.toDisplay("Object Selector state:\n\n" + this.m_dbgOSState + "\n\nObject Selector debug trace:\n\n" + this.m_dbgExecuteInfo), context);
                            }
                            this.m_resultStrings = null;
                            this.m_taskContext = null;
                            throw throwable;
                        }
                        D.log("<<<--- ObjectSelector: exiting execute.  returning " + bRet);
                        if (!bRet) {
                            String errMsgTitle = null;
                            String errMsgDesc = null;
                            if (!bPostSuccess) {
                                errMsgTitle = eMFrameUtils.getLocalizedString("FwResources", "OS.DirectorySearchErrorTitle", context);
                                errMsgDesc = this.m_PostError;
                            } else {
                                errMsgTitle = eMFrameUtils.getLocalizedString("FwResources", "OS.InternalErrorTitle", context);
                                errMsgDesc = eMFrameUtils.getLocalizedString("FwResources", "OS.InternalErrorDesc", context);
                            }
                            this.m_resultStrings.setProperty("GeneralMsg.suppressButtons", "true");
                            eMFrameUtils.setMessage("error", errMsgTitle, errMsgDesc, null, eMFrameUtils.toDisplay("Object Selector state:\n\n" + this.m_dbgOSState + "\n\nObject Selector debug trace:\n\n" + this.m_dbgExecuteInfo), context);
                        }
                        this.m_resultStrings = null;
                        this.m_taskContext = null;
                        return bl;
                    }
                    this.m_resultStrings = resultStrings;
                    this.m_taskContext = context;
                    this.m_authContext = this.m_taskContext.getAuthenticator().getAuthContext();
                    if (this.m_authContext != null) break block35;
                    this.dOut(this.m_dbgExecuteInfo, "ERROR!  No session cache could be found (m_sessionCache==null).");
                    boolean bl = false;
                    Object var10_9 = null;
                    this.dOut(this.m_dbgExecuteInfo, "Cache size on exit = " + this.m_authContext.size());
                    D.log("<<<--- ObjectSelector: exiting execute.  returning " + bRet);
                    if (!bRet) {
                        String errMsgTitle = null;
                        String errMsgDesc = null;
                        if (!bPostSuccess) {
                            errMsgTitle = eMFrameUtils.getLocalizedString("FwResources", "OS.DirectorySearchErrorTitle", context);
                            errMsgDesc = this.m_PostError;
                        } else {
                            errMsgTitle = eMFrameUtils.getLocalizedString("FwResources", "OS.InternalErrorTitle", context);
                            errMsgDesc = eMFrameUtils.getLocalizedString("FwResources", "OS.InternalErrorDesc", context);
                        }
                        this.m_resultStrings.setProperty("GeneralMsg.suppressButtons", "true");
                        eMFrameUtils.setMessage("error", errMsgTitle, errMsgDesc, null, eMFrameUtils.toDisplay("Object Selector state:\n\n" + this.m_dbgOSState + "\n\nObject Selector debug trace:\n\n" + this.m_dbgExecuteInfo), context);
                    }
                    this.m_resultStrings = null;
                    this.m_taskContext = null;
                    return bl;
                }
                String authName = context.getRequest().getParameter("OS.AuthName");
                AuthenticationBroker broker = DirAuthenticator.getDirAuth(context).getAuthenticationBroker(authName);
                try {
                    this.m_treeOE = (ObjectEntry)broker.getProtocolObject("AdminNamespace");
                }
                catch (AuthBrokerException e) {
                    D.log(e);
                }
                this.m_namespace = this.m_treeOE.getAdminNamespace();
                if (this.m_namespace != null) break block36;
                this.dOut(this.m_dbgExecuteInfo, "ERROR!  AdminNamespace not found (m_namespace==null).");
                boolean e = bRet;
                Object var10_10 = null;
                this.dOut(this.m_dbgExecuteInfo, "Cache size on exit = " + this.m_authContext.size());
                D.log("<<<--- ObjectSelector: exiting execute.  returning " + bRet);
                if (!bRet) {
                    String errMsgTitle = null;
                    String errMsgDesc = null;
                    if (!bPostSuccess) {
                        errMsgTitle = eMFrameUtils.getLocalizedString("FwResources", "OS.DirectorySearchErrorTitle", context);
                        errMsgDesc = this.m_PostError;
                    } else {
                        errMsgTitle = eMFrameUtils.getLocalizedString("FwResources", "OS.InternalErrorTitle", context);
                        errMsgDesc = eMFrameUtils.getLocalizedString("FwResources", "OS.InternalErrorDesc", context);
                    }
                    this.m_resultStrings.setProperty("GeneralMsg.suppressButtons", "true");
                    eMFrameUtils.setMessage("error", errMsgTitle, errMsgDesc, null, eMFrameUtils.toDisplay("Object Selector state:\n\n" + this.m_dbgOSState + "\n\nObject Selector debug trace:\n\n" + this.m_dbgExecuteInfo), context);
                }
                this.m_resultStrings = null;
                this.m_taskContext = null;
                return e;
            }
            String treeName = this.m_treeOE.getName();
            if (!this.isStrValid(treeName)) {
                treeName = "[root]";
            }
            this.m_resultStrings.put(SEARCH_CMD_TREENAME, treeName);
            this.m_req = this.m_taskContext.getRequest();
            if (this.m_req != null) break block37;
            this.dOut(this.m_dbgExecuteInfo, "ERROR!  HttpServletRequest not found (m_req==null).");
            boolean bl = bRet;
            Object var10_11 = null;
            this.dOut(this.m_dbgExecuteInfo, "Cache size on exit = " + this.m_authContext.size());
            D.log("<<<--- ObjectSelector: exiting execute.  returning " + bRet);
            if (!bRet) {
                String errMsgTitle = null;
                String errMsgDesc = null;
                if (!bPostSuccess) {
                    errMsgTitle = eMFrameUtils.getLocalizedString("FwResources", "OS.DirectorySearchErrorTitle", context);
                    errMsgDesc = this.m_PostError;
                } else {
                    errMsgTitle = eMFrameUtils.getLocalizedString("FwResources", "OS.InternalErrorTitle", context);
                    errMsgDesc = eMFrameUtils.getLocalizedString("FwResources", "OS.InternalErrorDesc", context);
                }
                this.m_resultStrings.setProperty("GeneralMsg.suppressButtons", "true");
                eMFrameUtils.setMessage("error", errMsgTitle, errMsgDesc, null, eMFrameUtils.toDisplay("Object Selector state:\n\n" + this.m_dbgOSState + "\n\nObject Selector debug trace:\n\n" + this.m_dbgExecuteInfo), context);
            }
            this.m_resultStrings = null;
            this.m_taskContext = null;
            return bl;
        }
        this.m_dbgExecuteInfo.append("OS URL = " + this.m_req.getRequestURI() + this.buildQueryString(this.m_req) + "\n");
        this.dOut(this.m_dbgExecuteInfo, "Cache size on entrance = " + this.m_authContext.size());
        bRet = true;
        this.parseParameters();
        this.saveAnchorInfo();
        this.performInit();
        if (this.m_strCmdToken.compareTo(SEARCH_TOKEN_POST) == 0) {
            this.m_PostError = null;
            bRet = bPostSuccess = this.performPost();
        } else if (this.m_strCmdToken.compareTo(SEARCH_TOKEN_UPDATE) == 0) {
            this.performUpdate();
        } else if (this.m_strCmdToken.compareTo(SEARCH_TOKEN_RESTART) == 0) {
            this.performRestart();
        } else if (this.m_strCmdToken.compareTo(SEARCH_TOKEN_SELECT_ALL) == 0) {
            this.performSelectAll();
            ObjectSelectorFinish finishTask = new ObjectSelectorFinish();
            bRet = finishTask.execute(this.m_taskContext, this.m_resultStrings);
        }
        boolean bl = bRet;
        Object var10_12 = null;
        this.dOut(this.m_dbgExecuteInfo, "Cache size on exit = " + this.m_authContext.size());
        D.log("<<<--- ObjectSelector: exiting execute.  returning " + bRet);
        if (!bRet) {
            String errMsgTitle = null;
            String errMsgDesc = null;
            if (!bPostSuccess) {
                errMsgTitle = eMFrameUtils.getLocalizedString("FwResources", "OS.DirectorySearchErrorTitle", context);
                errMsgDesc = this.m_PostError;
            } else {
                errMsgTitle = eMFrameUtils.getLocalizedString("FwResources", "OS.InternalErrorTitle", context);
                errMsgDesc = eMFrameUtils.getLocalizedString("FwResources", "OS.InternalErrorDesc", context);
            }
            this.m_resultStrings.setProperty("GeneralMsg.suppressButtons", "true");
            eMFrameUtils.setMessage("error", errMsgTitle, errMsgDesc, null, eMFrameUtils.toDisplay("Object Selector state:\n\n" + this.m_dbgOSState + "\n\nObject Selector debug trace:\n\n" + this.m_dbgExecuteInfo), context);
        }
        this.m_resultStrings = null;
        this.m_taskContext = null;
        return bl;
    }

    private Anchor createAnchor() {
        this.dOut(this.m_dbgExecuteInfo, "A new OS Anchor page has been encountered (ie, it has a os button on it.)");
        this.m_authContext.remove("OS.Anchor");
        String uri = (String)this.m_authContext.get("LastTaskURI");
        Hashtable queryParms = (Hashtable)this.m_authContext.get("LastTaskParams");
        if (queryParms == null) {
            queryParms = new Hashtable();
        }
        Enumeration e = queryParms.keys();
        while (e.hasMoreElements()) {
            String p = (String)e.nextElement();
            if (!this.isOSSpecificParm(p)) continue;
            queryParms.remove(p);
        }
        Anchor osAnchor = new Anchor("OS.Anchor", uri, queryParms);
        this.m_authContext.put("OS.Anchor", osAnchor);
        if (D.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer(1024);
            buf.append("    ").append(uri);
            Enumeration pe = queryParms.keys();
            int i = 0;
            while (pe.hasMoreElements()) {
                String k = (String)pe.nextElement();
                String v = (String)queryParms.get(k);
                buf.append("\n").append("    ").append(i == 0 ? "?" : "&").append(k).append("=").append(v);
                ++i;
            }
            this.dOut(this.m_dbgExecuteInfo, "New OS Anchor created! Return URL = \n" + buf.toString());
        }
        return osAnchor;
    }

    private void saveAnchorInfo() {
        boolean bAnchorCreated = false;
        Anchor osAnchor = (Anchor)this.m_authContext.get("OS.Anchor");
        if (osAnchor == null) {
            osAnchor = this.createAnchor();
            bAnchorCreated = true;
        } else if (this.m_strCmdToken.compareTo(SEARCH_TOKEN_INIT) == 0) {
            this.dOut(this.m_dbgExecuteInfo, "OSAnchor, unintializing aux info (only url info remains)!");
            osAnchor.setInitialized(false);
        }
        if (!osAnchor.isInitialized()) {
            String osControl = this.m_req.getParameter("OS.Control");
            this.dOut(this.m_dbgExecuteInfo, "OSAnchor, osControl = " + osControl);
            osAnchor.setActionControl(osControl);
            String osCallBack = this.m_req.getParameter("OS.CallBack");
            this.dOut(this.m_dbgExecuteInfo, "OSAnchor, osCallBack = " + osCallBack);
            osAnchor.setCallBack(osCallBack);
            String osDocState = this.m_req.getParameter("OS.AnchorDocState");
            if (osDocState != null) {
                this.dOut(this.m_dbgExecuteInfo, "OSAnchor, osDocState = " + osDocState);
                osAnchor.setDocState(osDocState);
            } else {
                this.dOut(this.m_dbgExecuteInfo, "OSAnchor, no osDocState param ... assuming no state info to save.");
                osAnchor.setDocState("");
            }
            String osCustomProcessing = this.m_req.getParameter("OS.CustomProcessing");
            if (osCustomProcessing != null) {
                osCustomProcessing = osCustomProcessing.toLowerCase();
                this.dOut(this.m_dbgExecuteInfo, "OSAnchor, osCustomProcessing = " + osCustomProcessing);
                osAnchor.setCustomProcessing(osCustomProcessing);
            } else {
                this.dOut(this.m_dbgExecuteInfo, "OSAnchor, no CustomProcessing param ... assuming false.");
                osAnchor.setCustomProcessing("false");
            }
            String osUrlUniqueId = this.m_req.getParameter("OS.URLUniqueId");
            if (osUrlUniqueId != null) {
                this.dOut(this.m_dbgExecuteInfo, "OSAnchor, osUrlUniqueId = " + osUrlUniqueId);
            }
            osAnchor.setInitialized(true);
            if (bAnchorCreated) {
                this.dOut(this.m_dbgExecuteInfo, "OSAnchor is fully initialized");
            } else {
                this.dOut(this.m_dbgExecuteInfo, "OSAnchor has been reinitialized");
            }
        } else {
            this.dOut(this.m_dbgExecuteInfo, "OSAnchor already initialized.");
        }
    }

    private boolean isStrValid(String s) {
        return s != null && s.length() > 0;
    }

    private void parseParameters() {
        String strTemp = null;
        this.m_strCmdToken = null;
        this.m_bMovementNext = false;
        this.m_bMovementPrev = false;
        this.m_strContextId = null;
        this.m_bMultiSelect = false;
        this.m_iMaxEntriesPerPage = 14;
        this.m_strContextId = this.m_req.getParameter(SEARCH_CMD_CONTEXTID);
        if (!this.isStrValid(this.m_strContextId)) {
            this.m_strContextId = "";
        }
        this.dOut(this.m_dbgExecuteInfo, "Search.ContextId=" + this.m_strContextId);
        this.m_strCmdToken = this.m_req.getParameter(SEARCH_CMD_TOKEN_PARAM);
        if (!this.isStrValid(this.m_strCmdToken)) {
            this.m_strCmdToken = SEARCH_TOKEN_INIT;
        }
        this.dOut(this.m_dbgExecuteInfo, "SearchCmdToken = " + this.m_strCmdToken);
        strTemp = this.m_req.getParameter(SEARCH_CMD_MOVEMENT);
        if (this.isStrValid(strTemp)) {
            if (strTemp.compareTo(SEARCH_MOVEMENT_NEXT) == 0) {
                this.m_bMovementNext = true;
                this.m_bMovementPrev = false;
                this.dOut(this.m_dbgExecuteInfo, "Move NEXT command");
            } else if (strTemp.compareTo(SEARCH_MOVEMENT_PREV) == 0) {
                this.m_bMovementPrev = true;
                this.m_bMovementNext = false;
                this.dOut(this.m_dbgExecuteInfo, "Move PREV command");
            }
        }
        if (this.isStrValid(strTemp = this.m_req.getParameter("OS.MultiSelect")) && strTemp.equalsIgnoreCase("true")) {
            this.m_bMultiSelect = true;
            this.dOut(this.m_dbgExecuteInfo, "OS.Multiselect = true");
        } else if (this.isStrValid(strTemp) && strTemp.equalsIgnoreCase("false")) {
            this.m_bMultiSelect = false;
            this.dOut(this.m_dbgExecuteInfo, "OS.Multiselect = false");
        } else {
            this.m_bMultiSelect = false;
            this.dOut(this.m_dbgExecuteInfo, "OS.Multiselect = defaulting to false");
        }
        strTemp = this.m_req.getParameter("OS.ResultsPerPage");
        if (!this.isStrValid(strTemp)) {
            strTemp = this.m_taskContext.getPersistentData("OSPrefs", "OS." + (this.m_bMultiSelect ? "MS" : "SS") + "ResultsPerPage");
        }
        if (this.isStrValid(strTemp)) {
            try {
                this.m_iMaxEntriesPerPage = Integer.parseInt(strTemp);
            }
            catch (Exception e) {
                this.dOut(this.m_dbgExecuteInfo, "Can't parse OS.ResultsPerPage = <" + strTemp + ">");
                this.dOut(this.m_dbgExecuteInfo, this.getStackTrace(e));
                strTemp = "";
            }
            if (this.m_iMaxEntriesPerPage < 1) {
                this.m_iMaxEntriesPerPage = 1;
                strTemp = "1";
                this.dOut(this.m_dbgExecuteInfo, "OS.ResultsPerPage can't be < 1");
            } else if (this.m_iMaxEntriesPerPage > 500) {
                this.m_iMaxEntriesPerPage = 500;
                strTemp = "500";
                this.dOut(this.m_dbgExecuteInfo, "OS.ResultsPerPage can't be > 500");
            }
        } else {
            strTemp = "";
        }
        this.m_resultStrings.put("OS.ResultsPerPage", strTemp);
        this.dOut(this.m_dbgExecuteInfo, "OS.ResultsPerPage = <" + strTemp + ">");
        if (!this.m_strCmdToken.equalsIgnoreCase(SEARCH_TOKEN_UPDATE)) {
            int i;
            this.m_strContainer = null;
            this.m_bCurrentContextSelectable = false;
            this.m_strNameFilter = null;
            this.m_arStrTypeFilter = null;
            this.m_strTypeFilter = null;
            this.m_hsTypeFilter = new HashSet();
            this.m_hsAuxTypeFilterEntries = new HashSet();
            this.m_hAdvSelCriterion = new Hashtable();
            this.m_bSearchOnStartup = false;
            this.m_bSearchSubContainers = true;
            this.m_bShowAuxClasses = false;
            this.m_bShowSubClasses = true;
            this.m_bShowGlue = false;
            this.m_bRootSelectable = false;
            this.m_bThisSelectable = false;
            this.m_bPublicSelectable = false;
            this.m_bBrowseMode = true;
            this.m_bExcludeMode = false;
            this.m_bMatchAllTypes = false;
            this.m_bMatchAllContainers = false;
            this.m_bMatchLeafObjects = false;
            this.m_bMatchNonPartitionedContainers = false;
            this.m_bMatchAllPartitions = false;
            this.m_bAdvancedSelection = false;
            this.m_dbgOSState = new StringBuffer(1024);
            this.m_showSubordinateCount = true;
            this.m_bShowFileSystemDirectory = false;
            this.m_bShowFileSystemFile = false;
            this.m_bShowFileSystemNetwareVolume = false;
            this.m_bFileSystemBrowseVolume = false;
            this.m_bShowVolumeObjectForFileSystem = true;
            strTemp = this.m_req.getParameter("OS.AdvancedSelection");
            if (this.isStrValid(strTemp) && strTemp.equalsIgnoreCase("true")) {
                this.m_bAdvancedSelection = true;
                this.dOut(this.m_dbgOSState, "OS.AdvancedSelection = true");
            } else if (this.isStrValid(strTemp) && strTemp.equalsIgnoreCase("false")) {
                this.m_bAdvancedSelection = false;
                this.dOut(this.m_dbgOSState, "OS.AdvancedSelection = false");
            } else {
                this.m_bAdvancedSelection = false;
                this.dOut(this.m_dbgOSState, "OS.AdvancedSelection = defaulting to false");
            }
            this.dOut(this.m_dbgOSState, "Determining starting container/context...");
            if (!this.isStrValid(this.m_strCmdToken) || this.m_strCmdToken.equalsIgnoreCase(SEARCH_TOKEN_INIT)) {
                this.dOut(this.m_dbgOSState, "    In Init state...");
                this.m_strContainer = this.m_req.getParameter("OS.InitialContext");
                if (this.isStrValid(this.m_strContainer)) {
                    this.dOut(this.m_dbgOSState, "    Using OS.InitialContext param = " + this.m_strContainer);
                } else {
                    this.dOut(this.m_dbgOSState, "    No OS.InitialContext param.");
                    this.m_strContainer = this.m_taskContext.getPersistentData("OSPrefs", "OS.AlwaysContext");
                    if (this.isStrValid(this.m_strContainer)) {
                        this.dOut(this.m_dbgOSState, "    Using OS.AlwaysContext param = " + this.m_strContainer);
                    } else {
                        this.dOut(this.m_dbgOSState, "    No OS.AlwaysContext pref.");
                        this.m_strContainer = (String)this.m_taskContext.getAuthAttribute("OS.LastContainer");
                        if (this.isStrValid(this.m_strContainer)) {
                            this.dOut(this.m_dbgOSState, "    Using cached context = " + this.m_strContainer);
                        } else {
                            this.dOut(this.m_dbgOSState, "    No cached context.");
                            this.m_strContainer = this.m_taskContext.getPersistentData("OSPrefs", "OS.StartingContext");
                            if (this.isStrValid(this.m_strContainer)) {
                                this.dOut(this.m_dbgOSState, "    Using first-time OS.StartingContext pref = " + this.m_strContainer);
                            } else {
                                this.dOut(this.m_dbgOSState, "    No first-time OS.StartingContext preference...");
                            }
                        }
                    }
                }
            } else {
                this.dOut(this.m_dbgOSState, "    In " + this.m_strCmdToken + " state...");
            }
            if (!this.isStrValid(this.m_strContainer)) {
                this.m_strContainer = this.m_req.getParameter("OS.Container");
                if (this.isStrValid(this.m_strContainer)) {
                    this.dOut(this.m_dbgOSState, "    Using OS.Container param = " + this.m_strContainer);
                } else {
                    this.dOut(this.m_dbgOSState, "    No OS.Container param.");
                }
            }
            if (!this.isStrValid(this.m_strContainer) || !this.oeExists(this.m_strContainer)) {
                if (this.m_strContainer == null) {
                    this.dOut(this.m_dbgOSState, "    The name of a valid context was not found; defaulting to [root]");
                    this.m_strContainer = "[root]";
                } else if (this.m_strContainer.equals("root")) {
                    this.m_strContainer = "[root]";
                }
            }
            if (!this.isStrValid(strTemp = this.m_req.getParameter("OS.Mode"))) {
                strTemp = this.m_taskContext.getPersistentData("OSPrefs", "OS.StartupMode");
            }
            if (this.isStrValid(strTemp) && strTemp.equalsIgnoreCase("Search")) {
                this.m_bBrowseMode = false;
                this.dOut(this.m_dbgOSState, "OS.Mode = Search");
            } else {
                this.m_bBrowseMode = true;
                this.dOut(this.m_dbgOSState, "OS.Mode = Browse");
            }
            this.m_strNameFilter = this.m_req.getParameter("OS.NameFilter");
            if (!this.isStrValid(this.m_strNameFilter)) {
                this.m_strNameFilter = "*";
            }
            this.dOut(this.m_dbgOSState, "OS.NameFilter = " + this.m_strNameFilter);
            this.m_strTypeFilter = this.m_req.getParameter("OS.TypeFilter");
            int numCrit = this.readAdvancedTypeFilters();
            if (!this.isStrValid(this.m_strTypeFilter) && numCrit == 0) {
                this.m_strTypeFilter = "*";
                this.dOut(this.m_dbgOSState, "No typeFilter found.  Defaulting to '" + this.m_strTypeFilter + "'");
            }
            ArrayList tf = this.splitTypeFilter(this.m_strTypeFilter, this.m_hAdvSelCriterion);
            tf = this.simplifySpecialOptions(tf);
            if (this.m_bExcludeMode) {
                tf = this.doExcludeProcessing(tf);
            }
            if (this.m_strCmdToken.compareTo(SEARCH_TOKEN_INIT) == 0) {
                this.outputTypesInfoToPropertyObject(tf, this.m_hAdvSelCriterion);
            }
            String tp = null;
            for (i = 0; i < tf.size(); ++i) {
                tp = (String)tf.get(i);
                if (!this.isStrValid(tp) || tp.equalsIgnoreCase("*")) continue;
                this.m_hsTypeFilter.add(tp);
                if (!this.m_taskContext.getDirUtils().isAuxClass(tp)) continue;
                this.m_hsAuxTypeFilterEntries.add(tp);
            }
            for (i = 0; i < tf.size(); ++i) {
                String type = (String)tf.get(i);
                if (type.equalsIgnoreCase("Directory")) {
                    this.m_bShowFileSystemDirectory = true;
                    continue;
                }
                if (type.equalsIgnoreCase("File")) {
                    this.m_bShowFileSystemFile = true;
                    continue;
                }
                if (type.equalsIgnoreCase("Netware Volume")) {
                    this.m_bShowFileSystemNetwareVolume = true;
                    continue;
                }
                if (!type.equalsIgnoreCase("Volume")) continue;
                this.m_bShowVolumeObjectForFileSystem = false;
            }
            if (this.m_bShowFileSystemDirectory || this.m_bShowFileSystemFile || this.m_bShowFileSystemNetwareVolume) {
                this.m_bFileSystemBrowseVolume = true;
                this.m_resultStrings.put("OS.Simple.Browsing.Only", "true");
                this.m_bBrowseMode = true;
            } else {
                this.m_resultStrings.put("OS.Simple.Browsing.Only", "false");
            }
            if (this.m_bShowVolumeObjectForFileSystem && (this.m_bShowFileSystemDirectory || this.m_bShowFileSystemFile || this.m_bShowFileSystemNetwareVolume)) {
                tf.add("Volume");
            }
            if (!this.m_bFileSystemBrowseVolume) {
                this.m_taskContext.setAuthAttribute("OS.LastContainer", this.m_strContainer);
                this.dOut(this.m_dbgOSState, "Starting container = " + this.m_strContainer + "; cached it!");
            }
            this.m_arStrTypeFilter = new String[tf.size()];
            tf.toArray(this.m_arStrTypeFilter);
            if (!this.m_hsAuxTypeFilterEntries.isEmpty()) {
                this.m_bShowAuxClasses = true;
            }
            this.dOut(this.m_dbgOSState, "OS.TypeFilter = " + this.m_strTypeFilter);
            this.dOut(this.m_dbgOSState, "m_bMatchAllTypes = " + this.m_bMatchAllTypes);
            this.dOut(this.m_dbgOSState, "m_bMatchAllContainers = " + this.m_bMatchAllContainers);
            this.dOut(this.m_dbgOSState, "m_bMatchLeafObjects = " + this.m_bMatchLeafObjects);
            this.dOut(this.m_dbgOSState, "m_bMatchNonPartitionedContainers = " + this.m_bMatchNonPartitionedContainers);
            this.dOut(this.m_dbgOSState, "m_bMatchAllPartitions = " + this.m_bMatchAllPartitions);
            this.dOut(this.m_dbgOSState, "m_bShowGlue = " + this.m_bShowGlue);
            strTemp = this.m_req.getParameter("OS.SearchSubContainers");
            if (this.isStrValid(strTemp) && strTemp.equalsIgnoreCase("false")) {
                this.m_bSearchSubContainers = false;
            }
            this.dOut(this.m_dbgOSState, "OS.SearchSubContainers = " + this.m_bSearchSubContainers);
            strTemp = this.m_req.getParameter("OS.ShowSubClasses");
            if (this.isStrValid(strTemp) && strTemp.equalsIgnoreCase("false")) {
                this.m_bShowSubClasses = false;
            }
            this.dOut(this.m_dbgOSState, "OS.ShowSubClasses = " + this.m_bShowSubClasses);
            strTemp = this.m_req.getParameter("OS.SearchOnStartup");
            if (!this.isStrValid(strTemp)) {
                strTemp = this.m_taskContext.getPersistentData("OSPrefs", "OS.StartupSearch");
            }
            if (this.isStrValid(strTemp) && strTemp.equalsIgnoreCase("true")) {
                this.m_bSearchOnStartup = true;
                this.dOut(this.m_dbgOSState, "OS.SearchOnStartup = true");
            } else if (this.isStrValid(strTemp) && strTemp.equalsIgnoreCase("false")) {
                this.m_bSearchOnStartup = false;
                this.dOut(this.m_dbgOSState, "OS.SearchOnStartup = false");
            } else {
                this.m_bSearchOnStartup = false;
                this.dOut(this.m_dbgOSState, "OS.SearchOnStartup = defaulting to false");
            }
            strTemp = this.m_req.getParameter("OS.ShowSubordinateCount");
            if (!this.isStrValid(strTemp)) {
                strTemp = this.m_taskContext.getPersistentData("OSPrefs", "OS.ShowSubordinateCount");
            }
            if (!this.isStrValid(strTemp) || strTemp.equalsIgnoreCase("true")) {
                this.m_showSubordinateCount = true;
                this.dOut(this.m_dbgOSState, "OS: OS.SearchOnStartup = true");
            } else if (this.isStrValid(strTemp) && strTemp.equalsIgnoreCase("false")) {
                this.m_showSubordinateCount = false;
                this.dOut(this.m_dbgOSState, "OS: OS.ShowSubordinateCount = false");
            } else {
                this.m_showSubordinateCount = true;
                this.dOut(this.m_dbgOSState, "OS: OS.ShowSubordinateCount = defaulting to true");
            }
        }
    }

    private boolean oeExists(String containerName) {
        try {
            return this.m_namespace.doesExist(this.m_treeOE, containerName);
        }
        catch (SPIException e) {
            return false;
        }
    }

    private int readAdvancedTypeFilters() {
        String strTemp = this.m_req.getParameter("OS.TypeFilter.cnt");
        int numCrit = 0;
        if (this.isStrValid(strTemp)) {
            try {
                numCrit = Integer.parseInt(strTemp);
            }
            catch (Exception e) {
                this.dOut(this.m_dbgOSState, "Can't parse OS.TypeFilter.cnt = <" + strTemp + ">");
                this.dOut(this.m_dbgOSState, this.getStackTrace(e));
            }
        }
        if (numCrit > 0) {
            String name = null;
            String crit = null;
            for (int i = 0; i < numCrit; ++i) {
                name = this.m_req.getParameter("OS.TypeFilter." + i + ".name");
                crit = this.m_req.getParameter("OS.TypeFilter." + i + ".crit");
                if (!this.isStrValid(name) || !this.isStrValid(crit)) continue;
                this.m_hAdvSelCriterion.put(name, crit);
                this.m_hsTypeFilter.add(name);
                if (this.m_taskContext.getDirUtils().isAuxClass(name)) {
                    this.m_hsAuxTypeFilterEntries.add(name);
                }
                this.dOut(this.m_dbgOSState, "Advanced selection for type[" + i + "] = " + name + "  crit=" + crit);
            }
        }
        return numCrit;
    }

    private ArrayList simplifySpecialOptions(ArrayList tf) {
        if (this.m_bMatchAllPartitions && this.m_bMatchNonPartitionedContainers) {
            this.m_bMatchAllContainers = true;
        }
        if (this.m_bMatchAllContainers) {
            this.m_bMatchAllPartitions = false;
            this.m_bMatchNonPartitionedContainers = false;
        }
        if (this.m_bMatchAllTypes || this.m_bMatchLeafObjects && this.m_bMatchAllContainers) {
            tf = new ArrayList<String>();
            tf.add("*");
            this.m_bMatchAllTypes = true;
            this.m_bMatchAllContainers = false;
            this.m_bMatchAllPartitions = false;
            this.m_bMatchLeafObjects = false;
            this.m_bMatchNonPartitionedContainers = false;
        }
        return tf;
    }

    private ArrayList doExcludeProcessing(ArrayList tf) {
        if (this.m_bMatchAllTypes) {
            tf = new ArrayList<String>();
        } else if (tf.size() > 0) {
            String tp = null;
            HashSet<String> hsTmp = new HashSet<String>();
            for (int i = 0; i < tf.size(); ++i) {
                tp = (String)tf.get(i);
                if (!this.isStrValid(tp) || tp.equalsIgnoreCase("*")) continue;
                hsTmp.add(tp);
            }
            String[] saTmp = this.m_taskContext.getDirUtils().getSelectableTypes(hsTmp);
            if (saTmp != null) {
                tf = new ArrayList();
                for (int i = 0; i < saTmp.length; ++i) {
                    tf.add(saTmp[i]);
                }
            }
        }
        return tf;
    }

    private void outputTypesInfoToPropertyObject(ArrayList tf, Hashtable hAdvSelCriterion) {
        Enumeration advSelTypes;
        if (!this.m_bMatchAllTypes && hAdvSelCriterion != null && (advSelTypes = hAdvSelCriterion.keys()) != null) {
            while (advSelTypes.hasMoreElements()) {
                tf.add(advSelTypes.nextElement());
            }
        }
        ArrayList<String> dtf = new ArrayList<String>();
        if (this.m_bMatchAllTypes) {
            dtf.add(eMFrameUtils.getLocalizedString("FwResources", "OS.All", this.m_taskContext));
        } else {
            this.m_taskContext.getDirUtils().createSortedTypeArrays(tf, dtf, this.m_taskContext);
        }
        int cnt = 0;
        String name = null;
        String dname = null;
        String crit = null;
        for (int i = 0; i < tf.size(); ++i) {
            name = (String)tf.get(i);
            if (name == null || name.length() <= 0) continue;
            dname = (String)dtf.get(i);
            crit = (String)this.m_hAdvSelCriterion.get(name);
            this.m_resultStrings.put("OS.TypeFilter." + cnt + ".name", name);
            this.m_resultStrings.put("OS.TypeFilter." + cnt + ".displayname", dname);
            this.m_resultStrings.put("OS.TypeFilter." + cnt + ".crit", crit == null || crit.length() == 0 ? "" : crit);
            ++cnt;
        }
        this.m_resultStrings.put("OS.TypeFilter.cnt", "" + cnt);
        ArrayList<String> pt = new ArrayList<String>();
        ArrayList<String> dpt = new ArrayList<String>();
        if (this.m_bMatchAllContainers) {
            pt.add("[containers]");
            dpt.add(eMFrameUtils.getLocalizedString("FwResources", "OS.AllContainers", this.m_taskContext));
        }
        if (this.m_bMatchLeafObjects) {
            pt.add("[non-containers]");
            dpt.add(eMFrameUtils.getLocalizedString("FwResources", "OS.AllLeafObjects", this.m_taskContext));
        }
        if (this.m_bMatchNonPartitionedContainers) {
            pt.add("[non-partitions]");
            dpt.add(eMFrameUtils.getLocalizedString("FwResources", "OS.NonPartitionedContainers", this.m_taskContext));
        }
        if (this.m_bMatchAllPartitions) {
            pt.add("[partitions]");
            dpt.add(eMFrameUtils.getLocalizedString("FwResources", "OS.AllPartitions", this.m_taskContext));
        }
        if (this.m_bRootSelectable) {
            pt.add("[root]");
            dpt.add(eMFrameUtils.getLocalizedString("FwResources", "OS.Root", this.m_taskContext));
        }
        if (this.m_bThisSelectable) {
            pt.add("[this]");
            dpt.add(eMFrameUtils.getLocalizedString("FwResources", "OS.This", this.m_taskContext));
        }
        if (this.m_bPublicSelectable) {
            pt.add("[public]");
            dpt.add(eMFrameUtils.getLocalizedString("FwResources", "OS.Public", this.m_taskContext));
        }
        if (this.m_bShowGlue) {
            pt.add("[glue]");
            dpt.add(eMFrameUtils.getLocalizedString("FwResources", "OS.ShowGlue", this.m_taskContext));
        }
        eMFrameUtils.sortKeyValues(dpt, pt, this.m_taskContext);
        for (int i = 0; i < pt.size(); ++i) {
            this.m_resultStrings.put("OS.PseudoTypeFilter." + i + ".name", pt.get(i));
            this.m_resultStrings.put("OS.PseudoTypeFilter." + i + ".displayname", dpt.get(i));
        }
        this.m_resultStrings.put("OS.PseudoTypeFilter.cnt", "" + pt.size());
    }

    private void performInit() {
        this.dOut(this.m_dbgExecuteInfo, "   >performInit: Performing INIT...");
        this.m_resultStrings.put(SEARCH_CMD_SHOWRESULTSET, "false");
        if (this.m_strContextId != null) {
            this.m_resultStrings.put(SEARCH_CMD_CONTEXTID, this.m_strContextId);
        }
        if (this.m_bBrowseMode) {
            this.m_resultStrings.put("OS.Mode", "Browse");
        } else {
            this.m_resultStrings.put("OS.Mode", "Search");
        }
        this.m_iNumPseudoObjects = 0;
        StringBuffer pObjs = new StringBuffer("...");
        if (this.m_bRootSelectable) {
            pObjs.setCharAt(0, 'R');
            ++this.m_iNumPseudoObjects;
        }
        if (this.m_bThisSelectable) {
            pObjs.setCharAt(1, 'T');
            ++this.m_iNumPseudoObjects;
        }
        if (this.m_bPublicSelectable) {
            pObjs.setCharAt(2, 'P');
            ++this.m_iNumPseudoObjects;
        }
        String po = pObjs.toString();
        this.m_resultStrings.put(SEARCH_CMD_PSEUDOOBJECTS, po);
        this.dOut(this.m_dbgExecuteInfo, "    performInit: Search.PseudoObjects = <" + po + ">");
        if (this.m_strCmdToken.compareTo(SEARCH_TOKEN_UPDATE) != 0) {
            this.m_resultStrings.put("OS.Container", this.m_strContainer);
            this.m_resultStrings.put("OS.TypeFilter", this.m_strTypeFilter);
            this.m_resultStrings.put("OS.NameFilter", this.m_strNameFilter);
            if (this.m_bSearchSubContainers) {
                this.m_resultStrings.put("OS.SearchSubContainers", "true");
            } else {
                this.m_resultStrings.put("OS.SearchSubContainers", "false");
            }
            if (this.m_bShowSubClasses) {
                this.m_resultStrings.put("OS.ShowSubClasses", "true");
            } else {
                this.m_resultStrings.put("OS.ShowSubClasses", "false");
            }
            if (this.m_bSearchOnStartup) {
                this.m_resultStrings.put("OS.SearchOnStartup", "true");
            } else {
                this.m_resultStrings.put("OS.SearchOnStartup", "false");
            }
            if (this.m_bAdvancedSelection) {
                this.m_resultStrings.put("OS.AdvancedSelection", "true");
            } else {
                this.m_resultStrings.put("OS.AdvancedSelection", "false");
            }
        }
        this.dOut(this.m_dbgExecuteInfo, "   <performInit: Completed INIT...");
    }

    private boolean performPost() {
        ObjectType ot;
        boolean bOptimizedMatchAll;
        int sortMode;
        this.dOut(this.m_dbgExecuteInfo, "   >performPost: Performing POST...");
        boolean bRet = true;
        if (this.m_strContextId != null && this.m_strContextId.length() > 0) {
            this.m_authContext.remove(this.m_strContextId);
            this.dOut(this.m_dbgExecuteInfo, "    performPost: Removed from session cache searchContext = " + this.m_strContextId);
        }
        SearchObjectContext searchContext = new SearchObjectContext(this.m_taskContext, this.m_treeOE, null);
        this.m_strContextId = ObjectSelector.getUniqueString();
        this.m_authContext.put(this.m_strContextId, searchContext);
        this.dOut(this.m_dbgExecuteInfo, "    performPost: Cached Search.ContextId = " + this.m_strContextId);
        this.m_resultStrings.put(SEARCH_CMD_CONTEXTID, this.m_strContextId);
        this.dOut(this.m_dbgExecuteInfo, "    performPost: Put Search.ContextId = " + this.m_strContextId + " in property object.");
        ResultModifier rm = null;
        int n = sortMode = !this.m_bSearchSubContainers && this.m_namespace instanceof NDSNamespace ? 0 : 3;
        if (this.m_bAdvancedSelection) {
            rm = new FilterResultModifier("AdvancedSearchModifier", sortMode, null, this.m_bSearchSubContainers);
            Enumeration types = this.m_hAdvSelCriterion.keys();
            while (types.hasMoreElements()) {
                String typeName = (String)types.nextElement();
                String typeCrit = (String)this.m_hAdvSelCriterion.get(typeName);
                ((FwDirUtils)this.m_taskContext.getDirUtils()).addASXMLFilterInfoToRM((FilterResultModifier)rm, typeName, typeCrit, (MContext)this.m_taskContext);
            }
        } else {
            rm = new ResultModifier("SearchModifier");
            rm.setSortByKey(sortMode);
            rm.setSubContainerSearch(this.m_bSearchSubContainers);
        }
        rm.setIncludeSubClasses(this.m_bShowSubClasses);
        rm.setIncludeAuxClasses(this.m_bShowAuxClasses);
        rm.setShowGlue(this.m_bShowGlue);
        rm.setSimpleAndOpAdvanced(false);
        if (this.m_bShowFileSystemDirectory || this.m_bShowFileSystemFile || this.m_bShowFileSystemNetwareVolume) {
            int allowFileSystemBrowse = 0;
            if (this.m_bFileSystemBrowseVolume) {
                allowFileSystemBrowse |= 1;
            }
            rm.setAllowFileSystemBrowse(allowFileSystemBrowse);
        }
        boolean bl = bOptimizedMatchAll = this.m_bBrowseMode && this.m_bMatchLeafObjects;
        if (bOptimizedMatchAll) {
            this.m_arStrTypeFilter = new String[]{"*"};
            this.dOut(this.m_dbgOSState, "    performPost: Matching leaf objects in browse mode; optimizing type filter to '*'");
        }
        ResultModifierFilterEntry filterEntry = null;
        if (this.isStrValid(this.m_strNameFilter) && this.m_arStrTypeFilter != null && this.m_arStrTypeFilter.length > 0) {
            filterEntry = new ResultModifierFilterEntry(this.m_strNameFilter, this.m_arStrTypeFilter);
            rm.addFilter(filterEntry);
        }
        if (!this.m_bMatchAllTypes && !bOptimizedMatchAll || this.isStrValid(this.m_strNameFilter) && !this.m_strNameFilter.equals("*")) {
            String[] c;
            if (this.m_bBrowseMode || this.m_bMatchAllContainers || this.m_bMatchNonPartitionedContainers || this.m_bMatchAllPartitions) {
                HashSet hsTmp = this.isStrValid(this.m_strNameFilter) && this.m_strNameFilter.equals("*") ? this.m_hsTypeFilter : null;
                String[] c2 = this.m_taskContext.getDirUtils().getSelectableContainerTypes(hsTmp);
                if (c2 != null) {
                    String tmpNameFilter = this.m_bBrowseMode ? "*" : this.m_strNameFilter;
                    filterEntry = new ResultModifierFilterEntry(tmpNameFilter, c2);
                    rm.addFilter(filterEntry);
                }
            }
            if (this.m_bMatchLeafObjects && (c = this.m_taskContext.getDirUtils().getSelectableLeafTypes(this.m_hsTypeFilter)) != null) {
                filterEntry = new ResultModifierFilterEntry(this.m_strNameFilter, c);
                rm.addFilter(filterEntry);
            }
        }
        searchContext.setModifier(rm);
        ObjectEntry oeContainer = null;
        this.dOut(this.m_dbgExecuteInfo, "    performPost: Getting oe for m_strContainer = " + this.m_strContainer);
        if (this.m_strContainer == null || this.m_strContainer.length() == 0 || this.m_strContainer.equalsIgnoreCase("[root]") || this.m_strContainer.equalsIgnoreCase(this.m_treeOE.getName())) {
            oeContainer = this.m_treeOE;
        } else {
            try {
                oeContainer = this.m_namespace.getObjectEntry(this.m_treeOE, this.m_strContainer);
            }
            catch (SPIException e) {
                // empty catch block
            }
        }
        if (!this.m_bShowFileSystemDirectory && !this.m_bShowFileSystemFile && !this.m_bShowFileSystemNetwareVolume && oeContainer != null && (ot = oeContainer.getObjectType()).getName().equalsIgnoreCase("Volume")) {
            rm.setAllowFileSystemBrowse(1);
        }
        if (oeContainer != null) {
            searchContext.setContainer(oeContainer);
            this.dOut(this.m_dbgExecuteInfo, "    performPost: Set search context Container oe = " + oeContainer);
            searchContext.setChildrenEnumeration(null);
            this.dOut(this.m_dbgExecuteInfo, "    performPost: Set result modifier for search = ");
            this.dumpRM(searchContext.getModifier());
        }
        DefaultIndexedObjectEntryEnumeration oeeChildren = new DefaultIndexedObjectEntryEnumeration(null, null);
        if (oeContainer == null) {
            this.m_PostError = eMFrameUtils.getLocalizedString("FwResources", "OS.DirectorySearchErrorDesc", this.m_taskContext) + " '" + this.m_strContainer + "'.";
            bRet = false;
        } else if (this.isValidRM(rm)) {
            try {
                oeeChildren = this.m_namespace.getChildren(oeContainer, rm);
                if (oeeChildren == null) {
                    this.dOut(this.m_dbgExecuteInfo, "    performPost: getChildren() returned null enum");
                } else {
                    this.dOut(this.m_dbgExecuteInfo, "    performPost: getChildren() returned valid enum");
                }
                if (!(oeeChildren instanceof BrowserObjectEntryEnumeration)) {
                    DefaultIndexedObjectEntryEnumeration dioee;
                    this.dOut(this.m_dbgExecuteInfo, "    performPost: oeeChildren is not virtual.  Create an indexed enumeration...");
                    oeeChildren = dioee = new DefaultIndexedObjectEntryEnumeration((ObjectEntryEnumeration)oeeChildren, null);
                }
            }
            catch (SPIException spie) {
                this.m_PostError = spie.getMessage();
                this.dOut(this.m_dbgExecuteInfo, "    performPost: ERROR -- getObjectEntry or getChildren failed, e = " + spie.toString());
                oeeChildren = new DefaultIndexedObjectEntryEnumeration(null, null);
                bRet = false;
            }
        }
        searchContext.setChildrenEnumeration((ObjectEntryEnumeration)oeeChildren);
        this.showSearchResults(searchContext, true);
        this.dOut(this.m_dbgExecuteInfo, "   <performPost: Completed POST...");
        return bRet;
    }

    private void performUpdate() {
        int iMoveNum;
        int i;
        ObjectEntryEnumeration oeeToMove;
        this.dOut(this.m_dbgExecuteInfo, "   >performUpdate: Performing UPDATE...");
        SearchObjectContext searchContext = null;
        if (this.m_strContextId != null && this.m_strContextId.length() != 0) {
            searchContext = (SearchObjectContext)this.m_authContext.get(this.m_strContextId);
        }
        if (searchContext == null) {
            this.dOut(this.m_dbgExecuteInfo, "    performUpdate:  ERROR! searchContext'" + this.m_strContextId + "'not found...");
            return;
        }
        if (this.m_bMovementPrev && (oeeToMove = searchContext.getChildrenEnumeration()) instanceof BrowserObjectEntryEnumeration && (i = this.moveEnumerationLeft((BrowserObjectEntryEnumeration)oeeToMove, iMoveNum = this.m_iMaxEntriesPerPage + searchContext.getLastMovementCount())) == iMoveNum) {
            iMoveNum = this.getNumOverheadLines(searchContext, this.atFirst((BrowserObjectEntryEnumeration)oeeToMove));
            this.moveEnumerationRight((BrowserObjectEntryEnumeration)oeeToMove, iMoveNum);
        }
        this.showSearchResults(searchContext, false);
        this.dOut(this.m_dbgExecuteInfo, "   <performUpdate: Completed UPDATE...");
    }

    private void performSelectAll() {
        ObjectEntryEnumeration oee;
        this.dOut(this.m_dbgExecuteInfo, "   >performUpdate: Performing SELECTALL...");
        String results = "";
        SearchObjectContext searchContext = null;
        if (this.m_strContextId != null && this.m_strContextId.length() != 0) {
            searchContext = (SearchObjectContext)this.m_authContext.get(this.m_strContextId);
        }
        if (searchContext != null && (oee = searchContext.getChildrenEnumeration()) instanceof BrowserObjectEntryEnumeration) {
            BrowserObjectEntryEnumeration boee = (BrowserObjectEntryEnumeration)oee;
            try {
                boee.moveFirst();
            }
            catch (SnapinException se) {
                return;
            }
            StringBuffer buf = new StringBuffer();
            ObjectEntry oe = null;
            String oeName = null;
            try {
                while ((oe = boee.next()) != null) {
                    if (buf.length() > 0) {
                        buf.append(",");
                    }
                    oeName = this.m_namespace.getUnrootedName(oe);
                    buf.append(eMFrameUtils.urlEncode(oeName, this.m_taskContext));
                }
            }
            catch (NoSuchElementException nsee) {
                // empty catch block
            }
            results = buf.toString();
        }
        I18NServletRequest req = (I18NServletRequest)this.m_req;
        req.setAttribute("OS.Results", results);
        this.dOut(this.m_dbgExecuteInfo, "   <performUpdate: Completed SELECTALL...");
    }

    private void performRestart() {
        this.dOut(this.m_dbgExecuteInfo, "   >performRestart: Performing RESTART...");
        if (this.m_strContextId != null && this.m_strContextId.length() != 0) {
            SearchObjectContext searchContext = (SearchObjectContext)this.m_authContext.get(this.m_strContextId);
            if (searchContext != null) {
                this.m_resultStrings.remove(SEARCH_CMD_CONTEXTID);
            }
            this.m_authContext.remove(this.m_strContextId);
            this.dOut(this.m_dbgExecuteInfo, "   performRestart: Removed from session cache searchContext = " + this.m_strContextId);
        }
        this.m_strContextId = null;
        this.dOut(this.m_dbgExecuteInfo, "   <performRestart: Completed RESTART...");
    }

    private void showSearchResults(SearchObjectContext searchContext, boolean bFirstHit) {
        BrowserObjectEntryEnumeration enumr = (BrowserObjectEntryEnumeration)searchContext.getChildrenEnumeration();
        if (enumr == null) {
            this.dOut(this.m_dbgExecuteInfo, "      showSearchResults: No results, myenum = null...");
            this.m_resultStrings.put(SEARCH_CMD_SHOWRESULTSET, "true");
            this.m_resultStrings.put("Search.ResultList.Count", "0");
            this.m_resultStrings.put("Search.PreviousElements", "false");
            this.m_resultStrings.put("Search.NextElements", "false");
        } else {
            ObjectEntry oeThisContainer = searchContext.getContainer();
            this.dOut(this.m_dbgExecuteInfo, "      showSearchResults: Searching from = " + oeThisContainer);
            this.m_bCurrentContextSelectable = false;
            if (oeThisContainer != null) {
                this.m_resultStrings.put("OS.Container.Type", this.m_taskContext.getDirUtils().getObjectEntryImageName(oeThisContainer));
                this.m_bCurrentContextSelectable = this.isContainerSelectable(oeThisContainer);
                this.m_resultStrings.put("OS.Container.Selectable", this.m_bCurrentContextSelectable ? "true" : "false");
            }
            this.m_resultStrings.put(SEARCH_CMD_SHOWRESULTSET, "true");
            boolean bAtFirstBeforeMove = true;
            if (!bFirstHit) {
                bAtFirstBeforeMove = this.atFirst(enumr);
            }
            int iChildrenShown = this.showChildEntries(searchContext, bAtFirstBeforeMove);
            searchContext.setLastMovementCount(iChildrenShown);
            boolean bAtLastAfterMove = this.atLast(enumr);
            this.m_resultStrings.put("Search.PreviousElements", "false");
            this.m_resultStrings.put("Search.NextElements", "false");
            if (!bAtFirstBeforeMove || !bAtLastAfterMove) {
                if (bAtFirstBeforeMove && !bAtLastAfterMove) {
                    this.m_resultStrings.put("Search.NextElements", "true");
                } else if (!bAtFirstBeforeMove && bAtLastAfterMove) {
                    this.m_resultStrings.put("Search.PreviousElements", "true");
                } else if (!bAtFirstBeforeMove && !bAtLastAfterMove) {
                    this.m_resultStrings.put("Search.PreviousElements", "true");
                    this.m_resultStrings.put("Search.NextElements", "true");
                }
            }
        }
        this.dOut(this.m_dbgExecuteInfo, "      showSearchResults: Exiting...");
    }

    private int computeMaxNumToRetrieve(SearchObjectContext searchContext, boolean bAtFirstBeforeMove) {
        int overheadLines = this.getNumOverheadLines(searchContext, bAtFirstBeforeMove);
        return overheadLines < this.m_iMaxEntriesPerPage ? this.m_iMaxEntriesPerPage - overheadLines : 1;
    }

    private int getNumOverheadLines(SearchObjectContext searchContext, boolean bAtFirst) {
        int overheadLines = 0;
        if (this.m_bBrowseMode) {
            boolean bAtRoot;
            boolean bl = bAtRoot = searchContext.getParentContainer() == null;
            if (bAtFirst) {
                if (bAtRoot) {
                    overheadLines = this.m_iNumPseudoObjects;
                } else {
                    overheadLines = 1;
                    if (this.m_bCurrentContextSelectable) {
                        ++overheadLines;
                    }
                    overheadLines += this.m_iNumPseudoObjects;
                    if (this.m_bRootSelectable) {
                        --overheadLines;
                    }
                }
            } else if (!bAtRoot) {
                overheadLines = 1;
                if (this.m_bCurrentContextSelectable) {
                    ++overheadLines;
                }
            }
        } else if (bAtFirst) {
            overheadLines = this.m_iNumPseudoObjects;
        }
        return overheadLines;
    }

    boolean showCurrentContainer(SearchObjectContext searchContext, boolean bAtFirst) {
        boolean ret = false;
        if (this.m_bCurrentContextSelectable && this.m_bBrowseMode) {
            boolean bAtRoot;
            boolean bl = bAtRoot = searchContext.getParentContainer() == null;
            if (bAtFirst) {
                if (!bAtRoot) {
                    ret = true;
                }
            } else if (!bAtRoot) {
                ret = true;
            }
        }
        return ret;
    }

    public int showChildEntries(SearchObjectContext searchContext, boolean bAtFirstBeforeMove) {
        this.dOut(this.m_dbgExecuteInfo, "       showChildEntries: Entering...");
        int iMaxNumToRetrieve = this.computeMaxNumToRetrieve(searchContext, bAtFirstBeforeMove);
        if (this.m_bBrowseMode) {
            this.m_resultStrings.put(SEARCH_CMD_PARENTCONTAINER, searchContext.getParentContainerName());
        }
        int iCountShown = 0;
        int i = 0;
        ObjectEntryEnumeration oee = searchContext.getChildrenEnumeration();
        if (oee == null) {
            this.dOut(this.m_dbgExecuteInfo, "       showChildEntries:  oee is null.");
        } else {
            if (this.showCurrentContainer(searchContext, bAtFirstBeforeMove)) {
                ObjectEntry oe = searchContext.getContainer();
                String name = this.m_namespace.getUnrootedName(oe);
                String currLevel = eMFrameUtils.getLocalizedString("FwResources", "OS.Browser.CurrentLevel", this.m_taskContext);
                String typeDisplayName = this.m_taskContext.getDirUtils().getObjectTypeDisplayName(oe.getTypeName(), this.m_taskContext);
                String typeIconName = this.m_taskContext.getDirUtils().getObjectEntryImageName(oe);
                int subcount = -1;
                if (this.m_showSubordinateCount) {
                    subcount = oe.getSubordinateCount();
                }
                this.outputDisplayInfo(i, name, currLevel, typeDisplayName, typeIconName, ".S....", subcount);
                ++i;
            }
            while (iCountShown < iMaxNumToRetrieve) {
                String oeName = null;
                String oeTypeName = null;
                String oeTypeDisplayName = null;
                String oeIconName = null;
                String oeDisplayName = null;
                ObjectEntry oe = null;
                ObjectType ot = null;
                int subcount = -1;
                try {
                    oe = oee.next();
                    if (oe == null) break;
                    ot = oe.getObjectType();
                    if (ot == null || (oeTypeName = ot.getName()).equalsIgnoreCase("File") && !this.m_bShowFileSystemFile || oeTypeName.equals("Tree Root")) continue;
                    oeName = this.m_namespace.getUnrootedName(oe);
                    oeDisplayName = this.m_bBrowseMode ? oe.getName() : oeName;
                    oeIconName = this.m_taskContext.getDirUtils().getObjectEntryImageName(oe);
                    oeTypeDisplayName = this.m_taskContext.getDirUtils().getObjectTypeDisplayName(oeTypeName, this.m_taskContext);
                    StringBuffer dAttribs = new StringBuffer(".S....");
                    long flags = oe.getObjectFlags();
                    boolean isContainer = ObjectFlags.isContainer((long)flags);
                    boolean isPartition = ObjectFlags.isPartition((long)flags);
                    boolean isAlias = ObjectFlags.isAlias((long)flags);
                    boolean isGlue = ObjectFlags.isGlue((long)flags);
                    boolean isJunction = ObjectFlags.isJunctionFile((long)flags);
                    if (isPartition) {
                        dAttribs.setCharAt(2, 'P');
                    }
                    if (isContainer) {
                        dAttribs.setCharAt(0, 'C');
                        boolean nameMatches = true;
                        if (!this.isStrValid(this.m_strNameFilter)) {
                            this.m_strNameFilter = "*";
                        }
                        if (this.m_bBrowseMode && !this.m_strNameFilter.equals("*") && this.isStrValid(oeName)) {
                            nameMatches = oeName.toLowerCase().matches(eMFrameUtils.replaceWith(this.m_strNameFilter, "*", ".*").toLowerCase());
                        }
                        if (!nameMatches) {
                            dAttribs.setCharAt(1, '.');
                        } else {
                            boolean bSelectable;
                            boolean bl = bSelectable = this.m_bMatchAllTypes || this.m_bMatchAllContainers || isGlue && this.m_bShowGlue || isAlias && this.m_hsTypeFilter.contains("Alias") || this.isContainerSelectable(oe) || this.isDirectorySelectable(oe) || this.isNetwareVolumeSelectable(oe);
                            if (!bSelectable) {
                                if (this.m_bMatchNonPartitionedContainers || this.m_bMatchAllPartitions) {
                                    if (this.m_bMatchNonPartitionedContainers && isPartition || this.m_bMatchAllPartitions && !isPartition) {
                                        dAttribs.setCharAt(1, '.');
                                    }
                                } else {
                                    dAttribs.setCharAt(1, '.');
                                }
                            }
                        }
                    }
                    if (isAlias) {
                        dAttribs.setCharAt(3, 'A');
                    }
                    if (isGlue) {
                        dAttribs.setCharAt(4, 'G');
                    }
                    if (isJunction) {
                        dAttribs.setCharAt(5, 'J');
                    }
                    String da = dAttribs.toString();
                    if (this.m_showSubordinateCount) {
                        subcount = oe.getSubordinateCount();
                    }
                    this.outputDisplayInfo(i, oeName, oeDisplayName, oeTypeDisplayName, oeIconName, da, subcount);
                    ++iCountShown;
                    ++i;
                }
                catch (NoSuchElementException nsee) {
                    break;
                }
            }
        }
        this.m_resultStrings.put("Search.ResultList.Count", Integer.toString(i));
        this.dOut(this.m_dbgExecuteInfo, "       showChildEntries: Exiting.  Displayed " + iCountShown + " of " + this.m_iMaxEntriesPerPage + " entries...");
        return iCountShown;
    }

    private void outputDisplayInfo(int cnt, String oeName, String oeDisplayName, String oeTypeDisplayName, String oeIconName, String oeDisplayAttribs, int subcount) {
        this.m_resultStrings.put("Search.ResultList." + cnt + ".Name", oeName);
        this.m_resultStrings.put("Search.ResultList." + cnt + ".DisplayName", oeDisplayName);
        this.m_resultStrings.put("Search.ResultList." + cnt + ".TypeName", oeTypeDisplayName);
        this.m_resultStrings.put("Search.ResultList." + cnt + ".TypeIcon", oeIconName);
        this.m_resultStrings.put("Search.ResultList." + cnt + ".DisplayAttributes", oeDisplayAttribs);
        String subcountString = "";
        if (subcount > 0) {
            subcountString = "(" + subcount + ")";
        }
        this.m_resultStrings.put("Search.ResultList." + cnt + ".SubordinateCount", subcountString);
    }

    private boolean isDirectorySelectable(ObjectEntry oe) {
        String otName = oe.getObjectType().getName();
        return oe != null && ObjectFlags.isContainer((long)oe.getObjectFlags()) && otName.equalsIgnoreCase("Directory") && this.m_bShowFileSystemDirectory;
    }

    private boolean isNetwareVolumeSelectable(ObjectEntry oe) {
        String otName = oe.getObjectType().getName();
        return oe != null && ObjectFlags.isContainer((long)oe.getObjectFlags()) && otName.equalsIgnoreCase("Netware Volume") && this.m_bShowFileSystemNetwareVolume;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isContainerSelectable(ObjectEntry oe) {
        String crit;
        Iterator i;
        String s;
        if (oe == null || !ObjectFlags.isContainer((long)oe.getObjectFlags())) {
            return false;
        }
        if (this.m_bMatchAllTypes || this.m_bMatchAllContainers) {
            return true;
        }
        boolean bSelectable = false;
        String matchedTypeFilterEntryName = null;
        String typeName = "";
        ObjectType ot = oe.getObjectType();
        typeName = ot.getName();
        if (this.m_hsTypeFilter.contains(typeName)) {
            bSelectable = true;
            matchedTypeFilterEntryName = typeName;
        } else if (this.m_hsTypeFilter.contains("*")) {
            bSelectable = true;
            matchedTypeFilterEntryName = "*";
        }
        if (!bSelectable && this.m_bShowSubClasses) {
            s = null;
            i = this.m_hsTypeFilter.iterator();
            while (!bSelectable && i.hasNext()) {
                s = (String)i.next();
                bSelectable = DirUtils.isOfType(ot, s, true);
                if (!bSelectable) continue;
                matchedTypeFilterEntryName = s;
            }
        }
        if (!bSelectable && this.m_bShowAuxClasses) {
            s = null;
            i = this.m_hsAuxTypeFilterEntries.iterator();
            while (!bSelectable && i.hasNext()) {
                s = (String)i.next();
                bSelectable = this.m_taskContext.getDirUtils().isOfAuxClass(oe, s);
                matchedTypeFilterEntryName = s;
            }
        }
        if (bSelectable && this.m_hAdvSelCriterion != null && (crit = (String)this.m_hAdvSelCriterion.get(matchedTypeFilterEntryName)) != null) {
            bSelectable = this.isAdvCritMatch(oe, crit);
        }
        boolean bl = bSelectable;
        return bl;
    }

    private boolean isAdvCritMatch(ObjectEntry oe, String criterion) {
        boolean bMatch = false;
        String objName = oe.getName();
        FilterResultModifier rm = new FilterResultModifier("AdvCritMatchRM", 0, null, false);
        String critType = ((FwDirUtils)this.m_taskContext.getDirUtils()).getFirstTypeFromASXMLCriterion(criterion, this.m_taskContext);
        ((FwDirUtils)this.m_taskContext.getDirUtils()).addASXMLFilterInfoToRM(rm, critType, criterion, (MContext)this.m_taskContext);
        ResultModifierFilterEntry filterEntry = null;
        if (objName != null && objName.length() > 0) {
            filterEntry = new ResultModifierFilterEntry(objName, new String[0]);
            rm.addFilter(filterEntry);
        }
        rm.setIncludeSubClasses(this.m_bShowSubClasses);
        rm.setIncludeAuxClasses(this.m_bShowAuxClasses);
        rm.setShowGlue(this.m_bShowGlue);
        rm.setSimpleAndOpAdvanced(true);
        try {
            ObjectEntryEnumeration oee = this.m_namespace.getChildren(oe.getParent(), (ResultModifier)rm);
            bMatch = oee.hasMoreElements();
        }
        catch (Exception e) {
            // empty catch block
        }
        return bMatch;
    }

    public int moveEnumerationLeft(BrowserObjectEntryEnumeration boee, int count) {
        int iCount = 0;
        if (boee != null) {
            for (int i = 0; i < count; ++i) {
                block6: {
                    try {
                        if (boee.previous() == null) {
                        }
                        break block6;
                    }
                    catch (SnapinException se) {
                    }
                    catch (NoSuchElementException nsee) {}
                    break;
                }
                ++iCount;
            }
        }
        return iCount;
    }

    public int moveEnumerationRight(BrowserObjectEntryEnumeration boee, int count) {
        int iCount = 0;
        if (boee != null) {
            for (int i = 0; i < count && boee.hasMoreElements() && boee.next() != null; ++i) {
                ++iCount;
            }
        }
        return iCount;
    }

    public boolean atFirst(BrowserObjectEntryEnumeration boee) {
        if (boee == null) {
            return true;
        }
        try {
            ObjectEntry prev = boee.previous();
            if (prev == null) {
                return true;
            }
            boee.next();
        }
        catch (SnapinException se) {
        }
        catch (NoSuchElementException nsee) {
            return true;
        }
        return false;
    }

    public boolean atLast(BrowserObjectEntryEnumeration boee) {
        if (boee == null) {
            return true;
        }
        try {
            ObjectEntry next = boee.next();
            if (next == null) {
                return true;
            }
            boee.previous();
        }
        catch (SnapinException se) {
        }
        catch (NoSuchElementException nsee) {
            return true;
        }
        return false;
    }

    public static String getUniqueString() {
        return "fw.OS" + uniqueStringCtr++;
    }

    private ArrayList splitTypeFilter(String s, Hashtable hAdvSelCrit) {
        ArrayList a = new ArrayList();
        if (s == null) {
            return a;
        }
        StringBuffer val = new StringBuffer("");
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch != ',') {
                val.append(ch);
                continue;
            }
            if (i + 1 < s.length() && s.charAt(i + 1) == ',') {
                val.append(',');
                ++i;
                continue;
            }
            this.addToArrayList(a, val.toString(), hAdvSelCrit);
            val.setLength(0);
        }
        this.addToArrayList(a, val.toString(), hAdvSelCrit);
        return a;
    }

    private void addToArrayList(ArrayList a, String s, Hashtable h) {
        if (s != null && (s = s.trim()).length() > 0 && h != null && h.get(s) == null) {
            if (s.equalsIgnoreCase("[root]")) {
                this.m_bRootSelectable = true;
            } else if (s.equalsIgnoreCase("[this]")) {
                this.m_bThisSelectable = true;
            } else if (s.equalsIgnoreCase("[public]")) {
                this.m_bPublicSelectable = true;
            } else if (s.equals("*")) {
                this.m_bMatchAllTypes = true;
            } else if (s.equals("[exclude-types]")) {
                this.m_bExcludeMode = true;
            } else if (s.equalsIgnoreCase("[containers]")) {
                this.m_bMatchAllContainers = true;
            } else if (s.equalsIgnoreCase("[non-partitions]")) {
                this.m_bMatchNonPartitionedContainers = true;
            } else if (s.equalsIgnoreCase("[partitions]")) {
                this.m_bMatchAllPartitions = true;
            } else if (s.equalsIgnoreCase("[non-containers]")) {
                this.m_bMatchLeafObjects = true;
            } else if (s.equalsIgnoreCase("[glue]")) {
                this.m_bShowGlue = true;
            } else {
                a.add(s);
            }
        }
    }

    private boolean isValidRM(ResultModifier rm) {
        boolean bRet = false;
        if (rm != null) {
            FilterResultModifier.Filter[] rmfa;
            ResultModifierFilterEntry[] rmfe = rm.getFilters();
            if (rmfe != null && rmfe.length > 0) {
                bRet = true;
            } else if (rm instanceof FilterResultModifier && (rmfa = ((FilterResultModifier)rm).getFRMFilters()) != null && rmfa.length > 0) {
                bRet = true;
            }
        }
        return bRet;
    }

    private void dumpRM(ResultModifier rm) {
        if (!D.isDebugEnabled()) {
            return;
        }
        if (rm != null) {
            FilterResultModifier.Filter[] rmfa;
            this.dOut(this.m_dbgExecuteInfo, rm.getDescriptiveName());
            this.dOut(this.m_dbgExecuteInfo, "      RM subcontainer search = " + rm.isSubContainerSearch());
            this.dOut(this.m_dbgExecuteInfo, "      RM matchAdvCrit = " + rm.getSimpleAndOpAdvanced());
            this.dOut(this.m_dbgExecuteInfo, "      RM showGlue = " + rm.getShowGlue());
            ResultModifierFilterEntry[] rmfe = rm.getFilters();
            if (rmfe != null && rmfe.length > 0) {
                for (int i = 0; i < rmfe.length; ++i) {
                    this.dOut(this.m_dbgExecuteInfo, "      RM FilterEntry[" + i + "]");
                    this.dOut(this.m_dbgExecuteInfo, "         nameFilter = <" + rmfe[i].getNameFilter() + ">");
                    String[] tf = rmfe[i].getTypeFilter();
                    if (tf == null || tf.length <= 0) continue;
                    for (int j = 0; j < tf.length; ++j) {
                        this.dOut(this.m_dbgExecuteInfo, "         typeFilter[" + j + "] = " + tf[j]);
                    }
                }
            }
            if (rm instanceof FilterResultModifier && (rmfa = ((FilterResultModifier)rm).getFRMFilters()) != null && rmfa.length > 0) {
                for (int i = 0; i < rmfa.length; ++i) {
                    FilterResultModifier.Filter f = rmfa[i];
                    this.dOut(this.m_dbgExecuteInfo, "      FRM Filter[" + i + "] type = " + f.getFilterTypeName());
                    FilterResultModifier.Filter.FilterItemGroupPair[] figp = f.getFilterItemGroupPairs();
                    if (figp == null || figp.length <= 0) continue;
                    for (int g = 0; g < figp.length; ++g) {
                        FilterResultModifier.FilterItemGroup.FilterItem[] fi;
                        this.dOut(this.m_dbgExecuteInfo, "         FRM FilterGroup[" + g + "]  <" + figp[g].getLogicalFilter() + ">");
                        FilterResultModifier.FilterItemGroup fig = figp[g].getFilterItemGroup();
                        if (fig == null || (fi = fig.getFilterItems()) == null || fi.length <= 0) continue;
                        for (int r = 0; r < fi.length; ++r) {
                            String crit = fi[r].getAttributeName() + " " + fi[r].getCompareFilter() + " " + fi[r].getAttributeValue() + "  <" + fi[r].getLogicalFilter() + ">";
                            this.dOut(this.m_dbgExecuteInfo, "            FRM criterion[" + r + "] => " + crit);
                        }
                    }
                }
            }
        }
    }

    static {
        for (int i = 0; i < m_osParms.length; ++i) {
            m_osParmsSet.add(m_osParms[i].toLowerCase());
        }
        bIsDebugEnabled = D.isDebugEnabled();
        uniqueStringCtr = 1;
    }
}

