/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.SchemaDefinition;
import com.novell.admin.ns.ldap.LDAPNamespace;
import com.novell.admin.ns.ldap.LDAPSchemaDefinition;
import com.novell.admin.ns.ldap.LDAPSyntax;
import com.novell.admin.ns.nds.NDSSyntax;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.AuthBrokerException;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DirPropertyBookPage;
import com.novell.emframe.dev.PageException;
import com.novell.emframe.dev.PropertyPageContext;
import com.novell.emframe.dev.UiHandler;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.FwAttr;
import com.novell.emframe.fw.FwTaskContext;
import com.novell.emframe.fw.studio.TemplateBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;

public class OtherPage
extends DirPropertyBookPage {
    private AdminNamespace ns = null;

    public void show(PropertyPageContext context) throws PageException {
        HttpServletRequest request = context.getRequest();
        Properties resultStrings = context.getResultStrings();
        String[] aclScopes = null;
        ObjectEntry treeOE = null;
        AuthenticationBroker broker = ((FwTaskContext)((Object)context)).getAuthenticationBroker();
        try {
            treeOE = (ObjectEntry)broker.getProtocolObject("AdminNamespace");
            this.ns = treeOE.getAdminNamespace();
            if (this.ns instanceof LDAPNamespace) {
                SchemaDefinition sd = this.ns.getSchemaDefinition(treeOE);
                aclScopes = ((LDAPSchemaDefinition)sd).aclScopes();
                FwAttr.setFwAuthAttr("aclScopesPacked", (Object)eMFrameUtils.pack(aclScopes, context), context);
            }
        }
        catch (AuthBrokerException e) {
            D.log(e);
        }
        catch (SPIException e) {
            D.log(e);
        }
        this.getAttributesToEdit(context, resultStrings, request);
        this.getUnvaluedAttributesToEdit(context, resultStrings, request);
        context.setAuthAttribute("otherPageObject", this.m_nsobj);
        super.show(context);
    }

    public void cache(PropertyPageContext context) throws PageException {
        super.cache(context);
        this.m_nsobj = this.getDirPropertyBook().getNSObject();
    }

    public String[] getAttributesForEDAS(PropertyPageContext context) {
        return context.getDirUtils().getSortedAttrs();
    }

    private void getAttributesToEdit(PropertyPageContext context, Properties resultStrings, HttpServletRequest request) {
        int i;
        boolean isRefresh = false;
        if (context.getRequest().getAttribute("isRefresh") != null) {
            isRefresh = context.getRequest().getAttribute("isRefresh").equals("true");
        }
        Object[] sAttrList = null;
        sAttrList = !isRefresh ? this.m_nsobj.getAttributes() : this.m_nsobj.getAttributes();
        String[] sHandledAttrList = this.m_propertyBook.getHandledAttributeNames();
        ArrayList<String> attributeList = new ArrayList<String>();
        for (i = 0; i < sAttrList.length; ++i) {
            attributeList.add(sAttrList[i]);
        }
        for (i = 0; i < sHandledAttrList.length; ++i) {
            attributeList.remove(sHandledAttrList[i]);
        }
        sAttrList = attributeList.toArray(new String[0]);
        Arrays.sort(sAttrList);
        Arrays.sort(sAttrList, new Comparator(){

            public int compare(Object a, Object b) {
                return ((String)a).compareToIgnoreCase((String)b);
            }

            public boolean equals(Object a) {
                return a == this;
            }
        });
        int count = 0;
        AttributeDefinition[] attributeDefs = new AttributeDefinition[1];
        String className = this.m_nsobj.getObjectEntry().getObjectType().getName();
        String[] superClasses = new String[]{};
        try {
            superClasses = context.getDirUtils().getSuperClasses(className);
        }
        catch (NamespaceException e) {
            D.log(e);
        }
        String client = ((FwTaskContext)((Object)context)).getUserInfo().getHtmlDirectory();
        AuthenticationBroker broker = ((FwTaskContext)((Object)context)).getAuthenticationBroker();
        ObjectEntry treeOE = null;
        try {
            treeOE = (ObjectEntry)broker.getProtocolObject("AdminNamespace");
        }
        catch (AuthBrokerException e) {
            D.log(e);
        }
        AdminNamespace ns = treeOE.getAdminNamespace();
        for (int i2 = 0; i2 < sAttrList.length; ++i2) {
            String safeAttrName = context.getDirUtils().getSafeName((String)sAttrList[i2]);
            try {
                attributeDefs[0] = ns.getAttributeDefinition(this.m_nsobj.getObjectEntry(), (String)sAttrList[i2]);
                UiHandler[] handlers = TemplateBuilder.getDefaultHandlers(context, attributeDefs, client, className, superClasses, false, false);
                if (handlers == null || handlers.length <= 0) continue;
                resultStrings.put("Attribute." + count + ".name", sAttrList[i2]);
                resultStrings.put("Attribute." + count + ".safeName", safeAttrName);
                ++count;
                continue;
            }
            catch (NamespaceException nse) {
                continue;
            }
            catch (SPIException spe) {
                continue;
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        resultStrings.put("Attribute.count", Integer.toString(count));
        request.setAttribute("NSOBJECT", (Object)this.m_nsobj);
    }

    private void getUnvaluedAttributesToEdit(PropertyPageContext context, Properties resultStrings, HttpServletRequest request) {
        int i;
        boolean isRefresh = false;
        if (context.getRequest().getAttribute("isRefresh") != null) {
            isRefresh = context.getRequest().getAttribute("isRefresh").equals("true");
        }
        String[] sAttrList = null;
        if (!isRefresh) {
            request.setAttribute("REFRESHING", (Object)"false");
        }
        sAttrList = this.m_nsobj.getUnvaluedAttributes();
        String[] sHandledAttrList = this.m_propertyBook.getHandledAttributeNames();
        ArrayList<String> attributeList = new ArrayList<String>();
        for (i = 0; i < sAttrList.length; ++i) {
            if (attributeList.contains(sAttrList[i])) continue;
            attributeList.add(sAttrList[i]);
        }
        for (i = 0; i < sHandledAttrList.length; ++i) {
            attributeList.remove(sHandledAttrList[i]);
        }
        sAttrList = attributeList.toArray(new String[0]);
        Arrays.sort(sAttrList, new Comparator(){

            public int compare(Object a, Object b) {
                return ((String)a).compareToIgnoreCase((String)b);
            }

            public boolean equals(Object a) {
                return a == this;
            }
        });
        int count = 0;
        AttributeDefinition[] attributeDefs = new AttributeDefinition[1];
        String className = this.m_nsobj.getObjectEntry().getObjectType().getName();
        String[] superClasses = new String[]{};
        try {
            superClasses = context.getDirUtils().getSuperClasses(className);
        }
        catch (NamespaceException e) {
            D.log(e);
        }
        String client = ((FwTaskContext)((Object)context)).getUserInfo().getHtmlDirectory();
        AuthenticationBroker broker = context.getAuthenticationBroker();
        ObjectEntry treeOE = null;
        try {
            treeOE = (ObjectEntry)broker.getProtocolObject("AdminNamespace");
        }
        catch (AuthBrokerException e) {
            D.log(e);
        }
        AdminNamespace ns = treeOE.getAdminNamespace();
        for (int i2 = 0; i2 < sAttrList.length; ++i2) {
            String safeAttrName = context.getDirUtils().getSafeName(sAttrList[i2]);
            try {
                UiHandler[] handlers;
                attributeDefs[0] = ns.getAttributeDefinition(this.m_nsobj.getObjectEntry(), sAttrList[i2]);
                if (attributeDefs[0].isAberrant() || attributeDefs[0].getSyntax() == NDSSyntax.SYN_BACK_LINK || attributeDefs[0].getSyntax() == LDAPSyntax.SYN_TAGGED_NAME || attributeDefs[0].getSyntax() == NDSSyntax.SYN_HOLD || attributeDefs[0].getSyntax() == NDSSyntax.SYN_REPLICA_POINTER || (handlers = TemplateBuilder.getDefaultHandlers(context, attributeDefs, client, className, superClasses, true, false)) == null || handlers.length <= 0) continue;
                resultStrings.put("UnvaluedAttribute." + count + ".name", sAttrList[i2]);
                resultStrings.put("UnvaluedAttribute." + count + ".safeName", safeAttrName);
                ++count;
                continue;
            }
            catch (NamespaceException nse) {
                continue;
            }
            catch (SPIException spe) {
                continue;
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        resultStrings.put("UnvaluedAttribute.count", Integer.toString(count));
    }
}

