/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.ldap.LDAPSyntax;
import com.novell.admin.ns.nds.NDSSyntax;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.AuthBrokerException;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.UiHandler;
import com.novell.emframe.dev.authenticator.AuthContext;
import com.novell.emframe.dev.eDirAccessServiceException;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.FwTaskContext;
import com.novell.emframe.fw.RightsBean;
import com.novell.emframe.fw.RightsCache;
import com.novell.emframe.fw.TargetCollection;
import com.novell.emframe.fw.iManager;
import com.novell.emframe.fw.npsCompat.NPSCompatUtils;
import com.novell.emframe.fw.studio.TemplateBuilder;
import com.novell.webaccess.common.I18NServletRequest;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class OtherPageEditor
extends Task {
    private static final long serialVersionUID = 1L;

    public boolean execute(TaskContext context, Properties resultStrings) {
        HttpServletRequest req = context.getRequest();
        String eDirAttrName = req.getParameter("attrName");
        String eDirSafeAttrName = context.getDirUtils().getSafeName(eDirAttrName);
        AuthenticationBroker broker = context.getAuthenticationBroker();
        ObjectEntry treeOE = null;
        try {
            treeOE = (ObjectEntry)broker.getProtocolObject("AdminNamespace");
        }
        catch (AuthBrokerException e) {
            D.log(e);
        }
        AdminNamespace namespace = treeOE.getAdminNamespace();
        NSObject nsobj = null;
        String strTemplateName = "otherPage" + eDirSafeAttrName;
        ObjectEntry uoe = null;
        String key = context.getDirUtils().getSafeName(eDirAttrName) + "DisplayName";
        resultStrings.put(key, context.getDirUtils().getAttributeDisplayName(eDirAttrName, context));
        resultStrings.put("safeAttrName", eDirSafeAttrName);
        try {
            String strAction = req.getParameter("action");
            String streDirTarget = req.getParameter("eDir$target");
            String[] strTargets = streDirTarget != null && streDirTarget.length() > 0 && streDirTarget.charAt(0) == 'P' && streDirTarget.charAt(streDirTarget.length() - 1) == 'P' ? eMFrameUtils.unpack(streDirTarget, context) : new String[]{streDirTarget};
            ((I18NServletRequest)context.getRequest()).setParameter("eDirSearch", "*");
            TargetCollection targets = new TargetCollection();
            targets.addTargetDefinition("target", streDirTarget, null, context);
            AuthContext hash = context.getAuthenticator().getAuthContext();
            nsobj = (NSObject)hash.get("otherPageObject");
            uoe = nsobj.getObjectEntry();
            if (strAction.equalsIgnoreCase("delete")) {
                RightsCache rightesCache = (RightsCache)targets.getEdasRightsData().get("target");
                RightsBean rightsBean = (RightsBean)rightesCache.get(eDirSafeAttrName);
                rightsBean.writeable = false;
            }
            context.getRequest().setAttribute("edasRights", (Object)targets.getEdasRightsData());
            String bigXml = "<edas>";
            String attrValue = req.getParameter("attrValue");
            if (attrValue != null && attrValue.length() > 0) {
                SAXBuilder saxBuilder = iManager.getSaxBuilder();
                Document doc = null;
                try {
                    doc = saxBuilder.build((Reader)new StringReader(attrValue));
                    Element root = doc.getRootElement();
                    if (!root.getName().equals(eDirSafeAttrName)) {
                        root.setName(eDirSafeAttrName);
                        bigXml = bigXml + this.parseElement(root, new String());
                    } else {
                        bigXml = bigXml + attrValue;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            bigXml = bigXml + "</edas>";
            resultStrings.put("edas", bigXml);
        }
        catch (eDirAccessServiceException edas) {
            // empty catch block
        }
        try {
            String tempDir = context.getWebappHome().getAbsolutePath() + "/portal/modules/temp/skins/default/devices/default/";
            String strFileName = strTemplateName + TemplateBuilder.getVersionString(context) + ".jsp";
            File file = new File(tempDir + strFileName);
            if (!file.exists()) {
                UiHandler[] handlers;
                AttributeDefinition[] attributeDefs = new AttributeDefinition[1];
                String className = uoe.getObjectType().getName();
                String[] superClasses = context.getDirUtils().getSuperClasses(className);
                String client = ((FwTaskContext)((Object)context)).getUserInfo().getHtmlDirectory();
                attributeDefs[0] = namespace.getAttributeDefinition(uoe, eDirAttrName);
                if (attributeDefs[0].getSyntax() != NDSSyntax.SYN_BACK_LINK && attributeDefs[0].getSyntax() != LDAPSyntax.SYN_TAGGED_NAME && attributeDefs[0].getSyntax() != NDSSyntax.SYN_REPLICA_POINTER && attributeDefs[0].getSyntax() != NDSSyntax.SYN_HOLD && (handlers = TemplateBuilder.getDefaultHandlers(context, attributeDefs, client, className, superClasses, false, false)) != null && handlers.length > 0) {
                    TemplateBuilder.createTemplate(context, handlers, "default", true, "TemplateOther_skeleton.jsp", null, false, "temp", strFileName, true);
                    try {
                        NPSCompatUtils.refreshResourceFileMap("temp");
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
            }
            eMFrameUtils.setMergeTemplate(context, "temp/" + strTemplateName + TemplateBuilder.getVersionString(context));
        }
        catch (NamespaceException nse) {
        }
        catch (SPIException spe) {
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return true;
    }

    private String parseElement(Element element, String bigXml) {
        List childList = element.getChildren();
        bigXml = bigXml + "<" + element.getName() + ">";
        if (childList == null || childList.isEmpty()) {
            bigXml = bigXml + element.getText();
        } else {
            ListIterator it = childList.listIterator();
            while (it.hasNext()) {
                bigXml = this.parseElement((Element)it.next(), bigXml);
            }
        }
        bigXml = bigXml + "</" + element.getName() + ">";
        return bigXml;
    }
}

