/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.StringValue;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectType;
import com.novell.emframe.dev.AuthBrokerException;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.DirRoleList;
import com.novell.emframe.fw.FwDirUtils;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.RBSUtil;
import com.novell.rbs.RBSAssociatedObject;
import com.novell.rbs.RBSCollection;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public class OwnedCollectionsTask
extends Task {
    private static final long serialVersionUID = 1L;
    private HttpServletRequest req;
    private TaskContext context;
    private Properties resultStrings;
    private String selectedMember;
    private ObjectEntry treeOE;
    private AdminNamespace ns;
    private String collectionOwnerObjectTypes;
    private RBSCollection[] previousRBSCollections = null;

    public static void shouldRun(HttpServletRequest req, String sServiceName) throws Exception {
        FwUtils.verifyRbsInstalled(req, sServiceName);
    }

    public boolean execute(TaskContext context, Properties resultStrings) {
        this.context = context;
        this.resultStrings = resultStrings;
        this.req = context.getRequest();
        this.treeOE = RBSUtil.getTreeOE(context);
        this.ns = this.treeOE.getAdminNamespace();
        String nextState = this.req.getParameter("nextState");
        if (nextState == null || nextState.equalsIgnoreCase("initialState")) {
            return this.showInitialForm();
        }
        if (nextState.equalsIgnoreCase("showList")) {
            return this.showList();
        }
        if (nextState.equalsIgnoreCase("saveList")) {
            return this.saveList();
        }
        return this.showInitialForm();
    }

    private boolean showInitialForm() {
        this.resultStrings.put("DisplayNameTitle", eMFrameUtils.getLocalizedString("FwResources", "OwnedCollections", this.context));
        this.resultStrings.put("Merge.Template", "fw.OwnedCollections");
        this.resultStrings.put("Next.State", "showList");
        try {
            this.collectionOwnerObjectTypes = RBSUtil.getCollectionOwnerObjectTypes(this.context, this.ns);
            this.resultStrings.put("MemberTypeFilter", this.collectionOwnerObjectTypes);
        }
        catch (Exception exc) {
            D.log(exc.toString());
        }
        return true;
    }

    private boolean showList() {
        this.selectedMember = this.req.getParameter("MemberName");
        RBSCollection[] rbsCollections = null;
        ObjectEntry memberOE = null;
        RBSAssociatedObject rbsAssociatedObject = null;
        Vector<String> collectionVector = new Vector<String>();
        try {
            memberOE = this.ns.getObjectEntry(this.treeOE, this.selectedMember);
            ObjectType objectType = memberOE.getObjectType();
            String[] collectionOwnerObjectType = RBSUtil.tokenizeObjectTypes(this.collectionOwnerObjectTypes);
            if (collectionOwnerObjectType != null) {
                boolean found = false;
                for (int i = 0; i < collectionOwnerObjectType.length; ++i) {
                    if (!DirUtils.isOfType(objectType, collectionOwnerObjectType[i], true)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "Error", this.context));
                    this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString("FwResources", "GetMemberName.WrongObject", this.context));
                    return false;
                }
            }
            this.context.addToHistory(memberOE);
            rbsAssociatedObject = new RBSAssociatedObject(memberOE);
            rbsCollections = rbsAssociatedObject.getOwnedCollections2();
            this.previousRBSCollections = rbsCollections;
        }
        catch (SPIException e) {
            D.log(e);
            eMFrameUtils.setErrorMessage(e, this.context);
            return false;
        }
        if (rbsCollections != null) {
            for (int i = 0; i < rbsCollections.length; ++i) {
                String strGroup = this.ns.getUnrootedName(rbsCollections[i].getObjectEntry());
                collectionVector.addElement(strGroup);
            }
        }
        this.resultStrings.put("RBSCollectionContext", this.selectedMember);
        int cv = collectionVector.size();
        this.context.setAuthAttribute("collectionSize", Integer.toString(cv));
        this.putCollections(collectionVector);
        this.context.setAuthAttribute("rbsAssociatedObject", rbsAssociatedObject);
        return true;
    }

    private boolean saveList() {
        this.resultStrings.put("TaskAfterGenConf", "fw.HomePage");
        this.resultStrings.put("MergeAfterGenConf", "fw.HomePage");
        String formChanged = this.req.getParameter("OwnedCollectionsFormChanged");
        if (formChanged.equals("true")) {
            ObjectEntry treeOE = null;
            try {
                treeOE = (ObjectEntry)this.context.getAuthenticationBroker().getProtocolObject("AdminNamespace");
            }
            catch (AuthBrokerException e) {
                D.log(e);
            }
            AdminNamespace ns = treeOE.getAdminNamespace();
            RBSAssociatedObject rbsAssociatedObject = (RBSAssociatedObject)this.context.getAuthAttribute("rbsAssociatedObject");
            String[] collections = this.getCollections(this.req);
            RBSCollection[] rbsCollection = null;
            if (collections != null && collections.length > 0) {
                rbsCollection = new RBSCollection[collections.length];
                for (int i = 0; i < collections.length; ++i) {
                    try {
                        ObjectEntry oe = ns.getObjectEntry(treeOE, collections[i]);
                        rbsCollection[i] = new RBSCollection(oe);
                        continue;
                    }
                    catch (SPIException e) {
                        D.log(e);
                        eMFrameUtils.setErrorMessage(e, this.context);
                        return false;
                    }
                }
            }
            try {
                ObjectEntry memberOE = null;
                memberOE = ns.getObjectEntry(treeOE, this.selectedMember);
                if (DirUtils.isOfType(memberOE.getObjectType(), "Group", true)) {
                    Enumeration staticMembersEnum;
                    ObjectAttribute[] objAttributes = ns.getAttributes(memberOE, new String[]{"Member"}, 1, null);
                    Enumeration enumeration = staticMembersEnum = objAttributes != null && objAttributes[0] != null ? objAttributes[0].getValueComponents() : null;
                    if (staticMembersEnum != null) {
                        Vector<RBSCollection> deletedRBSCollectionList = new Vector<RBSCollection>();
                        if (this.previousRBSCollections != null && this.previousRBSCollections.length > 0) {
                            if (rbsCollection != null && rbsCollection.length > 0) {
                                for (int x = 0; x < this.previousRBSCollections.length; ++x) {
                                    boolean found = false;
                                    for (int y = 0; y < rbsCollection.length; ++y) {
                                        if (!this.previousRBSCollections[x].getObjectEntry().getFullName().equals(rbsCollection[y].getObjectEntry().getFullName())) continue;
                                        found = true;
                                        break;
                                    }
                                    if (found) continue;
                                    deletedRBSCollectionList.add(this.previousRBSCollections[x]);
                                }
                            } else {
                                for (int x = 0; x < this.previousRBSCollections.length; ++x) {
                                    deletedRBSCollectionList.add(this.previousRBSCollections[x]);
                                }
                            }
                        }
                        while (staticMembersEnum.hasMoreElements()) {
                            RBSAssociatedObject grpMemberRBSAssociatedObject = null;
                            RBSCollection[] grpMemberOwnedRBSCollection = null;
                            RBSCollection[] grpOwnedRBSCollection = null;
                            Vector<RBSCollection> rbsCollectionList = new Vector<RBSCollection>();
                            String strGroupMemberOE = ((StringValue)staticMembersEnum.nextElement()).toString();
                            ObjectEntry groupMemberOE = ns.getObjectEntry(treeOE, strGroupMemberOE);
                            if (!DirUtils.isOfType(groupMemberOE.getObjectType(), "User", true)) continue;
                            grpMemberRBSAssociatedObject = new RBSAssociatedObject(groupMemberOE);
                            grpMemberOwnedRBSCollection = grpMemberRBSAssociatedObject.getOwnedCollections2();
                            grpOwnedRBSCollection = rbsCollection;
                            if (grpMemberOwnedRBSCollection != null && grpMemberOwnedRBSCollection.length > 0) {
                                int k;
                                boolean isDeletedRBSCollectionListExists;
                                boolean bl = isDeletedRBSCollectionListExists = deletedRBSCollectionList != null && deletedRBSCollectionList.size() > 0;
                                if (isDeletedRBSCollectionListExists) {
                                    for (k = 0; k < grpMemberOwnedRBSCollection.length; ++k) {
                                        boolean found = false;
                                        RBSCollection[] deletedRBSCollections = new RBSCollection[deletedRBSCollectionList.size()];
                                        deletedRBSCollectionList.toArray(deletedRBSCollections);
                                        for (int j = 0; j < deletedRBSCollections.length; ++j) {
                                            if (!grpMemberOwnedRBSCollection[k].getObjectEntry().getFullName().equals(deletedRBSCollections[j].getObjectEntry().getFullName())) continue;
                                            found = true;
                                            break;
                                        }
                                        if (found) continue;
                                        rbsCollectionList.add(grpMemberOwnedRBSCollection[k]);
                                    }
                                } else {
                                    for (k = 0; k < grpMemberOwnedRBSCollection.length; ++k) {
                                        rbsCollectionList.add(grpMemberOwnedRBSCollection[k]);
                                    }
                                }
                            }
                            if (grpOwnedRBSCollection != null && grpOwnedRBSCollection.length > 0) {
                                for (int k = 0; k < grpOwnedRBSCollection.length; ++k) {
                                    rbsCollectionList.add(grpOwnedRBSCollection[k]);
                                }
                            }
                            if (rbsCollectionList == null) continue;
                            RBSCollection[] arrayRBSCollection = new RBSCollection[rbsCollectionList.size()];
                            rbsCollectionList.toArray(arrayRBSCollection);
                            grpMemberRBSAssociatedObject.setOwnedCollections2(arrayRBSCollection);
                            grpMemberRBSAssociatedObject.update();
                        }
                    }
                }
                rbsAssociatedObject.setOwnedCollections2(rbsCollection);
                rbsAssociatedObject.update();
                ObjectEntry whoami = ns.getAuthenticatedIdentity(treeOE);
                if (this.selectedMember.equalsIgnoreCase(ns.getUnrootedName(whoami))) {
                    DirRoleList roleList;
                    RBSCollection[] rbsCollections = rbsAssociatedObject.getOwnedCollections2();
                    if (rbsCollections == null) {
                        roleList = RBSUtil.getDirRoleList(this.context);
                        roleList.setCollectionOwner(false);
                        FwDirUtils.updateAccessMode(this.context);
                    } else {
                        roleList = RBSUtil.getDirRoleList(this.context);
                        roleList.setCollectionOwner(true);
                        FwDirUtils.updateAccessMode(this.context);
                    }
                }
                this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "RBSCollectionName.ADD_OWNER_RBSCOLLECTION_SUCCESS", this.context));
                this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString("FwResources", "RBSCollectionName.ADD_OWNER_RBSCOLLECTION", this.context));
            }
            catch (Exception e) {
                D.log(e);
                eMFrameUtils.setErrorMessage(e, this.context);
                return false;
            }
        }
        this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "OwnedCollections", this.context));
        this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString("FwResources", "RBSCollectionName.NO_UPDATE_OWNER_RBSCOLLECTION", this.context));
        return true;
    }

    private void putCollections(Vector collections) {
        this.resultStrings.put("Owned.CollectionList.Count", Integer.toString(collections.size()));
        for (int i = 0; i < collections.size(); ++i) {
            String collectionStr = (String)collections.elementAt(i);
            this.resultStrings.put("Owned.CollectionList." + i, collectionStr);
        }
    }

    private String[] getCollections(HttpServletRequest req) {
        String ownedCollections = req.getParameter("OwnedCollectionsString");
        StringTokenizer ownedTokenizer = new StringTokenizer(ownedCollections, ";");
        String[] ownedCollectionsIds = null;
        if (ownedTokenizer.countTokens() > 0) {
            ownedCollectionsIds = new String[ownedTokenizer.countTokens()];
            int count = 0;
            while (ownedTokenizer.hasMoreTokens()) {
                ownedCollectionsIds[count] = eMFrameUtils.urlDecode(ownedTokenizer.nextToken(), req.getCharacterEncoding());
                ++count;
            }
        }
        return ownedCollectionsIds;
    }
}

