/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.emframe.dev.BookException;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.MTask;
import com.novell.emframe.dev.PluginException;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.taskMan.FwBaseUIPartInterface;
import com.novell.emframe.partDev.BaseUIParticipant;
import com.novell.emframe.partDev.PrimaryBaseUIParticipant;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.jdom.Document;

public abstract class ParticipantHandler
extends MTask {
    private static final String KEY_PAGE_ASSIGNMENT = "page-assignment";
    private static final String KEY_ICON_NAME = "Wizard.Icon.name";
    private static final String KEY_ICON_ALT = "Wizard.Icon.alt";
    private static final String KEY_DISPLAY_NAME = "Task.displayName";
    private static final String PAGE_HELP_FILE = "Help.file";
    private static final String KEY_COMMAND = "nextState";
    private static final String KEY_CURRENTPAGE = "activePage";
    private static final String KEY_NEXTPAGE = "nextPage";
    private static final String TEMPLATE_ERROR_PAGE = "fw/ErrorPage.jsp";
    private static final String TEMPLATE_FRAME_HEADER = "fw/ParticipantWizardFrameHeader.jsp";
    private static final String TEMPLATE_FRAMESET = "fw/ParticipantWizardFrameSet.jsp";
    private static final String KEY_BODY_NEXT_STATE = "wizardBodyNextState";
    protected String command = null;
    public String displayName = null;
    public String iconUrl = null;
    public String m_iconAlt = null;
    private HashMap m_initialParams = null;
    private Hashtable m_cache = null;
    private int m_currentPageId = -1;
    private String[] m_handledAttributeNames = null;
    protected String[] m_delayedAttributes = null;
    Vector parts = new Vector();
    int m_iCurrentPart = 0;
    private List partDocs = null;
    private String sCommand = null;
    private HttpServletRequest req = null;
    private String operation;
    private Set validTypes;
    private Set selectedTypes;
    private Object m_helpFile;

    public void init(MContext context, Document doc) {
        super.init(context, doc);
        this.operation = doc.getRootElement().getChildTextTrim("operation-type");
    }

    public Set getValidTypes(MContext context) {
        Document doc = FwUtils.getTaskDocument(context, this.getTaskId());
        if (this.validTypes == null) {
            List list = doc.getRootElement().getChildren("object-type-name");
        }
        return this.validTypes;
    }

    public void execute(MContext context) {
        block12: {
            String action = (String)context.getRequest().getAttribute("Action");
            this.req = context.getRequest();
            this.sCommand = context.getRequest().getParameter(KEY_COMMAND);
            try {
                if (this.sCommand == null || this.sCommand.equals("initialState") || this.sCommand.equals("selectTarget")) {
                    this.initialState();
                    break block12;
                }
                if (this.sCommand.equals("search")) {
                    this.callDoSearch();
                    break block12;
                }
                if (this.sCommand.equals("previous")) {
                    this.doPrevious();
                    this.outputMisc();
                    break block12;
                }
                if (this.sCommand.equals("nextButton")) {
                    this.doNext();
                    this.outputMisc();
                    break block12;
                }
                if (this.sCommand.equals("finishButton") || this.sCommand.equals("finish") || this.sCommand.equals("ok")) {
                    this.doFinish();
                    this.outputMisc();
                    break block12;
                }
                if (this.sCommand.equals("header")) {
                    this.outputHeader(false);
                    this.outputMisc();
                    this.setUIPage(TEMPLATE_FRAME_HEADER);
                    break block12;
                }
                if (this.sCommand.equals("footer")) {
                    this.outputHeader(false);
                    this.outputMisc();
                    this.setUIPage(TEMPLATE_FRAME_HEADER);
                    break block12;
                }
                if ("showInitial".equalsIgnoreCase(this.sCommand)) {
                    this.outputMisc();
                    this.onShow(null);
                    break block12;
                }
                if (this.sCommand.equals("progress")) {
                    this.updateMooProgressDialog();
                    break block12;
                }
                if (this.sCommand.equals("progress.cancel")) {
                    this.abortMooOperation();
                    break block12;
                }
                throw new Exception("Invalid value for nextstate: " + this.sCommand);
            }
            catch (Throwable e) {
                D.log(e);
                eMFrameUtils.setErrorMessage(e, context);
                this.outputData("GeneralMsg.Mode", "fatal");
                this.setUIPage("dev/GenErr.jsp");
            }
        }
    }

    private void doShow() {
    }

    private void outputHeader(boolean b) {
        this.outputData("TaskHeader.title", this.getDisplayName());
        this.outputData("TaskHeader.iconUrl", this.iconUrl);
        this.outputData("TaskHeader.iconAlt", this.m_iconAlt);
        this.outputData("TaskHeader.helpFile", this.m_helpFile);
    }

    private void doFinish() {
        MContext context = this.getContext();
        Vector<BaseUIParticipant> partsWithErrors = new Vector<BaseUIParticipant>();
        this.getPart(this.m_iCurrentPart).onFinish(context);
        Iterator iterParts = this.parts.iterator();
        while (iterParts.hasNext()) {
            BaseUIParticipant part = (BaseUIParticipant)iterParts.next();
            if (part.canCommit(context)) continue;
            partsWithErrors.add(part);
        }
        if (partsWithErrors.size() == 0) {
            try {
                ((PrimaryBaseUIParticipant)this).performOperation();
                this.doPostProcessing();
            }
            catch (PluginException e) {
                D.log(e);
            }
        }
    }

    private void doPostProcessing() {
        Vector<String> msgs = new Vector<String>();
        ((FwBaseUIPartInterface)((Object)this)).postProcessing(this.getContext());
        msgs.add(((FwBaseUIPartInterface)((Object)this)).getConfirmationMsg(this.getContext()));
        Iterator iterParts = this.parts.iterator();
        while (iterParts.hasNext()) {
            BaseUIParticipant part = (BaseUIParticipant)iterParts.next();
            part.postProcessing(this.getContext());
            msgs.add(part.getConfirmationMsg(this.getContext()));
        }
        this.setConfirmationMsg(msgs.toArray(new String[msgs.size()]));
    }

    protected abstract void setConfirmationMsg(String[] var1);

    private void doNext() {
        this.getPart(this.m_iCurrentPart).onNext(this.getContext());
        if (this.m_iCurrentPart < this.parts.size()) {
            --this.m_iCurrentPart;
            this.getPart(this.m_iCurrentPart).onShow(this.getContext());
        } else {
            this.doFinish();
        }
    }

    private void doPrevious() {
        this.getPart(this.m_iCurrentPart).onBack(this.getContext());
        if (this.m_iCurrentPart > -1) {
            --this.m_iCurrentPart;
        }
        this.getPart(this.m_iCurrentPart).onShow(this.getContext());
    }

    private void initialState() throws BookException {
        if (!this.validTargets()) {
            this.callDoSearch();
            return;
        }
        try {
            this.readData();
        }
        catch (PluginException e) {
            this.callDoSearch();
            return;
        }
        this.getRequest().setAttribute(KEY_BODY_NEXT_STATE, (Object)"showInitial");
        this.setUIPage(TEMPLATE_FRAMESET);
    }

    private void callDoSearch() {
        if (this.iconUrl != null) {
            this.outputData("Task.Icon.name", this.iconUrl);
        }
        if (this.m_iconAlt != null) {
            this.outputData("Task.Icon.alt", this.m_iconAlt);
        }
        this.doSearch();
        try {
            this.outputMisc();
        }
        catch (PluginException e) {
            D.log(e);
        }
    }

    public String getOperation(MContext context) {
        return this.operation;
    }

    protected String getPrefrencesKey() {
        return "fw_BaseOperationParticipantWizard_" + this.getTaskId() + "_" + this.operation;
    }

    protected FwBaseUIPartInterface getPart(int index) {
        FwBaseUIPartInterface part = index > 0 ? (FwBaseUIPartInterface)this.parts.elementAt(index) : (FwBaseUIPartInterface)((Object)this);
        return part;
    }

    private void outputData(String key, Object value) {
        if (key != null) {
            if (value == null) {
                value = "";
            }
            this.req.setAttribute(key, value);
        }
    }

    public void release() {
        super.release();
        Iterator iterator = this.parts.iterator();
        while (iterator.hasNext()) {
            BaseUIParticipant part = (BaseUIParticipant)iterator.next();
            try {
                part.release();
            }
            catch (Throwable e) {
                D.log(e);
            }
        }
    }

    protected void refresh() throws BookException {
    }

    protected void abortMooOperation() throws BookException {
    }

    protected boolean shouldThreadUpdate() {
        return false;
    }

    protected void updateMooProgressDialog() throws BookException {
    }

    public abstract void onShow(MContext var1);

    protected void instantiateParts(MContext context) throws PluginException {
        Iterator iterPartDocs = this.partDocs.iterator();
        while (iterPartDocs.hasNext()) {
            Document partDoc = (Document)iterPartDocs.next();
            BaseUIParticipant p = this.getInstance(partDoc, true, context);
            if (p == null) continue;
            try {
                this.addPart(p);
            }
            catch (Throwable e) {
                D.log("Unabled to add participant: id=" + partDoc.getRootElement().getChildTextTrim("id"));
                D.log(e);
            }
        }
    }

    private void addPart(BaseUIParticipant part) {
        this.parts.addElement(part);
    }

    protected BaseUIParticipant getInstance(Document doc, boolean verifyDevice, MContext context) {
        String strPageClassName = null;
        String strPageId = null;
        BaseUIParticipant p = null;
        try {
            strPageId = doc.getRootElement().getChildTextTrim("id");
            if (strPageId == null || strPageId.length() < 1) {
                ParticipantHandler.printErrorMessage("Skipping part because it has no id.");
                return null;
            }
            strPageClassName = eMFrameUtils.getClassName(doc);
            if (strPageClassName == null || strPageClassName.length() < 1) {
                ParticipantHandler.printErrorMessage("skippin part (" + strPageId + ") because it is missing a class-name");
                return null;
            }
            if (verifyDevice && FwUtils.callVerifyForDeviceMethod(context, doc) != null) {
                ParticipantHandler.printErrorMessage("skipping part (" + strPageId + ") because it does not run in the current environment or support the current device");
                return null;
            }
            Class<?> commandClass = Class.forName(strPageClassName);
            p = (BaseUIParticipant)commandClass.newInstance();
            p.init(context, doc, this);
        }
        catch (Throwable e) {
            ParticipantHandler.printErrorMessage("ParticipantHandler: Could not instanciate part class: " + strPageClassName + " Skipping part: " + strPageId);
            D.log(e);
            return null;
        }
        return p;
    }

    protected void outputMisc() throws PluginException {
        this.outputData(KEY_DISPLAY_NAME, this.getDisplayName());
        this.outputData("PartHandler_showWizard", new Boolean(this.showWizard()));
    }

    public String getDisplayName() {
        return this.displayName;
    }

    protected static void printErrorMessage(String message) {
        D.log("======================================================================");
        D.log("ParticipantHandler: " + message);
        D.log("======================================================================");
    }

    public boolean showWizard() {
        Iterator iterParts = this.parts.iterator();
        boolean hasPartToShow = false;
        while (iterParts.hasNext() && !hasPartToShow) {
            BaseUIParticipant part = (BaseUIParticipant)iterParts.next();
            if (part == null) continue;
            hasPartToShow = part.shouldShow(this.getContext());
        }
        if (this.partDocs.size() > 0 && !hasPartToShow) {
            D.log("Participant Handler has no Parts desiring to show.");
        }
        return hasPartToShow;
    }

    protected abstract boolean validTargets();

    protected abstract void readData() throws PluginException;

    protected abstract void performOperation() throws PluginException;

    protected abstract void doSearch();

    protected void updateMooProgressDialog(MContext context) throws BookException {
    }

    protected final void outputData(String key, String value) {
        if (key != null) {
            if (value == null) {
                value = "";
            }
            this.req.setAttribute(key, (Object)value);
        }
    }
}

