/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.application.console.snapin.BrowserObjectEntryEnumeration;
import com.novell.application.console.snapin.DefaultIndexedObjectEntryEnumeration;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectEntryEnumeration;
import com.novell.application.console.snapin.SnapinException;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.TargetObjects;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.webaccess.common.I18NServletRequest;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Properties;

public class PreviewObjectFilter
extends Task {
    private static final long serialVersionUID = 1L;
    private TaskContext m_context = null;
    private Properties m_resultStrings = null;
    private I18NServletRequest m_req = null;
    private boolean m_atFirst = false;
    private ObjectEntry m_firstObjectEntry = null;
    static final int BLOCK_SIZE = 200;

    public boolean execute(TaskContext context, Properties resultStrings) {
        this.m_resultStrings = resultStrings;
        this.m_context = context;
        this.m_req = (I18NServletRequest)context.getRequest();
        String nextState = this.m_req.getParameter("nextState");
        D.assrt(nextState != null, "nextState cannot be null");
        if (nextState.equals("initialState")) {
            return this.initialPreview();
        }
        if (nextState.equals("previewNext")) {
            return this.previewNext();
        }
        if (nextState.equals("previewPrevious")) {
            return this.previewPrevious();
        }
        D.assrt(false, "Invalid state");
        return false;
    }

    private final boolean initialPreview() {
        String queryString = this.m_req.getParameter("query");
        ObjectEntryEnumeration myenum = null;
        try {
            TargetObjects targetObjects = new TargetObjects(queryString, this.m_context);
            myenum = targetObjects.getObjectEntryEnumeration();
            if (!(myenum instanceof BrowserObjectEntryEnumeration)) {
                D.log("PreviewObjectFilter: ObjectEntryEnumeration is not virtual.  Create an indexed enumeration...");
                myenum = new DefaultIndexedObjectEntryEnumeration(myenum, null);
            }
            this.m_resultStrings.put("TotalCount", "" + targetObjects.getCount());
            this.m_resultStrings.put("TotalCountExact", "" + (targetObjects.getCountReliability() == 1));
            String msg = targetObjects.getCountReliablityMessage();
            if (msg != null) {
                this.m_resultStrings.put("TotalCountMessage", msg);
            }
        }
        catch (Exception e) {
            D.log(e);
            eMFrameUtils.setErrorMessage(e, this.m_context);
            this.m_req.setParameter("merge", "dev.GenError");
            this.m_req.setAttribute("GeneralMsg.suppressButtons", "true");
            return false;
        }
        this.m_firstObjectEntry = null;
        this.m_context.setAuthAttribute("PreviewFilter.enum", myenum);
        boolean success = this.ouputNextResults((Enumeration)myenum);
        if (this.m_firstObjectEntry != null) {
            this.m_context.setAuthAttribute("PreviewFilter.firstObjectEntry", this.m_firstObjectEntry);
        }
        return success;
    }

    private final boolean previewNext() {
        ObjectEntryEnumeration myenum = (ObjectEntryEnumeration)this.m_context.getAuthAttribute("PreviewFilter.enum");
        this.m_firstObjectEntry = (ObjectEntry)this.m_context.getAuthAttribute("PreviewFilter.firstObjectEntry");
        return this.ouputNextResults((Enumeration)myenum);
    }

    private final boolean ouputNextResults(Enumeration myenum) {
        int i;
        DirUtils dirUtils = this.m_context.getDirUtils();
        for (i = 0; myenum.hasMoreElements() && i < 200; ++i) {
            ObjectEntry oe = (ObjectEntry)myenum.nextElement();
            if (i == 0) {
                if (this.m_firstObjectEntry == null) {
                    this.m_firstObjectEntry = oe;
                }
                this.m_atFirst = oe.equals((Object)this.m_firstObjectEntry);
            }
            this.m_resultStrings.put("PreviewFilter." + i + ".name", oe.getName());
            this.m_resultStrings.put("PreviewFilter." + i + ".typeIcon", dirUtils.getObjectTypeImageName(oe.getTypeName()));
        }
        this.m_resultStrings.put("PreviewFilter.hasPrevious", "" + !this.m_atFirst);
        this.m_resultStrings.put("PreviewFilter.count", "" + i);
        this.m_resultStrings.put("PreviewFilter.hasNext", "" + myenum.hasMoreElements());
        return true;
    }

    private final boolean previewPrevious() {
        int objectEntryCount;
        ObjectEntryEnumeration myenum = (ObjectEntryEnumeration)this.m_context.getAuthAttribute("PreviewFilter.enum");
        this.m_firstObjectEntry = (ObjectEntry)this.m_context.getAuthAttribute("PreviewFilter.firstObjectEntry");
        D.assrt(myenum instanceof BrowserObjectEntryEnumeration, "Previous requires a BrowserObjectEntryEnumeration");
        BrowserObjectEntryEnumeration browser = (BrowserObjectEntryEnumeration)myenum;
        String strObjectEntryCount = this.m_req.getParameter("objectEntryCount");
        try {
            objectEntryCount = Integer.parseInt(strObjectEntryCount);
        }
        catch (NumberFormatException e) {
            D.log(e);
            eMFrameUtils.setErrorMessage(e, this.m_context);
            return false;
        }
        int backup = objectEntryCount + 200;
        for (int i = 0; i < backup; ++i) {
            ObjectEntry oe;
            try {
                oe = browser.previous();
            }
            catch (SnapinException e) {
                break;
            }
            catch (NoSuchElementException nsee) {
                break;
            }
            if (oe == null) break;
        }
        boolean success = this.ouputNextResults((Enumeration)browser);
        this.m_resultStrings.put("PreviewFilter.hasNext", "" + myenum.hasMoreElements());
        return success;
    }
}

