/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.ContentData;
import com.novell.emframe.fw.ModuleData;
import com.novell.emframe.fw.RBSObjectData;
import com.novell.emframe.fw.VersionInfo;
import java.text.Collator;
import java.util.Comparator;

public class RBSObjectDataSort
implements Comparator {
    public static final String SORT_DESCENDING = "descending";
    public static final String SORT_ASCENDING = "ascending";
    public static final String SORT_TYPE = "sortType";
    public static final String SORT_FDN_NAME = "sortFDNName";
    public static final String SORT_DISPLAY_NAME = "sortDisplayName";
    public static final String SORT_MODULE = "sortModule";
    public static final String SORT_INITIAL_VERSION = "sortInitialVersion";
    public static final String SORT_EXPIRED_VERSION = "sortExpiredVersion";
    public static final String SORT_STATUS = "sortStatus";
    public static final String SORT_INSTALLED_VERSION = "sortInstalledVersion";
    public static final String SORT_AVAILABLE_VERSION = "sortAvailableVersion";
    Collator m_collator = null;
    TaskContext m_context = null;
    String m_sortColumn = null;
    String m_sortDirection = null;

    public RBSObjectDataSort(TaskContext context, String sortColumn, String sortDirection) {
        this.m_context = context;
        this.m_sortColumn = sortColumn;
        this.m_sortDirection = sortDirection;
        this.m_collator = Collator.getInstance(this.m_context.getLocale());
    }

    public int compare(Object object1, Object object2) {
        int compare = 0;
        if (this.m_sortColumn.equalsIgnoreCase(SORT_DISPLAY_NAME)) {
            String name1 = ((RBSObjectData)object1).getDisplayName();
            String name2 = ((RBSObjectData)object2).getDisplayName();
            compare = this.compareString(this.m_sortDirection, name1, name2);
        } else if (this.m_sortColumn.equalsIgnoreCase(SORT_FDN_NAME)) {
            String name1 = ((RBSObjectData)object1).getObjectFDN();
            String name2 = ((RBSObjectData)object2).getObjectFDN();
            compare = this.compareString(this.m_sortDirection, name1, name2);
        } else if (this.m_sortColumn.equalsIgnoreCase(SORT_MODULE)) {
            String module1 = ((RBSObjectData)object1).getModuleDisplayName();
            String module2 = ((RBSObjectData)object2).getModuleDisplayName();
            compare = this.compareString(this.m_sortDirection, module1, module2);
        } else if (this.m_sortColumn.equalsIgnoreCase(SORT_INITIAL_VERSION)) {
            String version1 = ((RBSObjectData)object1).getInitialVersion();
            String version2 = ((RBSObjectData)object2).getInitialVersion();
            compare = this.compareVersion(this.m_sortDirection, version1, version2);
        } else if (this.m_sortColumn.equalsIgnoreCase(SORT_EXPIRED_VERSION)) {
            String version1 = ((RBSObjectData)object1).getExpiredVersion();
            String version2 = ((RBSObjectData)object2).getExpiredVersion();
            compare = this.compareVersion(this.m_sortDirection, version1, version2);
        } else if (this.m_sortColumn.equalsIgnoreCase(SORT_STATUS)) {
            String name1 = ((ModuleData)object1).getLocalizedStatus();
            String name2 = ((ModuleData)object2).getLocalizedStatus();
            compare = this.compareString(this.m_sortDirection, name1, name2);
        } else if (this.m_sortColumn.equalsIgnoreCase(SORT_INSTALLED_VERSION)) {
            String version1 = ((ModuleData)object1).getInstalledVersion();
            String version2 = ((ModuleData)object2).getInstalledVersion();
            compare = this.compareVersion(this.m_sortDirection, version1, version2);
        } else if (this.m_sortColumn.equalsIgnoreCase(SORT_AVAILABLE_VERSION)) {
            String version1 = ((ModuleData)object1).getAvailableVersion();
            String version2 = ((ModuleData)object2).getAvailableVersion();
            compare = this.compareVersion(this.m_sortDirection, version1, version2);
        } else if (this.m_sortColumn.equalsIgnoreCase(SORT_TYPE)) {
            String type1 = ((ContentData)object1).getContentType();
            String type2 = ((ContentData)object2).getContentType();
            compare = this.compareString(this.m_sortDirection, type1, type2);
        }
        return compare;
    }

    private int compareString(String sortDirection, String object1, String object2) {
        int compare = 0;
        compare = sortDirection.equalsIgnoreCase(SORT_DESCENDING) ? this.m_collator.compare(object1, object2) : this.m_collator.compare(object2, object1);
        return compare;
    }

    private int compareVersion(String sortDirection, String object1, String object2) {
        int compare = 0;
        VersionInfo version1 = null;
        VersionInfo version2 = null;
        version1 = object1 == null || object1.length() == 0 || object1.equalsIgnoreCase(eMFrameUtils.getLocalizedString("FwResources", "RBSConfiguration.NotApplicable", this.m_context.getLocale())) ? new VersionInfo() : new VersionInfo(object1);
        version2 = object2 == null || object2.length() == 0 || object2.equalsIgnoreCase(eMFrameUtils.getLocalizedString("FwResources", "RBSConfiguration.NotApplicable", this.m_context.getLocale())) ? new VersionInfo() : new VersionInfo(object2);
        compare = sortDirection.equalsIgnoreCase(SORT_DESCENDING) ? version1.compareTo(version2) : version2.compareTo(version1);
        return compare;
    }
}

