/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.fw.RoleRightsReport;
import java.text.Collator;
import java.util.Comparator;

public class RBSRoleRightsReportSort
implements Comparator {
    public static final String SORT_DESCENDING = "descending";
    public static final String SORT_ASCENDING = "ascending";
    public static final String SORT_TASK_NAME = "sortTaskName";
    public static final String SORT_TASK_OBJECT = "sortTaskObject";
    public static final String SORT_ATTR_NAME = "sortAttributeName";
    Collator m_collator = null;
    TaskContext m_context = null;
    String m_sortColumn = null;
    String m_sortDirection = null;

    public RBSRoleRightsReportSort(TaskContext context, String sortColumn, String sortDirection) {
        this.m_context = context;
        this.m_sortColumn = sortColumn;
        this.m_sortDirection = sortDirection;
        this.m_collator = Collator.getInstance(this.m_context.getBrowserLocale().getLocale());
    }

    public int compare(Object object1, Object object2) {
        int compare = 0;
        if (this.m_sortColumn.equalsIgnoreCase(SORT_TASK_NAME)) {
            String taskName1 = ((RoleRightsReport.RBSTaskRightsReport)object1).getTaskDisplayName();
            String taskName2 = ((RoleRightsReport.RBSTaskRightsReport)object2).getTaskDisplayName();
            compare = this.compareString(this.m_sortDirection, taskName1, taskName2);
        } else if (this.m_sortColumn.equalsIgnoreCase(SORT_TASK_OBJECT)) {
            String taskObject1 = ((RoleRightsReport.RBSTaskRightsReport)object1).getTaskFDN();
            String taskObject2 = ((RoleRightsReport.RBSTaskRightsReport)object2).getTaskFDN();
            compare = this.compareString(this.m_sortDirection, taskObject1, taskObject2);
        } else if (this.m_sortColumn.equalsIgnoreCase(SORT_ATTR_NAME)) {
            String taskObject1 = ((RoleRightsReport.RBSTaskRightsReport)object1).getAttrName();
            String taskObject2 = ((RoleRightsReport.RBSTaskRightsReport)object2).getAttrName();
            compare = this.compareString(this.m_sortDirection, taskObject1, taskObject2);
        }
        return compare;
    }

    private int compareString(String sortDirection, String object1, String object2) {
        int compare = 0;
        compare = sortDirection.equals(SORT_DESCENDING) ? this.m_collator.compare(object1, object2) : this.m_collator.compare(object2, object1);
        return compare;
    }
}

