/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.emframe.dev.D;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.XmlUtils;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.CollectionsReportClass;
import com.novell.emframe.fw.CustomCategoriesClass;
import com.novell.emframe.fw.CustomRolesClass;
import com.novell.emframe.fw.CustomTasksClass;
import com.novell.emframe.fw.RoleRightsReport;
import com.novell.emframe.fw.UnassignedCategoriesClass;
import com.novell.emframe.fw.UnassignedRolesClass;
import com.novell.emframe.fw.UnassignedTasksClass;
import com.novell.rbs.RBSRoleReport;
import com.novell.rbs.RBSTaskReport;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ReportsExportUtil {
    private static final String XML_RBS_REPORT = "rbs-report";
    private static final String XML_RBS_RECORD = "rbs-record";
    private static final String XML_RBS_ROLE_NAME = "role-name";
    private static final String XML_RBS_ROLE_OBJECT = "role-object";
    private static final String XML_RBS_MEMBER_OBJECT = "member-object";
    private static final String XML_RBS_MEMBER_TYPE = "member-type";
    private static final String XML_RBS_COLLECTION_OBJECT = "collection-object";
    private static final String XML_RBS_USER_OBJECT = "user-object";
    private static final String XML_RBS_TASK_NAME = "task-name";
    private static final String XML_RBS_TASK_OBJECT = "task-object";
    private static final String XML_RBS_ATTRIBUTE_NAME = "attribute-name";
    private static final String XML_RBS_PRIVILEGE = "privilege";
    private static final String XML_RBS_SCOPE = "scope";
    private static final String XML_RBS_INHERITED = "rights-inherit";
    private static final String XML_RBS_RIGHTS_SET = "rights-assigned";
    private static final String XML_RBS_CREATOR_OBJECT = "creator-object";
    private static final String XML_RBS_CREATION_DATE = "creation-date";
    private static final String XML_RBS_CATEGORY_NAME = "category-name";
    private static final String XML_RBS_CATEGORY_OBJECT = "category-object";
    private static final String XML_RBS_OWNER_OBJECT = "owner-object";
    private static final String XML_RBS_VERSION = "version";
    private static final String HTMLPARAM_REPORT_TYPE = "ReportType";
    private static final String REPORT_TYPE_XML = "XML";
    private static final String REPORT_TYPE_TXT = "TXT";
    private static final String REPORT_TYPE_SCV = "CSV";
    private static final String XML_FILE_VERSION_HEADER = "<?xml version=\"1.0\" encoding=\"utf-8\"?>";
    private static final String XML_FILE_STYLESHEET_HEADER = "<?xml-stylesheet type=\"text/xsl\" href=\"/nps/temp/RBSReport.xsl\"?>";
    private static final String XML_RBS_REPORT_HEADER = "rbs-report-header";
    private static final String XML_RBS_SELECTED_USERFDN = "user";
    private static final String XML_RBS_REPORT_TIME = "report-time";
    private static final String XML_RBS_MEMBER_TYPES = "selected-memeber-types";
    private static final String XML_RBS_DYN_GRP_CHECKED = "dynamic-group";
    private static final String XML_RBS_SEARCH_ENABLED = "search-enabled";
    private static final String XML_RBS_ROLE_SEARCH = "role-search";
    private static final String XML_RBS_SEARCH_TYPE = "search-for";
    private static final String XML_RBS_CONTAINER_ROLE = "container-role-search";
    TaskContext m_taskContext;
    ArrayList m_report = null;
    Vector m_reportsCreated = new Vector();

    public ReportsExportUtil(TaskContext taskContext, ArrayList reportList) {
        this.m_taskContext = taskContext;
        this.m_report = reportList;
        String sFullpath = this.m_taskContext.getWebappHome().getAbsolutePath() + "/temp";
        File fTemp = new File(sFullpath);
        fTemp.mkdirs();
    }

    public void exportRoleRightsReport() {
        HttpServletRequest req = this.m_taskContext.getRequest();
        String sReportType = req.getParameter(HTMLPARAM_REPORT_TYPE);
        if (sReportType != null) {
            String sFileName = null;
            if (sReportType.equalsIgnoreCase(REPORT_TYPE_XML)) {
                sFileName = this.doRightsXMLReport(false);
            } else if (sReportType.equalsIgnoreCase(REPORT_TYPE_TXT)) {
                sFileName = this.doRightsTextReport();
            } else if (sReportType.equalsIgnoreCase(REPORT_TYPE_SCV)) {
                sFileName = this.doRightsCSVReport();
            }
            if (sFileName != null) {
                req.setAttribute("NPPostRequestActions", (Object)sFileName);
            }
        }
    }

    public void exportUnassignedRolesReport() {
        HttpServletRequest req = this.m_taskContext.getRequest();
        String sReportType = req.getParameter(HTMLPARAM_REPORT_TYPE);
        if (sReportType != null) {
            String sFileName = null;
            if (sReportType.equalsIgnoreCase(REPORT_TYPE_XML)) {
                sFileName = this.doUnassignedRolesXMLReport(false);
            } else if (sReportType.equalsIgnoreCase(REPORT_TYPE_TXT)) {
                sFileName = this.doUnassignedRolesTEXTReport();
            } else if (sReportType.equalsIgnoreCase(REPORT_TYPE_SCV)) {
                sFileName = this.doUnassignedRolesCSVReport();
            }
            if (sFileName != null) {
                req.setAttribute("NPPostRequestActions", (Object)sFileName);
            }
        }
    }

    public void exportCustomRolesReport() {
        HttpServletRequest req = this.m_taskContext.getRequest();
        String sReportType = req.getParameter(HTMLPARAM_REPORT_TYPE);
        if (sReportType != null) {
            String sFileName = null;
            if (sReportType.equalsIgnoreCase(REPORT_TYPE_XML)) {
                sFileName = this.doCustomRolesXMLReport(false);
            } else if (sReportType.equalsIgnoreCase(REPORT_TYPE_TXT)) {
                sFileName = this.doCustomRolesTEXTReport();
            } else if (sReportType.equalsIgnoreCase(REPORT_TYPE_SCV)) {
                sFileName = this.doCustomRolesCSVReport();
            }
            if (sFileName != null) {
                req.setAttribute("NPPostRequestActions", (Object)sFileName);
            }
        }
    }

    public void exportCustomTasksReport() {
        HttpServletRequest req = this.m_taskContext.getRequest();
        String sReportType = req.getParameter(HTMLPARAM_REPORT_TYPE);
        if (sReportType != null) {
            String sFileName = null;
            if (sReportType.equalsIgnoreCase(REPORT_TYPE_XML)) {
                sFileName = this.doCustomTasksXMLReport(false);
            } else if (sReportType.equalsIgnoreCase(REPORT_TYPE_TXT)) {
                sFileName = this.doCustomTasksTEXTReport();
            } else if (sReportType.equalsIgnoreCase(REPORT_TYPE_SCV)) {
                sFileName = this.doCustomTasksCSVReport();
            }
            if (sFileName != null) {
                req.setAttribute("NPPostRequestActions", (Object)sFileName);
            }
        }
    }

    public void exportCustomCategoriesReport() {
        HttpServletRequest req = this.m_taskContext.getRequest();
        String sReportType = req.getParameter(HTMLPARAM_REPORT_TYPE);
        if (sReportType != null) {
            String sFileName = null;
            if (sReportType.equalsIgnoreCase(REPORT_TYPE_XML)) {
                sFileName = this.doCustomCategoriesXMLReport(false);
            } else if (sReportType.equalsIgnoreCase(REPORT_TYPE_TXT)) {
                sFileName = this.doCustomCategoriesTEXTReport();
            } else if (sReportType.equalsIgnoreCase(REPORT_TYPE_SCV)) {
                sFileName = this.doCustomCategoriesCSVReport();
            }
            if (sFileName != null) {
                req.setAttribute("NPPostRequestActions", (Object)sFileName);
            }
        }
    }

    public void exportUnassignedCategoriesReport() {
        HttpServletRequest req = this.m_taskContext.getRequest();
        String sReportType = req.getParameter(HTMLPARAM_REPORT_TYPE);
        if (sReportType != null) {
            String sFileName = null;
            if (sReportType.equalsIgnoreCase(REPORT_TYPE_XML)) {
                sFileName = this.doUnassignedCategoriesXMLReport(false);
            } else if (sReportType.equalsIgnoreCase(REPORT_TYPE_TXT)) {
                sFileName = this.doUnassignedCategoriesTEXTReport();
            } else if (sReportType.equalsIgnoreCase(REPORT_TYPE_SCV)) {
                sFileName = this.doUnassignedCategoriesCSVReport();
            }
            if (sFileName != null) {
                req.setAttribute("NPPostRequestActions", (Object)sFileName);
            }
        }
    }

    public void exportUnassignedTasksReport() {
        HttpServletRequest req = this.m_taskContext.getRequest();
        String sReportType = req.getParameter(HTMLPARAM_REPORT_TYPE);
        if (sReportType != null) {
            String sFileName = null;
            if (sReportType.equalsIgnoreCase(REPORT_TYPE_XML)) {
                sFileName = this.doUnassignedTasksXMLReport(false);
            } else if (sReportType.equalsIgnoreCase(REPORT_TYPE_TXT)) {
                sFileName = this.doUnassignedTasksTEXTReport();
            } else if (sReportType.equalsIgnoreCase(REPORT_TYPE_SCV)) {
                sFileName = this.doUnassignedTasksCSVReport();
            }
            if (sFileName != null) {
                req.setAttribute("NPPostRequestActions", (Object)sFileName);
            }
        }
    }

    public boolean sendRedirect(HttpServletRequest req, HttpServletResponse resp) {
        String sFileName = (String)req.getAttribute("NPPostRequestActions");
        if (sFileName != null) {
            Vector okFiles = (Vector)this.m_taskContext.getAuthAttribute("dev.DownloadableFiles");
            okFiles.add("temp/" + sFileName);
            String sServerURL = req.getRequestURL().toString();
            String url = sServerURL + "?taskId=fw.DownloadFile&file=temp/" + sFileName;
            try {
                resp.sendRedirect(url);
            }
            catch (IOException e) {
                D.log(e);
            }
            return true;
        }
        return false;
    }

    public String doRightsXMLReport(boolean b_includeStyleSheet) {
        String sFileName = System.currentTimeMillis() + ".xml";
        String sFullpath = this.m_taskContext.getWebappHome().getAbsolutePath() + "/temp/" + sFileName;
        File file = new File(sFullpath);
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(file));
            this.writeRightsXMLBuffer(bw, b_includeStyleSheet);
            this.m_reportsCreated.add(sFullpath);
            return sFileName;
        }
        catch (IOException e) {
            D.log(e);
            return null;
        }
    }

    private void writeRightsXMLBuffer(BufferedWriter bw, boolean bIncludeStylesheet) throws IOException {
        bw.write(XML_FILE_VERSION_HEADER);
        if (bIncludeStylesheet) {
            bw.write(XML_FILE_STYLESHEET_HEADER);
        }
        XmlUtils.writeStartTag(XML_RBS_REPORT, bw);
        for (int i = 0; i < this.m_report.size(); ++i) {
            XmlUtils.writeStartTag(XML_RBS_RECORD, bw);
            RoleRightsReport.RBSTaskRightsReport rbsRightsReport = (RoleRightsReport.RBSTaskRightsReport)this.m_report.get(i);
            XmlUtils.writeTag(XML_RBS_TASK_NAME, new String(rbsRightsReport.getTaskDisplayName().getBytes("UTF-8")), bw);
            XmlUtils.writeTag(XML_RBS_TASK_OBJECT, new String(rbsRightsReport.getTaskFDN().getBytes("UTF-8")), bw);
            XmlUtils.writeTag(XML_RBS_ATTRIBUTE_NAME, rbsRightsReport.getAttrName(), bw);
            XmlUtils.writeTag(XML_RBS_PRIVILEGE, new String(rbsRightsReport.getPrivDisplayName().getBytes("UTF-8")), bw);
            XmlUtils.writeEndTag(XML_RBS_RECORD, bw);
        }
        XmlUtils.writeEndTag(XML_RBS_REPORT, bw);
        bw.close();
    }

    public String doRightsCSVReport() {
        String sFileName = System.currentTimeMillis() + ".csv";
        String sFullpath = this.m_taskContext.getWebappHome().getAbsolutePath() + "/temp/" + sFileName;
        File file = new File(sFullpath);
        try {
            FileWriter fw = new FileWriter(file);
            BufferedWriter bw = new BufferedWriter(fw);
            String taskName = eMFrameUtils.getLocalizedString("FwResources", "TasksToUserReport.TaskName", this.m_taskContext.getLocale());
            bw.write("\"" + taskName + "\",");
            String taskObject = eMFrameUtils.getLocalizedString("FwResources", "TasksToUserReport.TaskObject", this.m_taskContext.getLocale());
            bw.write("\"" + taskObject + "\",");
            String attrName = eMFrameUtils.getLocalizedString("FwResources", "RoleRightsReport.AttrName", this.m_taskContext.getLocale());
            bw.write("\"" + attrName + "\",");
            String privilege = eMFrameUtils.getLocalizedString("FwResources", "RoleRightsReport.Privilege", this.m_taskContext.getLocale());
            bw.write("\"" + privilege + "\",");
            bw.write(13);
            bw.write(10);
            for (int i = 0; i < this.m_report.size(); ++i) {
                RoleRightsReport.RBSTaskRightsReport rbsTaskReport = (RoleRightsReport.RBSTaskRightsReport)this.m_report.get(i);
                bw.write("\"" + rbsTaskReport.getTaskDisplayName() + "\",");
                bw.write("\"" + rbsTaskReport.getTaskFDN() + "\",");
                bw.write("\"" + rbsTaskReport.getAttrName() + "\",");
                bw.write("\"" + rbsTaskReport.getPrivDisplayName() + "\"");
                bw.write(13);
                bw.write(10);
            }
            bw.close();
            this.m_reportsCreated.add(sFullpath);
            return sFileName;
        }
        catch (IOException e) {
            D.log(e);
            return null;
        }
    }

    public String doRightsTextReport() {
        String sFileName = System.currentTimeMillis() + ".txt";
        String sFullpath = this.m_taskContext.getWebappHome().getAbsolutePath() + "/temp/" + sFileName;
        File file = new File(sFullpath);
        try {
            FileWriter fw = new FileWriter(file);
            BufferedWriter bw = new BufferedWriter(fw);
            for (int i = 0; i < this.m_report.size(); ++i) {
                RoleRightsReport.RBSTaskRightsReport rbsTaskReport = (RoleRightsReport.RBSTaskRightsReport)this.m_report.get(i);
                String taskName = eMFrameUtils.getLocalizedString("FwResources", "TasksToUserReport.TaskName", this.m_taskContext.getLocale());
                bw.write(taskName + ": ");
                bw.write(rbsTaskReport.getTaskDisplayName());
                bw.write(13);
                bw.write(10);
                String taskObject = eMFrameUtils.getLocalizedString("FwResources", "TasksToUserReport.TaskObject", this.m_taskContext.getLocale());
                bw.write(taskObject + ": ");
                bw.write(rbsTaskReport.getTaskFDN());
                bw.write(13);
                bw.write(10);
                String attrName = eMFrameUtils.getLocalizedString("FwResources", "RoleRightsReport.AttrName", this.m_taskContext.getLocale());
                bw.write(attrName + ": ");
                bw.write(rbsTaskReport.getAttrName());
                bw.write(13);
                bw.write(10);
                String privilege = eMFrameUtils.getLocalizedString("FwResources", "RoleRightsReport.Privilege", this.m_taskContext.getLocale());
                bw.write(privilege + ": ");
                bw.write(rbsTaskReport.getPrivDisplayName());
                bw.write(13);
                bw.write(10);
                bw.write("-------------------------------------------------");
                bw.write(13);
                bw.write(10);
            }
            bw.close();
            this.m_reportsCreated.add(sFullpath);
            return sFileName;
        }
        catch (IOException e) {
            D.log(e);
            return null;
        }
    }

    protected void finalize() throws Throwable {
        if (this.m_reportsCreated.size() > 0) {
            for (int i = 0; i < this.m_reportsCreated.size(); ++i) {
                String s = (String)this.m_reportsCreated.elementAt(i);
                try {
                    File sFile = new File(s);
                    sFile.delete();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public String doUnassignedRolesXMLReport(boolean b_includeStyleSheet) {
        String sFileName = System.currentTimeMillis() + ".xml";
        String sFullpath = this.m_taskContext.getWebappHome().getAbsolutePath() + "/temp/" + sFileName;
        File file = new File(sFullpath);
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(file));
            this.writeUnassignedRolesXMLBuffer(bw, b_includeStyleSheet);
            this.m_reportsCreated.add(sFullpath);
            return sFileName;
        }
        catch (IOException e) {
            D.log(e);
            return null;
        }
    }

    private void writeUnassignedRolesXMLBuffer(BufferedWriter bw, boolean bIncludeStylesheet) throws IOException {
        bw.write(XML_FILE_VERSION_HEADER);
        if (bIncludeStylesheet) {
            bw.write(XML_FILE_STYLESHEET_HEADER);
        }
        XmlUtils.writeStartTag(XML_RBS_REPORT, bw);
        for (int i = 0; i < this.m_report.size(); ++i) {
            XmlUtils.writeStartTag(XML_RBS_RECORD, bw);
            UnassignedRolesClass unassignedRolesClass = (UnassignedRolesClass)this.m_report.get(i);
            XmlUtils.writeTag(XML_RBS_ROLE_NAME, new String(unassignedRolesClass.getRoleDisplayName().getBytes("UTF-8")), bw);
            XmlUtils.writeTag(XML_RBS_ROLE_OBJECT, new String(unassignedRolesClass.getRoleFDN().getBytes("UTF-8")), bw);
            XmlUtils.writeTag(XML_RBS_COLLECTION_OBJECT, new String(unassignedRolesClass.getCollectionFDN().getBytes("UTF-8")), bw);
            XmlUtils.writeEndTag(XML_RBS_RECORD, bw);
        }
        XmlUtils.writeEndTag(XML_RBS_REPORT, bw);
        bw.close();
    }

    public String doUnassignedRolesTEXTReport() {
        String sFileName = System.currentTimeMillis() + ".txt";
        String sFullpath = this.m_taskContext.getWebappHome().getAbsolutePath() + "/temp/" + sFileName;
        File file = new File(sFullpath);
        try {
            FileWriter fw = new FileWriter(file);
            BufferedWriter bw = new BufferedWriter(fw);
            for (int i = 0; i < this.m_report.size(); ++i) {
                UnassignedRolesClass unassignedRolesClass = (UnassignedRolesClass)this.m_report.get(i);
                String roleName = eMFrameUtils.getLocalizedString("FwResources", "UnassignedRolesReport.RoleName", this.m_taskContext.getLocale());
                bw.write(roleName + ": ");
                bw.write(unassignedRolesClass.getRoleDisplayName());
                bw.write(13);
                bw.write(10);
                String roleObject = eMFrameUtils.getLocalizedString("FwResources", "UnassignedRolesReport.RoleObject", this.m_taskContext.getLocale());
                bw.write(roleObject + ": ");
                bw.write(unassignedRolesClass.getRoleFDN());
                bw.write(13);
                bw.write(10);
                String collectionObject = eMFrameUtils.getLocalizedString("FwResources", "UnassignedRolesReport.CollectionObject", this.m_taskContext.getLocale());
                bw.write(collectionObject + ": ");
                bw.write(unassignedRolesClass.getCollectionFDN());
                bw.write(13);
                bw.write(10);
                bw.write("-------------------------------------------------");
                bw.write(13);
                bw.write(10);
            }
            bw.close();
            this.m_reportsCreated.add(sFullpath);
            return sFileName;
        }
        catch (IOException e) {
            D.log(e);
            return null;
        }
    }

    public String doUnassignedRolesCSVReport() {
        String sFileName = System.currentTimeMillis() + ".csv";
        String sFullpath = this.m_taskContext.getWebappHome().getAbsolutePath() + "/temp/" + sFileName;
        File file = new File(sFullpath);
        try {
            FileWriter fw = new FileWriter(file);
            BufferedWriter bw = new BufferedWriter(fw);
            String roleName = eMFrameUtils.getLocalizedString("FwResources", "UnassignedRolesReport.RoleName", this.m_taskContext.getLocale());
            bw.write("\"" + roleName + "\",");
            String roleObject = eMFrameUtils.getLocalizedString("FwResources", "UnassignedRolesReport.RoleObject", this.m_taskContext.getLocale());
            bw.write("\"" + roleObject + "\",");
            String collectionObject = eMFrameUtils.getLocalizedString("FwResources", "UnassignedRolesReport.CollectionObject", this.m_taskContext.getLocale());
            bw.write("\"" + collectionObject + "\",");
            bw.write(13);
            bw.write(10);
            for (int i = 0; i < this.m_report.size(); ++i) {
                UnassignedRolesClass unassignedRolesClass = (UnassignedRolesClass)this.m_report.get(i);
                bw.write("\"" + unassignedRolesClass.getRoleDisplayName() + "\",");
                bw.write("\"" + unassignedRolesClass.getRoleFDN() + "\",");
                bw.write("\"" + unassignedRolesClass.getCollectionFDN() + "\",");
                bw.write(13);
                bw.write(10);
            }
            bw.close();
            this.m_reportsCreated.add(sFullpath);
            return sFileName;
        }
        catch (IOException e) {
            D.log(e);
            return null;
        }
    }

    public String doUnassignedTasksXMLReport(boolean b_includeStyleSheet) {
        String sFileName = System.currentTimeMillis() + ".xml";
        String sFullpath = this.m_taskContext.getWebappHome().getAbsolutePath() + "/temp/" + sFileName;
        File file = new File(sFullpath);
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(file));
            this.writeUnassignedTasksXMLBuffer(bw, b_includeStyleSheet);
            this.m_reportsCreated.add(sFullpath);
            return sFileName;
        }
        catch (IOException e) {
            D.log(e);
            return null;
        }
    }

    private void writeUnassignedTasksXMLBuffer(BufferedWriter bw, boolean bIncludeStylesheet) throws IOException {
        bw.write(XML_FILE_VERSION_HEADER);
        if (bIncludeStylesheet) {
            bw.write(XML_FILE_STYLESHEET_HEADER);
        }
        XmlUtils.writeStartTag(XML_RBS_REPORT, bw);
        for (int i = 0; i < this.m_report.size(); ++i) {
            XmlUtils.writeStartTag(XML_RBS_RECORD, bw);
            UnassignedTasksClass unassignedTasksClass = (UnassignedTasksClass)this.m_report.get(i);
            XmlUtils.writeTag(XML_RBS_TASK_NAME, new String(unassignedTasksClass.getTaskDisplayName().getBytes("UTF-8")), bw);
            XmlUtils.writeTag(XML_RBS_TASK_OBJECT, new String(unassignedTasksClass.getTaskFDN().getBytes("UTF-8")), bw);
            XmlUtils.writeTag(XML_RBS_COLLECTION_OBJECT, new String(unassignedTasksClass.getCollectionFDN().getBytes("UTF-8")), bw);
            XmlUtils.writeEndTag(XML_RBS_RECORD, bw);
        }
        XmlUtils.writeEndTag(XML_RBS_REPORT, bw);
        bw.close();
    }

    public String doUnassignedTasksTEXTReport() {
        String sFileName = System.currentTimeMillis() + ".txt";
        String sFullpath = this.m_taskContext.getWebappHome().getAbsolutePath() + "/temp/" + sFileName;
        File file = new File(sFullpath);
        try {
            FileWriter fw = new FileWriter(file);
            BufferedWriter bw = new BufferedWriter(fw);
            for (int i = 0; i < this.m_report.size(); ++i) {
                UnassignedTasksClass unassignedTasksClass = (UnassignedTasksClass)this.m_report.get(i);
                String taskName = eMFrameUtils.getLocalizedString("FwResources", "UnassignedTasksReport.TaskName", this.m_taskContext.getLocale());
                bw.write(taskName + ": ");
                bw.write(unassignedTasksClass.getTaskDisplayName());
                bw.write(13);
                bw.write(10);
                String taskObject = eMFrameUtils.getLocalizedString("FwResources", "UnassignedTasksReport.TaskObject", this.m_taskContext.getLocale());
                bw.write(taskObject + ": ");
                bw.write(unassignedTasksClass.getTaskFDN());
                bw.write(13);
                bw.write(10);
                String collectionObject = eMFrameUtils.getLocalizedString("FwResources", "UnassignedTasksReport.CollectionObject", this.m_taskContext.getLocale());
                bw.write(collectionObject + ": ");
                bw.write(unassignedTasksClass.getCollectionFDN());
                bw.write(13);
                bw.write(10);
                bw.write("-------------------------------------------------");
                bw.write(13);
                bw.write(10);
            }
            bw.close();
            this.m_reportsCreated.add(sFullpath);
            return sFileName;
        }
        catch (IOException e) {
            D.log(e);
            return null;
        }
    }

    public String doUnassignedTasksCSVReport() {
        String sFileName = System.currentTimeMillis() + ".csv";
        String sFullpath = this.m_taskContext.getWebappHome().getAbsolutePath() + "/temp/" + sFileName;
        File file = new File(sFullpath);
        try {
            FileWriter fw = new FileWriter(file);
            BufferedWriter bw = new BufferedWriter(fw);
            String taskName = eMFrameUtils.getLocalizedString("FwResources", "UnassignedTasksReport.TaskName", this.m_taskContext.getLocale());
            bw.write("\"" + taskName + "\",");
            String taskObject = eMFrameUtils.getLocalizedString("FwResources", "UnassignedTasksReport.TaskObject", this.m_taskContext.getLocale());
            bw.write("\"" + taskObject + "\",");
            String collectionObject = eMFrameUtils.getLocalizedString("FwResources", "UnassignedTasksReport.CollectionObject", this.m_taskContext.getLocale());
            bw.write("\"" + collectionObject + "\",");
            bw.write(13);
            bw.write(10);
            for (int i = 0; i < this.m_report.size(); ++i) {
                UnassignedTasksClass unassignedTasksClass = (UnassignedTasksClass)this.m_report.get(i);
                bw.write("\"" + unassignedTasksClass.getTaskDisplayName() + "\",");
                bw.write("\"" + unassignedTasksClass.getTaskFDN() + "\",");
                bw.write("\"" + unassignedTasksClass.getCollectionFDN() + "\",");
                bw.write(13);
                bw.write(10);
            }
            bw.close();
            this.m_reportsCreated.add(sFullpath);
            return sFileName;
        }
        catch (IOException e) {
            D.log(e);
            return null;
        }
    }

    public String doCustomRolesXMLReport(boolean b_includeStyleSheet) {
        String sFileName = System.currentTimeMillis() + ".xml";
        String sFullpath = this.m_taskContext.getWebappHome().getAbsolutePath() + "/temp/" + sFileName;
        File file = new File(sFullpath);
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(file));
            this.writeCustomRolesXMLBuffer(bw, b_includeStyleSheet);
            this.m_reportsCreated.add(sFullpath);
            return sFileName;
        }
        catch (IOException e) {
            D.log(e);
            return null;
        }
    }

    private void writeCustomRolesXMLBuffer(BufferedWriter bw, boolean bIncludeStylesheet) throws IOException {
        bw.write(XML_FILE_VERSION_HEADER);
        if (bIncludeStylesheet) {
            bw.write(XML_FILE_STYLESHEET_HEADER);
        }
        XmlUtils.writeStartTag(XML_RBS_REPORT, bw);
        for (int i = 0; i < this.m_report.size(); ++i) {
            XmlUtils.writeStartTag(XML_RBS_RECORD, bw);
            CustomRolesClass customRolesClass = (CustomRolesClass)this.m_report.get(i);
            XmlUtils.writeTag(XML_RBS_ROLE_NAME, new String(customRolesClass.getRoleDisplayName().getBytes("UTF-8")), bw);
            XmlUtils.writeTag(XML_RBS_ROLE_OBJECT, new String(customRolesClass.getRoleFDN().getBytes("UTF-8")), bw);
            XmlUtils.writeTag(XML_RBS_COLLECTION_OBJECT, new String(customRolesClass.getCollectionFDN().getBytes("UTF-8")), bw);
            XmlUtils.writeTag(XML_RBS_CREATOR_OBJECT, new String(customRolesClass.getCreatorFDN().getBytes("UTF-8")), bw);
            XmlUtils.writeTag(XML_RBS_CREATION_DATE, customRolesClass.getCreationDate(), bw);
            XmlUtils.writeEndTag(XML_RBS_RECORD, bw);
        }
        XmlUtils.writeEndTag(XML_RBS_REPORT, bw);
        bw.close();
    }

    public String doCustomRolesTEXTReport() {
        String sFileName = System.currentTimeMillis() + ".txt";
        String sFullpath = this.m_taskContext.getWebappHome().getAbsolutePath() + "/temp/" + sFileName;
        File file = new File(sFullpath);
        try {
            FileWriter fw = new FileWriter(file);
            BufferedWriter bw = new BufferedWriter(fw);
            for (int i = 0; i < this.m_report.size(); ++i) {
                CustomRolesClass customRolesClass = (CustomRolesClass)this.m_report.get(i);
                String roleName = eMFrameUtils.getLocalizedString("FwResources", "CustomRolesReport.RoleName", this.m_taskContext.getLocale());
                bw.write(roleName + ": ");
                bw.write(customRolesClass.getRoleDisplayName());
                bw.write(13);
                bw.write(10);
                String roleObject = eMFrameUtils.getLocalizedString("FwResources", "CustomRolesReport.RoleObject", this.m_taskContext.getLocale());
                bw.write(roleObject + ": ");
                bw.write(customRolesClass.getRoleFDN());
                bw.write(13);
                bw.write(10);
                String collectionObject = eMFrameUtils.getLocalizedString("FwResources", "CustomRolesReport.CollectionObject", this.m_taskContext.getLocale());
                bw.write(collectionObject + ": ");
                bw.write(customRolesClass.getCollectionFDN());
                bw.write(13);
                bw.write(10);
                String creatorObject = eMFrameUtils.getLocalizedString("FwResources", "CustomTasksReport.CreatorObject", this.m_taskContext.getLocale());
                bw.write(creatorObject + ": ");
                bw.write(customRolesClass.getCreatorFDN());
                bw.write(13);
                bw.write(10);
                String creationDate = eMFrameUtils.getLocalizedString("FwResources", "CustomTasksReport.CreationDate", this.m_taskContext.getLocale());
                bw.write(creationDate + ": ");
                bw.write(customRolesClass.getCreationDate());
                bw.write(13);
                bw.write(10);
                bw.write("-------------------------------------------------");
                bw.write(13);
                bw.write(10);
            }
            bw.close();
            this.m_reportsCreated.add(sFullpath);
            return sFileName;
        }
        catch (IOException e) {
            D.log(e);
            return null;
        }
    }

    public String doCustomRolesCSVReport() {
        String sFileName = System.currentTimeMillis() + ".csv";
        String sFullpath = this.m_taskContext.getWebappHome().getAbsolutePath() + "/temp/" + sFileName;
        File file = new File(sFullpath);
        try {
            FileWriter fw = new FileWriter(file);
            BufferedWriter bw = new BufferedWriter(fw);
            String roleName = eMFrameUtils.getLocalizedString("FwResources", "CustomRolesReport.RoleName", this.m_taskContext.getLocale());
            bw.write("\"" + roleName + "\",");
            String roleObject = eMFrameUtils.getLocalizedString("FwResources", "CustomRolesReport.RoleObject", this.m_taskContext.getLocale());
            bw.write("\"" + roleObject + "\",");
            String collectionObject = eMFrameUtils.getLocalizedString("FwResources", "CustomRolesReport.CollectionObject", this.m_taskContext.getLocale());
            bw.write("\"" + collectionObject + "\",");
            String creatorObject = eMFrameUtils.getLocalizedString("FwResources", "CustomTasksReport.CreatorObject", this.m_taskContext.getLocale());
            bw.write("\"" + creatorObject + "\",");
            String creationDate = eMFrameUtils.getLocalizedString("FwResources", "CustomTasksReport.CreationDate", this.m_taskContext.getLocale());
            bw.write("\"" + creationDate + "\",");
            bw.write(13);
            bw.write(10);
            for (int i = 0; i < this.m_report.size(); ++i) {
                CustomRolesClass customRolesClass = (CustomRolesClass)this.m_report.get(i);
                bw.write("\"" + customRolesClass.getRoleDisplayName() + "\",");
                bw.write("\"" + customRolesClass.getRoleFDN() + "\",");
                bw.write("\"" + customRolesClass.getCollectionFDN() + "\",");
                bw.write("\"" + customRolesClass.getCreatorFDN() + "\",");
                bw.write("\"" + customRolesClass.getCreationDate() + "\",");
                bw.write(13);
                bw.write(10);
            }
            bw.close();
            this.m_reportsCreated.add(sFullpath);
            return sFileName;
        }
        catch (IOException e) {
            D.log(e);
            return null;
        }
    }

    public String doCustomTasksXMLReport(boolean b_includeStyleSheet) {
        String sFileName = System.currentTimeMillis() + ".xml";
        String sFullpath = this.m_taskContext.getWebappHome().getAbsolutePath() + "/temp/" + sFileName;
        File file = new File(sFullpath);
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(file));
            this.writeCustomTasksXMLBuffer(bw, b_includeStyleSheet);
            this.m_reportsCreated.add(sFullpath);
            return sFileName;
        }
        catch (IOException e) {
            D.log(e);
            return null;
        }
    }

    private void writeCustomTasksXMLBuffer(BufferedWriter bw, boolean bIncludeStylesheet) throws IOException {
        bw.write(XML_FILE_VERSION_HEADER);
        if (bIncludeStylesheet) {
            bw.write(XML_FILE_STYLESHEET_HEADER);
        }
        XmlUtils.writeStartTag(XML_RBS_REPORT, bw);
        for (int i = 0; i < this.m_report.size(); ++i) {
            XmlUtils.writeStartTag(XML_RBS_RECORD, bw);
            CustomTasksClass customTasksClass = (CustomTasksClass)this.m_report.get(i);
            XmlUtils.writeTag(XML_RBS_TASK_NAME, new String(customTasksClass.getTaskDisplayName().getBytes("UTF-8")), bw);
            XmlUtils.writeTag(XML_RBS_TASK_OBJECT, new String(customTasksClass.getTaskFDN().getBytes("UTF-8")), bw);
            XmlUtils.writeTag(XML_RBS_COLLECTION_OBJECT, new String(customTasksClass.getCollectionFDN().getBytes("UTF-8")), bw);
            XmlUtils.writeTag(XML_RBS_CREATOR_OBJECT, new String(customTasksClass.getCreatorFDN().getBytes("UTF-8")), bw);
            XmlUtils.writeTag(XML_RBS_CREATION_DATE, customTasksClass.getCreationDate(), bw);
            XmlUtils.writeEndTag(XML_RBS_RECORD, bw);
        }
        XmlUtils.writeEndTag(XML_RBS_REPORT, bw);
        bw.close();
    }

    public String doCustomTasksTEXTReport() {
        String sFileName = System.currentTimeMillis() + ".txt";
        String sFullpath = this.m_taskContext.getWebappHome().getAbsolutePath() + "/temp/" + sFileName;
        File file = new File(sFullpath);
        try {
            FileWriter fw = new FileWriter(file);
            BufferedWriter bw = new BufferedWriter(fw);
            for (int i = 0; i < this.m_report.size(); ++i) {
                CustomTasksClass customTasksClass = (CustomTasksClass)this.m_report.get(i);
                String taskName = eMFrameUtils.getLocalizedString("FwResources", "CustomTasksReport.TaskName", this.m_taskContext.getLocale());
                bw.write(taskName + ": ");
                bw.write(customTasksClass.getTaskDisplayName());
                bw.write(13);
                bw.write(10);
                String taskObject = eMFrameUtils.getLocalizedString("FwResources", "CustomTasksReport.TaskObject", this.m_taskContext.getLocale());
                bw.write(taskObject + ": ");
                bw.write(customTasksClass.getTaskFDN());
                bw.write(13);
                bw.write(10);
                String collectionObject = eMFrameUtils.getLocalizedString("FwResources", "CustomTasksReport.CollectionObject", this.m_taskContext.getLocale());
                bw.write(collectionObject + ": ");
                bw.write(customTasksClass.getCollectionFDN());
                bw.write(13);
                bw.write(10);
                String creatorObject = eMFrameUtils.getLocalizedString("FwResources", "CustomTasksReport.CreatorObject", this.m_taskContext.getLocale());
                bw.write(creatorObject + ": ");
                bw.write(customTasksClass.getCreatorFDN());
                bw.write(13);
                bw.write(10);
                String creationDate = eMFrameUtils.getLocalizedString("FwResources", "CustomTasksReport.CreationDate", this.m_taskContext.getLocale());
                bw.write(creationDate + ": ");
                bw.write(customTasksClass.getCreationDate());
                bw.write(13);
                bw.write(10);
                bw.write("-------------------------------------------------");
                bw.write(13);
                bw.write(10);
            }
            bw.close();
            this.m_reportsCreated.add(sFullpath);
            return sFileName;
        }
        catch (IOException e) {
            D.log(e);
            return null;
        }
    }

    public String doCustomTasksCSVReport() {
        String sFileName = System.currentTimeMillis() + ".csv";
        String sFullpath = this.m_taskContext.getWebappHome().getAbsolutePath() + "/temp/" + sFileName;
        File file = new File(sFullpath);
        try {
            FileWriter fw = new FileWriter(file);
            BufferedWriter bw = new BufferedWriter(fw);
            String taskName = eMFrameUtils.getLocalizedString("FwResources", "CustomTasksReport.TaskName", this.m_taskContext.getLocale());
            bw.write("\"" + taskName + "\",");
            String taskObject = eMFrameUtils.getLocalizedString("FwResources", "CustomTasksReport.TaskObject", this.m_taskContext.getLocale());
            bw.write("\"" + taskObject + "\",");
            String collectionObject = eMFrameUtils.getLocalizedString("FwResources", "CustomTasksReport.CollectionObject", this.m_taskContext.getLocale());
            bw.write("\"" + collectionObject + "\",");
            String creatorObject = eMFrameUtils.getLocalizedString("FwResources", "CustomTasksReport.CreatorObject", this.m_taskContext.getLocale());
            bw.write("\"" + creatorObject + "\",");
            String creationDate = eMFrameUtils.getLocalizedString("FwResources", "CustomTasksReport.CreationDate", this.m_taskContext.getLocale());
            bw.write("\"" + creationDate + "\",");
            bw.write(13);
            bw.write(10);
            for (int i = 0; i < this.m_report.size(); ++i) {
                CustomTasksClass customTasksClass = (CustomTasksClass)this.m_report.get(i);
                bw.write("\"" + customTasksClass.getTaskDisplayName() + "\",");
                bw.write("\"" + customTasksClass.getTaskFDN() + "\",");
                bw.write("\"" + customTasksClass.getCollectionFDN() + "\",");
                bw.write("\"" + customTasksClass.getCreatorFDN() + "\",");
                bw.write("\"" + customTasksClass.getCreationDate() + "\",");
                bw.write(13);
                bw.write(10);
            }
            bw.close();
            this.m_reportsCreated.add(sFullpath);
            return sFileName;
        }
        catch (IOException e) {
            D.log(e);
            return null;
        }
    }

    public String doCustomCategoriesXMLReport(boolean b_includeStyleSheet) {
        String sFileName = System.currentTimeMillis() + ".xml";
        String sFullpath = this.m_taskContext.getWebappHome().getAbsolutePath() + "/temp/" + sFileName;
        File file = new File(sFullpath);
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(file));
            this.writeCustomCategoriesXMLBuffer(bw, b_includeStyleSheet);
            this.m_reportsCreated.add(sFullpath);
            return sFileName;
        }
        catch (IOException e) {
            D.log(e);
            return null;
        }
    }

    private void writeCustomCategoriesXMLBuffer(BufferedWriter bw, boolean bIncludeStylesheet) throws IOException {
        bw.write(XML_FILE_VERSION_HEADER);
        if (bIncludeStylesheet) {
            bw.write(XML_FILE_STYLESHEET_HEADER);
        }
        XmlUtils.writeStartTag(XML_RBS_REPORT, bw);
        for (int i = 0; i < this.m_report.size(); ++i) {
            XmlUtils.writeStartTag(XML_RBS_RECORD, bw);
            CustomCategoriesClass customCategoriesClass = (CustomCategoriesClass)this.m_report.get(i);
            XmlUtils.writeTag(XML_RBS_CATEGORY_NAME, new String(customCategoriesClass.getCategoryDisplayName().getBytes("UTF-8")), bw);
            XmlUtils.writeTag(XML_RBS_CATEGORY_OBJECT, new String(customCategoriesClass.getCategoryFDN().getBytes("UTF-8")), bw);
            XmlUtils.writeTag(XML_RBS_COLLECTION_OBJECT, new String(customCategoriesClass.getCollectionFDN().getBytes("UTF-8")), bw);
            XmlUtils.writeTag(XML_RBS_CREATOR_OBJECT, new String(customCategoriesClass.getCreatorFDN().getBytes("UTF-8")), bw);
            XmlUtils.writeTag(XML_RBS_CREATION_DATE, customCategoriesClass.getCreationDate(), bw);
            XmlUtils.writeEndTag(XML_RBS_RECORD, bw);
        }
        XmlUtils.writeEndTag(XML_RBS_REPORT, bw);
        bw.close();
    }

    public String doCustomCategoriesTEXTReport() {
        String sFileName = System.currentTimeMillis() + ".txt";
        String sFullpath = this.m_taskContext.getWebappHome().getAbsolutePath() + "/temp/" + sFileName;
        File file = new File(sFullpath);
        try {
            FileWriter fw = new FileWriter(file);
            BufferedWriter bw = new BufferedWriter(fw);
            for (int i = 0; i < this.m_report.size(); ++i) {
                CustomCategoriesClass customCategoriesClass = (CustomCategoriesClass)this.m_report.get(i);
                String categoryName = eMFrameUtils.getLocalizedString("FwResources", "CustomCategoriesReport.CategoryName", this.m_taskContext.getLocale());
                bw.write(categoryName + ": ");
                bw.write(customCategoriesClass.getCategoryDisplayName());
                bw.write(13);
                bw.write(10);
                String categoryObject = eMFrameUtils.getLocalizedString("FwResources", "CustomCategoriesReport.CategoryObject", this.m_taskContext.getLocale());
                bw.write(categoryObject + ": ");
                bw.write(customCategoriesClass.getCategoryFDN());
                bw.write(13);
                bw.write(10);
                String collectionObject = eMFrameUtils.getLocalizedString("FwResources", "CustomCategoriesReport.CollectionObject", this.m_taskContext.getLocale());
                bw.write(collectionObject + ": ");
                bw.write(customCategoriesClass.getCollectionFDN());
                bw.write(13);
                bw.write(10);
                String creatorObject = eMFrameUtils.getLocalizedString("FwResources", "CustomCategoriesReport.CreatorObject", this.m_taskContext.getLocale());
                bw.write(creatorObject + ": ");
                bw.write(customCategoriesClass.getCreatorFDN());
                bw.write(13);
                bw.write(10);
                String creationDate = eMFrameUtils.getLocalizedString("FwResources", "CustomCategoriesReport.CreationDate", this.m_taskContext.getLocale());
                bw.write(creationDate + ": ");
                bw.write(customCategoriesClass.getCreationDate());
                bw.write(13);
                bw.write(10);
                bw.write("-------------------------------------------------");
                bw.write(13);
                bw.write(10);
            }
            bw.close();
            this.m_reportsCreated.add(sFullpath);
            return sFileName;
        }
        catch (IOException e) {
            D.log(e);
            return null;
        }
    }

    public String doCustomCategoriesCSVReport() {
        String sFileName = System.currentTimeMillis() + ".csv";
        String sFullpath = this.m_taskContext.getWebappHome().getAbsolutePath() + "/temp/" + sFileName;
        File file = new File(sFullpath);
        try {
            FileWriter fw = new FileWriter(file);
            BufferedWriter bw = new BufferedWriter(fw);
            String categoryName = eMFrameUtils.getLocalizedString("FwResources", "CustomCategoriesReport.CategoryName", this.m_taskContext.getLocale());
            bw.write("\"" + categoryName + "\",");
            String categoryObject = eMFrameUtils.getLocalizedString("FwResources", "CustomCategoriesReport.CategoryObject", this.m_taskContext.getLocale());
            bw.write("\"" + categoryObject + "\",");
            String collectionObject = eMFrameUtils.getLocalizedString("FwResources", "CustomCategoriesReport.CollectionObject", this.m_taskContext.getLocale());
            bw.write("\"" + collectionObject + "\",");
            String creatorObject = eMFrameUtils.getLocalizedString("FwResources", "CustomCategoriesReport.CreatorObject", this.m_taskContext.getLocale());
            bw.write("\"" + creatorObject + "\",");
            String creationDate = eMFrameUtils.getLocalizedString("FwResources", "CustomCategoriesReport.CreationDate", this.m_taskContext.getLocale());
            bw.write("\"" + creationDate + "\",");
            bw.write(13);
            bw.write(10);
            for (int i = 0; i < this.m_report.size(); ++i) {
                CustomCategoriesClass customCategoriesClass = (CustomCategoriesClass)this.m_report.get(i);
                bw.write("\"" + customCategoriesClass.getCategoryDisplayName() + "\",");
                bw.write("\"" + customCategoriesClass.getCategoryFDN() + "\",");
                bw.write("\"" + customCategoriesClass.getCollectionFDN() + "\",");
                bw.write("\"" + customCategoriesClass.getCreatorFDN() + "\",");
                bw.write("\"" + customCategoriesClass.getCreationDate() + "\",");
                bw.write(13);
                bw.write(10);
            }
            bw.close();
            this.m_reportsCreated.add(sFullpath);
            return sFileName;
        }
        catch (IOException e) {
            D.log(e);
            return null;
        }
    }

    public String doUnassignedCategoriesXMLReport(boolean b_includeStyleSheet) {
        String sFileName = System.currentTimeMillis() + ".xml";
        String sFullpath = this.m_taskContext.getWebappHome().getAbsolutePath() + "/temp/" + sFileName;
        File file = new File(sFullpath);
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(file));
            this.writeUnassignedCategoriesXMLBuffer(bw, b_includeStyleSheet);
            this.m_reportsCreated.add(sFullpath);
            return sFileName;
        }
        catch (IOException e) {
            D.log(e);
            return null;
        }
    }

    private void writeUnassignedCategoriesXMLBuffer(BufferedWriter bw, boolean bIncludeStylesheet) throws IOException {
        bw.write(XML_FILE_VERSION_HEADER);
        if (bIncludeStylesheet) {
            bw.write(XML_FILE_STYLESHEET_HEADER);
        }
        XmlUtils.writeStartTag(XML_RBS_REPORT, bw);
        for (int i = 0; i < this.m_report.size(); ++i) {
            XmlUtils.writeStartTag(XML_RBS_RECORD, bw);
            UnassignedCategoriesClass unassignedCategoriesClass = (UnassignedCategoriesClass)this.m_report.get(i);
            XmlUtils.writeTag(XML_RBS_CATEGORY_NAME, new String(unassignedCategoriesClass.getCategoryDisplayName().getBytes("UTF-8")), bw);
            XmlUtils.writeTag(XML_RBS_CATEGORY_OBJECT, new String(unassignedCategoriesClass.getCategoryFDN().getBytes("UTF-8")), bw);
            XmlUtils.writeTag(XML_RBS_COLLECTION_OBJECT, new String(unassignedCategoriesClass.getCollectionFDN().getBytes("UTF-8")), bw);
            XmlUtils.writeEndTag(XML_RBS_RECORD, bw);
        }
        XmlUtils.writeEndTag(XML_RBS_REPORT, bw);
        bw.close();
    }

    public String doUnassignedCategoriesTEXTReport() {
        String sFileName = System.currentTimeMillis() + ".txt";
        String sFullpath = this.m_taskContext.getWebappHome().getAbsolutePath() + "/temp/" + sFileName;
        File file = new File(sFullpath);
        try {
            FileWriter fw = new FileWriter(file);
            BufferedWriter bw = new BufferedWriter(fw);
            for (int i = 0; i < this.m_report.size(); ++i) {
                UnassignedCategoriesClass unassignedCategoriesClass = (UnassignedCategoriesClass)this.m_report.get(i);
                String categoryName = eMFrameUtils.getLocalizedString("FwResources", "UnassignedCategoriesReport.CategoryName", this.m_taskContext.getLocale());
                bw.write(categoryName + ": ");
                bw.write(unassignedCategoriesClass.getCategoryDisplayName());
                bw.write(13);
                bw.write(10);
                String categoryObject = eMFrameUtils.getLocalizedString("FwResources", "UnassignedCategoriesReport.CategoryObject", this.m_taskContext.getLocale());
                bw.write(categoryObject + ": ");
                bw.write(unassignedCategoriesClass.getCategoryFDN());
                bw.write(13);
                bw.write(10);
                String collectionObject = eMFrameUtils.getLocalizedString("FwResources", "UnassignedCategoriesReport.CollectionObject", this.m_taskContext.getLocale());
                bw.write(collectionObject + ": ");
                bw.write(unassignedCategoriesClass.getCollectionFDN());
                bw.write(13);
                bw.write(10);
                bw.write("-------------------------------------------------");
                bw.write(13);
                bw.write(10);
            }
            bw.close();
            this.m_reportsCreated.add(sFullpath);
            return sFileName;
        }
        catch (IOException e) {
            D.log(e);
            return null;
        }
    }

    public String doUnassignedCategoriesCSVReport() {
        String sFileName = System.currentTimeMillis() + ".csv";
        String sFullpath = this.m_taskContext.getWebappHome().getAbsolutePath() + "/temp/" + sFileName;
        File file = new File(sFullpath);
        try {
            FileWriter fw = new FileWriter(file);
            BufferedWriter bw = new BufferedWriter(fw);
            String categoryName = eMFrameUtils.getLocalizedString("FwResources", "UnassignedCategoriesReport.CategoryName", this.m_taskContext.getLocale());
            bw.write("\"" + categoryName + "\",");
            String categoryObject = eMFrameUtils.getLocalizedString("FwResources", "UnassignedCategoriesReport.CategoryObject", this.m_taskContext.getLocale());
            bw.write("\"" + categoryObject + "\",");
            String collectionObject = eMFrameUtils.getLocalizedString("FwResources", "UnassignedCategoriesReport.CollectionObject", this.m_taskContext.getLocale());
            bw.write("\"" + collectionObject + "\",");
            bw.write(13);
            bw.write(10);
            for (int i = 0; i < this.m_report.size(); ++i) {
                UnassignedCategoriesClass unassignedCategoriesClass = (UnassignedCategoriesClass)this.m_report.get(i);
                bw.write("\"" + unassignedCategoriesClass.getCategoryDisplayName() + "\",");
                bw.write("\"" + unassignedCategoriesClass.getCategoryFDN() + "\",");
                bw.write("\"" + unassignedCategoriesClass.getCollectionFDN() + "\",");
                bw.write(13);
                bw.write(10);
            }
            bw.close();
            this.m_reportsCreated.add(sFullpath);
            return sFileName;
        }
        catch (IOException e) {
            D.log(e);
            return null;
        }
    }

    public void exportCollectionsReport() {
        HttpServletRequest req = this.m_taskContext.getRequest();
        String sReportType = req.getParameter(HTMLPARAM_REPORT_TYPE);
        if (sReportType != null) {
            String sFileName = null;
            if (sReportType.equalsIgnoreCase(REPORT_TYPE_XML)) {
                sFileName = this.doCollectionsXMLReport(false);
            } else if (sReportType.equalsIgnoreCase(REPORT_TYPE_TXT)) {
                sFileName = this.doCollectionsTEXTReport();
            } else if (sReportType.equalsIgnoreCase(REPORT_TYPE_SCV)) {
                sFileName = this.doCollectionsCSVReport();
            }
            if (sFileName != null) {
                req.setAttribute("NPPostRequestActions", (Object)sFileName);
            }
        }
    }

    public String doCollectionsXMLReport(boolean b_includeStyleSheet) {
        String sFileName = System.currentTimeMillis() + ".xml";
        String sFullpath = this.m_taskContext.getWebappHome().getAbsolutePath() + "/temp/" + sFileName;
        File file = new File(sFullpath);
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(file));
            this.writeCollectionsXMLBuffer(bw, b_includeStyleSheet);
            this.m_reportsCreated.add(sFullpath);
            return sFileName;
        }
        catch (IOException e) {
            D.log(e);
            return null;
        }
    }

    private void writeCollectionsXMLBuffer(BufferedWriter bw, boolean bIncludeStylesheet) throws IOException {
        bw.write(XML_FILE_VERSION_HEADER);
        if (bIncludeStylesheet) {
            bw.write(XML_FILE_STYLESHEET_HEADER);
        }
        XmlUtils.writeStartTag(XML_RBS_REPORT, bw);
        for (int i = 0; i < this.m_report.size(); ++i) {
            XmlUtils.writeStartTag(XML_RBS_RECORD, bw);
            CollectionsReportClass collectionsReportClass = (CollectionsReportClass)this.m_report.get(i);
            XmlUtils.writeTag(XML_RBS_COLLECTION_OBJECT, new String(collectionsReportClass.getCollectionFDN().getBytes("UTF-8")), bw);
            XmlUtils.writeTag(XML_RBS_VERSION, collectionsReportClass.getVersionString(), bw);
            XmlUtils.writeTag(XML_RBS_OWNER_OBJECT, new String(collectionsReportClass.getOwnerFDN().getBytes("UTF-8")), bw);
            XmlUtils.writeTag(XML_RBS_CREATOR_OBJECT, new String(collectionsReportClass.getCreatorFDN().getBytes("UTF-8")), bw);
            XmlUtils.writeTag(XML_RBS_CREATION_DATE, collectionsReportClass.getCreationDate(), bw);
            XmlUtils.writeEndTag(XML_RBS_RECORD, bw);
        }
        XmlUtils.writeEndTag(XML_RBS_REPORT, bw);
        bw.close();
    }

    public String doCollectionsTEXTReport() {
        String sFileName = System.currentTimeMillis() + ".txt";
        String sFullpath = this.m_taskContext.getWebappHome().getAbsolutePath() + "/temp/" + sFileName;
        File file = new File(sFullpath);
        try {
            FileWriter fw = new FileWriter(file);
            BufferedWriter bw = new BufferedWriter(fw);
            for (int i = 0; i < this.m_report.size(); ++i) {
                CollectionsReportClass collectionsReportClass = (CollectionsReportClass)this.m_report.get(i);
                String collectionObject = eMFrameUtils.getLocalizedString("FwResources", "CollectionsReport.CollectionObject", this.m_taskContext.getLocale());
                bw.write(collectionObject + ": ");
                bw.write(collectionsReportClass.getCollectionFDN());
                bw.write(13);
                bw.write(10);
                String version = eMFrameUtils.getLocalizedString("FwResources", "CollectionsReport.Version", this.m_taskContext.getLocale());
                bw.write(version + ": ");
                bw.write(collectionsReportClass.getVersionString());
                bw.write(13);
                bw.write(10);
                String ownerObject = eMFrameUtils.getLocalizedString("FwResources", "CollectionsReport.OwnerObject", this.m_taskContext.getLocale());
                bw.write(ownerObject + ": ");
                bw.write(collectionsReportClass.getOwnerFDN());
                bw.write(13);
                bw.write(10);
                String creatorObject = eMFrameUtils.getLocalizedString("FwResources", "CollectionsReport.CreatorObject", this.m_taskContext.getLocale());
                bw.write(creatorObject + ": ");
                bw.write(collectionsReportClass.getCreatorFDN());
                bw.write(13);
                bw.write(10);
                String creationDate = eMFrameUtils.getLocalizedString("FwResources", "CollectionsReport.CreationDate", this.m_taskContext.getLocale());
                bw.write(creationDate + ": ");
                bw.write(collectionsReportClass.getCreationDate());
                bw.write(13);
                bw.write(10);
                bw.write("-------------------------------------------------");
                bw.write(13);
                bw.write(10);
            }
            bw.close();
            this.m_reportsCreated.add(sFullpath);
            return sFileName;
        }
        catch (IOException e) {
            D.log(e);
            return null;
        }
    }

    public String doCollectionsCSVReport() {
        String sFileName = System.currentTimeMillis() + ".csv";
        String sFullpath = this.m_taskContext.getWebappHome().getAbsolutePath() + "/temp/" + sFileName;
        File file = new File(sFullpath);
        try {
            FileWriter fw = new FileWriter(file);
            BufferedWriter bw = new BufferedWriter(fw);
            String collectionObject = eMFrameUtils.getLocalizedString("FwResources", "CollectionsReport.CollectionObject", this.m_taskContext.getLocale());
            bw.write("\"" + collectionObject + "\",");
            String version = eMFrameUtils.getLocalizedString("FwResources", "CollectionsReport.Version", this.m_taskContext.getLocale());
            bw.write("\"" + version + "\",");
            String ownerObject = eMFrameUtils.getLocalizedString("FwResources", "CollectionsReport.OwnerObject", this.m_taskContext.getLocale());
            bw.write("\"" + ownerObject + "\",");
            String creatorObject = eMFrameUtils.getLocalizedString("FwResources", "CollectionsReport.CreatorObject", this.m_taskContext.getLocale());
            bw.write("\"" + creatorObject + "\",");
            String creationDate = eMFrameUtils.getLocalizedString("FwResources", "CollectionsReport.CreationDate", this.m_taskContext.getLocale());
            bw.write("\"" + creationDate + "\",");
            bw.write(13);
            bw.write(10);
            for (int i = 0; i < this.m_report.size(); ++i) {
                CollectionsReportClass collectionsReportClass = (CollectionsReportClass)this.m_report.get(i);
                bw.write("\"" + collectionsReportClass.getCollectionFDN() + "\",");
                bw.write("\"" + collectionsReportClass.getVersionString() + "\",");
                bw.write("\"" + collectionsReportClass.getOwnerFDN() + "\",");
                bw.write("\"" + collectionsReportClass.getCreatorFDN() + "\",");
                bw.write("\"" + collectionsReportClass.getCreationDate() + "\",");
                bw.write(13);
                bw.write(10);
            }
            bw.close();
            this.m_reportsCreated.add(sFullpath);
            return sFileName;
        }
        catch (IOException e) {
            D.log(e);
            return null;
        }
    }

    public void exportUsersToRoleReport() {
        HttpServletRequest req = this.m_taskContext.getRequest();
        String sReportType = req.getParameter(HTMLPARAM_REPORT_TYPE);
        if (sReportType != null) {
            String sFileName = null;
            if (sReportType.equalsIgnoreCase(REPORT_TYPE_XML)) {
                sFileName = this.doXMLUsersToRoleReport(false);
            } else if (sReportType.equalsIgnoreCase(REPORT_TYPE_TXT)) {
                sFileName = this.doTEXTUsersToRoleReport();
            } else if (sReportType.equalsIgnoreCase(REPORT_TYPE_SCV)) {
                sFileName = this.doCSVUsersToRoleReport();
            }
            if (sFileName != null) {
                req.setAttribute("NPPostRequestActions", (Object)sFileName);
            }
        }
    }

    public String doXMLUsersToRoleReport(boolean b_includeStyleSheet) {
        String sFileName = System.currentTimeMillis() + ".xml";
        String sFullpath = this.m_taskContext.getWebappHome().getAbsolutePath() + "/temp/" + sFileName;
        File file = new File(sFullpath);
        try {
            FileOutputStream fos = new FileOutputStream(file);
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF8"));
            this.writeXMLUsersToRoleBuffer(bw, b_includeStyleSheet);
            this.m_reportsCreated.add(sFullpath);
            return sFileName;
        }
        catch (IOException e) {
            D.log(e);
            return null;
        }
    }

    private void writeXMLUsersToRoleBuffer(BufferedWriter bw, boolean bIncludeStylesheet) throws IOException {
        bw.write(XML_FILE_VERSION_HEADER);
        if (bIncludeStylesheet) {
            bw.write(XML_FILE_STYLESHEET_HEADER);
        }
        XmlUtils.writeStartTag(XML_RBS_REPORT, bw);
        for (int i = 0; i < this.m_report.size(); ++i) {
            XmlUtils.writeStartTag(XML_RBS_RECORD, bw);
            RBSRoleReport rbsRoleReport = (RBSRoleReport)this.m_report.get(i);
            XmlUtils.writeTag(XML_RBS_ROLE_NAME, new String(rbsRoleReport.getRoleDisplayName().getBytes("UTF-8"), "UTF-8"), bw);
            XmlUtils.writeTag(XML_RBS_ROLE_OBJECT, new String(rbsRoleReport.getRoleFDN().getBytes("UTF-8"), "UTF-8"), bw);
            XmlUtils.writeTag(XML_RBS_MEMBER_TYPE, rbsRoleReport.getMemberType(), bw);
            XmlUtils.writeTag(XML_RBS_MEMBER_OBJECT, new String(rbsRoleReport.getMemberFDN().getBytes("UTF-8"), "UTF-8"), bw);
            XmlUtils.writeTag(XML_RBS_SCOPE, new String(rbsRoleReport.getScopeFDN().getBytes("UTF-8"), "UTF-8"), bw);
            XmlUtils.writeTag(XML_RBS_RIGHTS_SET, Boolean.toString(rbsRoleReport.getRightsSet()), bw);
            XmlUtils.writeTag(XML_RBS_INHERITED, rbsRoleReport.getInherited(), bw);
            XmlUtils.writeEndTag(XML_RBS_RECORD, bw);
        }
        XmlUtils.writeEndTag(XML_RBS_REPORT, bw);
        bw.close();
    }

    public String doCSVUsersToRoleReport() {
        String sFileName = System.currentTimeMillis() + ".csv";
        String sFullpath = this.m_taskContext.getWebappHome().getAbsolutePath() + "/temp/" + sFileName;
        File file = new File(sFullpath);
        try {
            FileWriter fw = new FileWriter(file);
            BufferedWriter bw = new BufferedWriter(fw);
            String roleName = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.RoleName", this.m_taskContext.getLocale());
            bw.write("\"" + roleName + "\",");
            String roleObject = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.RoleObject", this.m_taskContext.getLocale());
            bw.write("\"" + roleObject + "\",");
            String type = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.Type", this.m_taskContext.getLocale());
            bw.write("\"" + type + "\",");
            String member = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.Member", this.m_taskContext.getLocale());
            bw.write("\"" + member + "\",");
            String scope = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.Scope", this.m_taskContext.getLocale());
            bw.write("\"" + scope + "\",");
            String assigned = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.RightsAssigned", this.m_taskContext.getLocale());
            bw.write("\"" + assigned + "\",");
            String inherit = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.RightsInheritable", this.m_taskContext.getLocale());
            bw.write("\"" + inherit + "\",");
            bw.write(13);
            bw.write(10);
            for (int i = 0; i < this.m_report.size(); ++i) {
                RBSRoleReport rbsRoleReport = (RBSRoleReport)this.m_report.get(i);
                bw.write("\"" + rbsRoleReport.getRoleDisplayName() + "\",");
                bw.write("\"" + rbsRoleReport.getRoleFDN() + "\",");
                bw.write("\"" + rbsRoleReport.getMemberType() + "\",");
                bw.write("\"" + rbsRoleReport.getMemberFDN() + "\",");
                bw.write("\"" + rbsRoleReport.getScopeFDN() + "\",");
                bw.write("\"" + Boolean.toString(rbsRoleReport.getRightsSet()) + "\",");
                bw.write("\"" + rbsRoleReport.getInherited() + "\",");
                bw.write(13);
                bw.write(10);
            }
            bw.close();
            this.m_reportsCreated.add(sFullpath);
            return sFileName;
        }
        catch (IOException e) {
            D.log(e);
            return null;
        }
    }

    public String doTEXTUsersToRoleReport() {
        String sFileName = System.currentTimeMillis() + ".txt";
        String sFullpath = this.m_taskContext.getWebappHome().getAbsolutePath() + "/temp/" + sFileName;
        File file = new File(sFullpath);
        try {
            FileWriter fw = new FileWriter(file);
            BufferedWriter bw = new BufferedWriter(fw);
            for (int i = 0; i < this.m_report.size(); ++i) {
                RBSRoleReport rbsRoleReport = (RBSRoleReport)this.m_report.get(i);
                String roleName = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.RoleName", this.m_taskContext.getLocale());
                bw.write(roleName + ": ");
                bw.write(rbsRoleReport.getRoleDisplayName());
                bw.write(13);
                bw.write(10);
                String roleObject = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.RoleObject", this.m_taskContext.getLocale());
                bw.write(roleObject + ": ");
                bw.write(rbsRoleReport.getRoleFDN());
                bw.write(13);
                bw.write(10);
                String type = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.Type", this.m_taskContext.getLocale());
                bw.write(type + ": ");
                bw.write(rbsRoleReport.getMemberType());
                bw.write(13);
                bw.write(10);
                String member = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.Member", this.m_taskContext.getLocale());
                bw.write(member + ": ");
                bw.write(rbsRoleReport.getMemberFDN());
                bw.write(13);
                bw.write(10);
                String scope = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.Scope", this.m_taskContext.getLocale());
                bw.write(scope + ": ");
                bw.write(rbsRoleReport.getScopeFDN());
                bw.write(13);
                bw.write(10);
                String assigned = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.RightsAssigned", this.m_taskContext.getLocale());
                bw.write(assigned + ": ");
                bw.write(Boolean.toString(rbsRoleReport.getRightsSet()));
                bw.write(13);
                bw.write(10);
                String inherit = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.RightsInheritable", this.m_taskContext.getLocale());
                bw.write(inherit + ": ");
                bw.write(rbsRoleReport.getInherited());
                bw.write(13);
                bw.write(10);
                bw.write("-------------------------------------------------");
                bw.write(13);
                bw.write(10);
            }
            bw.close();
            this.m_reportsCreated.add(sFullpath);
            return sFileName;
        }
        catch (IOException e) {
            D.log(e);
            return null;
        }
    }

    public void exportRolesToUserReport(String[] reportHeaderData) {
        HttpServletRequest req = this.m_taskContext.getRequest();
        String sReportType = req.getParameter(HTMLPARAM_REPORT_TYPE);
        if (sReportType != null) {
            String sFileName = null;
            if (sReportType.equalsIgnoreCase(REPORT_TYPE_XML)) {
                sFileName = this.doXMLRolesToUserReport(false, reportHeaderData);
            } else if (sReportType.equalsIgnoreCase(REPORT_TYPE_TXT)) {
                sFileName = this.doTEXTRolesToUserReport(reportHeaderData);
            } else if (sReportType.equalsIgnoreCase(REPORT_TYPE_SCV)) {
                sFileName = this.doCSVRolesToUserReport(reportHeaderData);
            }
            if (sFileName != null) {
                req.setAttribute("NPPostRequestActions", (Object)sFileName);
            }
        }
    }

    public String doXMLRolesToUserReport(boolean b_includeStyleSheet, String[] reportHeaderData) {
        String sFileName = System.currentTimeMillis() + ".xml";
        String sFullpath = this.m_taskContext.getWebappHome().getAbsolutePath() + "/temp/" + sFileName;
        File file = new File(sFullpath);
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(file));
            this.writeXMLRolesToUserBuffer(bw, b_includeStyleSheet, reportHeaderData);
            this.m_reportsCreated.add(sFullpath);
            return sFileName;
        }
        catch (IOException e) {
            D.log(e);
            return null;
        }
    }

    private void writeXMLRolesToUserBuffer(BufferedWriter bw, boolean bIncludeStylesheet, String[] reportHeaderData) throws IOException {
        bw.write(XML_FILE_VERSION_HEADER);
        if (bIncludeStylesheet) {
            bw.write(XML_FILE_STYLESHEET_HEADER);
        }
        XmlUtils.writeStartTag(XML_RBS_REPORT, bw);
        this.addReportHeaderDataXML(bw, reportHeaderData);
        for (int i = 0; i < this.m_report.size(); ++i) {
            XmlUtils.writeStartTag(XML_RBS_RECORD, bw);
            RBSRoleReport rbsRoleReport = (RBSRoleReport)this.m_report.get(i);
            XmlUtils.writeTag(XML_RBS_USER_OBJECT, new String(rbsRoleReport.getUserFDN().getBytes("UTF-8")), bw);
            XmlUtils.writeTag(XML_RBS_ROLE_NAME, new String(rbsRoleReport.getRoleDisplayName().getBytes("UTF-8")), bw);
            XmlUtils.writeTag(XML_RBS_ROLE_OBJECT, new String(rbsRoleReport.getRoleFDN().getBytes("UTF-8")), bw);
            XmlUtils.writeTag(XML_RBS_MEMBER_TYPE, rbsRoleReport.getMemberType(), bw);
            XmlUtils.writeTag(XML_RBS_MEMBER_OBJECT, new String(rbsRoleReport.getMemberFDN().getBytes("UTF-8")), bw);
            XmlUtils.writeTag(XML_RBS_SCOPE, new String(rbsRoleReport.getScopeFDN().getBytes("UTF-8")), bw);
            XmlUtils.writeTag(XML_RBS_RIGHTS_SET, Boolean.toString(rbsRoleReport.getRightsSet()), bw);
            XmlUtils.writeTag(XML_RBS_INHERITED, rbsRoleReport.getInherited(), bw);
            XmlUtils.writeEndTag(XML_RBS_RECORD, bw);
        }
        XmlUtils.writeEndTag(XML_RBS_REPORT, bw);
        bw.close();
    }

    private void addReportHeaderDataXML(BufferedWriter bw, String[] reportHeaderData) {
        try {
            XmlUtils.writeStartTag(XML_RBS_REPORT_HEADER, bw);
            XmlUtils.writeTag(XML_RBS_SELECTED_USERFDN, new String(reportHeaderData[0].getBytes("UTF-8")), bw);
            XmlUtils.writeTag(XML_RBS_REPORT_TIME, new String(reportHeaderData[1].getBytes("UTF-8")), bw);
            XmlUtils.writeTag(XML_RBS_MEMBER_TYPES, new String(reportHeaderData[2].getBytes("UTF-8")), bw);
            if (reportHeaderData[3].equalsIgnoreCase("true")) {
                XmlUtils.writeStartTag(XML_RBS_DYN_GRP_CHECKED, bw);
                XmlUtils.writeTag(XML_RBS_SEARCH_ENABLED, new String(reportHeaderData[4].getBytes("UTF-8")), bw);
                if (reportHeaderData[5].equalsIgnoreCase("true")) {
                    XmlUtils.writeTag(XML_RBS_ROLE_SEARCH, new String(reportHeaderData[6].getBytes("UTF-8")), bw);
                    XmlUtils.writeTag(XML_RBS_SEARCH_TYPE, new String(reportHeaderData[7].getBytes("UTF-8")), bw);
                }
                XmlUtils.writeEndTag(XML_RBS_DYN_GRP_CHECKED, bw);
            } else if (reportHeaderData[5].equalsIgnoreCase("false")) {
                XmlUtils.writeStartTag(XML_RBS_DYN_GRP_CHECKED, bw);
                XmlUtils.writeTag(XML_RBS_SEARCH_ENABLED, new String(reportHeaderData[4].getBytes("UTF-8")), bw);
                XmlUtils.writeEndTag(XML_RBS_DYN_GRP_CHECKED, bw);
            }
            if (reportHeaderData[8].equalsIgnoreCase("true")) {
                XmlUtils.writeTag(XML_RBS_CONTAINER_ROLE, new String(reportHeaderData[9].getBytes("UTF-8")), bw);
            }
            XmlUtils.writeEndTag(XML_RBS_REPORT_HEADER, bw);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String doCSVRolesToUserReport(String[] reportHeaderData) {
        String sFileName = System.currentTimeMillis() + ".csv";
        String sFullpath = this.m_taskContext.getWebappHome().getAbsolutePath() + "/temp/" + sFileName;
        File file = new File(sFullpath);
        try {
            FileWriter fw = new FileWriter(file);
            BufferedWriter bw = new BufferedWriter(fw);
            this.addReportHeaderDataCSV(bw, reportHeaderData);
            String user = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.User", this.m_taskContext.getLocale());
            bw.write("\"" + user + "\",");
            String roleName = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.RoleName", this.m_taskContext.getLocale());
            bw.write("\"" + roleName + "\",");
            String roleObject = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.RoleObject", this.m_taskContext.getLocale());
            bw.write("\"" + roleObject + "\",");
            String type = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.Type", this.m_taskContext.getLocale());
            bw.write("\"" + type + "\",");
            String member = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.Member", this.m_taskContext.getLocale());
            bw.write("\"" + member + "\",");
            String scope = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.Scope", this.m_taskContext.getLocale());
            bw.write("\"" + scope + "\",");
            String assigned = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.RightsAssigned", this.m_taskContext.getLocale());
            bw.write("\"" + assigned + "\",");
            String inherit = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.RightsInheritable", this.m_taskContext.getLocale());
            bw.write("\"" + inherit + "\",");
            bw.write(13);
            bw.write(10);
            for (int i = 0; i < this.m_report.size(); ++i) {
                RBSRoleReport rbsRoleReport = (RBSRoleReport)this.m_report.get(i);
                bw.write("\"" + rbsRoleReport.getUserFDN() + "\",");
                bw.write("\"" + rbsRoleReport.getRoleDisplayName() + "\",");
                bw.write("\"" + rbsRoleReport.getRoleFDN() + "\",");
                bw.write("\"" + rbsRoleReport.getMemberType() + "\",");
                bw.write("\"" + rbsRoleReport.getMemberFDN() + "\",");
                bw.write("\"" + rbsRoleReport.getScopeFDN() + "\",");
                bw.write("\"" + Boolean.toString(rbsRoleReport.getRightsSet()) + "\",");
                bw.write("\"" + rbsRoleReport.getInherited() + "\",");
                bw.write(13);
                bw.write(10);
            }
            bw.close();
            this.m_reportsCreated.add(sFullpath);
            return sFileName;
        }
        catch (IOException e) {
            D.log(e);
            return null;
        }
    }

    public String doTEXTRolesToUserReport(String[] reportHeaderData) {
        String sFileName = System.currentTimeMillis() + ".txt";
        String sFullpath = this.m_taskContext.getWebappHome().getAbsolutePath() + "/temp/" + sFileName;
        File file = new File(sFullpath);
        try {
            FileWriter fw = new FileWriter(file);
            BufferedWriter bw = new BufferedWriter(fw);
            this.addReportHeaderDataText(bw, reportHeaderData);
            for (int i = 0; i < this.m_report.size(); ++i) {
                RBSRoleReport rbsRoleReport = (RBSRoleReport)this.m_report.get(i);
                String user = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.User", this.m_taskContext.getLocale());
                bw.write(user + ": ");
                bw.write(rbsRoleReport.getUserFDN());
                bw.write(13);
                bw.write(10);
                String roleName = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.RoleName", this.m_taskContext.getLocale());
                bw.write(roleName + ": ");
                bw.write(rbsRoleReport.getRoleDisplayName());
                bw.write(13);
                bw.write(10);
                String roleObject = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.RoleObject", this.m_taskContext.getLocale());
                bw.write(roleObject + ": ");
                bw.write(rbsRoleReport.getRoleFDN());
                bw.write(13);
                bw.write(10);
                String type = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.Type", this.m_taskContext.getLocale());
                bw.write(type + ": ");
                bw.write(rbsRoleReport.getMemberType());
                bw.write(13);
                bw.write(10);
                String member = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.Member", this.m_taskContext.getLocale());
                bw.write(member + ": ");
                bw.write(rbsRoleReport.getMemberFDN());
                bw.write(13);
                bw.write(10);
                String scope = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.Scope", this.m_taskContext.getLocale());
                bw.write(scope + ": ");
                bw.write(rbsRoleReport.getScopeFDN());
                bw.write(13);
                bw.write(10);
                String assigned = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.RightsAssigned", this.m_taskContext.getLocale());
                bw.write(assigned + ": ");
                bw.write(Boolean.toString(rbsRoleReport.getRightsSet()));
                bw.write(13);
                bw.write(10);
                String inherit = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.RightsInheritable", this.m_taskContext.getLocale());
                bw.write(inherit + ": ");
                bw.write(rbsRoleReport.getInherited());
                bw.write(13);
                bw.write(10);
                bw.write("-------------------------------------------------");
                bw.write(13);
                bw.write(10);
            }
            bw.close();
            this.m_reportsCreated.add(sFullpath);
            return sFileName;
        }
        catch (IOException e) {
            D.log(e);
            return null;
        }
    }

    private void addReportHeaderDataCSV(BufferedWriter bw, String[] reportHeaderData) {
        try {
            String dynGrpSearchSettings;
            String reportQuery = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.ReportQuery", this.m_taskContext.getLocale());
            bw.write("\"" + reportQuery + "\"");
            bw.write(13);
            bw.write(10);
            String user = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.User", this.m_taskContext.getLocale());
            bw.write("\"" + user + ":\",");
            bw.write("\"" + reportHeaderData[0] + "\"");
            bw.write(13);
            bw.write(10);
            String date = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.ReportTime", this.m_taskContext.getLocale());
            bw.write("\"" + date + "\",");
            bw.write("\"" + reportHeaderData[1] + "\"");
            bw.write(13);
            bw.write(10);
            String selectedMemberTypes = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.SelectedMemberTypes", this.m_taskContext.getLocale());
            bw.write("\"" + selectedMemberTypes + "\",");
            bw.write("\"" + reportHeaderData[2] + "\"");
            bw.write(13);
            bw.write(10);
            if (reportHeaderData[3].equalsIgnoreCase("true")) {
                dynGrpSearchSettings = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.DynamicGroupSearchSettings", this.m_taskContext.getLocale());
                bw.write("\"" + dynGrpSearchSettings + ":\",");
                bw.write(13);
                bw.write(10);
                String searchEnabled = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.SearchEnabled", this.m_taskContext.getLocale());
                bw.write("\"" + searchEnabled + "\",");
                bw.write("\"" + reportHeaderData[4] + "\"");
                bw.write(13);
                bw.write(10);
                if (reportHeaderData[5].equalsIgnoreCase("true")) {
                    String dynGrpRoleSearch = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.DynamicGroupRoleSearch", this.m_taskContext.getLocale());
                    bw.write("\"" + dynGrpRoleSearch + "\",");
                    bw.write("\"" + reportHeaderData[6] + "\"");
                    bw.write(13);
                    bw.write(10);
                    String dynGrpSearchtype = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.DynamicGroupRoleSearch", this.m_taskContext.getLocale());
                    bw.write("\"" + dynGrpSearchtype + "\",");
                    bw.write("\"" + reportHeaderData[7] + "\"");
                    bw.write(13);
                    bw.write(10);
                }
            } else if (reportHeaderData[5].equalsIgnoreCase("false")) {
                dynGrpSearchSettings = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.DynamicGroupSearchSettings", this.m_taskContext.getLocale());
                bw.write("\"" + dynGrpSearchSettings + ":-\",");
                bw.write(13);
                bw.write(10);
                String searchEnabled = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.SearchEnabled", this.m_taskContext.getLocale());
                bw.write("\"" + searchEnabled + "\",");
                bw.write("\"" + reportHeaderData[4] + "\"");
                bw.write(13);
                bw.write(10);
            }
            if (reportHeaderData[8].equalsIgnoreCase("true")) {
                String containerRoleSearch = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.ConatinerRoleSearch", this.m_taskContext.getLocale());
                bw.write("\"" + containerRoleSearch + "\",");
                bw.write("\"" + reportHeaderData[9] + "\"");
                bw.write(13);
                bw.write(10);
            }
            bw.write(13);
            bw.write(10);
            String reportHeader = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.ReportHeader", this.m_taskContext.getLocale());
            bw.write("\"" + reportHeader + "\"");
            bw.write(13);
            bw.write(10);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addReportHeaderDataText(BufferedWriter bw, String[] reportHeaderData) {
        try {
            String dynGrpSearchSettings;
            String reportQuery = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.ReportQuery", this.m_taskContext.getLocale());
            bw.write(reportQuery);
            bw.write(13);
            bw.write(10);
            bw.write(13);
            bw.write(10);
            String user = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.User", this.m_taskContext.getLocale());
            bw.write(user + ": ");
            bw.write(reportHeaderData[0]);
            bw.write(13);
            bw.write(10);
            String date = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.ReportTime", this.m_taskContext.getLocale());
            bw.write(date + " ");
            bw.write(reportHeaderData[1]);
            bw.write(13);
            bw.write(10);
            String selectedMemberTypes = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.SelectedMemberTypes", this.m_taskContext.getLocale());
            bw.write(selectedMemberTypes + " ");
            bw.write(reportHeaderData[2]);
            bw.write(13);
            bw.write(10);
            if (reportHeaderData[3].equalsIgnoreCase("true")) {
                bw.write("-------------------------------------------------");
                bw.write(13);
                bw.write(10);
                dynGrpSearchSettings = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.DynamicGroupSearchSettings", this.m_taskContext.getLocale());
                bw.write(dynGrpSearchSettings + ": ");
                bw.write(13);
                bw.write(10);
                String searchEnabled = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.SearchEnabled", this.m_taskContext.getLocale());
                bw.write(searchEnabled + " ");
                bw.write(reportHeaderData[4]);
                bw.write(13);
                bw.write(10);
                if (reportHeaderData[5].equalsIgnoreCase("true")) {
                    String dynGrpRoleSearch = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.DynamicGroupRoleSearch", this.m_taskContext.getLocale());
                    bw.write(dynGrpRoleSearch + " ");
                    bw.write(reportHeaderData[6]);
                    bw.write(13);
                    bw.write(10);
                    String dynGrpSearchtype = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.DynamicGroupRoleSearch", this.m_taskContext.getLocale());
                    bw.write(dynGrpSearchtype + " ");
                    bw.write(reportHeaderData[7]);
                    bw.write(13);
                    bw.write(10);
                }
            } else if (reportHeaderData[5].equalsIgnoreCase("false")) {
                dynGrpSearchSettings = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.DynamicGroupSearchSettings", this.m_taskContext.getLocale());
                bw.write(dynGrpSearchSettings + " ");
                bw.write(13);
                bw.write(10);
                String searchEnabled = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.SearchEnabled", this.m_taskContext.getLocale());
                bw.write(searchEnabled + " ");
                bw.write(reportHeaderData[4]);
                bw.write(13);
                bw.write(10);
            }
            if (reportHeaderData[8].equalsIgnoreCase("true")) {
                String containerRoleSearch = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.ConatinerRoleSearch", this.m_taskContext.getLocale());
                bw.write(containerRoleSearch + " ");
                bw.write(reportHeaderData[9]);
                bw.write(13);
                bw.write(10);
            }
            bw.write("-------------------------------------------------");
            bw.write(13);
            bw.write(10);
            String reportHeader = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.ReportHeader", this.m_taskContext.getLocale());
            bw.write(reportHeader);
            bw.write(13);
            bw.write(10);
            bw.write(13);
            bw.write(10);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void exportTasksToRoleReport() {
        HttpServletRequest req = this.m_taskContext.getRequest();
        String sReportType = req.getParameter(HTMLPARAM_REPORT_TYPE);
        if (sReportType != null) {
            String sFileName = null;
            if (sReportType.equalsIgnoreCase(REPORT_TYPE_XML)) {
                sFileName = this.doTasksToRoleXMLReport(false);
            } else if (sReportType.equalsIgnoreCase(REPORT_TYPE_TXT)) {
                sFileName = this.doTasksToRoleTextReport();
            } else if (sReportType.equalsIgnoreCase(REPORT_TYPE_SCV)) {
                sFileName = this.doTasksToRoleCSVReport();
            }
            if (sFileName != null) {
                req.setAttribute("NPPostRequestActions", (Object)sFileName);
            }
        }
    }

    public String doTasksToRoleXMLReport(boolean b_includeStyleSheet) {
        String sFileName = System.currentTimeMillis() + ".xml";
        String sFullpath = this.m_taskContext.getWebappHome().getAbsolutePath() + "/temp/" + sFileName;
        File file = new File(sFullpath);
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(file));
            this.writeTasksToRoleXMLBuffer(bw, b_includeStyleSheet);
            this.m_reportsCreated.add(sFullpath);
            return sFileName;
        }
        catch (IOException e) {
            D.log(e);
            return null;
        }
    }

    private void writeTasksToRoleXMLBuffer(BufferedWriter bw, boolean bIncludeStylesheet) throws IOException {
        bw.write(XML_FILE_VERSION_HEADER);
        if (bIncludeStylesheet) {
            bw.write(XML_FILE_STYLESHEET_HEADER);
        }
        XmlUtils.writeStartTag(XML_RBS_REPORT, bw);
        for (int i = 0; i < this.m_report.size(); ++i) {
            XmlUtils.writeStartTag(XML_RBS_RECORD, bw);
            RBSTaskReport rbsTaskReport = (RBSTaskReport)this.m_report.get(i);
            XmlUtils.writeTag(XML_RBS_TASK_NAME, new String(rbsTaskReport.getTaskDisplayName().getBytes("UTF-8")), bw);
            XmlUtils.writeTag(XML_RBS_TASK_OBJECT, new String(rbsTaskReport.getTaskFDN().getBytes("UTF-8")), bw);
            XmlUtils.writeTag(XML_RBS_ROLE_NAME, new String(rbsTaskReport.getRoleDisplayName().getBytes("UTF-8")), bw);
            XmlUtils.writeTag(XML_RBS_ROLE_OBJECT, new String(rbsTaskReport.getRoleFDN().getBytes("UTF-8")), bw);
            XmlUtils.writeEndTag(XML_RBS_RECORD, bw);
        }
        XmlUtils.writeEndTag(XML_RBS_REPORT, bw);
        bw.close();
    }

    public String doTasksToRoleCSVReport() {
        String sFileName = System.currentTimeMillis() + ".csv";
        String sFullpath = this.m_taskContext.getWebappHome().getAbsolutePath() + "/temp/" + sFileName;
        File file = new File(sFullpath);
        try {
            FileWriter fw = new FileWriter(file);
            BufferedWriter bw = new BufferedWriter(fw);
            String taskName = eMFrameUtils.getLocalizedString("FwResources", "TasksToUserReport.TaskName", this.m_taskContext.getLocale());
            bw.write("\"" + taskName + "\",");
            String taskObject = eMFrameUtils.getLocalizedString("FwResources", "TasksToUserReport.TaskObject", this.m_taskContext.getLocale());
            bw.write("\"" + taskObject + "\",");
            String roleName = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.RoleName", this.m_taskContext.getLocale());
            bw.write("\"" + roleName + "\",");
            String roleObject = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.RoleObject", this.m_taskContext.getLocale());
            bw.write("\"" + roleObject + "\",");
            bw.write(13);
            bw.write(10);
            for (int i = 0; i < this.m_report.size(); ++i) {
                RBSTaskReport rbsTaskReport = (RBSTaskReport)this.m_report.get(i);
                bw.write("\"" + rbsTaskReport.getTaskDisplayName() + "\",");
                bw.write("\"" + rbsTaskReport.getTaskFDN() + "\",");
                bw.write("\"" + rbsTaskReport.getRoleDisplayName() + "\",");
                bw.write("\"" + rbsTaskReport.getRoleFDN() + "\"");
                bw.write(13);
                bw.write(10);
            }
            bw.close();
            this.m_reportsCreated.add(sFullpath);
            return sFileName;
        }
        catch (IOException e) {
            D.log(e);
            return null;
        }
    }

    public String doTasksToRoleTextReport() {
        String sFileName = System.currentTimeMillis() + ".txt";
        String sFullpath = this.m_taskContext.getWebappHome().getAbsolutePath() + "/temp/" + sFileName;
        File file = new File(sFullpath);
        try {
            FileWriter fw = new FileWriter(file);
            BufferedWriter bw = new BufferedWriter(fw);
            for (int i = 0; i < this.m_report.size(); ++i) {
                RBSTaskReport rbsTaskReport = (RBSTaskReport)this.m_report.get(i);
                String taskName = eMFrameUtils.getLocalizedString("FwResources", "TasksToUserReport.TaskName", this.m_taskContext.getLocale());
                bw.write(taskName + ": ");
                bw.write(rbsTaskReport.getTaskDisplayName());
                bw.write(13);
                bw.write(10);
                String taskObject = eMFrameUtils.getLocalizedString("FwResources", "TasksToUserReport.TaskObject", this.m_taskContext.getLocale());
                bw.write(taskObject + ": ");
                bw.write(rbsTaskReport.getTaskFDN());
                bw.write(13);
                bw.write(10);
                String roleName = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.RoleName", this.m_taskContext.getLocale());
                bw.write(roleName + ": ");
                bw.write(rbsTaskReport.getRoleDisplayName());
                bw.write(13);
                bw.write(10);
                String roleObject = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.RoleObject", this.m_taskContext.getLocale());
                bw.write(roleObject + ": ");
                bw.write(rbsTaskReport.getRoleFDN());
                bw.write(13);
                bw.write(10);
                bw.write("-------------------------------------------------");
                bw.write(13);
                bw.write(10);
            }
            bw.close();
            this.m_reportsCreated.add(sFullpath);
            return sFileName;
        }
        catch (IOException e) {
            D.log(e);
            return null;
        }
    }

    public void exportTasksToUserReport() {
        HttpServletRequest req = this.m_taskContext.getRequest();
        String sReportType = req.getParameter(HTMLPARAM_REPORT_TYPE);
        if (sReportType != null) {
            String sFileName = null;
            if (sReportType.equalsIgnoreCase(REPORT_TYPE_XML)) {
                sFileName = this.doTasksToUserXMLReport(false);
            } else if (sReportType.equalsIgnoreCase(REPORT_TYPE_TXT)) {
                sFileName = this.doTasksToUserTextReport();
            } else if (sReportType.equalsIgnoreCase(REPORT_TYPE_SCV)) {
                sFileName = this.doTasksToUserCSVReport();
            }
            if (sFileName != null) {
                req.setAttribute("NPPostRequestActions", (Object)sFileName);
            }
        }
    }

    public String doTasksToUserXMLReport(boolean b_includeStyleSheet) {
        String sFileName = System.currentTimeMillis() + ".xml";
        String sFullpath = this.m_taskContext.getWebappHome().getAbsolutePath() + "/temp/" + sFileName;
        File file = new File(sFullpath);
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(file));
            this.writeTasksToUserXMLBuffer(bw, b_includeStyleSheet);
            this.m_reportsCreated.add(sFullpath);
            return sFileName;
        }
        catch (IOException e) {
            D.log(e);
            return null;
        }
    }

    private void writeTasksToUserXMLBuffer(BufferedWriter bw, boolean bIncludeStylesheet) throws IOException {
        bw.write(XML_FILE_VERSION_HEADER);
        if (bIncludeStylesheet) {
            bw.write(XML_FILE_STYLESHEET_HEADER);
        }
        XmlUtils.writeStartTag(XML_RBS_REPORT, bw);
        for (int i = 0; i < this.m_report.size(); ++i) {
            XmlUtils.writeStartTag(XML_RBS_RECORD, bw);
            RBSTaskReport rbsTaskReport = (RBSTaskReport)this.m_report.get(i);
            XmlUtils.writeTag(XML_RBS_USER_OBJECT, new String(rbsTaskReport.getUserFDN().getBytes("UTF-8")), bw);
            XmlUtils.writeTag(XML_RBS_TASK_NAME, new String(rbsTaskReport.getTaskDisplayName().getBytes("UTF-8")), bw);
            XmlUtils.writeTag(XML_RBS_TASK_OBJECT, new String(rbsTaskReport.getTaskFDN().getBytes("UTF-8")), bw);
            XmlUtils.writeTag(XML_RBS_ROLE_NAME, new String(rbsTaskReport.getRoleDisplayName().getBytes("UTF-8")), bw);
            XmlUtils.writeTag(XML_RBS_ROLE_OBJECT, new String(rbsTaskReport.getRoleFDN().getBytes("UTF-8")), bw);
            XmlUtils.writeEndTag(XML_RBS_RECORD, bw);
        }
        XmlUtils.writeEndTag(XML_RBS_REPORT, bw);
        bw.close();
    }

    public String doTasksToUserCSVReport() {
        String sFileName = System.currentTimeMillis() + ".csv";
        String sFullpath = this.m_taskContext.getWebappHome().getAbsolutePath() + "/temp/" + sFileName;
        File file = new File(sFullpath);
        try {
            FileWriter fw = new FileWriter(file);
            BufferedWriter bw = new BufferedWriter(fw);
            String user = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.User", this.m_taskContext.getLocale());
            bw.write("\"" + user + "\",");
            String taskName = eMFrameUtils.getLocalizedString("FwResources", "TasksToUserReport.TaskName", this.m_taskContext.getLocale());
            bw.write("\"" + taskName + "\",");
            String taskObject = eMFrameUtils.getLocalizedString("FwResources", "TasksToUserReport.TaskObject", this.m_taskContext.getLocale());
            bw.write("\"" + taskObject + "\",");
            String roleName = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.RoleName", this.m_taskContext.getLocale());
            bw.write("\"" + roleName + "\",");
            String roleObject = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.RoleObject", this.m_taskContext.getLocale());
            bw.write("\"" + roleObject + "\",");
            bw.write(13);
            bw.write(10);
            for (int i = 0; i < this.m_report.size(); ++i) {
                RBSTaskReport rbsTaskReport = (RBSTaskReport)this.m_report.get(i);
                bw.write("\"" + rbsTaskReport.getUserFDN() + "\",");
                bw.write("\"" + rbsTaskReport.getTaskDisplayName() + "\",");
                bw.write("\"" + rbsTaskReport.getTaskFDN() + "\",");
                bw.write("\"" + rbsTaskReport.getRoleDisplayName() + "\",");
                bw.write("\"" + rbsTaskReport.getRoleFDN() + "\"");
                bw.write(13);
                bw.write(10);
            }
            bw.close();
            this.m_reportsCreated.add(sFullpath);
            return sFileName;
        }
        catch (IOException e) {
            D.log(e);
            return null;
        }
    }

    public String doTasksToUserTextReport() {
        String sFileName = System.currentTimeMillis() + ".txt";
        String sFullpath = this.m_taskContext.getWebappHome().getAbsolutePath() + "/temp/" + sFileName;
        File file = new File(sFullpath);
        try {
            FileWriter fw = new FileWriter(file);
            BufferedWriter bw = new BufferedWriter(fw);
            for (int i = 0; i < this.m_report.size(); ++i) {
                RBSTaskReport rbsTaskReport = (RBSTaskReport)this.m_report.get(i);
                String user = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.User", this.m_taskContext.getLocale());
                bw.write(user + ": ");
                bw.write(rbsTaskReport.getUserFDN());
                bw.write(13);
                bw.write(10);
                String taskName = eMFrameUtils.getLocalizedString("FwResources", "TasksToUserReport.TaskName", this.m_taskContext.getLocale());
                bw.write(taskName + ": ");
                bw.write(rbsTaskReport.getTaskDisplayName());
                bw.write(13);
                bw.write(10);
                String taskObject = eMFrameUtils.getLocalizedString("FwResources", "TasksToUserReport.TaskObject", this.m_taskContext.getLocale());
                bw.write(taskObject + ": ");
                bw.write(rbsTaskReport.getTaskFDN());
                bw.write(13);
                bw.write(10);
                String roleName = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.RoleName", this.m_taskContext.getLocale());
                bw.write(roleName + ": ");
                bw.write(rbsTaskReport.getRoleDisplayName());
                bw.write(13);
                bw.write(10);
                String roleObject = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.RoleObject", this.m_taskContext.getLocale());
                bw.write(roleObject + ": ");
                bw.write(rbsTaskReport.getRoleFDN());
                bw.write(13);
                bw.write(10);
                bw.write("-------------------------------------------------");
                bw.write(13);
                bw.write(10);
            }
            bw.close();
            this.m_reportsCreated.add(sFullpath);
            return sFileName;
        }
        catch (IOException e) {
            D.log(e);
            return null;
        }
    }
}

