/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.authDev.iMgrAuthenticatorImpl;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.fw.FwAttr;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.RoleInfoComparator;
import com.novell.emframe.fw.authenticator.AuthLoader;
import com.novell.emframe.fw.authenticator.DirAuthenticator;
import com.novell.emframe.fw.util.infos.RoleInfo;
import com.novell.emframe.fw.util.infos.RoleInfoLight;
import com.novell.emframe.fw.util.infos.TaskInfoLight;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import org.jdom.Document;

public class RoleList {
    protected LinkedHashMap m_hmRolesById = new LinkedHashMap();
    protected LinkedHashMap m_hmAllTasksById = new LinkedHashMap();
    private boolean m_bRolesAreSorted;

    public static final RoleList getInstance(MContext context) {
        return RoleList.getInstance(context, true);
    }

    private static final RoleList getInstance(MContext context, boolean refresh) {
        RoleList roleList = (RoleList)FwAttr.getFwSessionAttribute("authentication.authenticatedroles", context.getSession());
        if (roleList == null) {
            roleList = new RoleList();
            FwAttr.setFwSessionAttribute("authentication.authenticatedroles", roleList, context.getSession());
            roleList.updateRolesFromAuthenticators(context);
        }
        return roleList;
    }

    public void updateRolesFromAuthenticators(MContext context) {
        int i;
        boolean bProcessDirAuth = false;
        iMgrAuthenticatorImpl[] auths = AuthLoader.getAllSystemAuths(context.getRequest());
        DirAuthenticator dirAuth = DirAuthenticator.getDirAuth(context);
        for (i = 0; i < auths.length; ++i) {
            if (auths[i] != dirAuth) continue;
            auths[i] = auths[auths.length - 1];
            auths[auths.length - 1] = dirAuth;
            break;
        }
        for (i = 0; i < auths.length; ++i) {
            iMgrAuthenticatorImpl auth = auths[i];
            if (auth != null) {
                Map hmNewRolesById = auth.getUpdatedRoles(context);
                D.assrt(hmNewRolesById != null, "authenticator :" + auth.getAuthContext().getName() + " should not return null from updateRoles.");
                Iterator iterNewRoles = hmNewRolesById.values().iterator();
                while (iterNewRoles.hasNext()) {
                    RoleInfo roleInfo = (RoleInfo)iterNewRoles.next();
                    if (!this.m_hmRolesById.containsKey(roleInfo.getId())) {
                        this.addRoleInfo(roleInfo);
                        continue;
                    }
                    this.combineRoleInfosWithSameId(roleInfo);
                }
                continue;
            }
            D.log("RoleList: updateRolesFromAuthenticators failed.  No auths found.");
        }
    }

    private void combineRoleInfosWithSameId(RoleInfo roleInfo) {
        RoleInfo roleInfoOld = (RoleInfo)this.m_hmRolesById.get(roleInfo.getId());
        this.combineRoleInfos(roleInfo, roleInfoOld);
    }

    private void combineRoleInfos(RoleInfo roleInfo, RoleInfo roleInfoDestination) {
        roleInfoDestination.getTaskDocsById().putAll(roleInfo.getTaskDocsById());
        this.m_hmAllTasksById.putAll(roleInfoDestination.getTaskDocsById());
        roleInfoDestination.getCategoryDisplayNamesByIdMap().putAll(roleInfo.getCategoryDisplayNamesByIdMap());
    }

    protected void addRoleInfo(RoleInfo roleInfo) {
        this.m_hmAllTasksById.putAll(roleInfo.getTaskDocsById());
        this.m_hmRolesById.put(roleInfo.getId(), roleInfo);
    }

    public Iterator getRoles() {
        return this.m_hmRolesById.values().iterator();
    }

    public Map getRolesById() {
        return this.m_hmRolesById;
    }

    public Map getAllTasksById() {
        return this.m_hmAllTasksById;
    }

    public Map getRolesByIdSortedByValue(MContext context) {
        RoleInfoComparator roleInfoComparator = new RoleInfoComparator(context);
        if (!this.m_bRolesAreSorted) {
            FwUtils.sortLinkedHashMapByValue(this.m_hmRolesById, roleInfoComparator);
        }
        RoleInfo lastRoleInfo = null;
        Vector<RoleInfo[]> infosToCombine = new Vector<RoleInfo[]>();
        Iterator iterRoleInfos = this.m_hmRolesById.values().iterator();
        while (iterRoleInfos.hasNext()) {
            RoleInfo roleInfo = (RoleInfo)iterRoleInfos.next();
            if (lastRoleInfo != null) {
                boolean match;
                boolean bl = match = roleInfoComparator.compare(lastRoleInfo, roleInfo) == 0;
                if (match) {
                    infosToCombine.add(new RoleInfo[]{lastRoleInfo, roleInfo});
                    continue;
                }
                lastRoleInfo = roleInfo;
                continue;
            }
            lastRoleInfo = roleInfo;
        }
        Iterator iterRoleInfosToCombine = infosToCombine.iterator();
        while (iterRoleInfosToCombine.hasNext()) {
            RoleInfo[] entry = (RoleInfo[])iterRoleInfosToCombine.next();
            this.combineRoleInfos(entry[1], entry[0]);
            this.m_hmRolesById.remove(entry[1].getId());
        }
        return this.getRolesById();
    }

    public RoleInfo getRole(String roleId) {
        return (RoleInfo)this.m_hmRolesById.get(roleId);
    }

    public Document getTaskDocument(String taskId) {
        return (Document)this.m_hmAllTasksById.get(taskId);
    }

    protected static ArrayList combineDuplicateRoles(ArrayList roles) {
        HashMap<String, RoleInfoLight> uniqueMap = new HashMap<String, RoleInfoLight>();
        Iterator ri = roles.iterator();
        while (ri.hasNext()) {
            RoleInfoLight currRole = (RoleInfoLight)ri.next();
            String roleId = currRole.getId();
            if (uniqueMap.containsKey(roleId)) {
                RoleInfoLight existingRole = (RoleInfoLight)uniqueMap.get(roleId);
                if (currRole.equals(existingRole)) continue;
                ArrayList tasks = currRole.getContent();
                ArrayList existingTasks = existingRole.getContent();
                Iterator ti = tasks.iterator();
                while (ti.hasNext()) {
                    TaskInfoLight newTask = (TaskInfoLight)ti.next();
                    boolean bDupTask = false;
                    Iterator eti = existingTasks.iterator();
                    while (eti.hasNext()) {
                        TaskInfoLight existingTask = (TaskInfoLight)eti.next();
                        if (!existingTask.getId().equals(newTask.getId())) continue;
                        bDupTask = true;
                        break;
                    }
                    if (bDupTask) continue;
                    existingTasks.add(newTask);
                }
                ArrayList cats = currRole.getCategories();
                if (cats == null) continue;
                for (int i = 0; i < cats.size(); ++i) {
                    existingRole.addCategory((ObjectEntry)cats.get(i));
                }
                continue;
            }
            uniqueMap.put(roleId, currRole);
        }
        return new ArrayList(uniqueMap.values());
    }
}

