/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.nds.NDSAttributeDefinition;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.admin.ns.nds.NDSSchemaDefinition;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.UiHandler;
import com.novell.emframe.dev.eDirAccessService;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.FwTaskContext;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.studio.TemplateBuilder;
import com.novell.webaccess.common.I18NServletRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Properties;

public class SOEProTask
extends Task {
    private static final long serialVersionUID = 1L;
    I18NServletRequest m_req;
    TaskContext m_context;
    Properties resultStrings;
    ObjectEntry m_treeOE;
    NDSNamespace m_namespace;
    static final String[] hideAttributes = new String[]{"Login Allowed Time Map"};

    public boolean execute(TaskContext context, Properties resultStrings) {
        this.m_context = context;
        this.resultStrings = resultStrings;
        this.m_req = (I18NServletRequest)context.getRequest();
        String nextState = this.m_req.getParameter("nextState");
        if (nextState == null || nextState.equalsIgnoreCase("initialState")) {
            return this.showInitialForm();
        }
        if (nextState.equalsIgnoreCase("doSOEPro")) {
            String target = this.m_req.getParameter("eDir$target");
            if (this.read(target = eMFrameUtils.unpack(target, context)[0])) {
                this.m_req.setParameter("eDirSearch", "*");
                eDirAccessService edas = new eDirAccessService();
                return edas.execute(context, resultStrings);
            }
            return false;
        }
        if (nextState.equalsIgnoreCase("eDasServiceAccess")) {
            eDirAccessService edas = new eDirAccessService();
            return edas.execute(context, resultStrings);
        }
        return this.showInitialForm();
    }

    private boolean showInitialForm() {
        eMFrameUtils.setupTargetChooser(new String[]{"*"}, this.m_context);
        return true;
    }

    private boolean read(String dn) {
        NDSAttributeDefinition[] attributeDefinitions;
        AuthenticationBroker broker = this.m_context.getAuthenticationBroker();
        this.m_treeOE = (ObjectEntry)broker.getAPIObject("NDSNamespace");
        this.m_namespace = (NDSNamespace)this.m_treeOE.getNamespace();
        ObjectEntry oe = null;
        try {
            oe = this.m_namespace.getObjectEntry(this.m_treeOE, dn);
        }
        catch (Exception e) {
            eMFrameUtils.setErrorMessage(e, this.m_context);
            return false;
        }
        String className = oe.getObjectType().getName();
        String client = ((FwTaskContext)((Object)this.m_context)).getUserInfo().getHtmlDirectory();
        try {
            NDSSchemaDefinition schemaDef = (NDSSchemaDefinition)this.m_namespace.getSchemaDefinition(this.m_treeOE);
            AttributeDefinition[] mandatory = schemaDef.getMandatoryAttributes(className);
            AttributeDefinition[] optional = schemaDef.getOptionalAttributes(className);
            ArrayList list = this.putAllAttributes(mandatory, optional);
            if (FwUtils.isParamTrue("justValued", this.m_context)) {
                try {
                    NSObject nsObject = this.m_namespace.getDetails(oe);
                    String[] valuedAttributes = nsObject.getAttributes();
                    for (int i = list.size() - 1; i >= 0; --i) {
                        AttributeDefinition definition = (AttributeDefinition)list.get(i);
                        boolean found = false;
                        for (int i2 = 0; i2 < valuedAttributes.length; ++i2) {
                            if (!definition.getName().equals(valuedAttributes[i2])) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        list.remove(i);
                    }
                }
                catch (Exception e) {
                    eMFrameUtils.setErrorMessage(e, this.m_context);
                    return false;
                }
            }
            attributeDefinitions = new NDSAttributeDefinition[list.size()];
            list.toArray(attributeDefinitions);
            if (null == attributeDefinitions) {
                D.log("Generic Creator does not know how to create this type of object.\nThere was no naming attribute for this object type.");
                String strTitle = eMFrameUtils.getLocalizedString("FwResources", "FwConsts.RES_CREATEOBJECT_FAILURE", this.m_context);
                String strBody = eMFrameUtils.getLocalizedString("FwResources", "FwConsts.RES_NO_REGISTRATION", this.m_context);
                eMFrameUtils.setMessage("error", strTitle, strBody, this.m_context);
                this.m_req.setParameter("merge", "dev.GenErr");
                return false;
            }
        }
        catch (Exception e) {
            D.log(e);
            return false;
        }
        try {
            String[] superClasses = this.m_context.getDirUtils().getSuperClasses(className);
            UiHandler[] uihandlers = TemplateBuilder.getDefaultHandlers(this.m_context, (AttributeDefinition[])attributeDefinitions, client, className, superClasses, false, false);
            String customLabel = eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "Creator.NamePrompt", this.m_context), new String[]{this.m_context.getDirUtils().getObjectTypeDisplayName(className, this.m_context)});
            String filename = TemplateBuilder.createTemplate(this.m_context, uihandlers, client, true, "TemplateBuilder_skeletonSOEPro.jsp", null, false, "temp", null, true);
            this.m_req.setParameter("merge", "temp/" + filename);
        }
        catch (IOException e) {
            D.log(e);
            return false;
        }
        catch (NamespaceException e) {
            D.log(e);
            return false;
        }
        this.resultStrings.put("GifName", this.m_context.getDirUtils().getObjectTypeImageName(className));
        String strBody = eMFrameUtils.getLocalizedString("FwResources", "Creator.Create", this.m_context);
        String strDisplayTask = eMFrameUtils.formatMessage(strBody, new String[]{this.m_context.getDirUtils().getObjectTypeDisplayName(className, this.m_context)});
        this.resultStrings.put("Task.displayName", strDisplayTask);
        this.resultStrings.put("createClassName", className);
        return true;
    }

    private ArrayList putAllAttributes(AttributeDefinition[] mandatory, AttributeDefinition[] optional) {
        ArrayList<AttributeDefinition> list = new ArrayList<AttributeDefinition>(Arrays.asList(mandatory));
        eMFrameUtils.addUnique(list, optional);
        for (int i = list.size() - 1; i >= 0; --i) {
            AttributeDefinition definition = list.get(i);
            if (definition.isReadOnly() || definition.isHidden()) {
                list.remove(i);
            }
            for (int j = 0; j < hideAttributes.length; ++j) {
                if (!definition.getName().equals(hideAttributes[j])) continue;
                list.remove(i);
            }
        }
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                AttributeDefinition ad1 = (AttributeDefinition)o1;
                AttributeDefinition ad2 = (AttributeDefinition)o2;
                int syn = ad1.getSyntax().getId() - ad2.getSyntax().getId();
                if (syn != 0) {
                    return syn;
                }
                return ad1.getName().compareTo(ad2.getName());
            }
        });
        Iterator<AttributeDefinition> i = list.iterator();
        while (i.hasNext()) {
            AttributeDefinition aDefinitions = i.next();
            String temp = this.m_context.getDirUtils().getSafeName(aDefinitions.getName()) + "DisplayName";
            this.resultStrings.put(temp, this.m_context.getDirUtils().getAttributeDisplayName(aDefinitions.getName(), this.m_context));
        }
        return list;
    }
}

