/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.emframe.dev.D;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.config.ConfigException;
import com.novell.emframe.dev.config.SystemConfig;
import com.novell.emframe.dev.eMFrameUtils;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;

public class SystemConfigGetAuthInfoTask
extends Task {
    private static final long serialVersionUID = 1L;
    private TaskContext m_context;
    private Properties m_resultStrings;
    private HttpServletRequest m_req;

    public boolean execute(TaskContext context, Properties resultStrings) {
        this.m_context = context;
        this.m_resultStrings = resultStrings;
        this.m_req = context.getRequest();
        String strTree = this.m_req.getParameter("AuthenticationSelectedTreeName");
        this.readExchangerAuthInfoAndSet(this.m_context, strTree, this.m_resultStrings);
        this.savePreviousAuthInfoInConfig(this.m_context);
        return true;
    }

    private void removeAuthInfo(TaskContext context, String sTree) {
        String sAuthDefProtocol = "NDAP";
        SystemConfig config = SystemConfig.getSystemConfig(context);
        try {
            config.removeSetting("Authenticate.Form.PublicUser." + sAuthDefProtocol + "." + sTree.toLowerCase());
            config.removeSetting("Authenticate.Form.PublicPassword." + sAuthDefProtocol + "." + sTree.toLowerCase());
            config.removeSetting("Authenticate.Form.SearchContainers." + sAuthDefProtocol + "." + sTree.toLowerCase());
            config.removeSettingValue("Authenticate.Form.Trees.List", sTree);
            String[] sAuthSelectedTree = config.getSettings("Authenticate.Form.Trees.List");
            context.getRequest().setAttribute("AuthTreeListParam", (Object)sAuthSelectedTree);
        }
        catch (ConfigException ce) {
            D.log("cannot remove the settings for the removed tree:  " + sTree);
            D.log(ce);
        }
    }

    private void savePreviousAuthInfoInConfig(TaskContext context) {
        SystemConfig config = SystemConfig.getSystemConfig(context);
        String sPrevSelTree = this.m_req.getParameter("AuthenticationPrevAuthTree");
        String sPrevUsername = this.m_req.getParameter("AuthenticationPrevUsername");
        String sPrevPassword = this.m_req.getParameter("AuthenticationPrevPassword");
        String sPrevContainers = this.m_req.getParameter("AuthenticationPrevContainers");
        String[] arrPrevContainers = eMFrameUtils.unpack(sPrevContainers, context);
        String sAuthDefProtocol = "NDAP";
        try {
            config.removeSetting("Authenticate.Form.PublicUser." + sAuthDefProtocol + "." + sPrevSelTree.toLowerCase());
            config.setSetting("Authenticate.Form.PublicUser." + sAuthDefProtocol + "." + sPrevSelTree.toLowerCase(), sPrevUsername);
            config.removeSetting("Authenticate.Form.PublicPassword." + sAuthDefProtocol + "." + sPrevSelTree.toLowerCase());
            config.setSetting("Authenticate.Form.PublicPassword." + sAuthDefProtocol + "." + sPrevSelTree.toLowerCase(), sPrevPassword);
            config.removeSetting("Authenticate.Form.SearchContainers." + sAuthDefProtocol + "." + sPrevSelTree.toLowerCase());
            config.setSetting("Authenticate.Form.SearchContainers." + sAuthDefProtocol + "." + sPrevSelTree.toLowerCase(), arrPrevContainers);
            config.writeSettings();
        }
        catch (ConfigException ce) {
            D.log("cannot set the previous values for previous selected tree and user:  " + sPrevSelTree + " + " + sPrevUsername + " + " + sPrevContainers);
            D.log(ce);
        }
    }

    private void readExchangerAuthInfoAndSet(TaskContext context, String sTree, Properties resultStrings) {
        String sAuthDefProtocol = "NDAP";
        String sAuthPublicPassword = "";
        String sAuthPublicUser = "";
        SystemConfig config = SystemConfig.getSystemConfig(context);
        sAuthPublicPassword = config.getSetting("Authenticate.Form.PublicPassword." + sAuthDefProtocol + "." + sTree.toLowerCase());
        sAuthPublicUser = config.getSetting("Authenticate.Form.PublicUser." + sAuthDefProtocol + "." + sTree.toLowerCase());
        String[] sAuthSearchContainers = config.getSettings("Authenticate.Form.SearchContainers." + sAuthDefProtocol + "." + sTree.toLowerCase());
        resultStrings.put("AuthenticationPublicUser", null == sAuthPublicUser ? "" : sAuthPublicUser);
        resultStrings.put("AuthenticationPublicPassword", null == sAuthPublicPassword ? "" : sAuthPublicPassword);
        String sTemp = null;
        sTemp = null == sAuthSearchContainers ? eMFrameUtils.pack(new String[]{""}, context) : eMFrameUtils.pack(sAuthSearchContainers, context);
        resultStrings.put("AuthenticationSearchContainers", sTemp);
    }
}

