/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.MOOManager;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.ObjectOperation;
import com.novell.admin.ns.SchemaDefinition;
import com.novell.admin.ns.nds.NDSAttributeDefinition;
import com.novell.admin.ns.nds.NDSObjectOperation;
import com.novell.admin.ns.nds.NDSSyntax;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.AuthBrokerException;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.TargetObjects;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eDirAccessServiceException;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.EdasRightsData;
import com.novell.emframe.fw.FormElement;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.MooUpdateErrorInformation;
import com.novell.emframe.fw.Target;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.jdom.Document;
import org.jdom.JDOMException;

public class TargetCollection {
    private static final String[] reservedWords = new String[]{"createContext", "createClassName", "createPassword", "createSourceObjectForClone"};
    private ArrayList m_formElements = new ArrayList();
    private ArrayList m_auxElements = new ArrayList();
    private Hashtable m_targets = new Hashtable();
    private EdasRightsData m_edasRightsData = new EdasRightsData(this);

    public EdasRightsData getEdasRightsData() {
        return this.m_edasRightsData;
    }

    private void parseFormData(TaskContext context) throws eDirAccessServiceException {
        HttpServletRequest req = context.getRequest();
        String target = null;
        this.m_formElements = new ArrayList();
        this.m_auxElements = new ArrayList();
        Enumeration myenum = req.getParameterNames();
        while (myenum.hasMoreElements()) {
            String value;
            String key = (String)myenum.nextElement();
            if (!key.startsWith("eDir$") || (value = req.getParameter(key)) == null || value.length() == 0 || value.equalsIgnoreCase("ignore")) continue;
            int firstSeperator = key.indexOf("$");
            int lastSeperator = key.indexOf("$", firstSeperator + 1);
            if (lastSeperator == -1) {
                target = key.substring(firstSeperator + 1);
                String eDirCommand = req.getParameter("eDirCommand");
                if (eDirCommand != null && eDirCommand.equalsIgnoreCase("create") && target.equalsIgnoreCase("target")) continue;
                this.addTargetDefinition(target, value, null, context);
                continue;
            }
            target = key.substring(firstSeperator + 1, lastSeperator);
            String attributeName = key.substring(lastSeperator + 1);
            List<String> reservedCreateWords = Arrays.asList(reservedWords);
            if (reservedCreateWords.contains(attributeName)) continue;
            FormElement formElement = new FormElement(context, target, attributeName, value);
            if (formElement.getPostName().equals("auxillaryClassExtension")) {
                this.m_auxElements.add(formElement);
                continue;
            }
            if (formElement.getRealName() == null) {
                throw new eDirAccessServiceException("eDir Access Service Error", "Attribute " + formElement.getPostName() + " not found in the schema.");
            }
            this.m_formElements.add(formElement);
        }
    }

    public void update(TaskContext context) throws eDirAccessServiceException {
        Target target = null;
        Enumeration myenum = this.m_targets.elements();
        while (myenum.hasMoreElements()) {
            target = (Target)myenum.nextElement();
            target.update(context);
        }
    }

    public void abortUpdate(TaskContext context) throws SPIException, JDOMException {
        Enumeration myenum = this.m_targets.elements();
        while (myenum.hasMoreElements()) {
            Target target = (Target)myenum.nextElement();
            target.abortUpdate();
        }
        this.clearMOOTargets(context);
    }

    public void outputProgressInformation(TaskContext context) {
        HttpServletRequest req = context.getRequest();
        Enumeration myenum = this.m_targets.elements();
        int numObjects = 0;
        int numObjectsUpdated = 0;
        ArrayList errorList = new ArrayList();
        boolean finished = true;
        while (myenum.hasMoreElements()) {
            Target target = (Target)myenum.nextElement();
            numObjects += target.getCount();
            numObjectsUpdated += target.getProgressCount();
            errorList.addAll(target.getProgressErrors());
            if (target.isProgressComplete()) continue;
            finished = false;
        }
        req.setAttribute("Progress.totalNumber", (Object)("" + numObjects));
        req.setAttribute("Progress.numberCompleted", (Object)("" + numObjectsUpdated));
        req.setAttribute("Progress.finished", (Object)("" + finished));
        Iterator iter = errorList.iterator();
        int count = 0;
        while (iter.hasNext()) {
            MooUpdateErrorInformation error = (MooUpdateErrorInformation)iter.next();
            req.setAttribute("Progress.errorMessages." + count + ".objectName", (Object)DirUtils.removeRightMostName(error.m_objectEntry.getFullName()));
            req.setAttribute("Progress.errorMessages." + count + ".message", (Object)eMFrameUtils.getExceptionMessage(error.m_exception, context));
            ++count;
        }
        req.setAttribute("Progress.errorMessages.count", (Object)("" + count));
    }

    public void read(TaskContext context, String[] attributesToRead, Properties customHandlers, boolean bigXmlOnly) throws eDirAccessServiceException {
        HttpServletRequest req = context.getRequest();
        this.parseFormData(context);
        Enumeration myenum = this.m_targets.keys();
        while (myenum.hasMoreElements()) {
            String keyName = (String)myenum.nextElement();
            Target target = (Target)this.m_targets.get(keyName);
            target.read(keyName, attributesToRead, customHandlers, bigXmlOnly, context);
        }
        Target primaryTarget = this.getTarget("target");
        boolean isMoo = primaryTarget.isMOO();
        req.setAttribute("Task.moo", (Object)("" + isMoo));
        req.setAttribute("taskIsMoo", (Object)("" + isMoo));
        String targetDisplayName = null;
        if (isMoo) {
            Object[] params = new String[]{"" + primaryTarget.getCount()};
            String pattern = eMFrameUtils.getLocalizedString("DevResources", "General.nObjects", context);
            targetDisplayName = eMFrameUtils.formatMessage(pattern, params);
        } else {
            targetDisplayName = DirUtils.removeRightMostName(primaryTarget.m_oe.getFullName());
        }
        req.setAttribute("Task.targetDisplayName", (Object)targetDisplayName);
        String taskId = context.getRequest().getParameter("taskId");
        Document doc = FwUtils.getTaskDocument(context, taskId);
        String defaultDisplayName = eMFrameUtils.getDisplayName(doc, (MContext)context);
        req.setAttribute("Task.displayName", (Object)defaultDisplayName);
        context.getRequest().setAttribute("edasRights", (Object)this.m_edasRightsData);
    }

    public void extendClasses(TaskContext context) throws eDirAccessServiceException {
        Iterator iterator = this.m_auxElements.iterator();
        while (iterator.hasNext()) {
            FormElement formElement = (FormElement)iterator.next();
            Target target = this.getTarget(formElement.getTarget());
            String[] attrName = new String[this.m_formElements.size()];
            boolean[] attrValue = new boolean[this.m_formElements.size()];
            for (int i = 0; i < this.m_formElements.size(); ++i) {
                attrName[i] = ((FormElement)this.m_formElements.get(i)).getRealName();
                String value = ((FormElement)this.m_formElements.get(i)).getValue();
                attrValue[i] = true;
                if (!value.equals("<attribute></attribute>") && !value.equals("<attribute ></attribute>") && !value.equals("<mvstring></mvstring>") && !value.startsWith("<attribute mode='ignore'>") && !value.startsWith("<mvstring mode='ignore'>") && !value.startsWith("<attribute mode='remove'>") && !value.startsWith("<mvstring mode='remove'>")) continue;
                attrValue[i] = false;
            }
            if (target == null) {
                String errorMsg = new String("Template is missing target definition for: " + formElement.getTarget());
                throw new eDirAccessServiceException("eDir Access Service Error", errorMsg);
            }
            StringTokenizer st = new StringTokenizer(formElement.getValue(), ",");
            block7: while (st.hasMoreTokens()) {
                String className = st.nextToken();
                className = context.getDirUtils().getRealName(className);
                if (target.isMOO()) {
                    ObjectEntry objectEntry = null;
                    AdminNamespace namespace = null;
                    Object theObj = this.getTarget(formElement.getTarget()).getObject();
                    if (!(theObj instanceof MOOManager)) continue;
                    objectEntry = ((MOOManager)theObj).getTreeObjectEntry();
                    namespace = objectEntry.getAdminNamespace();
                    MOOManager mooManager = (MOOManager)theObj;
                    AttributeDefinition attributeDef = null;
                    try {
                        SchemaDefinition sd = namespace.getSchemaDefinition(objectEntry);
                        ClassDefinition cd = sd.getClassDefinition(className);
                        boolean validEntry = false;
                        for (int j = 0; j < attrName.length; ++j) {
                            boolean bl = validEntry = attrValue[j] && this.isAttribute(cd, attrName[j]);
                            if (validEntry) break;
                        }
                        if (!validEntry) continue;
                        attributeDef = namespace.getAttributeDefinition(objectEntry, "Object Class");
                        ObjectOperation objectOperation = null;
                        if (!(attributeDef instanceof NDSAttributeDefinition)) continue;
                        objectOperation = mooManager.getObjectOperation(attributeDef.getName());
                        if (objectOperation == null) {
                            objectOperation = new NDSObjectOperation((NDSAttributeDefinition)attributeDef, 1);
                        }
                        objectOperation.addComponent(NDSSyntax.SYN_CLASS_NAME.createValueComponent((Object)className));
                        mooManager.addObjectOperation(objectOperation);
                        continue;
                    }
                    catch (Exception e) {
                        D.log(e);
                        D.log("Could not extend class with aux class " + className);
                        throw new eDirAccessServiceException(e);
                    }
                }
                NSObject nsObj = (NSObject)this.getTarget(formElement.getTarget()).getObject();
                boolean exists = false;
                ClassDefinition[] defs = nsObj.getClassDefinitions();
                for (int i = 0; i < defs.length; ++i) {
                    if (!defs[i].getName().equals(className)) continue;
                    exists = true;
                    break;
                }
                if (exists) continue;
                AdminNamespace ns = (AdminNamespace)target.m_oe.getObjectType().getNamespace();
                try {
                    SchemaDefinition sd = ns.getSchemaDefinition(target.m_oe);
                    ClassDefinition cd = sd.getClassDefinition(className);
                    boolean validEntry = false;
                    for (int j = 0; j < attrName.length; ++j) {
                        boolean bl = validEntry = attrValue[j] && this.isAttribute(cd, attrName[j]);
                        if (!validEntry) continue;
                        nsObj.setShadowSign(true);
                        nsObj.addAuxiliaryClassDefinition(cd, null);
                        continue block7;
                    }
                }
                catch (NamespaceException exc) {
                    if (!exc.getMessage().equals(NamespaceException.CLASS_NOT_DEFINED.getMessage())) continue;
                }
                catch (Exception e) {
                    D.log(e);
                    throw new eDirAccessServiceException(e);
                }
            }
        }
    }

    public boolean isAttribute(ClassDefinition cd, String attr) {
        return cd.isClassUsingAttribute(attr) || cd.isNamedBy(attr);
    }

    public void write(Properties customHandlers, TaskContext context) throws eDirAccessServiceException {
        this.parseFormData(context);
        this.extendClasses(context);
        Iterator iterator = this.m_formElements.iterator();
        while (iterator.hasNext()) {
            FormElement formElement = (FormElement)iterator.next();
            Target target = this.getTarget(formElement.getTarget());
            if (target != null) {
                target.write(formElement, customHandlers, context);
                continue;
            }
            String errorMsg = new String("Template is missing target definition for: " + formElement.getTarget());
            throw new eDirAccessServiceException("eDir Access Service Error", errorMsg);
        }
    }

    public void clearMOOTargets(TaskContext context) throws SPIException, JDOMException {
        Enumeration myenum = this.m_targets.elements();
        while (myenum.hasMoreElements()) {
            Target target = (Target)myenum.nextElement();
            if (!target.isMOO()) continue;
            target.resetMOOManager(context);
        }
    }

    public Target getTarget(String tName) {
        return (Target)this.m_targets.get(tName);
    }

    public boolean existsTarget(String targetID) {
        return this.m_targets.containsKey(targetID);
    }

    public boolean isEmpty() {
        return this.m_targets.isEmpty();
    }

    public void addTargetDefinition(String varName, String targetNames, String[] delayedAttributes, TaskContext context) throws eDirAccessServiceException {
        this.addTargetDefinition(varName, targetNames, context.getRequest().getParameter("eDirSearch"), delayedAttributes, context);
    }

    public void addTargetDefinition(String varName, String targetNames, String typeFilter, String[] delayedAttributes, TaskContext context) throws eDirAccessServiceException {
        ArrayList targetTypes = null;
        HttpServletRequest request = context.getRequest();
        String command = request.getParameter("eDirCommand");
        if (varName.equals("target") && (command == null || command.equals("read"))) {
            String[] baseTargetTypes;
            if (typeFilter == null) {
                typeFilter = "*";
            }
            if (!(baseTargetTypes = eMFrameUtils.split(typeFilter, ","))[0].equals("*") && !baseTargetTypes[0].equals("[containers]")) {
                for (int i = 0; i < baseTargetTypes.length; ++i) {
                    baseTargetTypes[i] = context.getDirUtils().getRealName(baseTargetTypes[i]);
                }
                targetTypes = context.getDirUtils().getAllSubClasses(baseTargetTypes);
            }
        }
        try {
            TargetObjects objects = new TargetObjects(targetNames, context);
            Exception[] errors = objects.getErrors();
            if (errors != null && errors.length > 0) {
                throw errors[0];
            }
            this.m_targets.put(varName, new Target(objects, targetTypes, delayedAttributes, context));
        }
        catch (Exception e) {
            throw new eDirAccessServiceException(e);
        }
    }

    public void createTargetDefinition(String parentContext, String objectName, String className, TaskContext context) throws eDirAccessServiceException {
        AuthenticationBroker broker = context.getAuthenticationBroker();
        ObjectEntry treeOE = null;
        try {
            treeOE = (ObjectEntry)broker.getProtocolObject("AdminNamespace");
        }
        catch (AuthBrokerException e) {
            D.log(e);
        }
        AdminNamespace ns = null;
        ns = treeOE.getAdminNamespace();
        NSObject nsObj = null;
        ObjectEntry parentOE = null;
        String strException = null;
        if (parentContext.equalsIgnoreCase("[root]") || parentContext.equals("")) {
            parentContext = treeOE.getName();
        }
        try {
            parentOE = treeOE.getName().equalsIgnoreCase(parentContext) ? ns.getObjectEntry(parentContext) : ns.getObjectEntry(treeOE, parentContext);
            context.addToHistory(parentOE);
        }
        catch (SPIException e) {
            String strFailure = eMFrameUtils.getLocalizedString("BaseResources", "CreateObject.Failure", context);
            String strContainerNotFound = eMFrameUtils.getLocalizedString("BaseResources", "Common.ContainerNotFound", context);
            D.log(e);
            String header = eMFrameUtils.formatMessage(strFailure, new String[]{context.getDirUtils().getObjectTypeDisplayName(className, context)});
            String body = eMFrameUtils.formatMessage(strContainerNotFound, new String[]{parentContext});
            throw new eDirAccessServiceException(header, body);
        }
        try {
            SchemaDefinition sd = null;
            String strParentType = parentOE.getObjectType().getName();
            sd = ns.getSchemaDefinition(parentOE);
            boolean canContain = sd.canContain(strParentType, className);
            if (!canContain) {
                String strFailure = eMFrameUtils.getLocalizedString("BaseResources", "CreateObject.Failure", context);
                String strBadParentType = eMFrameUtils.getLocalizedString("FwResources", "FwConsts.RES_INVALID_OBJECTTYPE", context);
                throw new eDirAccessServiceException(eMFrameUtils.formatMessage(strFailure, new String[]{context.getDirUtils().getObjectTypeDisplayName(className, context)}), eMFrameUtils.formatMessage(strBadParentType, new String[]{context.getDirUtils().getObjectTypeDisplayName(className, context)}));
            }
        }
        catch (SPIException e) {
            D.log(e);
            throw new eDirAccessServiceException((Exception)((Object)e));
        }
        try {
            ObjectEntry newOE = ns.createObjectEntry(parentOE, objectName, className);
            nsObj = ns.createNSObject(newOE, null, false);
            nsObj.setShadowSign(true);
        }
        catch (NamespaceException e) {
            D.log(e);
            strException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), context);
        }
        catch (SPIException e) {
            D.log(e);
            throw new eDirAccessServiceException((Exception)((Object)e));
        }
        if (strException != null) {
            String strFailure = eMFrameUtils.getLocalizedString("BaseResources", "CreateObject.Failure", context);
            String strCommonError = eMFrameUtils.getLocalizedString("BaseResources", "Common.FailureExplain", context);
            throw new eDirAccessServiceException(eMFrameUtils.formatMessage(strFailure, new String[]{context.getDirUtils().getObjectTypeDisplayName(className, context)}), eMFrameUtils.formatMessage(strCommonError, new String[]{strException}));
        }
        Target target = new Target(nsObj);
        this.m_targets.put("target", target);
    }
}

