/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectType;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.RBSReportUtil;
import com.novell.emframe.fw.RBSTaskReportSort;
import com.novell.emframe.fw.ReportsExportUtil;
import com.novell.nps.gadgetManager.GadgetInstanceException;
import com.novell.rbs.RBSAssociatedObject;
import com.novell.rbs.RBSObject;
import com.novell.rbs.RBSRole;
import com.novell.rbs.RBSRoleReport;
import com.novell.rbs.RBSTaskReport;
import com.novell.webaccess.common.I18NServletRequest;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class TasksToUserReport
extends Task {
    private static final long serialVersionUID = 1L;
    private TaskContext m_context;
    private Properties m_resultStrings;
    private HttpServletRequest m_req;
    private NDSNamespace m_ns;
    private ObjectEntry m_treeOE;
    ArrayList m_errors = new ArrayList();
    private boolean m_stopThread;
    private boolean m_threadDone;
    private int m_reportCount = 0;
    private int m_reportsNotRead = 0;
    private String m_roleDiscoveryDomain;
    private String m_dynamicGroupEnabled;
    private String m_dynamicGroupDiscoveryDomain;
    private String m_dynamicGroupSearchType;
    private String m_selectedUserFDN;
    private ArrayList m_taskList = new ArrayList();
    private String m_inProgress = "false";
    private String m_progressCancelled = "false";
    private String m_progressMessage = "";
    private int m_totalReportsCount = 0;
    private String m_sortColumn;
    private String m_sortDirection;
    private String m_reportTime;
    private ReportThread reportThread;
    private ReportsExportUtil m_exportUtil = null;

    public static void shouldRun(HttpServletRequest req, String sServiceName) throws Exception {
        FwUtils.verifyRbsInstalled(req, sServiceName);
    }

    public boolean execute(TaskContext context, Properties resultStrings) {
        this.m_context = context;
        this.m_resultStrings = resultStrings;
        this.m_req = this.m_context.getRequest();
        this.m_treeOE = (ObjectEntry)this.m_context.getAuthenticationBroker().getAPIObject("NDSNamespace");
        this.m_ns = (NDSNamespace)this.m_treeOE.getNamespace();
        String nextState = this.m_req.getParameter("nextState");
        if (nextState == null || nextState.equalsIgnoreCase("initialState")) {
            return this.initialState();
        }
        if (nextState.equalsIgnoreCase("getTasksReport")) {
            return this.getTasksReport();
        }
        if (nextState.equalsIgnoreCase("refresh")) {
            return this.refresh();
        }
        if (nextState.equalsIgnoreCase("cancel")) {
            return this.cancel();
        }
        if (nextState.equalsIgnoreCase("finished")) {
            return this.finished();
        }
        if (nextState.equalsIgnoreCase("sortByColumn")) {
            return this.sortByColumn();
        }
        if (nextState.equalsIgnoreCase("exportReport")) {
            return this.handleExportFile();
        }
        return true;
    }

    private boolean initialState() {
        this.m_req.setAttribute("inProgress", (Object)this.m_inProgress);
        this.m_req.setAttribute("progressCancelled", (Object)this.m_progressCancelled);
        this.m_req.setAttribute("SelectedUserFDN", (Object)"");
        return true;
    }

    private boolean getTasksReport() {
        this.m_totalReportsCount = 6;
        this.m_reportCount = 0;
        this.m_taskList.clear();
        this.m_selectedUserFDN = this.m_req.getParameter("SelectedUserFDN");
        ObjectEntry userOE = null;
        try {
            userOE = this.m_ns.getObjectEntry(this.m_treeOE, this.m_selectedUserFDN);
            ObjectType objectType = userOE.getObjectType();
            if (!DirUtils.isOfType(objectType, "User", true)) {
                String strError = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.WrongObject", this.m_context);
                String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
                eMFrameUtils.setMessage("error", strTitle, strError, this.m_context);
                return false;
            }
            this.m_context.addToHistory(userOE);
        }
        catch (Exception exc) {
            D.log(exc);
            eMFrameUtils.setErrorMessage(exc, this.m_context);
            return false;
        }
        this.m_dynamicGroupEnabled = RBSReportUtil.isDynamicGroupEnabled(this.m_context);
        this.m_roleDiscoveryDomain = RBSReportUtil.getRoleDiscoveryDomain(this.m_context);
        this.m_dynamicGroupDiscoveryDomain = RBSReportUtil.getDynamicGroupDiscoveryDomain(this.m_context);
        this.m_dynamicGroupSearchType = RBSReportUtil.getDynamicGroupSearchType(this.m_context);
        this.m_progressMessage = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.Initializing", this.m_context);
        this.m_inProgress = "true";
        String url = new String("webacc?taskId=" + eMFrameUtils.urlEncode(this.m_req.getParameter("taskId"), this.m_context) + "&merge=fw.GetTasksUserNameForm&User.context=" + this.m_req.getParameter("User.context") + "&nextState=refresh" + "&inProgress=" + this.m_inProgress + "&progressMessage=" + this.m_progressMessage + "&SelectedUserFDN=" + this.m_selectedUserFDN);
        this.m_resultStrings.put("UrlTask.url", url);
        ((I18NServletRequest)this.m_req).setParameter("merge", "fw.UrlTask");
        Date date = new Date();
        Locale locale = this.m_context.getLocale();
        String reportTime = DateFormat.getDateInstance(0, locale).format(date);
        String reportDate = DateFormat.getTimeInstance(0, locale).format(date);
        this.m_reportTime = eMFrameUtils.formatMessage("{0} ({1})", new String[]{reportTime, reportDate});
        this.m_stopThread = false;
        this.m_threadDone = false;
        this.reportThread = new ReportThread(userOE);
        this.reportThread.start();
        return true;
    }

    private void getReportAssociations(ObjectEntry userOE) {
        String roleDisplayName;
        int i;
        ArrayList<RBSRoleReport> reportList = new ArrayList<RBSRoleReport>();
        this.m_errors.clear();
        RBSAssociatedObject rbsAssociatedObject = new RBSAssociatedObject(userOE);
        if (!this.m_stopThread) {
            ++this.m_reportCount;
            try {
                RBSRoleReport[] directReportAssociation = rbsAssociatedObject.getDirectRoleReport(userOE);
                if (directReportAssociation != null) {
                    for (i = 0; i < directReportAssociation.length; ++i) {
                        roleDisplayName = RBSReportUtil.getRoleDisplayName(this.m_context, this.m_treeOE, directReportAssociation[i].getRoleFDN());
                        if (roleDisplayName != null) {
                            directReportAssociation[i].setRoleDisplayName(roleDisplayName);
                        }
                        reportList.add(directReportAssociation[i]);
                    }
                }
            }
            catch (Exception exc) {
                D.log(exc);
                ++this.m_reportsNotRead;
                this.m_errors.add(new String[]{eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.UserReport", this.m_context), eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.ReadingReportRequestFailed", this.m_context), eMFrameUtils.getExceptionMessage(exc, this.m_context), ""});
            }
        }
        if (!this.m_stopThread) {
            ++this.m_reportCount;
            try {
                RBSRoleReport[] groupReportAssociation = rbsAssociatedObject.getGroupRoleReport();
                if (groupReportAssociation != null) {
                    for (i = 0; i < groupReportAssociation.length; ++i) {
                        roleDisplayName = RBSReportUtil.getRoleDisplayName(this.m_context, this.m_treeOE, groupReportAssociation[i].getRoleFDN());
                        if (roleDisplayName != null) {
                            groupReportAssociation[i].setRoleDisplayName(roleDisplayName);
                        }
                        reportList.add(groupReportAssociation[i]);
                    }
                }
            }
            catch (Exception exc) {
                D.log(exc);
                ++this.m_reportsNotRead;
                this.m_errors.add(new String[]{eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.GroupReport", this.m_context), eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.ReadingReportRequestFailed", this.m_context), eMFrameUtils.getExceptionMessage(exc, this.m_context), ""});
            }
        }
        if (!this.m_stopThread) {
            ++this.m_reportCount;
            try {
                RBSRoleReport[] containerReportAssociation = rbsAssociatedObject.getContainerRoleReport(this.m_roleDiscoveryDomain);
                if (containerReportAssociation != null) {
                    for (i = 0; i < containerReportAssociation.length; ++i) {
                        roleDisplayName = RBSReportUtil.getRoleDisplayName(this.m_context, this.m_treeOE, containerReportAssociation[i].getRoleFDN());
                        if (roleDisplayName != null) {
                            containerReportAssociation[i].setRoleDisplayName(roleDisplayName);
                        }
                        reportList.add(containerReportAssociation[i]);
                    }
                }
            }
            catch (Exception exc) {
                D.log(exc);
                ++this.m_reportsNotRead;
                this.m_errors.add(new String[]{eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.ContainerReport", this.m_context), eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.ReadingReportRequestFailed", this.m_context), eMFrameUtils.getExceptionMessage(exc, this.m_context), ""});
            }
        }
        if (!this.m_stopThread) {
            ++this.m_reportCount;
            try {
                RBSRoleReport[] dynamicGroupReportAssociation = rbsAssociatedObject.getDynamicGroupRoleReport(this.m_dynamicGroupDiscoveryDomain, this.m_dynamicGroupSearchType);
                if (dynamicGroupReportAssociation != null) {
                    for (i = 0; i < dynamicGroupReportAssociation.length; ++i) {
                        roleDisplayName = RBSReportUtil.getRoleDisplayName(this.m_context, this.m_treeOE, dynamicGroupReportAssociation[i].getRoleFDN());
                        if (roleDisplayName != null) {
                            dynamicGroupReportAssociation[i].setRoleDisplayName(roleDisplayName);
                        }
                        reportList.add(dynamicGroupReportAssociation[i]);
                    }
                }
            }
            catch (Exception exc) {
                D.log(exc);
                ++this.m_reportsNotRead;
                this.m_errors.add(new String[]{eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.DynamicGroupReport", this.m_context), eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.ReadingReportRequestFailed", this.m_context), eMFrameUtils.getExceptionMessage(exc, this.m_context), ""});
            }
        }
        if (!this.m_stopThread) {
            ++this.m_reportCount;
            try {
                RBSRoleReport[] orgRoleReportAssociation = rbsAssociatedObject.getOrgRolesRoleReport();
                if (orgRoleReportAssociation != null) {
                    for (i = 0; i < orgRoleReportAssociation.length; ++i) {
                        roleDisplayName = RBSReportUtil.getRoleDisplayName(this.m_context, this.m_treeOE, orgRoleReportAssociation[i].getRoleFDN());
                        if (roleDisplayName != null) {
                            orgRoleReportAssociation[i].setRoleDisplayName(roleDisplayName);
                        }
                        reportList.add(orgRoleReportAssociation[i]);
                    }
                }
            }
            catch (Exception exc) {
                D.log(exc);
                ++this.m_reportsNotRead;
                this.m_errors.add(new String[]{eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.OrganizationalRoleReport", this.m_context), eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.ReadingReportRequestFailed", this.m_context), eMFrameUtils.getExceptionMessage(exc, this.m_context), ""});
            }
        }
        if (!this.m_stopThread) {
            ++this.m_reportCount;
            Hashtable<String, String> roleTable = new Hashtable<String, String>();
            for (i = 0; i < reportList.size(); ++i) {
                RBSRoleReport rbsRoleReport = (RBSRoleReport)reportList.get(i);
                String roleFDN = rbsRoleReport.getRoleFDN();
                if (roleTable.get(roleFDN) != null) continue;
                roleTable.put(roleFDN, roleFDN);
                try {
                    ObjectEntry roleOE = this.m_ns.getObjectEntry(this.m_treeOE, roleFDN);
                    RBSRole rbsRole = new RBSRole(roleOE);
                    RBSObject[] rbsObject = rbsRole.getContent();
                    if (rbsObject == null) continue;
                    for (int j = 0; j < rbsObject.length; ++j) {
                        ObjectEntry taskOE = rbsObject[j].getObjectEntry();
                        String taskFDN = this.m_ns.getUnrootedName(taskOE);
                        String taskDisplayName = RBSReportUtil.getTaskDisplayName(this.m_context, this.m_treeOE, taskFDN);
                        String roleDisplayName2 = RBSReportUtil.getRoleDisplayName(this.m_context, this.m_treeOE, rbsRoleReport.getRoleFDN());
                        RBSTaskReport rbsTaskReport = new RBSTaskReport(this.m_selectedUserFDN, taskDisplayName, taskFDN, roleDisplayName2, roleFDN);
                        this.m_taskList.add(rbsTaskReport);
                    }
                    continue;
                }
                catch (Exception exc) {
                    D.log(exc);
                    ++this.m_reportsNotRead;
                    this.m_errors.add(new String[]{eMFrameUtils.getLocalizedString("FwResources", "TasksToUserReport.TaskReport", this.m_context), eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.ReadingReportRequestFailed", this.m_context), eMFrameUtils.getExceptionMessage(exc, this.m_context), ""});
                    return;
                }
            }
        }
        this.m_sortColumn = "sortTaskName";
        this.m_sortDirection = "descending";
        Collections.sort(this.m_taskList, new RBSTaskReportSort(this.m_context, this.m_sortColumn, this.m_sortDirection));
    }

    private boolean refresh() {
        String taskId = this.m_req.getParameter("taskId");
        String userContext = this.m_req.getParameter("User.context");
        if (!this.m_threadDone) {
            if (this.m_reportCount == 0) {
                this.m_progressMessage = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.Initializing", this.m_context);
            } else {
                Object[] values = new String[]{Integer.toString(this.m_reportCount), Integer.toString(this.m_totalReportsCount)};
                this.m_progressMessage = eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.ReadingReport", this.m_context), values);
            }
            this.m_resultStrings.put("progressMessage", this.m_progressMessage);
        } else {
            String url = new String("webacc?taskId=" + eMFrameUtils.urlEncode(taskId, this.m_context) + "&User.context=" + userContext + "&nextState=finished");
            if (this.m_errors.size() > 0) {
                url = url + "&merge=dev.MooGenErr&GeneralMsg.Mode=error";
            }
            this.m_resultStrings.put("UrlTask.url", url);
            ((I18NServletRequest)this.m_req).setParameter("merge", "fw.UrlTask");
        }
        return true;
    }

    private boolean cancel() {
        this.m_stopThread = true;
        this.m_inProgress = "false";
        this.m_progressCancelled = "true";
        this.m_req.setAttribute("inProgress", (Object)this.m_inProgress);
        this.m_req.setAttribute("progressCancelled", (Object)this.m_progressCancelled);
        this.m_req.setAttribute("SelectedUserFDN", (Object)this.m_selectedUserFDN);
        return true;
    }

    private boolean finished() {
        if (this.m_errors.size() > 0) {
            String strTitle = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.ErrorTitle", this.m_context);
            String strBody = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.ErrorBody", this.m_context);
            Object[] values = new String[]{Integer.toString(this.m_totalReportsCount - this.m_reportsNotRead), Integer.toString(this.m_totalReportsCount)};
            eMFrameUtils.setMooErrorMessage(this.m_resultStrings, strTitle, eMFrameUtils.formatMessage(strBody, values), this.m_errors);
        } else {
            this.m_req.setAttribute("taskReportData", (Object)this.m_taskList);
            this.m_req.setAttribute("sortColumn", (Object)this.m_sortColumn);
            this.m_req.setAttribute("sortDirection", (Object)this.m_sortDirection);
            this.m_req.setAttribute("selectedUserFDN", (Object)this.m_selectedUserFDN);
            this.m_req.setAttribute("reportTime", (Object)this.m_reportTime);
            this.m_req.setAttribute("dynamicGroupEnabled", (Object)this.m_dynamicGroupEnabled);
            String taskId = this.m_req.getParameter("taskId");
            String userContext = this.m_req.getParameter("User.context");
            String url = new String("webacc?taskId=" + eMFrameUtils.urlEncode(taskId, this.m_context) + "&User.context=" + userContext);
            this.m_resultStrings.put("UrlTask.url", url);
            ((I18NServletRequest)this.m_req).setParameter("merge", "fw.TasksToUserReport");
        }
        return true;
    }

    private boolean sortByColumn() {
        this.m_sortColumn = this.m_req.getParameter("sortColumn");
        this.m_sortDirection = this.m_req.getParameter("sortDirection");
        Collections.sort(this.m_taskList, new RBSTaskReportSort(this.m_context, this.m_sortColumn, this.m_sortDirection));
        this.m_req.setAttribute("taskReportData", (Object)this.m_taskList);
        this.m_req.setAttribute("selectedUserFDN", (Object)this.m_selectedUserFDN);
        this.m_req.setAttribute("reportTime", (Object)this.m_reportTime);
        this.m_req.setAttribute("sortColumn", (Object)this.m_sortColumn);
        this.m_req.setAttribute("sortDirection", (Object)this.m_sortDirection);
        return true;
    }

    public boolean handleExportFile() {
        if (this.m_context != null && this.m_taskList != null) {
            this.m_exportUtil = new ReportsExportUtil(this.m_context, this.m_taskList);
            this.m_exportUtil.exportTasksToUserReport();
        }
        return true;
    }

    public boolean handlePostRequestActions(HttpServletRequest req, HttpServletResponse resp) throws GadgetInstanceException {
        return this.m_exportUtil.sendRedirect(req, resp);
    }

    class ReportThread
    extends Thread {
        private ObjectEntry m_userOE;

        public ReportThread(ObjectEntry userOE) {
            this.setPriority(4);
            this.setDaemon(true);
            this.m_userOE = userOE;
        }

        public void run() {
            TasksToUserReport.this.getReportAssociations(this.m_userOE);
            TasksToUserReport.this.m_threadDone = true;
        }
    }
}

