/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.fw.UnassignedTasksClass;
import java.text.Collator;
import java.util.Comparator;

public class UnassignedTasksReportSort
implements Comparator {
    public static final String SORT_DESCENDING = "descending";
    public static final String SORT_ASCENDING = "ascending";
    public static final String SORT_TASK_NAME = "sortTaskName";
    public static final String SORT_TASK_OBJECT = "sortTaskObject";
    public static final String SORT_COLLECTION_OBJECT = "sortCollectionObject";
    Collator m_collator = null;
    TaskContext m_context = null;
    String m_sortColumn = null;
    String m_sortDirection = null;

    public UnassignedTasksReportSort(TaskContext context, String sortColumn, String sortDirection) {
        this.m_context = context;
        this.m_sortColumn = sortColumn;
        this.m_sortDirection = sortDirection;
        this.m_collator = Collator.getInstance(this.m_context.getLocale());
    }

    public int compare(Object object1, Object object2) {
        int compare = 0;
        if (this.m_sortColumn.equalsIgnoreCase(SORT_TASK_NAME)) {
            String taskName1 = ((UnassignedTasksClass)object1).getTaskDisplayName();
            String taskName2 = ((UnassignedTasksClass)object2).getTaskDisplayName();
            compare = this.compareString(this.m_sortDirection, taskName1, taskName2);
        } else if (this.m_sortColumn.equalsIgnoreCase(SORT_TASK_OBJECT)) {
            String taskObject1 = ((UnassignedTasksClass)object1).getTaskFDN();
            String taskObject2 = ((UnassignedTasksClass)object2).getTaskFDN();
            compare = this.compareString(this.m_sortDirection, taskObject1, taskObject2);
        } else if (this.m_sortColumn.equalsIgnoreCase(SORT_COLLECTION_OBJECT)) {
            String collectionObject1 = ((UnassignedTasksClass)object1).getCollectionFDN();
            String collectionObject2 = ((UnassignedTasksClass)object2).getCollectionFDN();
            compare = this.compareString(this.m_sortDirection, collectionObject1, collectionObject2);
        }
        return compare;
    }

    private int compareString(String sortDirection, String object1, String object2) {
        int compare = 0;
        compare = sortDirection.equals(SORT_DESCENDING) ? this.m_collator.compare(object1, object2) : this.m_collator.compare(object2, object1);
        return compare;
    }
}

