/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.config.SystemConfig;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.util.eMFrameComponentInstall;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class UpdateTask
extends Task {
    private static final long serialVersionUID = 1L;
    HttpServletRequest req;
    TaskContext context;
    Properties resultStrings;
    Hashtable xmlInstallFiles;

    public boolean execute(TaskContext context, Properties resultStrings) {
        this.context = context;
        this.resultStrings = resultStrings;
        this.req = context.getRequest();
        String nextState = this.req.getParameter("nextState");
        if (nextState == null || nextState.equalsIgnoreCase("initialState")) {
            return this.showInitialForm();
        }
        if (nextState.equalsIgnoreCase("getTasks")) {
            return this.getTasks();
        }
        return this.showInitialForm();
    }

    private boolean showInitialForm() {
        return true;
    }

    private boolean getTasks() {
        String xmlFilePath = SystemConfig.getSystemConfig(this.context).getSetting("Provider.eMFrame.Install.path");
        File xmlDir = new File(xmlFilePath);
        ArrayList<TaskToUpdateInfo> taskInfoList = new ArrayList<TaskToUpdateInfo>();
        String t = this.req.getParameter("tasksToUpdate");
        String c = this.req.getParameter("collections");
        String[] tasks = eMFrameUtils.unpack(t, this.context);
        String[] collections = eMFrameUtils.unpack(c, this.context);
        for (int i = 0; i < collections.length; ++i) {
            if (collections[i] == null) continue;
            String currentC = collections[i];
            TaskToUpdateInfo taskInfo = new TaskToUpdateInfo(currentC);
            for (int x = i; x < collections.length; ++x) {
                if (collections[x] == null || !currentC.equals(collections[x])) continue;
                String currentT = tasks[x];
                taskInfo.taskId.add(currentT);
                this.processDirectory(xmlDir, true, taskInfo, tasks[x]);
                tasks[x] = null;
                collections[x] = null;
            }
            taskInfoList.add(taskInfo);
        }
        return this.doInstallPackage(taskInfoList);
    }

    private boolean doInstallPackage(ArrayList ListOfTasks) {
        AuthenticationBroker broker = this.context.getAuthenticationBroker();
        ObjectEntry treeOE = (ObjectEntry)broker.getAPIObject("NDSNamespace");
        boolean failure = false;
        for (int i = 0; i < ListOfTasks.size(); ++i) {
            eMFrameComponentInstall install = new eMFrameComponentInstall(treeOE, this.context);
            TaskToUpdateInfo taskElement = (TaskToUpdateInfo)ListOfTasks.get(i);
            String collectionContext = taskElement.collection;
            String[] installFile = taskElement.xmlFiles.toArray(new String[0]);
            String dynamicGroupSearchType = FwUtils.getDynamicSearchType(this.context);
            try {
                install.installPlugin(collectionContext, installFile, null, dynamicGroupSearchType);
                continue;
            }
            catch (Exception exc) {
                failure = true;
            }
        }
        if (!failure) {
            this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "HiddenPluginsUpdateTaskSuccessHead", this.context));
            this.resultStrings.put("GeneralMsg.MsgBodyPlainText", eMFrameUtils.getLocalizedString("FwResources", "HiddenPluginsUpdateTaskSuccess", this.context));
            return true;
        }
        this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "HiddenPluginsUpdateTaskFailureHead", this.context));
        this.resultStrings.put("GeneralMsg.MsgBodyPlainText", eMFrameUtils.getLocalizedString("FwResources", "HiddenPluginsUpdateTaskFailure", this.context));
        return true;
    }

    public void processDirectory(File xmlDirPath, boolean firstLevel, TaskToUpdateInfo tInfo, String taskName) {
        String[] children = xmlDirPath.list();
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                File child = new File(xmlDirPath, children[i]);
                if (child.isDirectory()) {
                    this.processDirectory(child, false, tInfo, taskName);
                    continue;
                }
                if (firstLevel) continue;
                this.processNode(child, tInfo, taskName);
            }
        }
    }

    public void processNode(File file, TaskToUpdateInfo taskInfo, String taskId) {
        if (file.getName().toLowerCase().endsWith("xml")) {
            try {
                SAXBuilder saxBuilder = new SAXBuilder(false);
                Document doc = saxBuilder.build(file);
                Element root = doc.getRootElement();
                String strType = root.getName();
                if (strType.equals("install")) {
                    List taskList = root.getChildren("task");
                    Iterator i = taskList.iterator();
                    while (i.hasNext()) {
                        Element task = (Element)i.next();
                        String id = task.getChild("id").getTextTrim();
                        if (!id.equalsIgnoreCase(taskId)) continue;
                        String fileName = file.toString();
                        taskInfo.xmlFiles.add(fileName);
                    }
                }
            }
            catch (Exception e) {
                D.log(e);
                D.log("InstallPackageTask::Error processing file: " + file.getName() + ", ignoring file");
            }
        }
    }

    class TaskToUpdateInfo {
        public String collection = null;
        public Set xmlFiles;
        public ArrayList taskId;

        public TaskToUpdateInfo(String collection) {
            this.collection = collection;
            this.xmlFiles = new HashSet();
            this.taskId = new ArrayList();
        }
    }
}

