/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.emframe.dev.D;

public class VersionInfo {
    private Integer m_major;
    private Integer m_minor;
    private Integer m_rev;
    private Integer m_build;

    public VersionInfo() {
        this.m_major = new Integer(0);
        this.m_minor = new Integer(0);
        this.m_rev = new Integer(0);
        this.m_build = new Integer(0);
    }

    public VersionInfo(String versionString) {
        this.setVersionFromVersionString(versionString);
    }

    public VersionInfo(Integer major, Integer minor, Integer rev, Integer build) {
        this.m_major = major;
        this.m_minor = minor;
        this.m_rev = rev;
        this.m_build = build;
    }

    public VersionInfo(Integer major, Integer minor, Integer rev) {
        this.m_major = major;
        this.m_minor = minor;
        this.m_rev = rev;
        this.m_build = new Integer(0);
    }

    public void setMajor(Integer major) {
        this.m_major = major;
    }

    public Integer getMajor() {
        return this.m_major;
    }

    public void setMinor(Integer minor) {
        this.m_minor = minor;
    }

    public Integer getMinor() {
        return this.m_minor;
    }

    public void setRev(Integer rev) {
        this.m_rev = rev;
    }

    public Integer getRev() {
        return this.m_rev;
    }

    public void setBuild(Integer build) {
        this.m_build = build;
    }

    public Integer getBuild() {
        return this.m_build;
    }

    public int compareTo(VersionInfo version) {
        int value = this.m_major.compareTo(version.getMajor());
        if (value == 0 && (value = this.m_minor.compareTo(version.getMinor())) == 0 && (value = this.m_rev.compareTo(version.getRev())) == 0) {
            value = this.m_build.compareTo(version.getBuild());
        }
        return value;
    }

    public String setVersionFromVersionString(String versionString) {
        String originalVersionString = versionString;
        String validString = null;
        boolean truncated = false;
        String majorStr = "0";
        String minorStr = "0";
        String revStr = "0";
        String buildStr = "0";
        validString = this.validateVersionString(versionString);
        if (validString == null) {
            if (versionString != null && !versionString.equals("")) {
                majorStr = versionString;
                if (versionString.indexOf(".") != -1) {
                    majorStr = versionString.substring(0, versionString.indexOf("."));
                    minorStr = versionString = versionString.substring(versionString.indexOf(".") + 1, versionString.length());
                    if (versionString.indexOf(".") != -1) {
                        minorStr = versionString.substring(0, versionString.indexOf("."));
                        revStr = versionString = versionString.substring(versionString.indexOf(".") + 1, versionString.length());
                        if (versionString.indexOf(".") != -1) {
                            revStr = versionString.substring(0, versionString.indexOf("."));
                            buildStr = versionString = versionString.substring(versionString.indexOf(".") + 1, versionString.length());
                            if (versionString.indexOf(".") != -1) {
                                buildStr = versionString.substring(0, versionString.indexOf("."));
                            }
                        }
                    }
                }
            }
            if (majorStr.length() > 8) {
                truncated = true;
                majorStr = majorStr.substring(0, 8);
            }
            if (minorStr.length() > 8) {
                truncated = true;
                minorStr = minorStr.substring(0, 8);
            }
            if (revStr.length() > 8) {
                truncated = true;
                revStr = revStr.substring(0, 8);
            }
            if (buildStr.length() > 8) {
                truncated = true;
                buildStr = buildStr.substring(0, 8);
            }
        }
        this.m_major = new Integer(majorStr);
        this.m_minor = new Integer(minorStr);
        this.m_rev = new Integer(revStr);
        this.m_build = new Integer(buildStr);
        if (truncated) {
            D.log("WARNING: Truncating  Version: " + originalVersionString + " to " + this.getVersionString() + ".");
        }
        return validString;
    }

    public String getVersionString() {
        String version = this.m_major.toString() + "." + this.m_minor.toString() + "." + this.m_rev.toString();
        if (this.m_build > 0) {
            version = version + "." + this.m_build.toString();
        }
        return version;
    }

    public String validateVersionString(String versionString) {
        String validString = null;
        String validChars = "0123456789.";
        for (int i = 0; i < versionString.length(); ++i) {
            char c = versionString.charAt(i);
            if (validChars.indexOf(c) != -1) continue;
            validString = "Invalid character[" + c + "] at position " + (i + 1);
            break;
        }
        return validString;
    }
}

