/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw.config;

import com.novell.emframe.dev.D;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class ConfigRecord
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String RECORD_CHAR_SET = "UTF-8";
    private static final String COMMENT_BEGIN = "<!--";
    private static final String COMMENT_END = "-->";
    private static final String CONFIG_ID_TAG = "ConfigID=";
    private static final String NULL_STR = "null";
    private boolean m_bIsValid = true;
    private String m_sConfigID = null;
    private String m_sRecordData = null;
    private String m_sFileName = null;
    private byte[] m_baRawData = null;

    public ConfigRecord() {
    }

    public ConfigRecord(String sConfigID) {
        this.m_sConfigID = sConfigID;
    }

    public ConfigRecord(String sConfigID, String sRecordData) {
        this.m_sConfigID = sConfigID;
        this.m_sRecordData = sRecordData;
    }

    public boolean isValid() {
        return this.m_bIsValid;
    }

    public void setConfigID(String sConfigID) {
        this.m_sConfigID = sConfigID;
    }

    public String getConfigID() {
        return this.m_sConfigID;
    }

    public String getFileName() {
        return this.m_sFileName;
    }

    public void setFileName(String sFileName) {
        this.m_sFileName = sFileName;
    }

    public byte[] getRawData() {
        return this.m_baRawData;
    }

    public void setRawData(byte[] baRawData) {
        this.m_baRawData = baRawData;
    }

    public void setRecordData(String sRecordData) {
        this.m_sRecordData = sRecordData;
    }

    public String getRecordData() {
        return this.m_sRecordData;
    }

    public void read(InputStream is) {
        try {
            int i;
            int iSize = is.available();
            byte[] ba = new byte[iSize];
            is.read(ba);
            String sTemp = new String(ba, 0, iSize, RECORD_CHAR_SET);
            boolean bFound = false;
            for (i = 0; i < sTemp.length(); ++i) {
                char ch = sTemp.charAt(i);
                if (ch != '\n' && ch != '\r') continue;
                bFound = true;
                break;
            }
            if (bFound) {
                this.m_sRecordData = sTemp.substring(i + 1);
            }
            String sFirstLine = sTemp.substring(0, i);
            this.parseID(sFirstLine);
        }
        catch (IOException e) {
            D.log(e);
        }
    }

    private void parseID(String sLine) {
        int j;
        int i;
        boolean bFoundConfigID = false;
        if (sLine != null && (i = sLine.indexOf(COMMENT_BEGIN)) != -1 && (j = sLine.indexOf(COMMENT_END, i + COMMENT_BEGIN.length())) != -1) {
            String sTemp = sLine.substring(i + COMMENT_BEGIN.length(), j);
            j = 0;
            i = sTemp.indexOf(CONFIG_ID_TAG);
            if (i != -1) {
                bFoundConfigID = true;
                StringBuffer sb = new StringBuffer();
                j = this.parseID(sTemp, i + CONFIG_ID_TAG.length(), sb);
                this.m_sConfigID = sb.toString();
                if (this.m_sConfigID.equals(NULL_STR)) {
                    this.m_sConfigID = null;
                }
            }
        }
        if (!bFoundConfigID) {
            this.m_bIsValid = false;
        }
    }

    private int parseID(String sStr, int iIndex, StringBuffer sbRet) {
        int i;
        sbRet.setLength(0);
        boolean bInQuote = false;
        for (i = iIndex; i < sStr.length(); ++i) {
            char ch = sStr.charAt(i);
            if (ch == '\"') {
                bInQuote = !bInQuote;
                continue;
            }
            if (bInQuote) {
                sbRet.append(ch);
                continue;
            }
            if (Character.isWhitespace(ch)) break;
            sbRet.append(ch);
        }
        return i;
    }

    public void write(OutputStream os) {
        if (this.m_sRecordData == null) {
            return;
        }
        try {
            byte[] ba = null;
            StringBuffer sb = new StringBuffer(100);
            sb.append(COMMENT_BEGIN);
            sb.append(" ");
            sb.append(CONFIG_ID_TAG);
            sb.append("\"");
            sb.append(this.m_sConfigID);
            sb.append("\" ");
            sb.append(COMMENT_END);
            sb.append("\n");
            String sFirstLine = sb.toString();
            ba = sFirstLine.getBytes(RECORD_CHAR_SET);
            os.write(ba);
            ba = this.m_sRecordData.getBytes(RECORD_CHAR_SET);
            os.write(ba);
        }
        catch (IOException e) {
            D.log(e);
        }
    }

    public boolean isMatch(String sConfigID) {
        return this.isConfigMatch(sConfigID);
    }

    private boolean isConfigMatch(String sConfigID) {
        boolean bRet = false;
        if (sConfigID != null && this.m_sConfigID != null) {
            if (sConfigID.equals(this.m_sConfigID)) {
                bRet = true;
            }
        } else if (sConfigID == null && this.m_sConfigID == null) {
            bRet = true;
        }
        return bRet;
    }
}

