/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw.config;

import com.novell.emframe.dev.XmlUtils;
import com.novell.emframe.fw.config.ConfigRecord;
import com.novell.emframe.fw.config.Setting;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ConfigSettings {
    private ConfigRecord m_configRecord = null;
    private HashMap m_hmSettings = new HashMap();
    private String m_sConfigID = null;
    private Document m_document = null;
    private boolean m_bHasChanged = false;
    public static final String ROOT_CONFIG_ELEMENT = "config";
    public static final String SETTING_CONFIG_ELEMENT = "setting";
    public static final String VALUE_CONFIG_ELEMENT = "value";
    public static final String NAME_CONFIG_ELEMENT = "name";
    public static final String CDATA_START = "<![CDATA[";
    public static final String CDATA_END = "]]>";

    public ConfigSettings() {
    }

    public ConfigSettings(ConfigRecord record) {
        this.m_configRecord = record;
        if (record != null) {
            this.m_sConfigID = record.getConfigID();
        }
        this.read();
    }

    public ConfigSettings(String configID, String taskID) {
        this.m_sConfigID = configID;
    }

    public String getConfigID() {
        return this.m_sConfigID;
    }

    public void setConfigID(String configID) {
        this.m_sConfigID = configID;
    }

    protected ConfigRecord getConfigRecord() {
        this.write();
        return this.m_configRecord;
    }

    private void setConfigRecord(ConfigRecord record) {
        this.m_configRecord = record;
        this.read();
    }

    public Document getDocument() {
        return this.m_document;
    }

    public void setDocument(Document m_document) {
        this.m_document = m_document;
    }

    public boolean isChanged() {
        return this.m_bHasChanged;
    }

    public void setChanged(boolean hasChanged) {
        this.m_bHasChanged = hasChanged;
    }

    public HashMap getSettings() {
        return this.m_hmSettings;
    }

    public void setSettings(HashMap settings) {
        this.m_hmSettings = settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSettingNames() {
        if (this.m_hmSettings == null) {
            return null;
        }
        String[] keyNames = null;
        HashMap hashMap = this.m_hmSettings;
        synchronized (hashMap) {
            Set set = this.m_hmSettings.keySet();
            if (set != null) {
                keyNames = new String[set.size()];
                set.toArray(keyNames);
            }
        }
        return keyNames;
    }

    public String[] getSetting(String setting) {
        Vector values;
        if (setting == null) {
            return null;
        }
        Setting tempSetting = (Setting)this.m_hmSettings.get(setting);
        if (tempSetting != null && (values = tempSetting.getValues()) != null && values.size() != 0) {
            return values.toArray(new String[1]);
        }
        return null;
    }

    public String getSingleSetting(String setting) {
        return this.getSingleSetting(setting, null);
    }

    public String getSingleSetting(String setting, String defaultValue) {
        Vector values;
        if (setting == null) {
            return defaultValue;
        }
        Setting tempSetting = (Setting)this.m_hmSettings.get(setting);
        if (tempSetting != null && (values = tempSetting.getValues()) != null && values.size() != 0) {
            return (String)values.elementAt(0);
        }
        return defaultValue;
    }

    public void setSetting(String setting, String[] values) {
        if (setting == null) {
            return;
        }
        if (values == null || values.length == 0) {
            this.removeSetting(setting);
            return;
        }
        Vector<String> vValues = null;
        int numValues = values.length;
        vValues = new Vector<String>();
        for (int i = 0; i < numValues; ++i) {
            if (values[i] == null || values[i].length() == 0) continue;
            vValues.add(values[i]);
        }
        if (vValues.size() == 0) {
            this.removeSetting(setting);
            return;
        }
        Setting newSetting = new Setting(setting, vValues);
        this.m_hmSettings.put(setting, newSetting);
        this.m_bHasChanged = true;
    }

    public void setSetting(String setting, String value) {
        if (setting == null) {
            return;
        }
        String[] saValues = null;
        if (value != null && value.length() > 0) {
            saValues = new String[]{value};
        }
        this.setSetting(setting, saValues);
    }

    public void addSettingValue(String setting, String value) {
        if (setting == null || value == null) {
            return;
        }
        Setting tempSetting = (Setting)this.m_hmSettings.get(setting);
        if (tempSetting != null) {
            tempSetting.addValue(value);
        } else {
            this.setSetting(setting, value);
        }
        this.m_bHasChanged = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSetting(String setting) {
        if (setting == null) {
            return;
        }
        HashMap hashMap = this.m_hmSettings;
        synchronized (hashMap) {
            this.m_hmSettings.remove(setting);
        }
        this.m_bHasChanged = true;
    }

    public void removeSettingValue(String setting, String value) {
        if (setting == null || value == null) {
            return;
        }
        Setting tempSetting = (Setting)this.m_hmSettings.get(setting);
        if (tempSetting != null) {
            tempSetting.removeValue(value);
        }
        this.m_bHasChanged = true;
    }

    private void buildDom(String data) {
        if (data == null) {
            return;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            ByteArrayInputStream ba = new ByteArrayInputStream(data.getBytes("UTF-8"));
            this.m_document = builder.parse(ba);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    protected void readDom() {
        try {
            if (this.m_document == null) {
                return;
            }
            Document root = this.m_document;
            NodeList nl = root.getChildNodes();
            if (nl.getLength() == 0) {
                return;
            }
            Node rootElement = nl.item(0);
            if (!rootElement.getNodeName().equals(ROOT_CONFIG_ELEMENT)) {
                return;
            }
            NodeList configSettingsList = rootElement.getChildNodes();
            for (int i = 0; i < configSettingsList.getLength(); ++i) {
                Node settingElement = configSettingsList.item(i);
                if (settingElement.getNodeType() != 1 || !settingElement.getNodeName().equals(SETTING_CONFIG_ELEMENT)) continue;
                Vector<String> vValues = new Vector<String>();
                String settingName = null;
                NodeList settingValueList = settingElement.getChildNodes();
                for (int j = 0; j < settingValueList.getLength(); ++j) {
                    Node valueData;
                    Node valueElement = settingValueList.item(j);
                    if (valueElement.getNodeType() != 1) continue;
                    if (valueElement.getNodeName().equals(NAME_CONFIG_ELEMENT)) {
                        valueData = valueElement.getFirstChild();
                        if (valueData.getNodeType() != 4 && valueData.getNodeType() != 3) continue;
                        settingName = XmlUtils.xmlDecode(valueData.getNodeValue());
                        continue;
                    }
                    if (!valueElement.getNodeName().equals(VALUE_CONFIG_ELEMENT) || (valueData = valueElement.getFirstChild()) == null || valueData.getNodeType() != 4 && valueData.getNodeType() != 3) continue;
                    vValues.add(XmlUtils.xmlDecode(valueData.getNodeValue()));
                }
                if (settingName == null || vValues.size() <= 0) continue;
                String[] saTemp = new String[vValues.size()];
                vValues.toArray(saTemp);
                this.setSetting(settingName, saTemp);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void mergeConfig(ConfigSettings newConfig) {
        if (newConfig == null) {
            return;
        }
        if (newConfig.getSettings() == null) {
            return;
        }
        this.m_hmSettings.putAll(newConfig.getSettings());
    }

    public ConfigSettings copy() {
        ConfigSettings cs = new ConfigSettings();
        cs.setConfigID(this.getConfigID());
        cs.setConfigRecord(this.getConfigRecord());
        cs.setSettings((HashMap)this.getSettings().clone());
        return cs;
    }

    private void read() {
        if (this.m_configRecord == null) {
            return;
        }
        this.m_bHasChanged = false;
        String data = this.m_configRecord.getRecordData();
        this.buildDom(data);
        this.readDom();
    }

    public String toXMLString() {
        String data = "";
        data = data + "<config>\n";
        String[] settings = this.getSettingNames();
        for (int i = 0; i < settings.length; ++i) {
            Setting setting = (Setting)this.m_hmSettings.get(settings[i]);
            data = data + setting.toXMLString() + "\n";
        }
        data = data + "</config>";
        return data;
    }

    private void write() {
        if (!this.m_bHasChanged) {
            return;
        }
        if (this.m_configRecord == null) {
            this.m_configRecord = new ConfigRecord(this.m_sConfigID);
        }
        this.m_configRecord.setRecordData(this.toXMLString());
        this.m_bHasChanged = false;
    }
}

