/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw.config;

import com.novell.emframe.fw.config.ConfigManager;
import com.novell.emframe.fw.config.ConfigSettings;
import java.util.Map;

public class SystemConfigManager {
    private static ConfigManager m_sysConfigManager = null;

    public static void init() {
        m_sysConfigManager = new ConfigManager();
        ConfigSettings rootSettings = m_sysConfigManager.getConfigSettings(null);
        if (rootSettings != null) {
            String sCacheSize = rootSettings.getSingleSetting("ConfigSettingsCacheSize", String.valueOf(m_sysConfigManager.getCacheSize()));
            int cacheSize = Integer.valueOf(sCacheSize);
            m_sysConfigManager.setCacheSize(cacheSize);
        }
    }

    public static String[] getSettingNames(String sysConfigID) {
        return m_sysConfigManager.getSettingNames(sysConfigID);
    }

    public static String[] getSetting(String sysConfigID, String setting) {
        return m_sysConfigManager.getSetting(sysConfigID, setting);
    }

    public static String getSingleSetting(String sysConfigID, String setting) {
        return m_sysConfigManager.getSingleSetting(sysConfigID, setting);
    }

    public static String getSingleSetting(String sysConfigID, String setting, String defaultValue) {
        return m_sysConfigManager.getSingleSetting(sysConfigID, setting, defaultValue);
    }

    public static void setSetting(String sysConfigID, String setting, String[] values) {
        m_sysConfigManager.setSetting(sysConfigID, setting, values);
    }

    public static void setSetting(String sysConfigID, String setting, String value) {
        m_sysConfigManager.setSetting(sysConfigID, setting, value);
    }

    public static void addSettingValue(String sysConfigID, String setting, String value) {
        m_sysConfigManager.addSettingValue(sysConfigID, setting, value);
    }

    public static void removeSettingValue(String sysConfigID, String setting, String value) {
        m_sysConfigManager.removeSettingValue(sysConfigID, setting, value);
    }

    public static void removeSetting(String sysConfigID, String setting) {
        m_sysConfigManager.removeSetting(sysConfigID, setting);
    }

    public static ConfigSettings getConfigSettings(String sysConfigID) {
        return m_sysConfigManager.getConfigSettings(sysConfigID);
    }

    public static void writeSettings(String sysConfigID) {
        m_sysConfigManager.writeSettings(sysConfigID);
    }

    public static int getCacheSize() {
        return m_sysConfigManager.getCacheSize();
    }

    public static Map getSystemConfigAsMap() {
        return m_sysConfigManager.getConfigSettings(null).getSettings();
    }

    static {
        SystemConfigManager.init();
    }
}

