/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.MappingObject;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.config.SystemConfig;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.RBSUtil;
import com.novell.emframe.fw.XmlElement;
import com.novell.emframe.fw.util.RBSObjectInstaller;
import com.novell.emframe.fw.xmlinfos.ModuleClassObject;
import com.novell.emframe.fw.xmlinfos.XMLFileReader;
import com.novell.rbs.RBSCollection;
import com.novell.rbs.RBSObject;
import com.novell.rbs.RBSObjectCreator;
import com.novell.rbs.RBSRole;
import com.novell.rbs.RBSTask;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.text.Collator;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class eGuideCreateTask
extends Task {
    private static final long serialVersionUID = 1L;
    private HttpServletRequest req;
    private TaskContext context;
    private Properties resultStrings;
    private AdminNamespace namespace;
    private ObjectEntry treeOE;
    private Collator m_collator;
    private Locale m_locale;
    private boolean m_isLDAP;

    public static void shouldRun(HttpServletRequest req, String sServiceName) throws Exception {
        FwUtils.verifyRbsInstalled(req, sServiceName);
    }

    public boolean execute(TaskContext context, Properties resultStrings) {
        this.context = context;
        this.resultStrings = resultStrings;
        this.req = context.getRequest();
        this.treeOE = RBSUtil.getTreeOE(context);
        this.namespace = this.treeOE.getAdminNamespace();
        this.m_locale = context.getLocale();
        this.m_collator = Collator.getInstance(this.m_locale);
        this.m_isLDAP = this.namespace.getUniqueID().equalsIgnoreCase("LDAP");
        String nextState = this.req.getParameter("nextState");
        if (nextState == null || nextState.equalsIgnoreCase("initialState")) {
            return this.showInitialForm();
        }
        if (nextState.equalsIgnoreCase("getEGuideAddress")) {
            return this.getEGuideAddress();
        }
        if (nextState.equalsIgnoreCase("retrieveCategories")) {
            return this.retrieveCategories();
        }
        if (nextState.equalsIgnoreCase("displayCategoryAttributes")) {
            return this.displayCategoryAttributes();
        }
        if (nextState.equalsIgnoreCase("displayAlleGuideRoles")) {
            return this.displayAlleGuideRoles();
        }
        if (nextState.equalsIgnoreCase("wizardFinished")) {
            return this.wizardFinished();
        }
        if (nextState.equalsIgnoreCase("taskSummary")) {
            return this.taskSummary();
        }
        return this.showInitialForm();
    }

    private boolean getEGuideAddress() {
        String sTaskContext;
        D.log("Inside getEGuideAddress method");
        String sTaskName = this.req.getParameter("CreateTaskName");
        String sOriginalTaskContext = sTaskContext = this.req.getParameter("CreateTaskContext");
        String sTaskDescription = this.req.getParameter("CreateTaskDescription");
        if (sTaskName == null || sTaskName.length() == 0) {
            this.reportLocalizedError("TaskBuilder.MustEnterTaskName");
        }
        if (sTaskContext == null || sTaskContext.length() == 0) {
            this.reportLocalizedError("CreateRole.InvalidRoleContext");
        }
        ObjectEntry oeModule = null;
        try {
            oeModule = this.namespace.getObjectEntry(sTaskContext);
        }
        catch (SPIException ex) {
            D.log(ex.getLocalizedMessage());
        }
        if (oeModule == null) {
            this.reportLocalizedError("CreateRole.InvalidRoleContext");
            return false;
        }
        if (!oeModule.getTypeName().equals("rbsCollection2")) {
            this.reportLocalizedError("CreateRole.InvalidRoleContext");
        }
        oeModule = null;
        String eGuide = "eguide";
        if (this.m_isLDAP) {
            eGuide = "cn=eguide";
        }
        try {
            oeModule = this.namespace.getObjectEntry(RBSUtil.concatStr(this.namespace, eGuide, sTaskContext));
        }
        catch (SPIException ex) {
            D.log(ex.getLocalizedMessage());
        }
        if (oeModule == null) {
            RBSObjectCreator rbs = new RBSObjectCreator(this.treeOE);
            try {
                rbs.createRBSModule(sTaskContext, eGuide);
            }
            catch (Exception ex) {
                D.log(ex.toString());
                this.reportError("Could not create eGuide rbsModule: " + sTaskContext);
                return false;
            }
        }
        sTaskContext = RBSUtil.concatStr(this.namespace, "eguide", sTaskContext);
        String sTaskFullContext = RBSUtil.concatStr(this.namespace, sTaskName, sTaskContext);
        ObjectEntry oeTask = null;
        try {
            oeTask = this.namespace.getObjectEntry(sTaskFullContext);
        }
        catch (SPIException ex) {
            D.log("Task name available: " + sTaskFullContext);
        }
        if (oeTask != null) {
            this.reportLocalizedError("DevelopersForm.Task.NameExist");
            return false;
        }
        this.context.setAuthAttribute("fw.eGuideTaskName", sTaskName);
        this.context.setAuthAttribute("fw.eGuideTaskContext", sOriginalTaskContext);
        if (sTaskDescription != null || sTaskDescription.length() > 0) {
            this.context.setAuthAttribute("fw.eGuideTaskDescription", sTaskDescription);
        }
        this.resultStrings.put("SearchFilter", "rbsRole2");
        String sEG = SystemConfig.getSystemConfig(this.context).getSetting("Provider.eMFrame.eGuide.location");
        if ((sEG == null || sEG.equals("EMFRAME_SERVER")) && (sEG = FwUtils.getDefaulteGuideLocation(this.context)).startsWith("https:")) {
            sEG = "http" + sEG.substring(sEG.indexOf(":"), sEG.length());
        }
        this.resultStrings.put("eGuideServerAddress", sEG);
        return true;
    }

    private boolean showInitialForm() {
        D.log("Inside showInitialForm method");
        String taskDelegate = this.req.getParameter("RBSAdmin_TaskDelegate");
        if (taskDelegate == null) {
            this.context.setAuthAttribute("RBSAdmin_TaskDelegate", "");
            this.resultStrings.put("RBSAdmin_TaskDelegate", "");
        } else {
            this.context.setAuthAttribute("RBSAdmin_TaskDelegate", taskDelegate);
            this.resultStrings.put("RBSAdmin_TaskDelegate", taskDelegate);
            String selectedCollectionName = this.req.getParameter("selectedCollectionName");
            String[] strings = eMFrameUtils.unpack(selectedCollectionName, this.context);
            selectedCollectionName = strings[0];
            this.resultStrings.put("selectedCollectionName", selectedCollectionName);
            String CreateTaskContext = this.req.getParameter("CreateTaskContext");
            strings = eMFrameUtils.unpack(CreateTaskContext, this.context);
            CreateTaskContext = strings[0];
            this.resultStrings.put("CreateTaskContext", CreateTaskContext);
        }
        return true;
    }

    private boolean retrieveCategories() {
        D.log("Inside retrieveCategories method");
        String sEguideURL = this.req.getParameter("ServerAddress");
        return this.getEGuideCategories(sEguideURL);
    }

    private boolean displayCategoryAttributes() {
        D.log("Inside displayCategoryAttributes method");
        return this.getEGuideAttributes((String)this.context.getAuthAttribute("fw.eGuideServerAddress"), this.req.getParameter("CategoryList"));
    }

    private boolean getEGuideAttributes(String sURL, String sCategory) {
        D.log("Inside getEGuideAttributes method");
        if (sURL == null || sURL.length() == 0) {
            this.reportLocalizedError("eGuide.Taskbuilder.InvalidURL.Label");
            return false;
        }
        if (sCategory == null || sCategory.length() == 0) {
            this.reportError("Invalid eGuide Category");
            return false;
        }
        String sXML = null;
        sXML = this.postRequest(sURL + "?Action=RequestCategoryAttributes" + "&RenderXML=true" + "&Category=" + sCategory);
        if (sXML == null) {
            D.log("Attributes not accessible through eGuide: " + sURL);
            this.reportLocalizedError("eGuide.Taskbuilder.InvalidURL.Label");
            return false;
        }
        XmlElement xmlBase = XmlElement.parseXml(sXML);
        Vector vElements = xmlBase.getChildren("eGuide");
        xmlBase = (XmlElement)vElements.elementAt(0);
        vElements = xmlBase.getChildren("Category");
        xmlBase = (XmlElement)vElements.elementAt(0);
        Vector<MyXmlElement> vAttributes = xmlBase.getChildren("Attribute");
        Vector<MyXmlElement> vSortedAttributes = new Vector<MyXmlElement>();
        MappingObject mo = this.context.getDirUtils().getMappingObject();
        for (int i = 0; i < vAttributes.size(); ++i) {
            String sAttr = ((XmlElement)vAttributes.elementAt(i)).getChildTextTrim("Name");
            if (mo.LDAPAttributeToNDS(sAttr) == null) {
                D.log("Warning: No LDAP mapping for attribute: " + sAttr);
                continue;
            }
            vSortedAttributes.addElement(new MyXmlElement((XmlElement)vAttributes.elementAt(i), "Name"));
        }
        Collections.sort(vSortedAttributes);
        vAttributes = vSortedAttributes;
        XmlElement xmlAttr = null;
        this.resultStrings.put("Attribute.Count", Integer.toString(vAttributes.size()));
        Properties p = new Properties();
        for (int i = 0; i < vAttributes.size(); ++i) {
            xmlAttr = (XmlElement)vAttributes.elementAt(i);
            this.resultStrings.put("Attribute." + i + ".Name", xmlAttr.getChildTextTrim("Name"));
            p.put(xmlAttr.getChildTextTrim("Name"), xmlAttr.getChildTextTrim("Key"));
        }
        this.context.setAuthAttribute("fw.eGuideAttributeKeys", p);
        this.context.setAuthAttribute("fw.eGuideCategory", sCategory);
        return true;
    }

    private boolean displayAlleGuideRoles() {
        D.log("Inside displayAlleGuideRoles method");
        this.resultStrings.put("eGuide.Category", this.context.getAuthAttribute("fw.eGuideCategory"));
        Enumeration myenum = this.req.getParameterNames();
        Vector<String> vEnabledAttrs = new Vector<String>();
        Hashtable<String, String> hEditAttrs = new Hashtable<String, String>();
        if (this.req.getParameter("BackSelected") != null) {
            if (this.context.getAuthAttribute("fw.selectedEGuideRoles") != null) {
                this.context.removeAuthAttribute("fw.selectedEGuideRoles");
            }
        } else {
            XmlElement xmlNode;
            while (myenum.hasMoreElements()) {
                String sAttrName = (String)myenum.nextElement();
                int index = sAttrName.indexOf("_Enabled");
                if (index == -1) continue;
                String sAttrNameOnly = sAttrName.substring(0, index);
                vEnabledAttrs.addElement(sAttrNameOnly);
                if (this.req.getParameter(sAttrNameOnly + "_Editable") == null) continue;
                hEditAttrs.put(sAttrNameOnly, "true");
            }
            this.context.setAuthAttribute("eGuide.EnabledAttrs", vEnabledAttrs);
            if (vEnabledAttrs.size() == 0) {
                this.reportLocalizedError("eGuide.Taskbuilder.EnableAttribute.Label");
                return false;
            }
            Properties pKeys = (Properties)this.context.getAuthAttribute("fw.eGuideAttributeKeys");
            XmlElement xmlRole = new XmlElement("Attributes", "");
            myenum = vEnabledAttrs.elements();
            while (myenum.hasMoreElements()) {
                String sAttr = (String)myenum.nextElement();
                xmlNode = new XmlElement("Attribute", "");
                xmlNode.add(new XmlElement("Name", sAttr));
                xmlNode.add(new XmlElement("Key", pKeys.getProperty(sAttr)));
                xmlNode.add(new XmlElement("Editable", hEditAttrs.containsKey(sAttr) ? "true" : "false"));
                xmlRole.add(xmlNode);
            }
            this.context.setAuthAttribute("fw.eGuideTaskXML", xmlRole.toString());
            myenum = vEnabledAttrs.elements();
            XmlElement xmlUpdate = new XmlElement("Resources", "");
            while (myenum.hasMoreElements()) {
                String sKey = (String)myenum.nextElement();
                String sVal = ((String)pKeys.get(sKey)).toUpperCase();
                xmlNode = new XmlElement("Resource", "");
                xmlNode.add(new XmlElement("Key", sVal));
                xmlNode.add(new XmlElement("Value", sVal));
                xmlUpdate.add(xmlNode);
            }
            String sURL = (String)this.context.getAuthAttribute("fw.eGuideServerAddress");
            sURL = sURL + "?Action=UpdateResources&RenderXML=true&Resources=" + xmlUpdate.toString();
            this.context.setAuthAttribute("fw.eGuideResourceUpdateXML", sURL);
        }
        String sTaskContext = (String)this.context.getAuthAttribute("fw.eGuideTaskContext");
        int iRoleCounter = 0;
        Hashtable<String, RBSRole> hRoles = new Hashtable<String, RBSRole>();
        try {
            ObjectEntry oeCollection = this.namespace.getObjectEntry(sTaskContext);
            RBSCollection rbsCollection = new RBSCollection(oeCollection);
            RBSRole[] roles = null;
            String[] arRoles = new String[]{"eguide"};
            roles = rbsCollection.getSpecifiedRoles(arRoles);
            for (int i = 0; i < roles.length; ++i) {
                String sRoleType;
                String sRoleParams = roles[i].getParameters();
                if (sRoleParams.toLowerCase().indexOf("type=eguide") == -1) continue;
                String sRoleName = roles[i].getObjectEntry().getName();
                if (sRoleParams.toLowerCase().indexOf("self-provisioning=true") != -1) {
                    if (!SystemConfig.getSystemConfig(this.context).getSetting("Provider.eMFrame.This.enable").equals("true")) {
                        D.log("Warning: [this] not enabled so ignoring self-admin role: " + sRoleName);
                        continue;
                    }
                    sRoleType = eMFrameUtils.getLocalizedString("FwResources", "eGuide.Taskbuilder.SelfProvisioningRole.Label", this.context);
                } else {
                    sRoleType = eMFrameUtils.getLocalizedString("FwResources", "eGuide.Taskbuilder.NormalRole.Label", this.context);
                }
                String sRoleDescription = roles[i].getDescription();
                if (sRoleDescription == null) {
                    sRoleDescription = "";
                }
                this.resultStrings.put("eGuide." + iRoleCounter + ".Role", sRoleName);
                this.resultStrings.put("eGuide." + iRoleCounter + ".RoleType", sRoleType);
                this.resultStrings.put("eGuide." + iRoleCounter + ".RoleDescription", sRoleDescription);
                hRoles.put(sRoleName, roles[i]);
                ++iRoleCounter;
            }
        }
        catch (Exception ex) {
            this.resultStrings.put("eGuide.Role.Count", "0");
            D.log("Warning: Could not locate any eGuide roles in specified context: " + ex.toString());
            return true;
        }
        this.resultStrings.put("eGuide.Role.Count", Integer.toString(iRoleCounter));
        this.context.setAuthAttribute("fw.eGuideRoles", hRoles);
        return true;
    }

    private boolean getEGuideCategories(String sURL) {
        int i;
        XmlElement xmlBase;
        Vector vEGuide;
        String sXML = this.postRequest(sURL + "?Action=RequestCategories&RenderXML=true");
        if (sXML == null) {
            D.log("No Response from eGuide: " + sURL);
            this.reportLocalizedError("eGuide.Taskbuilder.InvalidURL.Label");
            return false;
        }
        if (sXML.equals("")) {
            D.log("eGuide is not currently installed.");
            this.reportLocalizedError("LauncheGuide.eGuideNotInstalledBody");
            return false;
        }
        this.context.setAuthAttribute("fw.eGuideServerAddress", sURL);
        String sEG = SystemConfig.getSystemConfig(this.context).getSetting("Provider.eMFrame.eGuide.location");
        if ((sEG == null || sEG.equals("EMFRAME_SERVER")) && (sEG = FwUtils.getDefaulteGuideLocation(this.context)).startsWith("https:")) {
            sEG = "http" + sEG.substring(sEG.indexOf(":"), sEG.length());
        }
        if (!sEG.equals(sURL)) {
            // empty if block
        }
        if ((vEGuide = (xmlBase = XmlElement.parseXml(sXML)).getChildren("eGuide")) == null || vEGuide.size() == 0) {
            D.log("No Response from eGuide: " + sURL);
            this.reportLocalizedError("eGuide.Taskbuilder.InvalidPartURL.Label");
            return false;
        }
        XmlElement xmlEGuide = (XmlElement)vEGuide.elementAt(0);
        vEGuide = xmlEGuide.getChildren();
        Vector<MyXmlElement> vCategories = null;
        for (int i2 = 0; i2 < vEGuide.size(); ++i2) {
            XmlElement xmlNode = (XmlElement)vEGuide.elementAt(i2);
            if (!xmlNode.getName().equals("Categories")) continue;
            vCategories = xmlNode.getChildren();
            break;
        }
        if (vCategories == null) {
            this.reportError("Error: No categories could be ascertained from eGuide");
            return false;
        }
        this.resultStrings.put("eGuide.Category.Count", Integer.toString(vCategories.size()));
        Vector<MyXmlElement> vSortedCategories = new Vector<MyXmlElement>();
        for (i = 0; i < vCategories.size(); ++i) {
            vSortedCategories.addElement(new MyXmlElement((XmlElement)vCategories.elementAt(i), "Value"));
        }
        vCategories = vSortedCategories;
        Collections.sort(vCategories);
        for (i = 0; i < vCategories.size(); ++i) {
            this.resultStrings.put("eGuide.Category." + i + ".Name", ((XmlElement)vCategories.elementAt(i)).getText());
        }
        return true;
    }

    private String postRequest(String sURL) {
        StringBuffer response = new StringBuffer();
        BufferedReader buffer = null;
        if (sURL == null || sURL.length() == 0) {
            D.log("Error: eGuide URL not specified.");
            return null;
        }
        D.log(" Attempting to post eGuide URL:\n" + sURL);
        try {
            String sLine;
            URL url = new URL(sURL);
            buffer = new BufferedReader(new InputStreamReader(url.openConnection().getInputStream()));
            D.log("Connection made. eGuide Request Posted.");
            while ((sLine = buffer.readLine()) != null) {
                response.append(sLine);
            }
        }
        catch (IOException io) {
            D.log("IOException returned from eGuide: " + io.toString());
            return null;
        }
        catch (Exception ex) {
            D.log("Exception returned from eGuide: " + ex.toString());
            return null;
        }
        D.log("Response returned from eGuide: " + response.toString());
        return response.toString();
    }

    private boolean taskSummary() {
        String sAssignedRoles = this.req.getParameter("SelectedRoles");
        String[] arSelectedRoles = null;
        if (sAssignedRoles != null && sAssignedRoles.length() > 0) {
            arSelectedRoles = eMFrameUtils.unpack(sAssignedRoles, this.context);
            this.context.setAuthAttribute("fw.selectedEGuideRoles", arSelectedRoles);
        }
        this.resultStrings.put("Task.Name", this.context.getAuthAttribute("fw.eGuideTaskName"));
        String sTaskDescription = (String)this.context.getAuthAttribute("fw.eGuideTaskDescription");
        if (sTaskDescription != null || sTaskDescription.length() > 0) {
            this.resultStrings.put("Task.Description", sTaskDescription);
        }
        this.resultStrings.put("Task.Context", "eguide." + (String)this.context.getAuthAttribute("fw.eGuideTaskContext"));
        this.resultStrings.put("Task.Category", this.context.getAuthAttribute("fw.eGuideCategory"));
        Vector vAttrs = (Vector)this.context.getAuthAttribute("eGuide.EnabledAttrs");
        Collections.sort(vAttrs, this.m_collator);
        int iCntr = 0;
        Enumeration myenum = vAttrs.elements();
        while (myenum.hasMoreElements()) {
            this.resultStrings.put("eGuide." + iCntr + ".Attribute", myenum.nextElement());
            ++iCntr;
        }
        this.resultStrings.put("eGuide.Attributes.Count", Integer.toString(iCntr));
        iCntr = 0;
        Vector<String> vRoleNames = new Vector<String>();
        if (arSelectedRoles != null) {
            for (int i = 0; i < arSelectedRoles.length; ++i) {
                vRoleNames.addElement(arSelectedRoles[i]);
            }
            Collections.sort(vRoleNames, this.m_collator);
            myenum = vRoleNames.elements();
            while (myenum.hasMoreElements()) {
                this.resultStrings.put("eGuide." + iCntr + ".Role", eMFrameUtils.urlDecode((String)myenum.nextElement(), this.context));
                ++iCntr;
            }
        }
        this.resultStrings.put("eGuide.Roles.Count", Integer.toString(iCntr));
        return true;
    }

    private boolean wizardFinished() {
        RBSTask rbsTask;
        File fNewTask;
        D.log("Inside wizardFinished method");
        String sUpdateResources = (String)this.context.getAuthAttribute("fw.eGuideResourceUpdateXML");
        D.log("Attempting to update resource bundle in eGuide...");
        this.postRequest(sUpdateResources);
        D.log("Completed eGuide Resource Bundle URL request.");
        String sEguideTaskXML = (String)this.context.getAuthAttribute("fw.eGuideTaskXML");
        String sTaskName = (String)this.context.getAuthAttribute("fw.eGuideTaskName");
        String sTaskContext = (String)this.context.getAuthAttribute("fw.eGuideTaskContext");
        String sCategory = (String)this.context.getAuthAttribute("fw.eGuideCategory");
        String sTaskDescription = (String)this.context.getAuthAttribute("fw.eGuideTaskDescription");
        XmlElement xmlBase = new XmlElement("install", "");
        XmlElement xmlModule = new XmlElement("module", "");
        xmlModule.add(new XmlElement("id", "eguide"));
        xmlModule.add(new XmlElement("version", "1.0"));
        xmlModule.add(new XmlElement("required-version", "1.0"));
        xmlModule.add(new XmlElement("resource-properties-file", "eGuideResources"));
        xmlModule.add(new XmlElement("Description", ""));
        xmlBase.add(xmlModule);
        XmlElement xmlTask = new XmlElement("task", "");
        xmlTask.add(new XmlElement("id", "eguide." + sTaskName));
        xmlTask.add(new XmlElement("version", "1.0"));
        xmlTask.add(new XmlElement("required-version", "1.0"));
        XmlElement xmlParam1 = new XmlElement("url-param", "");
        xmlParam1.add(new XmlElement("param-key", "type"));
        xmlParam1.add(new XmlElement("param-value", "eGuide"));
        XmlElement xmlParam2 = new XmlElement("url-param", "");
        xmlParam2.add(new XmlElement("param-key", "category"));
        xmlParam2.add(new XmlElement("param-value", sCategory));
        XmlElement xmlInfo = new XmlElement("rbs-xml-info", "");
        XmlElement xmlEGuide = new XmlElement("eguide", "");
        xmlEGuide.add(XmlElement.parseXml(sEguideTaskXML));
        xmlInfo.add(xmlEGuide);
        xmlTask.add(xmlInfo);
        xmlTask.add(xmlParam1);
        xmlTask.add(xmlParam2);
        XmlElement xmlRights = XmlElement.parseXml(sEguideTaskXML);
        Vector vAttrs = xmlRights.getChildren();
        Enumeration myenum = vAttrs.elements();
        while (myenum.hasMoreElements()) {
            XmlElement xmlNode = (XmlElement)myenum.nextElement();
            String sEditable = xmlNode.getChildTextTrim("Editable");
            String sAttrName = xmlNode.getChildTextTrim("Name");
            String sRealAttrName = this.context.getDirUtils().getMappingObject().LDAPAttributeToNDS(sAttrName);
            if (sRealAttrName != null) {
                xmlRights = new XmlElement("rights-assignment", "");
                xmlRights.add(new XmlElement("attribute-name", sRealAttrName));
                if (sEditable.equalsIgnoreCase("true")) {
                    xmlRights.add(new XmlElement("privilege", "Supervisor"));
                } else {
                    xmlRights.add(new XmlElement("privilege", "Browse"));
                    xmlRights.add(new XmlElement("privilege", "Read"));
                }
                xmlTask.add(xmlRights);
                continue;
            }
            D.log("Warning: could not find eDirectory mapping for LDAP Attribute: " + sAttrName);
        }
        xmlBase.add(xmlTask);
        String sInstallDir = eMFrameUtils.getModulesBasePath() + File.separator + "eguide" + File.separator + "install";
        String sTaskFileName = null;
        String sOrigTaskName = sTaskName;
        File fInstallDir = new File(sInstallDir);
        if (!fInstallDir.exists() || !fInstallDir.isDirectory()) {
            if (!fInstallDir.mkdir()) {
                D.log("Install directory does not exist and could not be created: " + sInstallDir);
                this.reportLocalizedError("eGuide.Taskbuilder.InvalidInstallDir.Label");
                return false;
            }
            D.log("Creating eguide directory: " + sInstallDir);
        }
        int iIndex = 1;
        if (sTaskName.indexOf(32) != -1) {
            String sTmpTask = new String();
            for (int i = 0; i < sTaskName.length(); ++i) {
                if (sTaskName.charAt(i) == ' ') continue;
                sTmpTask = sTmpTask + sTaskName.charAt(i);
            }
            sTaskName = sTmpTask;
        }
        boolean bFirstIn = true;
        do {
            if (bFirstIn) {
                sTaskFileName = sInstallDir + File.separator + sTaskName + ".xml";
                bFirstIn = false;
                continue;
            }
            sTaskFileName = sInstallDir + File.separator + sTaskName + iIndex++ + ".xml";
        } while ((fNewTask = new File(sTaskFileName)).exists());
        D.log("Using eGuide task filename: " + sTaskFileName);
        if (!this.writeXMLToDisk(sTaskFileName, xmlBase.toString())) {
            this.reportError("Could not create XML output for task");
            return false;
        }
        XMLFileReader xmlFileReader = new XMLFileReader(this.namespace);
        ModuleClassObject mco = new ModuleClassObject();
        String authName = "eDir";
        try {
            if (this.namespace.isSupported("NVDS")) {
                authName = "NVDS";
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            mco = xmlFileReader.readFile(sTaskFileName, authName);
        }
        catch (Exception ex) {
            this.reportError(ex.getLocalizedMessage());
            return false;
        }
        RBSObjectInstaller installer = new RBSObjectInstaller(this.treeOE, mco);
        try {
            String dynamicGroupSearchType = FwUtils.getDynamicSearchType(this.context);
            installer.install(sTaskContext, dynamicGroupSearchType);
        }
        catch (Exception ex) {
            this.reportError("Could not create task in directory: " + ex.getLocalizedMessage());
        }
        try {
            SAXBuilder sax = new SAXBuilder(false);
            Document doc = sax.build((Reader)new StringReader("<eguide>" + sEguideTaskXML + "</eguide>"));
            Element e = (Element)doc.getRootElement().clone();
            String eguide = "eguide";
            if (this.m_isLDAP) {
                eguide = "cn=eguide";
            }
            ObjectEntry oeTask = this.namespace.getObjectEntry(RBSUtil.concatStr(this.namespace, RBSUtil.concatStr(this.namespace, sOrigTaskName, eguide), sTaskContext));
            rbsTask = new RBSTask(oeTask);
            rbsTask.setrbsXMLInfo(e);
            rbsTask.setParameters("type=eguide;category=" + sCategory);
            if (sTaskDescription != null || sTaskDescription.length() > 0) {
                rbsTask.setDescription(sTaskDescription);
            }
            rbsTask.update();
        }
        catch (Exception ex) {
            this.reportError(ex.getLocalizedMessage());
            return false;
        }
        Hashtable hRoles = (Hashtable)this.context.getAuthAttribute("fw.eGuideRoles");
        String[] arRoles = (String[])this.context.getAuthAttribute("fw.selectedEGuideRoles");
        RBSTask[] arTasks = new RBSTask[]{rbsTask};
        if (arRoles != null) {
            for (int i = 0; i < arRoles.length; ++i) {
                RBSRole role = (RBSRole)hRoles.get(eMFrameUtils.urlDecode(arRoles[i], this.context));
                try {
                    String dynamicGroupSearchType = FwUtils.getDynamicSearchType(this.context);
                    role.addContent((RBSObject[])arTasks, dynamicGroupSearchType);
                    role.update();
                    continue;
                }
                catch (Exception ex) {
                    D.log("Error updating role membership with task: " + ex.toString());
                    this.reportError(ex.toString());
                    return false;
                }
            }
        }
        this.context.removeAuthAttribute("fw.eGuideServerAddress");
        this.context.removeAuthAttribute("fw.eGuideAttributeKeys");
        this.context.removeAuthAttribute("fw.eGuideResourceUpdateXML");
        this.context.removeAuthAttribute("fw.eGuideTaskXML");
        this.context.removeAuthAttribute("fw.eGuideTaskName");
        this.context.removeAuthAttribute("fw.eGuideTaskContext");
        this.context.removeAuthAttribute("fw.eGuideTaskDescription");
        this.context.removeAuthAttribute("fw.eGuideCategory");
        this.context.removeAuthAttribute("fw.eGuideRoles");
        this.context.removeAuthAttribute("eGuide.EnabledAttrs");
        this.context.removeAuthAttribute("fw.selectedEGuideRoles");
        this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "eGuide.Taskbuilder.TaskSuccess.Title", this.context));
        this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString("FwResources", "eGuide.Taskbuilder.TaskSuccessMessage", this.context));
        this.resultStrings.put("GeneralMsg.Url", "");
        return true;
    }

    private boolean writeXMLToDisk(String sFileName, String sXMLData) {
        try {
            FileOutputStream f = new FileOutputStream(sFileName, true);
            DataOutputStream dos = new DataOutputStream(f);
            dos.writeBytes(sXMLData);
            f.close();
        }
        catch (IOException ex) {
            D.log("Error writing XML data to file: " + sFileName);
            this.reportLocalizedError("eGuide.Taskbuilder.XMLToDiskError.Label");
            return false;
        }
        return true;
    }

    private void reportError(String sError) {
        D.log(sError);
        this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "Error", this.context));
        this.resultStrings.put("GeneralMsg.MsgBody", sError);
    }

    private void reportLocalizedError(String sErrorKey) {
        D.log(sErrorKey);
        this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "Error", this.context));
        this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString("FwResources", sErrorKey, this.context));
    }

    private class MyXmlElement
    extends XmlElement
    implements Comparable {
        private String m_sSortKey;

        public MyXmlElement(XmlElement element, String sSortKey) {
            super(element.getName(), element.getText());
            this.m_sSortKey = null;
            Vector vChildren = element.getChildren();
            for (int i = 0; i < vChildren.size(); ++i) {
                super.add((XmlElement)vChildren.elementAt(i));
            }
            this.m_sSortKey = sSortKey;
        }

        public int compareTo(Object obj) {
            XmlElement elementIn = (XmlElement)obj;
            String sAttrIn = elementIn.getChildTextTrim(this.m_sSortKey);
            String sAttr = this.getChildTextTrim(this.m_sSortKey);
            if (sAttrIn == null || sAttr == null) {
                return -1;
            }
            return sAttr.compareTo(sAttrIn);
        }
    }
}

