/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw.ldap;

import com.novell.emframe.dev.AuthBrokerException;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.LazyAuthBrokerAuthenticator;
import com.novell.emframe.dev.ManagementServiceSet;
import com.novell.emframe.dev.PluginException;
import com.novell.emframe.fw.ldap.JndiLdapUtil;
import java.util.Properties;
import javax.naming.ldap.InitialLdapContext;

public class JndiLdapAuthenticator
extends LazyAuthBrokerAuthenticator {
    private ManagementServiceSet m_manageSS;
    private JndiLdapUtil jlUtil = null;

    public Object login(String name, String password, String accessDomain, ManagementServiceSet manageSS) throws AuthBrokerException {
        this.m_manageSS = manageSS;
        return this;
    }

    public void logout(Object apiObject) {
        this.m_manageSS = null;
    }

    public Object authenticate(String inLdapName, String inPassword, String inLdapAccessDomain, Properties inputProperties) throws AuthBrokerException {
        AuthenticationBroker broker = this.m_manageSS.getAuthenticationBroker();
        String usingLdapName = inLdapName;
        String usingPassword = inPassword;
        boolean trySSL = broker.getAuthUseLdapSSL();
        if (inputProperties != null) {
            Object propValueObj = inputProperties.get("SSL");
            if (propValueObj != null && propValueObj instanceof Boolean) {
                trySSL = (Boolean)propValueObj;
            }
            if ((propValueObj = inputProperties.get("LDAPNAME")) != null && propValueObj instanceof String) {
                usingLdapName = (String)propValueObj;
            }
            if ((propValueObj = inputProperties.get("PASSWORD")) != null && propValueObj instanceof String) {
                usingPassword = (String)propValueObj;
            }
        }
        if (this.jlUtil == null) {
            this.jlUtil = new JndiLdapUtil();
        }
        InitialLdapContext dirCtx = null;
        try {
            dirCtx = this.jlUtil.createJNDILDAPContext(usingLdapName, usingPassword, inLdapAccessDomain, broker.getAuthLdapDefaultClearPort(), broker.getAuthLdapDefaultSSLPort(), trySSL, null, this.m_manageSS.getLocale());
        }
        catch (PluginException ple) {
            throw new AuthBrokerException(ple.getMessage());
        }
        return dirCtx;
    }
}

