/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw.security;

import com.novell.emframe.dev.D;
import com.novell.emframe.fw.security.CertificateException_IM;
import com.novell.emframe.fw.security.KeyStore_IM;
import com.novell.emframe.fw.security.SecurityException_IM;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;

public class TrustManager_IM
implements X509TrustManager {
    public void checkClientTrusted(X509Certificate[] x509Certificates, String authType) throws CertificateException {
        throw new CertificateException_IM("Not Implemented", null);
    }

    public void checkServerTrusted(X509Certificate[] x509Certificates, String authType) throws CertificateException_IM {
        boolean foundValidCertificate = false;
        try {
            KeyStore_IM imanKS = KeyStore_IM.getiManagerKeyStore();
            for (int ii = x509Certificates.length - 1; ii >= 0; --ii) {
                if (!imanKS.validateCertificate(x509Certificates[ii])) continue;
                foundValidCertificate = true;
                break;
            }
        }
        catch (Exception ce) {
            throw new CertificateException_IM("", x509Certificates, ce);
        }
        if (!foundValidCertificate) {
            SecurityException_IM seim = new SecurityException_IM(7);
            String errmsg = seim.getLocalizedMessage();
            throw new CertificateException_IM(errmsg, x509Certificates);
        }
    }

    public X509Certificate[] getAcceptedIssuers() {
        X509Certificate[] certArr = null;
        try {
            KeyStore_IM imanKS = KeyStore_IM.getiManagerKeyStore();
            certArr = imanKS.getAllCertificates();
        }
        catch (SecurityException_IM seim) {
            D.log(seim);
        }
        if (certArr == null) {
            certArr = new X509Certificate[]{};
        }
        return certArr;
    }
}

