/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw.servlet;

import com.novell.emframe.fw.FwAttr;
import com.novell.emframe.fw.servlet.AuthenticatorServlet;
import java.io.File;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class DeviceInterface {
    private static final String DEVINTEROBJ = "DevInterObj";
    private String m_sDefaultInterface = "default";
    private String m_sDefaultContentType = "text/html";
    private Vector m_vUserAgent = null;
    private Hashtable m_hAccept = null;
    private Hashtable m_hInterfaces = null;
    private Hashtable m_hContentTypes = null;
    private int m_iCount = 0;
    private Hashtable m_hResCache = new Hashtable();

    private void reset() {
        if (this.m_hAccept != null) {
            this.m_hAccept.clear();
        }
        if (this.m_hContentTypes != null) {
            this.m_hContentTypes.clear();
        }
        if (this.m_hInterfaces != null) {
            this.m_hInterfaces.clear();
        }
        if (this.m_vUserAgent != null) {
            this.m_vUserAgent.removeAllElements();
        }
    }

    public boolean load(Properties cfgProps) {
        this.reset();
        if (cfgProps == null) {
            return false;
        }
        String sId = (String)cfgProps.get("Device.Interface.Default.id");
        if (sId != null && sId.trim().length() != 0) {
            this.m_sDefaultInterface = sId;
        }
        this.loadUserAgents(cfgProps);
        this.loadAcceptTypes(cfgProps);
        this.loadContentTypes(cfgProps);
        return true;
    }

    private void loadUserAgents(Properties cfgProps) {
        StringBuffer sb = new StringBuffer(35);
        sb.append("Device.UserAgent.");
        int iSbLen = 17;
        int iIdx = 1;
        sb.append(iIdx).append(".id");
        String sId = (String)cfgProps.get(sb.toString());
        while (sId != null) {
            sb.setLength(iSbLen);
            sb.append(iIdx).append(".interface");
            String sInterface = (String)cfgProps.get(sb.toString());
            if (sInterface != null && sInterface.trim().length() != 0) {
                if (this.m_vUserAgent == null) {
                    this.m_vUserAgent = new Vector();
                }
                UserAgentInterface uai = new UserAgentInterface(sId, sInterface);
                this.m_vUserAgent.addElement(uai);
            }
            sb.setLength(iSbLen);
            sb.append(++iIdx).append(".id");
            sId = (String)cfgProps.get(sb.toString());
        }
    }

    private void loadAcceptTypes(Properties cfgProps) {
        StringBuffer sb = new StringBuffer(35);
        sb.append("Device.Accept.");
        int iSbLen = 14;
        int iIdx = 1;
        sb.append(iIdx).append(".id");
        String sId = (String)cfgProps.get(sb.toString());
        while (sId != null) {
            sb.setLength(iSbLen);
            sb.append(iIdx).append(".interface");
            String sInterface = (String)cfgProps.get(sb.toString());
            if (sInterface != null && sInterface.trim().length() != 0) {
                if (this.m_hAccept == null) {
                    this.m_hAccept = new Hashtable();
                }
                this.m_hAccept.put(sId, sInterface);
            }
            sb.setLength(iSbLen);
            sb.append(++iIdx).append(".id");
            sId = (String)cfgProps.get(sb.toString());
        }
    }

    private void loadContentTypes(Properties cfgProps) {
        StringBuffer sb = new StringBuffer(35);
        sb.append("Device.Interface.");
        int iSbLen = 17;
        if (this.m_hContentTypes == null) {
            this.m_hContentTypes = new Hashtable();
        }
        if (this.m_hInterfaces == null) {
            this.m_hInterfaces = new Hashtable();
        }
        int iIdx = 1;
        sb.append(iIdx).append(".id");
        String sId = (String)cfgProps.get(sb.toString());
        while (sId != null) {
            this.m_hInterfaces.put(sId, new Integer(iIdx).toString());
            sb.setLength(iSbLen);
            sb.append(iIdx).append(".contentType");
            String sContentType = (String)cfgProps.get(sb.toString());
            if (sContentType != null && sContentType.trim().length() != 0) {
                this.m_hContentTypes.put(sId, sContentType);
            }
            sb.setLength(iSbLen);
            sb.append(++iIdx).append(".id");
            sId = (String)cfgProps.get(sb.toString());
        }
        this.m_iCount = iIdx - 1;
    }

    int getCount() {
        return this.m_iCount;
    }

    private String getCachedResource(String sModNFile) {
        return (String)this.m_hResCache.get(sModNFile);
    }

    private void setCachedResource(String sModNFile, String sRes) {
        this.m_hResCache.put(sModNFile, sRes);
    }

    public void initSession(HttpSession session) {
        session.setAttribute(DEVINTEROBJ, (Object)this);
    }

    public static String getInterfaceUrl(HttpServletRequest req, String sModNFile) {
        String sPath = null;
        HttpSession session = req.getSession();
        DeviceInterface dvInt = (DeviceInterface)session.getAttribute(DEVINTEROBJ);
        sPath = dvInt.getCachedResource(sModNFile);
        if (sPath != null) {
            return sPath;
        }
        String sMod = DeviceInterface.getModuleFromFullName(sModNFile);
        String sRes = DeviceInterface.getResourceFromFullName(sModNFile);
        StringBuffer sbPath = new StringBuffer(75);
        sbPath.append("/portal/modules/");
        sbPath.append(sMod).append("/skins/default/devices/");
        int iPathLen = sbPath.length();
        if (dvInt != null) {
            sbPath.append(dvInt.getInterface(req) + '/' + sRes);
        } else {
            sbPath.append("/default/" + sRes);
        }
        sPath = sbPath.toString();
        boolean bExists = dvInt.resourceExists(sPath, req);
        if (!bExists && !sRes.equals("default")) {
            sbPath.setLength(iPathLen);
            sbPath.append("default/" + sRes);
            sPath = sbPath.toString();
            if (dvInt.resourceExists(sPath, req)) {
                bExists = true;
            }
        }
        dvInt.setCachedResource(sModNFile, sPath);
        return sPath;
    }

    private boolean resourceExists(String sRes, HttpServletRequest req) {
        HttpServlet srv = (HttpServlet)FwAttr.getFwRequestAttribute(AuthenticatorServlet.THIS_SERVLET, req);
        String sRoot = srv.getServletContext().getRealPath("/");
        String sPath = sRoot + sRes;
        File f = new File(sPath);
        return f.isFile();
    }

    private static String getModuleFromFullName(String fullName) {
        if (fullName == null) {
            return null;
        }
        String module = null;
        int index = fullName.indexOf(47);
        if (index == -1) {
            return null;
        }
        try {
            module = fullName.substring(0, index);
        }
        catch (StringIndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        return module;
    }

    private static String getResourceFromFullName(String fullName) {
        if (fullName == null) {
            return null;
        }
        String page = null;
        int index = fullName.indexOf(47);
        if (index == -1) {
            return null;
        }
        try {
            page = fullName.substring(index + 1);
        }
        catch (StringIndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        return page;
    }

    public String getInterface(HttpServletRequest req) {
        String sAccept;
        String sInterface = null;
        if (this.m_vUserAgent != null) {
            UserAgentInterface uai = null;
            int iSize = this.m_vUserAgent.size();
            for (int i = 0; i < iSize; ++i) {
                uai = (UserAgentInterface)this.m_vUserAgent.elementAt(i);
                if (!this.findPattern(uai.getId(), req.getHeader("User-Agent"))) continue;
                return uai.getInterface();
            }
        }
        if (this.m_hAccept != null && (sAccept = req.getHeader("Accept")) != null) {
            StringTokenizer st = new StringTokenizer(sAccept, ", ");
            String sToken = null;
            while (st.hasMoreTokens()) {
                sToken = st.nextToken();
                sInterface = (String)this.m_hAccept.get(sToken);
                if (sInterface == null) {
                    int iIdx = sToken.indexOf(";");
                    if (iIdx == -1 || (sInterface = (String)this.m_hAccept.get(sToken = sToken.substring(0, iIdx))) == null) continue;
                    return sInterface;
                }
                return sInterface;
            }
        }
        return this.m_sDefaultInterface;
    }

    String getInterfaceNumber(String sInterface) {
        return (String)this.m_hInterfaces.get(sInterface);
    }

    public String getContentType(String sInterface) {
        String sContentType = null;
        if (this.m_hContentTypes != null && (sContentType = (String)this.m_hContentTypes.get(sInterface)) != null) {
            return sContentType;
        }
        return this.m_sDefaultContentType;
    }

    private boolean findPattern(String sPattern, String sText) {
        int iTextPos = 0;
        if (sPattern.equals("*")) {
            return true;
        }
        StringTokenizer st = new StringTokenizer(sPattern, "*", true);
        String sToken = null;
        while (st.hasMoreTokens()) {
            int iNextPos;
            sToken = st.nextToken();
            if (sToken.equals("*")) {
                if (!st.hasMoreTokens()) {
                    return true;
                }
                sToken = st.nextToken();
                iNextPos = sText.indexOf(sToken, iTextPos);
                if (iNextPos >= 0) {
                    iTextPos = iNextPos + sToken.length();
                    continue;
                }
                return false;
            }
            iNextPos = sText.indexOf(sToken, iTextPos);
            if (!st.hasMoreTokens()) {
                iTextPos = iNextPos + sToken.length();
                if (iTextPos == sText.length()) continue;
                return false;
            }
            if (iNextPos != iTextPos) {
                return false;
            }
            iTextPos = iNextPos + sToken.length();
        }
        return true;
    }

    private class UserAgentInterface {
        private String m_sId = null;
        private String m_sInterface = null;

        UserAgentInterface(String sId, String sInterface) {
            this.m_sId = sId;
            this.m_sInterface = sInterface;
        }

        public String getId() {
            return this.m_sId;
        }

        public String getInterface() {
            return this.m_sInterface;
        }
    }
}

