/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw.studio;

import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.SchemaUtil;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.AuthBrokerException;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.GlobalRegistry;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.UiHandler;
import com.novell.emframe.dev.UiHandlerContext;
import com.novell.emframe.dev.Version;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.npsCompat.NPSCompatUtils;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.jdom.Document;

public class TemplateBuilder {
    private static String version = null;

    public static String getVersionString(MContext context) {
        if (version == null) {
            Version versionTemp = eMFrameUtils.getVersion(context);
            version = "" + versionTemp.getMajor() + versionTemp.getMinor();
        }
        return version;
    }

    public static UiHandler[] getDefaultHandlers(MContext context, AttributeDefinition[] attributeDefinitions, String client, String className, String[] superClasses, boolean calledForAux, boolean makeNamingAttrSingleValued) throws IOException {
        if (attributeDefinitions == null) {
            return null;
        }
        ObjectEntry treeOE = null;
        try {
            treeOE = (ObjectEntry)context.getAuthenticationBroker().getProtocolObject("AdminNamespace");
        }
        catch (AuthBrokerException e) {
            D.log(e);
        }
        AdminNamespace ns = treeOE.getAdminNamespace();
        ArrayList<UiHandler> array = new ArrayList<UiHandler>();
        for (int i = 0; i < attributeDefinitions.length; ++i) {
            String syntaxName;
            Document doc;
            if (attributeDefinitions[i].getName().equals(SchemaUtil.translateNDAPAttr((ObjectEntry)treeOE, (String)"Object Class")) && calledForAux) continue;
            boolean isMulti = !attributeDefinitions[i].isSingleValued();
            boolean isNamingAttribute = false;
            try {
                ClassDefinition classDefinition = ns.getSchemaDefinition(treeOE).getClassDefinition(className);
                isNamingAttribute = classDefinition.isNamedBy(attributeDefinitions[i].getName());
            }
            catch (Throwable e) {
                D.log(e);
            }
            if (isNamingAttribute && makeNamingAttrSingleValued) {
                isMulti = false;
            }
            D.assrt((doc = GlobalRegistry.getDefaultUiHandlerDoc(syntaxName = attributeDefinitions[i].getSyntax().getName(), attributeDefinitions[i].getName(), className, superClasses, isMulti, attributeDefinitions[i].isReadOnly(), client)) != null, "PluginBuilder: no uihandler doc for id; syntax=" + syntaxName);
            if (doc == null) continue;
            try {
                String classname = eMFrameUtils.getClassName(doc);
                Class<?> c = Class.forName(classname);
                UiHandler uihandler = (UiHandler)c.newInstance();
                UiHandlerContext uiHandlerContext = new UiHandlerContext(attributeDefinitions[i], client, doc.getRootElement().getChildTextTrim("id"), false, false, false);
                uihandler.init(uiHandlerContext);
                array.add(uihandler);
                continue;
            }
            catch (Exception e) {
                D.log(e);
            }
        }
        return array.toArray(new UiHandler[array.size()]);
    }

    private static String findSkeletonFile(String skeletonFilename) {
        return "fw/skins/default/devices/default/" + skeletonFilename;
    }

    public static String createTemplate(MContext context, UiHandler[] handlers, String client, boolean labelAboveControl, String skeletonFileName, String[] auxClassExtensions, boolean allAttributesMandatory, String moduleName, String filename, boolean onExitOnSubmit) throws IOException {
        return TemplateBuilder.createTemplate(context, handlers, client, labelAboveControl, skeletonFileName, auxClassExtensions, allAttributesMandatory, moduleName, filename, onExitOnSubmit, null);
    }

    public static String createTemplate(MContext context, UiHandler[] handlers, String client, boolean labelAboveControl, String skeletonFileName, String[] auxClassExtensions, boolean allAttributesMandatory, String moduleName, String filename, boolean onExitOnSubmit, String defaultXml) throws IOException {
        String modulesHome = context.getWebappHome().getAbsolutePath() + "/portal/modules/";
        String tempDirName = modulesHome + moduleName + "/skins/default/devices/" + client;
        String fullSkeletonFilename = modulesHome + TemplateBuilder.findSkeletonFile(skeletonFileName);
        File templateDirectory = new File(tempDirName);
        if (!templateDirectory.exists()) {
            templateDirectory.mkdirs();
        }
        File templateFile = null;
        if (filename != null) {
            templateFile = new File(templateDirectory, filename);
        } else {
            templateFile = File.createTempFile("temptemplate", ".jsp", templateDirectory);
            templateFile.deleteOnExit();
        }
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(templateFile)), "utf-8");
        PrintWriter pw = new PrintWriter(writer);
        BufferedReader skeleton = new BufferedReader(new FileReader(fullSkeletonFilename));
        TemplateBuilder.printTemplate(pw, skeleton, handlers, labelAboveControl, client, auxClassExtensions, allAttributesMandatory, onExitOnSubmit, defaultXml, context);
        NPSCompatUtils.refreshResourceFileMap(moduleName);
        pw.close();
        skeleton.close();
        String templateName = templateFile.getName();
        templateName = templateName.substring(0, templateName.length() - 4);
        return templateName;
    }

    private static void printTemplate(PrintWriter pw, BufferedReader skeleton, UiHandler[] handlers, boolean labelAboveControl, String client, String[] auxClassExtensions, boolean allAttributesMandatory, boolean onExitOnSubmit, String defaultXml, MContext taskContext) {
        int i;
        int i2;
        String indent = null;
        if (defaultXml != null) {
            indent = TemplateBuilder.skipTo(pw, skeleton, "DEFAULT_XML");
            pw.println(indent + defaultXml);
        }
        ArrayList<String> headerList = new ArrayList<String>();
        headerList.add("iman:eMFrameScripts");
        for (i2 = 0; i2 < handlers.length; ++i2) {
            eMFrameUtils.addUnique(headerList, handlers[i2].getSharedHeaderCode());
        }
        indent = TemplateBuilder.skipTo(pw, skeleton, "SHARED_HEADER_CODE");
        TemplateBuilder.printSharedCode(pw, headerList, indent, client);
        indent = TemplateBuilder.skipTo(pw, skeleton, "ONINIT");
        for (i2 = 0; i2 < handlers.length; ++i2) {
            handlers[i2].printInitCode(pw, indent);
            if (i2 != 0) continue;
            handlers[0].printFocus(pw, indent);
        }
        if (headerList.contains("iman:osScripts")) {
            pw.println(indent + "returnFromOS();");
        }
        indent = TemplateBuilder.skipTo(pw, skeleton, "ONEXIT");
        for (i2 = 0; i2 < handlers.length; ++i2) {
            handlers[i2].printExitCode(pw, indent);
            handlers[i2].printMandatoryCheckCode(pw, indent, allAttributesMandatory);
        }
        indent = TemplateBuilder.skipTo(pw, skeleton, "FORM_TAG");
        boolean makeMultiPartForm = false;
        for (int i3 = 0; i3 < handlers.length; ++i3) {
            if (!handlers[i3].makeMultiPartFrom()) continue;
            makeMultiPartForm = true;
        }
        String action = makeMultiPartForm ? "webacc?Autoparse=true" : "webacc";
        String extra = makeMultiPartForm ? "enctype=\"multipart/form-data\"" : "";
        String submit = onExitOnSubmit ? "onSubmit=\"onExit();\"" : "";
        pw.println(indent + "<FORM name=\"form\" method=\"post\" action=\"" + action + "\"" + extra + " " + submit + ">");
        indent = TemplateBuilder.skipTo(pw, skeleton, "SHARED_FORM_CODE");
        if (auxClassExtensions != null && auxClassExtensions.length > 0) {
            pw.println("\n\n" + indent + "<!-- Automatic Aux Class Extension -->");
            pw.print(indent + "<INPUT type=hidden name=\"eDir$target$auxillaryClassExtension\" value=\"");
            for (i = 0; i < auxClassExtensions.length; ++i) {
                pw.print(FwUtils.getSafeName(auxClassExtensions[i]));
                if (i + 1 >= auxClassExtensions.length) continue;
                pw.print(",");
            }
            pw.println("\" >");
            pw.println();
        }
        indent = TemplateBuilder.skipTo(pw, skeleton, "CONTROLS");
        if (labelAboveControl) {
            for (i = 0; i < handlers.length; ++i) {
                pw.println();
                pw.println(indent + "<%-- " + handlers[i].getEncodedAttributeName() + " --%>");
                handlers[i].printLabelAboveControl(pw, indent, taskContext);
                handlers[i].printScript(pw, indent);
                pw.println(indent + "<TR><TD height=\"9\"></TD></TR>");
            }
        } else {
            for (i = 0; i < handlers.length; ++i) {
                pw.println();
                pw.println(indent + "<%-- " + handlers[i].getEncodedAttributeName() + " --%>");
                handlers[i].printLabelLeftOfControl(pw, indent, taskContext);
                handlers[i].printScript(pw, indent);
                pw.println(indent + "<TR><TD height=\"8\"></TD></TR>");
            }
        }
        TemplateBuilder.skipToEnd(pw, skeleton);
    }

    private static String skipTo(PrintWriter pw, BufferedReader skeleton, String tag) {
        tag = "{" + tag + "}";
        String s = null;
        int index = 0;
        while (true) {
            try {
                s = skeleton.readLine();
            }
            catch (IOException e) {
                D.log(e);
                return null;
            }
            D.assrt(s != null, "PluginBuilder: ERROR: didn't find tab " + tag);
            index = s.indexOf(tag);
            if (index != -1) {
                return s.substring(0, index);
            }
            pw.println(s);
        }
    }

    private static void skipToEnd(PrintWriter pw, BufferedReader skeleton) {
        String s = null;
        while (true) {
            try {
                s = skeleton.readLine();
            }
            catch (IOException e) {
                D.log(e);
                return;
            }
            if (s == null) {
                return;
            }
            pw.println(s);
        }
    }

    private static void printSharedCode(PrintWriter pw, ArrayList list, String indent, String client) {
        String temp = null;
        for (int index = 0; index < list.size(); ++index) {
            temp = (String)list.get(index);
            if (temp == null) continue;
            String[] array = eMFrameUtils.split(temp, ":");
            if (array == null || array.length < 2) {
                D.log("invalid format of shared code: " + temp);
                continue;
            }
            String codeType = array[0];
            String fullFilename = array[1];
            if (codeType.equalsIgnoreCase("iman")) {
                pw.println(indent + "<iman:" + fullFilename + "/>");
                continue;
            }
            int indexOfSlash = fullFilename.indexOf(47);
            String moduleName = fullFilename.substring(0, indexOfSlash);
            String filename = fullFilename.substring(indexOfSlash, fullFilename.length());
            if (codeType.equalsIgnoreCase("inc")) {
                pw.println(indent + "<iman:include page=\"" + fullFilename + "\"/>");
                continue;
            }
            if (codeType.equalsIgnoreCase("js")) {
                if (client.equalsIgnoreCase("pocket")) {
                    D.assrt(false, "js files not supported on pocket");
                    continue;
                }
                pw.println(indent + "<SCRIPT language=\"JavaScript\" src=\"<c:out value=\"${ContextPath}\"/>/portal/modules/" + moduleName + "/javascripts/" + filename + "\"></SCRIPT>");
                continue;
            }
            if (codeType.equalsIgnoreCase("css")) {
                if (client.equalsIgnoreCase("pocket")) {
                    D.log("style sheets (css) not supported on pocketpc");
                    continue;
                }
                pw.println(indent + "<LINK rel=\"stylesheet\" href=\"<c:out value=\"${ContextPath}\"/>/portal/modules/" + moduleName + "/css/" + filename + "\" >");
                continue;
            }
            D.log("unsupported shared code type");
        }
    }
}

