/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw.util;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.FwAttr;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.Registry;
import com.novell.emframe.fw.RoleList;
import com.novell.emframe.fw.iManager;
import com.novell.emframe.fw.util.infos.RoleInfo;
import com.novell.emframe.fw.util.infos.RoleInfoLight;
import com.novell.emframe.fw.util.infos.TaskInfoLight;
import com.novell.rbs.RBSBook;
import com.novell.rbs.RBSCategory;
import com.novell.rbs.RBSRole;
import com.novell.rbs.RBSTask;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;

public class InfoFactory {
    public static WeakHashMap rbsTasksMap = new WeakHashMap();

    public static RoleInfo createRoleInfo(RoleInfoLight roleInfoLight, MContext context) {
        Registry reg;
        Document docRole;
        RBSRole rbsRole = roleInfoLight.getRBSRole();
        if (rbsRole == null) {
            rbsRole = new RBSRole(roleInfoLight.getObjectEntry());
        }
        String roleId = eMFrameUtils.getUniqueString(roleInfoLight.getId(), "");
        String defaultDisplayName = DirUtils.getLeftMostName(rbsRole.getObjectEntry().getName());
        String resourceFile = null;
        String displayNameKey = null;
        int order = 500;
        if (roleId.startsWith("base.")) {
            order = 300;
        }
        if ((docRole = (reg = Registry.getRegistry("Install")).getPluginDocument(roleInfoLight.getId())) != null) {
            D.log("found doc for role: " + roleId);
        } else {
            RoleInfo existingRoleInfo = null;
            RoleList roleList = RoleList.getInstance(context);
            if (roleList != null) {
                existingRoleInfo = roleList.getRole(roleInfoLight.getId());
            }
            if (existingRoleInfo != null) {
                D.log("found roleInfo for role: " + roleId);
                docRole = existingRoleInfo.getDocument();
                if (docRole == null) {
                    resourceFile = existingRoleInfo.getResourcePropertiesFile();
                    displayNameKey = existingRoleInfo.getDisplayNameKey();
                    order = existingRoleInfo.getOrder();
                }
            } else {
                Properties parameters = null;
                try {
                    parameters = eMFrameUtils.parseParameters(rbsRole.getParameters());
                }
                catch (SPIException spie) {
                    D.log("processParams: Exception: ");
                    D.log(spie);
                }
                Enumeration<Object> keys = parameters.keys();
                while (keys.hasMoreElements()) {
                    String strKey = (String)keys.nextElement();
                    String strValue = (String)parameters.get(strKey);
                    if (strKey.equalsIgnoreCase("resource-properties-file")) {
                        resourceFile = strValue;
                        continue;
                    }
                    if (strKey.equalsIgnoreCase("display-name-key")) {
                        displayNameKey = strValue;
                        continue;
                    }
                    if (!strKey.equals("order")) continue;
                    try {
                        order = Integer.parseInt(strValue);
                    }
                    catch (Exception e) {}
                }
            }
        }
        ArrayList cats = roleInfoLight.getCategories();
        HashMap<String, String> categoriesForRole = new HashMap<String, String>();
        if (cats == null || cats.size() == 0) {
            D.log("CreateRoleInfo: No category membership for role '" + rbsRole.getObjectClassName() + "'");
        } else {
            for (int i = 0; i < cats.size(); ++i) {
                ObjectEntry oeCat = (ObjectEntry)cats.get(i);
                RBSCategory rbsCat = new RBSCategory(oeCat);
                try {
                    String catResFile;
                    String catDisplayNameId;
                    String categoryParams = rbsCat.getParameters();
                    Properties parameters = eMFrameUtils.parseParameters(categoryParams, ";");
                    String id = oeCat.getName();
                    Document docCat = reg.getPluginDocument(id);
                    if (docCat != null) {
                        D.log("found doc for cat: " + id);
                        catDisplayNameId = reg.getPluginSettingFromDoc(id, "display-name-key");
                        catResFile = reg.getPluginSettingFromDoc(id, "resource-properties-file");
                    } else {
                        catDisplayNameId = (String)parameters.get("display-name-key");
                        catResFile = (String)parameters.get("resource-properties-file");
                    }
                    String catDisplayName = eMFrameUtils.getLocalizedString(catResFile, catDisplayNameId, context);
                    catDisplayName = catDisplayName == null ? oeCat.getName() : catDisplayName;
                    categoriesForRole.put(oeCat.getName(), catDisplayName);
                    continue;
                }
                catch (Exception e) {
                    D.log("CreateRoleInfo: Error.  Skipping category '" + oeCat.getName() + "'");
                }
            }
        }
        ArrayList lightTasks = roleInfoLight.getContent();
        RoleInfo roleInfo = null;
        roleInfo = docRole == null ? new RoleInfo(roleId, resourceFile, displayNameKey, defaultDisplayName, categoriesForRole, order) : new RoleInfo(roleId, defaultDisplayName, docRole, categoriesForRole, context);
        HashMap<String, Document> hmTasks = new HashMap<String, Document>(lightTasks.size());
        for (int i = 0; i < lightTasks.size(); ++i) {
            Document doc;
            TaskInfoLight lightTask = (TaskInfoLight)lightTasks.get(i);
            RBSTask rbsTask = lightTask.convert();
            if (rbsTask instanceof RBSBook) {
                doc = InfoFactory.createDirPropertyBookDoc((RBSBook)rbsTask, context);
                if (doc == null) continue;
                hmTasks.put(doc.getRootElement().getChildTextTrim("id"), doc);
                rbsTasksMap.put(doc, rbsTask);
                continue;
            }
            if (!(rbsTask instanceof RBSTask) || (doc = InfoFactory.createSnapinTaskDoc(rbsTask, lightTask.getObjectEntry(), context)) == null) continue;
            hmTasks.put(doc.getRootElement().getChildTextTrim("id"), doc);
            rbsTasksMap.put(doc, rbsTask);
        }
        roleInfo.setTasks(hmTasks, context);
        return roleInfo;
    }

    private static String getRealServiceName(RBSTask rbsTask, MContext context) {
        ObjectEntry oe = rbsTask.getObjectEntry();
        String moduleName = oe.getParent().getName();
        String taskNameWithoutModule = oe.getName();
        if (DirUtils.isNVDS(context)) {
            moduleName = InfoFactory.removeLeadingCN(moduleName);
            taskNameWithoutModule = InfoFactory.removeLeadingCN(taskNameWithoutModule);
        }
        String id = moduleName + "." + taskNameWithoutModule;
        Registry reg = Registry.getRegistry("Install");
        id = reg.getRealServiceName(id);
        return id;
    }

    private static String removeLeadingCN(String nameWithCn) {
        return nameWithCn.substring(nameWithCn.indexOf("=") + 1);
    }

    public static Document createSnapinTaskDoc(RBSTask rbsTask, ObjectEntry oe, MContext context) {
        String id = InfoFactory.getRealServiceName(rbsTask, context);
        Document doc = FwUtils.getTaskDocument(context, id);
        if (doc == null) {
            return null;
        }
        D.log("found doc for task: " + id + " in rolelist or Install registry.");
        InfoFactory.addToTasksByType(context, doc);
        return doc;
    }

    public static boolean requiredVersionOk(Document doc) {
        String requiredVersion = doc.getRootElement().getChildTextTrim("required-version");
        if (requiredVersion == null) {
            return true;
        }
        return InfoFactory.compareVersions(iManager.getVersionString(), requiredVersion) >= 0;
    }

    public static boolean expiredVersionOk(Document doc) {
        String expiredVersion = doc.getRootElement().getChildTextTrim("expired-version");
        if (expiredVersion == null) {
            return true;
        }
        return InfoFactory.compareVersions(expiredVersion, iManager.getVersionString()) > 0;
    }

    public static boolean versionOk(String originalId, Document doc) {
        String docFromRegVersion;
        String version = doc.getRootElement().getChildTextTrim("required-version");
        Document docFromReg = Registry.getRegistry("Install").getPluginDocument(originalId);
        return docFromReg == null || InfoFactory.compareVersions(version, docFromRegVersion = docFromReg.getRootElement().getChildTextTrim("required-version")) >= 0;
    }

    static int compareVersions(String v1, String v2) {
        if (v1 == null || v2 == null || v1.equals("") || v2.equals("")) {
            return 0;
        }
        try {
            String[] s1 = new String[]{v1};
            String[] s2 = new String[]{v2};
            int rev1 = InfoFactory.getRev(s1);
            int rev2 = InfoFactory.getRev(s2);
            v1 = s1[0];
            v2 = s2[0];
            double dv1 = Double.valueOf(v1);
            double dv2 = Double.valueOf(v2);
            if (dv1 < dv2) {
                return -1;
            }
            if (dv1 > dv2) {
                return 1;
            }
            if (rev1 < rev2) {
                return -1;
            }
            if (rev1 > rev2) {
                return 1;
            }
            return 0;
        }
        catch (Exception e) {
            D.log(e);
            return 0;
        }
    }

    static int getRev(String[] v1) {
        int rev = 0;
        try {
            int i2;
            int i1 = v1[0].indexOf(46);
            if (i1 != -1 && (i2 = v1[0].indexOf(46, i1 + 1)) != -1) {
                String revStr = v1[0].substring(i2 + 1);
                v1[0] = v1[0].substring(0, i2);
                rev = Integer.valueOf(revStr);
            }
        }
        catch (Exception e) {
            D.log(e);
        }
        return rev;
    }

    public static Document createDirPropertyBookDoc(RBSBook rbsBook, MContext context) {
        ObjectEntry oe = rbsBook.getObjectEntry();
        String id = InfoFactory.getRealServiceName((RBSTask)rbsBook, context);
        Document doc = FwUtils.getTaskDocument(context, id);
        if (doc != null) {
            D.log("found doc for Book: " + id);
            doc.getRootElement().removeChildren("page-assignment");
            doc.getRootElement().removeChildren("pageOrders");
        } else {
            doc = new Document(new Element("book"));
            try {
                String entryPoint = rbsBook.getEntryPoint();
                doc.getRootElement().addContent(new Element("class-name").setText(entryPoint));
                String[] strValidTargetTypes = rbsBook.getTargetObjectType();
                if (strValidTargetTypes != null && strValidTargetTypes.length > 0) {
                    for (int index = 0; index < strValidTargetTypes.length; ++index) {
                        doc.getRootElement().addContent(new Element("object-type-name").setText(strValidTargetTypes[index]));
                    }
                }
                InfoFactory.processParams((RBSTask)rbsBook, doc);
                doc.getRootElement().addContent(new Element("id").setText(id));
                String ldapDN = null;
                AdminNamespace nsa = oe.getAdminNamespace();
                ldapDN = nsa instanceof NDSNamespace ? context.getDirUtils().getMappingObject().NDSNameToLDAPName(oe) : oe.getFullName();
                doc.getRootElement().addContent(new Element("ldap-dn", ldapDN));
                InfoFactory.addAuthAssignmentToDoc((RBSTask)rbsBook, doc);
            }
            catch (Exception e) {
                D.log(e);
            }
        }
        try {
            String[] aPages = rbsBook.getPageMemebership();
            if (aPages != null) {
                for (int index = 0; index < aPages.length; ++index) {
                    Element newPage = new Element("page-assignment");
                    newPage.setText(aPages[index]);
                    doc.getRootElement().addContent(newPage);
                }
            }
        }
        catch (SPIException e) {
            D.log(e);
            D.log("PropertyBook: could not read pages for RBSBook");
        }
        try {
            Element pageOrdersElement = rbsBook.getrbsXMLInfo("pageOrders");
            if (pageOrdersElement != null) {
                doc.getRootElement().addContent(pageOrdersElement);
            }
        }
        catch (Exception e) {
            D.log(e);
        }
        InfoFactory.addToTasksByType(context, doc);
        return doc;
    }

    private static void addAuthAssignmentToDoc(RBSTask rbsTask, Document doc) throws SPIException, JDOMException, IOException {
        Element iManagerNode = rbsTask.getrbsXMLInfo("imanager");
        if (iManagerNode != null) {
            List authAssignments = iManagerNode.getChildren("auth-assignment");
            Iterator iter = authAssignments.iterator();
            while (iter.hasNext()) {
                Element authAssignment = (Element)iter.next();
                doc.getRootElement().addContent((Element)authAssignment.clone());
            }
        }
    }

    private static void addToTasksByType(MContext context, Document doc) {
        Hashtable tasksByType = (Hashtable)FwAttr.getFwAuthAttr("fw.tasksByType", context);
        if (tasksByType == null) {
            tasksByType = new Hashtable();
            FwAttr.setFwAuthAttr("fw.tasksByType", tasksByType, context);
        }
        List list = doc.getRootElement().getChildren("object-type-name");
        ListIterator iterator = list.listIterator();
        while (iterator.hasNext()) {
            String taskId;
            String otn = ((Element)iterator.next()).getTextTrim();
            if (otn == null || otn.equals("")) continue;
            HashMap<String, Document> tasksForTypeById = (HashMap<String, Document>)tasksByType.get(otn);
            if (tasksForTypeById == null) {
                tasksForTypeById = new HashMap<String, Document>();
                tasksByType.put(otn, tasksForTypeById);
            }
            if (tasksForTypeById.containsKey(taskId = doc.getRootElement().getChildTextTrim("id"))) continue;
            tasksForTypeById.put(taskId, doc);
        }
    }

    private static void processParams(RBSTask rbsTask, Document doc) {
        HashMap parameters;
        try {
            parameters = eMFrameUtils.parseParameters2(rbsTask.getParameters());
        }
        catch (SPIException spie) {
            D.log("processParams: Exception: ");
            D.log(spie);
            return;
        }
        Element root = doc.getRootElement();
        Set keys = parameters.keySet();
        Iterator i = keys.iterator();
        while (i.hasNext()) {
            String strKey = (String)i.next();
            Object objValue = parameters.get(strKey);
            Collection colValue = (Collection)objValue;
            Iterator i2 = colValue.iterator();
            while (i2.hasNext()) {
                String strValue = (String)i2.next();
                if (strKey.equalsIgnoreCase("resource-properties-file")) {
                    root.addContent(new Element("resource-properties-file").setText(strValue));
                    continue;
                }
                if (strKey.equalsIgnoreCase("display-name-key")) {
                    root.addContent(new Element("display-name-key").setText(strValue));
                    continue;
                }
                if (strKey.equalsIgnoreCase("merge-template")) {
                    root.addContent(new Element("merge-template").setText(strValue));
                    continue;
                }
                if (strKey.equalsIgnoreCase("error-template")) {
                    root.addContent(new Element("error-template").setText(strValue));
                    continue;
                }
                if (strKey.equalsIgnoreCase("order")) {
                    root.addContent(new Element("order").setText(strValue));
                    continue;
                }
                if (strKey.equalsIgnoreCase("object-type-name")) {
                    root.addContent(new Element("object-type-name").setText(strValue));
                    continue;
                }
                if (strKey.equalsIgnoreCase("supported-device-type")) {
                    root.addContent(new Element("supported-device-type").setText(strValue));
                    continue;
                }
                if (strKey.equalsIgnoreCase("version")) {
                    root.addContent(new Element("version").setText(strValue));
                    continue;
                }
                if (strKey.equalsIgnoreCase("required-version")) {
                    root.addContent(new Element("required-version").setText(strValue));
                    continue;
                }
                if (strKey.equalsIgnoreCase("expired-version")) {
                    root.addContent(new Element("expired-version").setText(strValue));
                    continue;
                }
                if (strKey.equalsIgnoreCase("type")) {
                    root.addContent(new Element("type").setText(strValue));
                    continue;
                }
                Element eKey = new Element("param-key");
                eKey.setText(strKey);
                Element eVal = new Element("param-value");
                eVal.setText(strValue);
                Element param = new Element("url-param");
                param.addContent(eKey);
                param.addContent(eVal);
                root.addContent(param);
            }
        }
    }
}

