/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw.util;

import com.novell.emframe.dev.D;
import com.novell.emframe.dev.config.SystemConfig;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.VersionInfo;
import com.novell.emframe.fw.config.ModuleInfo;
import com.novell.emframe.fw.util.TarEntry;
import com.novell.emframe.fw.util.TarInputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.util.Calendar;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.jar.Manifest;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ModuleGet {
    private static final String ROOT_ELEMENT = "modules";
    private static final String MODULE_ELEMENT = "module";
    private static final String MODULEID_ELEMENT = "moduleID";
    private static final String SELECTED_ATTRIBUTE = "selected";
    private static final String FILENAME_ELEMENT = "filename";
    private static final String VERSION_ELEMENT = "version";
    private static final String URL_ELEMENT = "url";
    private static final String URLTYPE_ATTRIBUTE = "type";
    private static final String IMAN_MIN_VERSION_ELEMENT = "min-required-version";
    private static final String IMAN_MAX_VERSION_ELEMENT = "max-required-version";
    private static final String DESCRIPTION_ELEMENT = "description";
    private static final String DESC_LANG_ATTRIBUTE = "lang";
    private static final String MODULE_MANIFEST_VERSION = "Implementation-Version";
    private static final String OS_ELEMENT = "os";
    private static final String GROUP_ELEMENT = "group";
    private static final int DOWNLOAD_TIMEOUT_SECONDS = 0;
    private static final int MODULE_DESCRIPTOR_DOC_EXPIRATION_HOURS = 168;
    private static final String TITLE_ELEMENT = "title";
    private static final String INFOURL_ELEMENT = "info_url";
    private static final String DEPENDS_ON = "depends-on";
    private String m_sIManVersion = "2.6.0";
    private String m_sOS = "all";
    private String m_sPackagePath = "";
    private static boolean sm_bUpdatedModuleDescriptorDoc = false;
    private static String m_sDescriptorUrl = "http://www.novell.com/products/consoles/imanager/iman_mod_desc.xml";
    private static Document sm_ModuleDescriptorDocument;
    private static long sm_iModuleDescriptorDocExpirationTime;
    private static Vector m_moduleList;
    private static boolean refresh;
    private static long sm_downloadStartedTime;
    private static boolean sm_bDownloadErrorlong;
    private static Throwable sm_throwableDownloadError;

    public ModuleGet(String imanVersion, String os, String packagePath) {
        this.m_sIManVersion = imanVersion;
        this.m_sOS = os;
        this.m_sPackagePath = packagePath;
        if (this.m_sPackagePath.length() == 0) {
            this.m_sPackagePath = ".";
        }
    }

    public Vector getListFromDownloadXML() {
        boolean waitForUpdate = refresh;
        ModuleGet.getModuleDescriptorDocument(waitForUpdate);
        if (sm_bUpdatedModuleDescriptorDoc || m_moduleList == null) {
            m_moduleList = this.getValidModuleInfo(sm_ModuleDescriptorDocument);
            sm_bUpdatedModuleDescriptorDoc = false;
        }
        Vector<ModuleInfo> returnList = new Vector<ModuleInfo>();
        VersionInfo iManVersion = new VersionInfo(this.m_sIManVersion);
        for (int i = 0; m_moduleList != null && i < m_moduleList.size(); ++i) {
            String platform;
            ModuleInfo newInfo = (ModuleInfo)m_moduleList.elementAt(i);
            if (FwUtils.doesModuleMeetCriteria(newInfo, iManVersion, this.m_sOS, platform = FwUtils.getiManagerPlatform())) {
                boolean needToAdd = true;
                for (int index = 0; index < returnList.size(); ++index) {
                    VersionInfo oldVersion;
                    needToAdd = true;
                    ModuleInfo oldInfo = (ModuleInfo)returnList.get(index);
                    if (!newInfo.getModuleID().equalsIgnoreCase(oldInfo.getModuleID())) continue;
                    needToAdd = false;
                    VersionInfo newVersion = new VersionInfo(newInfo.getModuleVersion());
                    if (newVersion.compareTo(oldVersion = new VersionInfo(oldInfo.getModuleVersion())) > 0) {
                        returnList.remove(index);
                        returnList.add(index, newInfo);
                        D.log("Replacing: This is a newer version of a module we already have");
                        continue;
                    }
                    D.log("Discarding: We already have a newer version of this module");
                }
                if (needToAdd) {
                    returnList.add(newInfo);
                    D.log("Added to list");
                    continue;
                }
                needToAdd = true;
                continue;
            }
            D.log("Skipped");
        }
        return returnList;
    }

    public static boolean errorOnLastDescriptorDocDownload() {
        return sm_bDownloadErrorlong;
    }

    public static Throwable getLastDescriptorDocDownloadError() {
        return sm_throwableDownloadError;
    }

    public Vector getUpdateListFromDownloadXML(boolean bShouldDownloadAll) {
        Vector list = this.getListFromDownloadXML();
        if (!bShouldDownloadAll) {
            for (int i = 0; i < list.size(); ++i) {
                ModuleInfo info = (ModuleInfo)list.elementAt(i);
                if (this.isThisModuleInstalledAndNewerVersion(info)) continue;
                D.log("Removing module from download XML list: " + info.getModuleID());
                list.remove(i--);
            }
        }
        return list;
    }

    public boolean getModules(Vector list) {
        boolean result = true;
        for (int i = 0; i < list.size(); ++i) {
            ModuleInfo info = (ModuleInfo)list.elementAt(i);
            if (this.shouldThisModuleBeDownloaded(info)) {
                D.log("=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-");
                D.log("=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+");
                D.log("ModuleGet() - Begin download of: " + this.m_sPackagePath + File.separator + info.getFilename());
                D.log("=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-");
                D.log("=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+");
                File oldFile = new File(this.m_sPackagePath + File.separator + info.getFilename());
                File nFile = null;
                nFile = this.downloadModule(info);
                if (nFile != null) {
                    if (oldFile.exists()) {
                        oldFile.delete();
                    }
                    try {
                        this.renameFile(nFile, oldFile);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        result = false;
                    }
                    continue;
                }
                result = false;
                continue;
            }
            result = false;
        }
        return result;
    }

    public static void clearCache() {
        refresh = true;
        sm_iModuleDescriptorDocExpirationTime = 0L;
        sm_downloadStartedTime = 0L;
    }

    private void renameFile(File file, File toFile) throws IOException {
        boolean result = file.renameTo(toFile);
        if (!result) {
            int data;
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(toFile));
            while ((data = bis.read()) != -1) {
                bos.write(data);
            }
            bis.close();
            bos.close();
            file.delete();
        }
    }

    private void writeModule(OutputStream os, ModuleInfo info) throws Throwable {
        BufferedInputStream is = new BufferedInputStream(FwUtils.getiManInputStreamBasedOnProxy(info.getUrl()));
        try {
            switch (info.getUrlType()) {
                case 0: {
                    int d;
                    while ((d = ((InputStream)is).read()) != -1) {
                        os.write(d);
                    }
                    break;
                }
                case 1: {
                    ZipEntry entry;
                    boolean found = false;
                    ZipInputStream zis = new ZipInputStream(is);
                    while ((entry = zis.getNextEntry()) != null) {
                        int d;
                        if (!entry.getName().endsWith(info.getFilename())) continue;
                        long size = entry.getSize();
                        long numRead = 0L;
                        while ((d = zis.read()) != -1 && numRead++ < size) {
                            os.write(d);
                        }
                        found = true;
                        break;
                    }
                    if (found) break;
                    throw new Exception("File not found: " + info.getFilename());
                }
                case 3: {
                    TarEntry entry;
                    boolean found = false;
                    TarInputStream tis = new TarInputStream(is);
                    while ((entry = tis.getNextEntry()) != null) {
                        int d;
                        if (!entry.getName().endsWith(info.getFilename())) continue;
                        long size = entry.getSize();
                        long numRead = 0L;
                        while ((d = tis.read()) != -1 && numRead++ < size) {
                            os.write(d);
                        }
                        found = true;
                        break;
                    }
                    if (found) break;
                    throw new Exception("File not found: " + info.getFilename());
                }
                case 2: {
                    TarEntry entry;
                    boolean found = false;
                    GZIPInputStream gis = new GZIPInputStream(is);
                    TarInputStream tis = new TarInputStream(gis);
                    while ((entry = tis.getNextEntry()) != null) {
                        int d;
                        if (!entry.getName().endsWith(info.getFilename())) continue;
                        long size = entry.getSize();
                        long numRead = 0L;
                        while ((d = tis.read()) != -1 && numRead++ < size) {
                            os.write(d);
                        }
                        found = true;
                        break;
                    }
                    if (found) break;
                    throw new Exception("File not found: " + info.getFilename());
                }
            }
        }
        finally {
            ((InputStream)is).close();
        }
    }

    private File downloadModule(ModuleInfo info) {
        OutputStream os = null;
        File file = null;
        try {
            file = new File(this.m_sPackagePath + File.separator + info.getFilename() + this.getTime());
            os = new FileOutputStream(file);
            os = new BufferedOutputStream(os);
            this.writeModule(os, info);
            os.close();
            Properties sysProps = System.getProperties();
            if (System.getProperty("proxySet") != null && sysProps.getProperty("http.proxyHost") != null && sysProps.getProperty("http.proxyPort") != null) {
                sysProps.remove("proxySet");
                sysProps.remove("http.proxyHost");
                sysProps.remove("http.proxyPort");
            }
            Authenticator.setDefault(null);
            return file;
        }
        catch (Throwable e) {
            if (e instanceof NoRouteToHostException) {
                info.setException(new Exception("No route to host. Please check network connection or proxy configuration settings."));
            } else if (e instanceof SocketTimeoutException) {
                info.setException(new Exception("Connect timed out. Please check network connection or proxy configuration settings."));
            } else if (e instanceof ProtocolException) {
                if (e.toString().indexOf("Server redirected too many  times") != -1) {
                    info.setException(new Exception("Server redirected too many times. Please check proxy configuration settings."));
                } else {
                    info.setException(e);
                }
            } else {
                info.setException(e);
            }
            if (os != null) {
                try {
                    os.close();
                    if (file != null) {
                        file.delete();
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            return null;
        }
    }

    private String getTime() {
        Calendar c = Calendar.getInstance();
        String time = "" + c.get(1) + c.get(5) + c.get(5) + c.get(11) + c.get(12);
        return time;
    }

    private Vector getValidModuleInfo(Document document) {
        Vector<ModuleInfo> modules = new Vector<ModuleInfo>();
        try {
            if (document == null) {
                return modules;
            }
            Document root = document;
            NodeList nl = root.getChildNodes();
            if (nl.getLength() == 0) {
                return modules;
            }
            Node rootElement = nl.item(0);
            if (!rootElement.getNodeName().equals(ROOT_ELEMENT)) {
                return modules;
            }
            NodeList modulesList = rootElement.getChildNodes();
            for (int i = 0; i < modulesList.getLength(); ++i) {
                Node moduleElement = modulesList.item(i);
                if (moduleElement.getNodeType() != 1 || !moduleElement.getNodeName().equals(MODULE_ELEMENT)) continue;
                ModuleInfo moduleInfo = new ModuleInfo();
                moduleInfo.setIsLocal(false);
                NodeList moduleInfoList = moduleElement.getChildNodes();
                for (int j = 0; j < moduleInfoList.getLength(); ++j) {
                    Node valueData;
                    Node valueData2;
                    NamedNodeMap attributes;
                    Node infoElement = moduleInfoList.item(j);
                    if (infoElement.getNodeType() != 1) continue;
                    if (infoElement.getNodeName().equals(MODULEID_ELEMENT)) {
                        boolean selected = false;
                        attributes = infoElement.getAttributes();
                        Node selectedData = attributes.getNamedItem(SELECTED_ATTRIBUTE);
                        if (selectedData != null) {
                            String sSelected = selectedData.getNodeValue();
                            Boolean bSelected = new Boolean(sSelected);
                            selected = bSelected;
                            moduleInfo.setSelected(selected);
                        }
                        if (((valueData2 = infoElement.getFirstChild()) == null || valueData2.getNodeType() != 4) && valueData2.getNodeType() != 3) continue;
                        moduleInfo.setModuleID(valueData2.getNodeValue());
                        continue;
                    }
                    if (infoElement.getNodeName().equals(FILENAME_ELEMENT)) {
                        Node valueData3 = infoElement.getFirstChild();
                        if (valueData3 == null || valueData3.getNodeType() != 4 && valueData3.getNodeType() != 3) continue;
                        moduleInfo.setFilename(valueData3.getNodeValue());
                        continue;
                    }
                    if (infoElement.getNodeName().equals(VERSION_ELEMENT)) {
                        Node valueData4 = infoElement.getFirstChild();
                        if (valueData4 == null || valueData4.getNodeType() != 4 && valueData4.getNodeType() != 3) continue;
                        moduleInfo.setModuleVersion(valueData4.getNodeValue());
                        continue;
                    }
                    if (infoElement.getNodeName().equals(IMAN_MIN_VERSION_ELEMENT)) {
                        Node valueData5 = infoElement.getFirstChild();
                        if (valueData5 == null || valueData5.getNodeType() != 4 && valueData5.getNodeType() != 3) continue;
                        moduleInfo.setMinRequiredVersion(valueData5.getNodeValue());
                        continue;
                    }
                    if (infoElement.getNodeName().equals(IMAN_MAX_VERSION_ELEMENT)) {
                        Node valueData6 = infoElement.getFirstChild();
                        if (valueData6 == null || valueData6.getNodeType() != 4 && valueData6.getNodeType() != 3) continue;
                        moduleInfo.setMaxRequiredVersion(valueData6.getNodeValue());
                        continue;
                    }
                    if (infoElement.getNodeName().equals(URL_ELEMENT)) {
                        int type = 0;
                        attributes = infoElement.getAttributes();
                        Node typeData = attributes.getNamedItem(URLTYPE_ATTRIBUTE);
                        if (typeData != null) {
                            String sType = typeData.getNodeValue();
                            if (sType.equalsIgnoreCase("npm")) {
                                type = 0;
                            }
                            if (sType.equalsIgnoreCase("zip")) {
                                type = 1;
                            }
                            if (sType.equalsIgnoreCase("targz")) {
                                type = 2;
                            }
                            if (sType.equalsIgnoreCase("tar")) {
                                type = 3;
                            }
                        }
                        if ((valueData2 = infoElement.getFirstChild()) == null || valueData2.getNodeType() != 4 && valueData2.getNodeType() != 3) continue;
                        moduleInfo.setUrl(valueData2.getNodeValue(), type);
                        continue;
                    }
                    if (infoElement.getNodeName().equals(INFOURL_ELEMENT)) {
                        Node valueData7 = infoElement.getFirstChild();
                        if (valueData7 == null || valueData7.getNodeType() != 4 && valueData7.getNodeType() != 3) continue;
                        moduleInfo.setInfoUrl(valueData7.getNodeValue());
                        continue;
                    }
                    if (infoElement.getNodeName().equals(DEPENDS_ON)) {
                        Node valueData8 = infoElement.getFirstChild();
                        if (valueData8 == null || valueData8.getNodeType() != 4 && valueData8.getNodeType() != 3) continue;
                        String[] sValuetemp = valueData8.getNodeValue().split(",");
                        for (int k = 0; k < sValuetemp.length; ++k) {
                            moduleInfo.setDependsOn(sValuetemp[k]);
                        }
                        continue;
                    }
                    if (infoElement.getNodeName().equals(DESCRIPTION_ELEMENT)) {
                        String lang = "en";
                        attributes = infoElement.getAttributes();
                        Node langData = attributes.getNamedItem(DESC_LANG_ATTRIBUTE);
                        if (langData != null) {
                            lang = langData.getNodeValue();
                        }
                        if ((valueData2 = infoElement.getFirstChild()) == null || valueData2.getNodeType() != 4 && valueData2.getNodeType() != 3) continue;
                        moduleInfo.setDescription(valueData2.getNodeValue(), lang);
                        continue;
                    }
                    if (infoElement.getNodeName().equals(OS_ELEMENT)) {
                        Node valueData9 = infoElement.getFirstChild();
                        if (valueData9 == null || valueData9.getNodeType() != 4 && valueData9.getNodeType() != 3) continue;
                        moduleInfo.setSupportedOSTypes(valueData9.getNodeValue());
                        continue;
                    }
                    if (infoElement.getNodeName().equals(GROUP_ELEMENT)) {
                        Node valueData10 = infoElement.getFirstChild();
                        if (valueData10 == null || valueData10.getNodeType() != 4 && valueData10.getNodeType() != 3) continue;
                        moduleInfo.setGroup(valueData10.getNodeValue());
                        continue;
                    }
                    if (!infoElement.getNodeName().equals(TITLE_ELEMENT) || (valueData = infoElement.getFirstChild()) == null || valueData.getNodeType() != 4 && valueData.getNodeType() != 3) continue;
                    moduleInfo.setModuleTitle(valueData.getNodeValue());
                }
                modules.add(moduleInfo);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return modules;
    }

    public static Document getModuleDescriptorDocument(boolean waitForUpdate) {
        if (sm_ModuleDescriptorDocument == null || waitForUpdate && sm_iModuleDescriptorDocExpirationTime < System.currentTimeMillis()) {
            while (sm_downloadStartedTime != 0L && sm_downloadStartedTime + 0L > System.currentTimeMillis()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (sm_downloadStartedTime != 0L) {
                System.err.println("Timed out trying to download module descriptor file.");
            }
        }
        if (sm_downloadStartedTime == 0L && sm_ModuleDescriptorDocument != null && sm_iModuleDescriptorDocExpirationTime < System.currentTimeMillis()) {
            if (waitForUpdate) {
                ModuleGet.downloadModuleDescriptorDocument(true);
            } else {
                ModuleGet.startAsyncDownloadOfModuleDescriptor();
            }
        }
        return sm_ModuleDescriptorDocument;
    }

    public static void startAsyncDownloadOfModuleDescriptor() {
        Thread thread = new Thread((Runnable)new AsyncModuleDescriptorDownloader(), "AsyncGetModuleDescriptorFromWeb");
        thread.start();
    }

    private static void downloadModuleDescriptorDocument(boolean bClearDocOnError) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            sm_downloadStartedTime = System.currentTimeMillis();
            BufferedInputStream is = new BufferedInputStream(FwUtils.getiManInputStreamBasedOnProxy(ModuleGet.getDescriptorUrl()));
            sm_ModuleDescriptorDocument = builder.parse(is);
            int expirationHours = 168;
            String sRet = new SystemConfig().getSetting("ModuleDescriptorDocExpirationHours", Integer.toString(expirationHours));
            if (sRet != null) {
                try {
                    expirationHours = Integer.parseInt(sRet);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
            sm_iModuleDescriptorDocExpirationTime = System.currentTimeMillis() + (long)(60000 * expirationHours * 60);
            sm_downloadStartedTime = 0L;
            sm_bUpdatedModuleDescriptorDoc = true;
            refresh = false;
            sm_bDownloadErrorlong = false;
            sm_throwableDownloadError = null;
            Properties sysProps = System.getProperties();
            if (System.getProperty("proxySet") != null && sysProps.getProperty("http.proxyHost") != null && sysProps.getProperty("http.proxyPort") != null) {
                sysProps.remove("proxySet");
                sysProps.remove("http.proxyHost");
                sysProps.remove("http.proxyPort");
            }
            Authenticator.setDefault(null);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (SAXException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
            sm_bDownloadErrorlong = true;
            sm_throwableDownloadError = e1;
            if (bClearDocOnError) {
                sm_ModuleDescriptorDocument = null;
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            D.log(ex.toString());
        }
    }

    public static String getDescriptorUrl() {
        return m_sDescriptorUrl;
    }

    public static void setDescriptorUrl(String descriptorUrl) {
        m_sDescriptorUrl = descriptorUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void buildModuleDownloadDescriptorFile(Set modules, File packagesDir, String url) {
        packagesDir.mkdirs();
        File descFile = new File(packagesDir, "iman_mod_desc.xml");
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(descFile);
            fos.write("<modules>".getBytes());
            Object[] mods = modules.toArray();
            for (int i = 0; i < mods.length; ++i) {
                ModuleInfo minfo = (ModuleInfo)((Map.Entry)mods[i]).getValue();
                fos.write("\n\t".getBytes());
                fos.write("<module>".getBytes());
                if (minfo.getModuleID() != null && minfo.getModuleID().length() > 0) {
                    fos.write("\n\t\t".getBytes());
                    fos.write("<moduleID>".getBytes());
                    fos.write(minfo.getModuleID().getBytes());
                    fos.write("</moduleID>".getBytes());
                }
                if (minfo.getFilename() != null && minfo.getFilename().length() > 0) {
                    fos.write("\n\t\t".getBytes());
                    fos.write("<filename>".getBytes());
                    fos.write(minfo.getFilename().getBytes());
                    fos.write("</filename>".getBytes());
                    if (url != null && url.length() > 0) {
                        fos.write("\n\t\t".getBytes());
                        fos.write("<url>".getBytes());
                        fos.write(url.getBytes());
                        fos.write(minfo.getFilename().getBytes());
                        fos.write("</url>".getBytes());
                    }
                }
                if (minfo.getModuleTitle() != null && minfo.getModuleTitle().length() > 0) {
                    fos.write("\n\t\t".getBytes());
                    fos.write("<title>".getBytes());
                    fos.write(minfo.getModuleTitle().getBytes());
                    fos.write("</title>".getBytes());
                }
                if (minfo.getModuleVersion() != null && minfo.getModuleVersion().length() > 0) {
                    fos.write("\n\t\t".getBytes());
                    fos.write("<version>".getBytes());
                    fos.write(minfo.getModuleVersion().getBytes());
                    fos.write("</version>".getBytes());
                }
                if (minfo.getMinRequiredVersion() != null && minfo.getMinRequiredVersion().length() > 0) {
                    fos.write("\n\t\t".getBytes());
                    fos.write("<min-required-version>".getBytes());
                    fos.write(minfo.getMinRequiredVersion().getBytes());
                    fos.write("</min-required-version>".getBytes());
                }
                if (minfo.getMaxRequiredVersion() != null && minfo.getMaxRequiredVersion().length() > 0) {
                    fos.write("\n\t\t".getBytes());
                    fos.write("<max-required-version>".getBytes());
                    fos.write(minfo.getMaxRequiredVersion().getBytes());
                    fos.write("</max-required-version>".getBytes());
                }
                if (minfo.getModuleDescription() != null && minfo.getModuleDescription().length() > 0) {
                    fos.write("\n\t\t".getBytes());
                    fos.write("<description>".getBytes());
                    fos.write(minfo.getModuleDescription().getBytes());
                    fos.write("</description>".getBytes());
                }
                if (minfo.getSupportedOSTypes() != null && minfo.getSupportedOSTypes().length() > 0) {
                    fos.write("\n\t\t".getBytes());
                    fos.write("<os>".getBytes());
                    fos.write(minfo.getSupportedOSTypes().getBytes());
                    fos.write("</os>".getBytes());
                }
                fos.write("\n\t".getBytes());
                fos.write("</module>".getBytes());
            }
            fos.write("\n".getBytes());
            fos.write("</modules>".getBytes());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private boolean isThisModuleInstalledAndNewerVersion(ModuleInfo info) {
        String manifestPath = eMFrameUtils.getRealPath("/") + "WEB-INF/modules/" + info.getModuleID() + "/META-INF/";
        String manifestUpper = "MANIFEST.MF";
        String manifestLower = "manifest.mf";
        boolean fileExist = false;
        File manifestFile = new File(manifestPath + manifestUpper);
        fileExist = manifestFile.exists();
        if (!fileExist) {
            manifestFile = new File(manifestPath + manifestLower);
            fileExist = manifestFile.exists();
        }
        if (fileExist) {
            D.log("Manifest file exist: " + manifestPath);
            String installedVersion = this.getManifestFileVersion(manifestFile);
            D.log("Installed version: " + installedVersion);
            D.log("New version: " + info.getModuleVersion());
            VersionInfo installedVersionInfo = new VersionInfo(installedVersion);
            VersionInfo newModuleVersionInfo = new VersionInfo(info.getModuleVersion());
            if (installedVersionInfo.compareTo(newModuleVersionInfo) >= 0) {
                D.log("The installed moudle has a newer version then the new modue");
                return false;
            }
        } else {
            D.log("Manifest file DOESN'T exist: " + manifestPath);
            return false;
        }
        return true;
    }

    private boolean shouldThisModuleBeDownloaded(ModuleInfo info) {
        File npmFile;
        String manifestPath = eMFrameUtils.getRealPath("/") + "WEB-INF/modules/" + info.getModuleID() + "/META-INF/manifest.mf";
        File manifestFile = new File(manifestPath);
        boolean shouldDownload = true;
        if (manifestFile.exists()) {
            D.log("Manifest file exist: " + manifestPath);
            String version = this.getManifestFileVersion(manifestFile);
            D.log("Manifest file version: " + version);
            VersionInfo oldVersionInfo = new VersionInfo(version);
            VersionInfo newVersionInfo = new VersionInfo(info.getModuleVersion());
            if (newVersionInfo.compareTo(oldVersionInfo) <= 0) {
                shouldDownload = false;
            }
        }
        if (shouldDownload && (npmFile = new File(this.m_sPackagePath + File.separator + info.getFilename())).exists() && !npmFile.canWrite()) {
            shouldDownload = false;
            D.log("<><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><>");
            D.log("<><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><>");
            D.log(npmFile.getAbsolutePath() + ": Is set to read-only and cannot not be downloaded.");
            D.log("<><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><>");
            D.log("<><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><>");
        }
        if (!shouldDownload) {
            Exception exc = new Exception(info.getModuleTitle());
            info.setException(exc);
        }
        return shouldDownload;
    }

    private String getManifestFileVersion(File manifestFile) {
        String version = "";
        try {
            if (manifestFile.canRead()) {
                FileInputStream fileInputStream = new FileInputStream(manifestFile);
                BufferedInputStream bufInputStream = new BufferedInputStream(fileInputStream);
                ByteArrayOutputStream baOutputStream = new ByteArrayOutputStream();
                BufferedOutputStream bufBaOutputStream = new BufferedOutputStream(baOutputStream);
                int data = bufInputStream.read();
                while (data != -1) {
                    bufBaOutputStream.write(data);
                    if (data == 58) {
                        data = bufInputStream.read();
                        if (data != 32) {
                            bufBaOutputStream.write(32);
                            continue;
                        }
                        bufBaOutputStream.write(data);
                    }
                    data = bufInputStream.read();
                }
                bufBaOutputStream.write("\r\n".getBytes());
                bufInputStream.close();
                bufBaOutputStream.close();
                byte[] baBuff = baOutputStream.toByteArray();
                ByteArrayInputStream baInputStream = new ByteArrayInputStream(baBuff);
                Manifest manifest = new Manifest(baInputStream);
                version = manifest.getMainAttributes().getValue(MODULE_MANIFEST_VERSION);
            }
        }
        catch (Throwable e) {
            D.log("Could not read manifest file for: " + manifestFile.getAbsolutePath());
        }
        return version;
    }

    static {
        m_moduleList = null;
        refresh = true;
        sm_throwableDownloadError = null;
    }

    static class AsyncModuleDescriptorDownloader
    implements Runnable {
        AsyncModuleDescriptorDownloader() {
        }

        public void run() {
            ModuleGet.downloadModuleDescriptorDocument(false);
        }
    }
}

