/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw.util;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.common.exceptions.UniqueSPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.SchemaDefinition;
import com.novell.admin.ns.SchemaUtil;
import com.novell.admin.ns.Syntax;
import com.novell.admin.ns.ValueComponent;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.SnapinVetoException;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameFactory;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.RBSUtil;
import com.novell.emframe.fw.VersionInfo;
import com.novell.emframe.fw.iManager;
import com.novell.emframe.fw.servlet.AuthenticatorServlet;
import com.novell.emframe.fw.util.InfoFactory;
import com.novell.emframe.fw.xmlinfos.BookAddOnClassObject;
import com.novell.emframe.fw.xmlinfos.BookClassObject;
import com.novell.emframe.fw.xmlinfos.CategoryClassObject;
import com.novell.emframe.fw.xmlinfos.ModuleClassObject;
import com.novell.emframe.fw.xmlinfos.RoleClassObject;
import com.novell.emframe.fw.xmlinfos.TaskClassObject;
import com.novell.rbs.RBSBook;
import com.novell.rbs.RBSCategory;
import com.novell.rbs.RBSException;
import com.novell.rbs.RBSModule;
import com.novell.rbs.RBSObject;
import com.novell.rbs.RBSRights;
import com.novell.rbs.RBSRole;
import com.novell.rbs.RBSTask;
import java.io.IOException;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.jdom.Element;
import org.jdom.JDOMException;

public class RBSObjectInstaller {
    private ObjectEntry treeOE;
    private ModuleClassObject moduleClassObject;
    private AdminNamespace m_ns;
    private ObjectEntry rbsCollectionOE;
    private ObjectEntry rbsModuleOE;
    private Hashtable rbsCategoryNSObjectTable;
    private Hashtable rbsRoleNSObjectTable;
    private String dynamicGroupSearchType;
    private boolean reinstallModule = false;
    private boolean isLDAP = false;

    public RBSObjectInstaller(ObjectEntry tOE, ModuleClassObject mClassObject) {
        this.treeOE = tOE;
        this.m_ns = this.treeOE.getAdminNamespace();
        this.moduleClassObject = mClassObject;
        this.rbsCategoryNSObjectTable = new Hashtable();
        this.rbsRoleNSObjectTable = new Hashtable();
        this.isLDAP = this.m_ns.getUniqueID().equalsIgnoreCase("LDAP");
    }

    public void install(String rbsCollectionContext, String dGSearchType) throws SPIException, SnapinVetoException, ComponentCreationException, NamespaceException, RBSException, JDOMException, IOException {
        this.install(rbsCollectionContext, dGSearchType, false);
    }

    public void install(String rbsCollectionContext, String dGSearchType, boolean reinstall) throws SPIException, SnapinVetoException, ComponentCreationException, NamespaceException, RBSException, JDOMException, IOException {
        this.dynamicGroupSearchType = dGSearchType;
        this.reinstallModule = reinstall;
        this.rbsCollectionOE = this.m_ns.getObjectEntry(this.treeOE, rbsCollectionContext);
        this.createTheRBSModuleContainer();
        this.createAllTheCategories();
        this.createAllTheRoles();
        this.createAllTheTasks();
        this.createAllTheBooks();
        this.addAllTheBookAddOns();
    }

    private void createTheRBSModuleContainer() throws SPIException, SnapinVetoException, ComponentCreationException, NamespaceException, IOException, JDOMException {
        String moduleName = this.moduleClassObject.getModuleName();
        if (this.isLDAP) {
            moduleName = "cn=".concat(moduleName);
        }
        if (moduleName != "" && !this.m_ns.doesExist(this.rbsCollectionOE, moduleName)) {
            ValueComponent[] vals = new ValueComponent[1];
            ValueComponent[] nameVal = new ValueComponent[1];
            AttributeDefinition objClassAttrDef = this.m_ns.getAttributeDefinition(this.rbsCollectionOE, SchemaUtil.translateNDAPAttr((ObjectEntry)this.rbsCollectionOE, (String)"Object Class"));
            Syntax objClassSyn = objClassAttrDef.getSyntax();
            vals[0] = objClassSyn.createValueComponent((Object)"rbsModule2");
            ObjectAttribute attrObj = new ObjectAttribute(objClassAttrDef, vals);
            AttributeDefinition cnAttrDef = this.m_ns.getAttributeDefinition(this.rbsCollectionOE, SchemaUtil.translateNDAPAttr((ObjectEntry)this.rbsCollectionOE, (String)"CN"));
            Syntax cnSyn = cnAttrDef.getSyntax();
            nameVal[0] = cnSyn.createValueComponent((Object)moduleName);
            ObjectAttribute objNameAttr = new ObjectAttribute(cnAttrDef, nameVal);
            Vector<ObjectAttribute> attrOV = new Vector<ObjectAttribute>();
            attrOV.addElement(attrObj);
            attrOV.addElement(objNameAttr);
            this.rbsModuleOE = this.m_ns.createObjectEntry(this.rbsCollectionOE, moduleName, "rbsModule2");
            NSObject taskModuleObj = this.m_ns.createNSObject(this.rbsModuleOE, attrOV);
            this.m_ns.create(taskModuleObj);
            this.updateRBSModule(taskModuleObj);
        } else {
            this.rbsModuleOE = this.m_ns.getObjectEntry(this.rbsCollectionOE, moduleName);
            NSObject moduleObj = this.m_ns.getDetails(this.rbsModuleOE);
            RBSModule rbsModule = new RBSModule(moduleObj);
            String oldVersion = RBSUtil.getVersionFromElement(rbsModule.getrbsXMLInfo("version"));
            if (oldVersion == null) {
                D.log("The version element for " + this.m_ns.getUnrootedName(this.rbsModuleOE) + " has not been set.  Initializing to 0.0.0.");
                oldVersion = "0.0.0";
            }
            if (this.reinstallModule || RBSUtil.isUpdateNeeded(oldVersion, this.moduleClassObject.getVersion())) {
                this.updateRBSModule(moduleObj);
            }
        }
    }

    private void createAllTheTasks() throws SPIException, SnapinVetoException, ComponentCreationException, NamespaceException, RBSException, JDOMException, IOException {
        Vector taskList = this.moduleClassObject.getTasks();
        for (int i = 0; i < taskList.size(); ++i) {
            TaskClassObject tList = (TaskClassObject)taskList.elementAt(i);
            this.createRBSTask(tList);
        }
    }

    private void createAllTheBooks() throws SPIException, SnapinVetoException, ComponentCreationException, NamespaceException, RBSException, JDOMException, IOException {
        Vector bookList = this.moduleClassObject.getBooks();
        for (int i = 0; i < bookList.size(); ++i) {
            BookClassObject bList = (BookClassObject)bookList.elementAt(i);
            this.createRBSBook(bList);
        }
    }

    private NSObject createRBSTask(TaskClassObject taskClassObject) throws SPIException, SnapinVetoException, ComponentCreationException, NamespaceException, RBSException, JDOMException, IOException {
        NSObject taskObj = null;
        String tempName = new String(taskClassObject.getName());
        String taskName = null;
        int indexOfDelemeter = tempName.indexOf(".");
        taskName = indexOfDelemeter != -1 ? tempName.substring(indexOfDelemeter + 1) : tempName;
        if (this.isLDAP) {
            taskName = "cn=".concat(taskName);
        }
        if (!this.m_ns.doesExist(this.rbsModuleOE, taskName)) {
            ValueComponent[] vals = new ValueComponent[1];
            ValueComponent[] nameVal = new ValueComponent[1];
            AttributeDefinition objClassAttrDef = this.m_ns.getAttributeDefinition(this.rbsModuleOE, SchemaUtil.translateNDAPAttr((ObjectEntry)this.rbsModuleOE, (String)"Object Class"));
            Syntax objClassSyn = objClassAttrDef.getSyntax();
            vals[0] = objClassSyn.createValueComponent((Object)"rbsTask2");
            ObjectAttribute attrObj = new ObjectAttribute(objClassAttrDef, vals);
            AttributeDefinition cnAttrDef = this.m_ns.getAttributeDefinition(this.rbsModuleOE, SchemaUtil.translateNDAPAttr((ObjectEntry)this.rbsModuleOE, (String)"CN"));
            Syntax cnSyn = cnAttrDef.getSyntax();
            nameVal[0] = cnSyn.createValueComponent((Object)taskName);
            ObjectAttribute objNameAttr = new ObjectAttribute(cnAttrDef, nameVal);
            Vector<ObjectAttribute> attrOV = new Vector<ObjectAttribute>();
            attrOV.addElement(attrObj);
            attrOV.addElement(objNameAttr);
            if (taskClassObject.getRequiredVersion().length() > 0 && InfoFactory.compareVersions(taskClassObject.getRequiredVersion(), iManager.getVersionString()) > 0) {
                return null;
            }
            if (taskClassObject.getExpiredVersion().length() > 0 && InfoFactory.compareVersions(taskClassObject.getExpiredVersion(), iManager.getVersionString()) <= 0) {
                return null;
            }
            ObjectEntry taskOE = this.m_ns.createObjectEntry(this.rbsModuleOE, taskName, "rbsTask2");
            taskObj = this.m_ns.createNSObject(taskOE, attrOV);
            this.m_ns.create(taskObj);
            this.updateRBSTask(taskObj, taskClassObject);
        } else {
            ObjectEntry taskOE = this.m_ns.getObjectEntry(this.rbsModuleOE, taskName);
            taskObj = this.m_ns.getDetails(taskOE);
            RBSTask rbsTask = new RBSTask(taskObj);
            String oldVersion = this.getVersionFromParameters(rbsTask.getParameters());
            this.reinstallModule = true;
            if (true || RBSUtil.isUpdateNeeded(oldVersion, taskClassObject.getVersion())) {
                this.updateRBSTask(taskObj, taskClassObject);
            }
        }
        return taskObj;
    }

    private void updateRBSTask(NSObject taskObj, TaskClassObject taskClassObject) throws SPIException, SnapinVetoException, ComponentCreationException, NamespaceException, RBSException, JDOMException, IOException {
        String[] roleList;
        RBSRights[] rights;
        int i;
        Element[] authAssignmentElements;
        ObjectEntry taskOE = taskObj.getObjectEntry();
        AdminNamespace namespace = taskOE.getAdminNamespace();
        SchemaDefinition schemaDef = namespace.getSchemaDefinition(taskOE);
        boolean update = false;
        boolean addToRole = true;
        RBSTask rbsTask = new RBSTask(taskObj);
        if (taskClassObject.getClassPath().length() > 0) {
            rbsTask.setEntryPoint(taskClassObject.getClassPath());
            update = true;
        }
        if (taskClassObject.getParameters().length() > 0) {
            rbsTask.setParameters(taskClassObject.getParameters());
            update = true;
        }
        if (taskClassObject.getRBSXMLInfo() != null) {
            rbsTask.setrbsXMLInfo(taskClassObject.getRBSXMLInfo());
            update = true;
        }
        if ((authAssignmentElements = taskClassObject.getAuthAssignmentElement()) != null) {
            Element iManagerElement = rbsTask.getrbsXMLInfo("imanager");
            if (iManagerElement == null) {
                iManagerElement = new Element("imanager");
                for (i = 0; i < authAssignmentElements.length; ++i) {
                    iManagerElement.addContent(authAssignmentElements[i]);
                }
            } else {
                int i2;
                List authAssignmentList = iManagerElement.getChildren("auth-assignment");
                if (authAssignmentList != null) {
                    for (i2 = 0; i2 < authAssignmentList.size(); ++i2) {
                        Element authAssignmentElement = (Element)authAssignmentList.get(i2);
                        iManagerElement.removeContent(authAssignmentElement);
                    }
                }
                for (i2 = 0; i2 < authAssignmentElements.length; ++i2) {
                    iManagerElement.addContent(authAssignmentElements[i2]);
                }
            }
            rbsTask.setrbsXMLInfo(iManagerElement);
            update = true;
        }
        if (taskClassObject.getSecondaryRightsElement() != null) {
            Element secondaryRights = null;
            Element iManagerElement = rbsTask.getrbsXMLInfo("imanager");
            if (iManagerElement == null) {
                iManagerElement = new Element("imanager").addContent(taskClassObject.getSecondaryRightsElement());
            } else {
                secondaryRights = iManagerElement.getChild("secondary-rights");
                if (secondaryRights != null) {
                    iManagerElement.removeContent(secondaryRights);
                }
                iManagerElement.addContent(taskClassObject.getSecondaryRightsElement());
            }
            rbsTask.setrbsXMLInfo(iManagerElement);
            update = true;
            Element[] secondarySetElements = com.novell.rbs.RBSUtil.getSecondarySetElements((RBSObject[])new RBSObject[]{rbsTask});
            if (secondarySetElements != null) {
                block5: for (int i3 = 0; i3 < secondarySetElements.length && addToRole; ++i3) {
                    Element currentSetElement = secondarySetElements[i3];
                    List rightsAssignmentChildren = currentSetElement.getChildren("rights-assignment");
                    RBSRights[] rights2 = com.novell.rbs.RBSUtil.getRightsAssignment((List)rightsAssignmentChildren, (String)"");
                    if (rights2 == null) continue;
                    for (int j = 0; j < rights2.length; ++j) {
                        if (rights2[j].getProtectedAttrName().equalsIgnoreCase("[Entry Rights]") || rights2[j].getProtectedAttrName().equalsIgnoreCase("[All Attributes Rights]") || rights2[j].getProtectedAttrName().equalsIgnoreCase("[No Self Rights Assignment]") || schemaDef.isAttributeDefined(rights2[j].getProtectedAttrName())) continue;
                        D.log("--  Discarding task: " + this.m_ns.getUnrootedName(taskOE) + " attribute undefined: " + rights2[j].getProtectedAttrName());
                        addToRole = false;
                        continue block5;
                    }
                }
            }
        }
        if (taskClassObject.getDescData().length() > 0) {
            rbsTask.setDescription(taskClassObject.getDescData());
            update = true;
        }
        if ((rights = taskClassObject.getRights()) != null && rights.length > 0) {
            rbsTask.setRights(rights);
            update = true;
            if (addToRole) {
                for (i = 0; i < rights.length; ++i) {
                    if (rights[i].getProtectedAttrName().equalsIgnoreCase("[Entry Rights]") || rights[i].getProtectedAttrName().equalsIgnoreCase("[All Attributes Rights]") || rights[i].getProtectedAttrName().equalsIgnoreCase("[No Self Rights Assignment]") || schemaDef.isAttributeDefined(rights[i].getProtectedAttrName())) continue;
                    D.log("--  Discarding task: " + this.m_ns.getUnrootedName(taskOE) + " attribute undefined: " + rights[i].getProtectedAttrName());
                    addToRole = false;
                    break;
                }
            }
        }
        rbsTask.setContentMembership(null, this.dynamicGroupSearchType);
        if (addToRole && (roleList = taskClassObject.getRoleList()) != null && roleList.length > 0) {
            Vector<RBSRole> rolesV = new Vector<RBSRole>();
            for (int j = 0; j < roleList.length; ++j) {
                NSObject roleObj = (NSObject)this.rbsRoleNSObjectTable.get(roleList[j]);
                if (roleObj != null) {
                    rolesV.add(new RBSRole(roleObj));
                    continue;
                }
                ObjectEntry oe = null;
                try {
                    oe = this.m_ns.getObjectEntry(this.rbsCollectionOE, roleList[j]);
                }
                catch (SPIException e) {
                    continue;
                }
                rolesV.add(new RBSRole(oe));
            }
            if (rolesV.size() > 0) {
                RBSRole[] currentRoles = rbsTask.getContentMembership();
                if (currentRoles == null || currentRoles.length == 0) {
                    Object[] roles = new RBSRole[rolesV.size()];
                    rolesV.copyInto(roles);
                    rbsTask.setContentMembership((RBSRole[])roles, this.dynamicGroupSearchType);
                    update = true;
                } else {
                    boolean updateRole = false;
                    for (int i4 = 0; i4 < rolesV.size(); ++i4) {
                        boolean add = true;
                        RBSRole newRole = (RBSRole)rolesV.elementAt(i4);
                        ObjectEntry newRoleOE = newRole.getObjectEntry();
                        String newRoleName = this.m_ns.getUnrootedName(newRoleOE);
                        RBSRole oldRole = null;
                        for (int j = 0; j < currentRoles.length; ++j) {
                            oldRole = currentRoles[j];
                            ObjectEntry oldRoleOE = oldRole.getObjectEntry();
                            String oldRoleName = this.m_ns.getUnrootedName(oldRoleOE);
                            if (!newRoleName.equalsIgnoreCase(oldRoleName)) continue;
                            add = false;
                            break;
                        }
                        if (!add) continue;
                        updateRole = true;
                        rolesV.add(oldRole);
                    }
                    if (updateRole) {
                        Object[] roles = new RBSRole[rolesV.size()];
                        rolesV.copyInto(roles);
                        rbsTask.setContentMembership((RBSRole[])roles, this.dynamicGroupSearchType);
                        update = true;
                    }
                }
            }
        }
        if (update) {
            rbsTask.update();
        }
    }

    private NSObject createRBSBook(BookClassObject bookClassObject) throws SPIException, SnapinVetoException, ComponentCreationException, NamespaceException, RBSException, JDOMException, IOException {
        NSObject bookObj = null;
        String tempName = new String(bookClassObject.getName());
        String bookName = null;
        int indexOfDelemeter = tempName.indexOf(".");
        bookName = indexOfDelemeter != -1 ? tempName.substring(indexOfDelemeter + 1) : tempName;
        if (this.isLDAP) {
            bookName = "cn=".concat(bookName);
        }
        if (!this.m_ns.doesExist(this.rbsModuleOE, bookName)) {
            ValueComponent[] vals = new ValueComponent[1];
            ValueComponent[] nameVal = new ValueComponent[1];
            AttributeDefinition objClassAttrDef = this.m_ns.getAttributeDefinition(this.rbsModuleOE, SchemaUtil.translateNDAPAttr((ObjectEntry)this.rbsModuleOE, (String)"Object Class"));
            Syntax objClassSyn = objClassAttrDef.getSyntax();
            vals[0] = objClassSyn.createValueComponent((Object)"rbsBook2");
            ObjectAttribute attrObj = new ObjectAttribute(objClassAttrDef, vals);
            AttributeDefinition cnAttrDef = this.m_ns.getAttributeDefinition(this.rbsModuleOE, SchemaUtil.translateNDAPAttr((ObjectEntry)this.rbsModuleOE, (String)"CN"));
            Syntax cnSyn = cnAttrDef.getSyntax();
            nameVal[0] = cnSyn.createValueComponent((Object)bookName);
            ObjectAttribute objNameAttr = new ObjectAttribute(cnAttrDef, nameVal);
            Vector<ObjectAttribute> attrOV = new Vector<ObjectAttribute>();
            attrOV.addElement(attrObj);
            attrOV.addElement(objNameAttr);
            if (bookClassObject.getRequiredVersion().length() > 0 && InfoFactory.compareVersions(bookClassObject.getRequiredVersion(), iManager.getVersionString()) > 0) {
                return null;
            }
            if (bookClassObject.getExpiredVersion().length() > 0 && InfoFactory.compareVersions(bookClassObject.getExpiredVersion(), iManager.getVersionString()) <= 0) {
                return null;
            }
            ObjectEntry bookOE = this.m_ns.createObjectEntry(this.rbsModuleOE, bookName, "rbsBook2");
            bookObj = this.m_ns.createNSObject(bookOE, attrOV);
            this.m_ns.create(bookObj);
            this.updateRBSBook(bookObj, bookClassObject);
        } else {
            ObjectEntry bookOE = this.m_ns.getObjectEntry(this.rbsModuleOE, bookName);
            bookObj = this.m_ns.getDetails(bookOE);
            RBSBook rbsBook = new RBSBook(bookObj);
            String oldVersion = this.getVersionFromParameters(rbsBook.getParameters());
            this.reinstallModule = true;
            if (true || RBSUtil.isUpdateNeeded(oldVersion, bookClassObject.getVersion())) {
                this.updateRBSBook(bookObj, bookClassObject);
            }
        }
        return bookObj;
    }

    private void updateRBSModule(NSObject moduleObj) throws SPIException, SnapinVetoException, ComponentCreationException, NamespaceException, IOException, JDOMException {
        boolean update = false;
        RBSModule rbsModule = new RBSModule(moduleObj);
        if (this.moduleClassObject.getDescData().length() > 0) {
            rbsModule.setDescription(this.moduleClassObject.getDescData());
            update = true;
        }
        if (this.moduleClassObject.getVersion().length() > 0) {
            Element versionElement = new Element("version").addContent(this.moduleClassObject.getVersion());
            if (this.moduleClassObject.getCheckForUpdate().equalsIgnoreCase("yes")) {
                String versionNumber = versionElement.getTextTrim();
                VersionInfo versionInfo = new VersionInfo(versionNumber);
                versionInfo.setBuild(new Integer(1));
                versionNumber = versionInfo.getVersionString();
                versionElement.setText(versionNumber);
            }
            rbsModule.setrbsXMLInfo(versionElement);
            update = true;
        }
        if (this.moduleClassObject.getResourceBundle().length() > 0) {
            Element resourceBundleElement = new Element("resource-properties-file").addContent(this.moduleClassObject.getResourceBundle());
            rbsModule.setrbsXMLInfo(resourceBundleElement);
            update = true;
        }
        if (this.moduleClassObject.getDisplayNameKey().length() > 0) {
            Element displayNameKeyElement = new Element("display-name-key").addContent(this.moduleClassObject.getDisplayNameKey());
            rbsModule.setrbsXMLInfo(displayNameKeyElement);
            update = true;
        }
        if (this.moduleClassObject.getiManagerVersion().length() > 0) {
            Element iManagerVersion = new Element("last-updated-by-imanager-version").addContent(this.moduleClassObject.getiManagerVersion());
            rbsModule.setrbsXMLInfo(iManagerVersion);
            update = true;
        }
        if (this.moduleClassObject.getRBSXMLInfo() != null) {
            rbsModule.setrbsXMLInfo(this.moduleClassObject.getRBSXMLInfo());
            update = true;
        }
        if (this.moduleClassObject.getAuthAssignmentElement() != null) {
            Element iManagerElement = rbsModule.getrbsXMLInfo("imanager");
            if (iManagerElement == null) {
                iManagerElement = new Element("imanager").addContent(this.moduleClassObject.getAuthAssignmentElement());
            } else {
                Element authAssignment = iManagerElement.getChild("auth-assignment");
                if (authAssignment != null) {
                    iManagerElement.removeContent(authAssignment);
                }
                iManagerElement.addContent(this.moduleClassObject.getAuthAssignmentElement());
            }
            rbsModule.setrbsXMLInfo(iManagerElement);
            update = true;
        }
        if (update) {
            rbsModule.update();
        }
    }

    private void updateRBSBook(NSObject bookObj, BookClassObject bookClassObject) throws SPIException, SnapinVetoException, ComponentCreationException, NamespaceException, RBSException, JDOMException, IOException {
        Object[] rbsRoles;
        String[] removeRoleList;
        String[] roleList;
        RBSBook rbsBook;
        boolean addToRole;
        boolean update;
        block43: {
            RBSRights[] rights;
            SchemaDefinition schemaDef;
            ObjectEntry bookOE;
            block42: {
                String[] pageList;
                int i;
                Element[] authAssignmentElements;
                bookOE = bookObj.getObjectEntry();
                AdminNamespace namespace = bookOE.getAdminNamespace();
                schemaDef = namespace.getSchemaDefinition(bookOE);
                update = false;
                addToRole = true;
                rbsBook = new RBSBook(bookObj);
                if (bookClassObject.getClassPath().length() > 0) {
                    rbsBook.setEntryPoint(bookClassObject.getClassPath());
                    update = true;
                }
                if (bookClassObject.getParameters().length() > 0) {
                    rbsBook.setParameters(bookClassObject.getParameters());
                    update = true;
                }
                if (bookClassObject.getRBSXMLInfo() != null) {
                    rbsBook.setrbsXMLInfo(bookClassObject.getRBSXMLInfo());
                    update = true;
                }
                if ((authAssignmentElements = bookClassObject.getAuthAssignmentElement()) != null) {
                    Element iManagerElement = rbsBook.getrbsXMLInfo("imanager");
                    if (iManagerElement == null) {
                        iManagerElement = new Element("imanager");
                        for (int i2 = 0; i2 < authAssignmentElements.length; ++i2) {
                            iManagerElement.addContent(authAssignmentElements[i2]);
                        }
                    } else {
                        List authAssignmentList = iManagerElement.getChildren("auth-assignment");
                        if (authAssignmentList != null) {
                            for (i = 0; i < authAssignmentList.size(); ++i) {
                                Element authAssignmentElement = (Element)authAssignmentList.get(i);
                                iManagerElement.removeContent(authAssignmentElement);
                            }
                        }
                        for (i = 0; i < authAssignmentElements.length; ++i) {
                            iManagerElement.addContent(authAssignmentElements[i]);
                        }
                    }
                    rbsBook.setrbsXMLInfo(iManagerElement);
                    update = true;
                }
                if (bookClassObject.getDescData().length() > 0) {
                    rbsBook.setDescription(bookClassObject.getDescData());
                    update = true;
                }
                if (bookClassObject.getObjectClassType().length > 0) {
                    rbsBook.setTargetObjectType(bookClassObject.getObjectClassType());
                    update = true;
                }
                if ((pageList = bookClassObject.getPageList()) != null && pageList.length > 0) {
                    Vector<String> pagesV = new Vector<String>();
                    for (i = 0; i < pageList.length; ++i) {
                        boolean add = true;
                        RBSRights[] rights2 = FwUtils.getPagesRights(new String[]{pageList[i]}, this.treeOE);
                        if (rights2 != null) {
                            for (int j = 0; j < rights2.length; ++j) {
                                if (rights2[j].getProtectedAttrName().equalsIgnoreCase("[Entry Rights]") || rights2[j].getProtectedAttrName().equalsIgnoreCase("[All Attributes Rights]") || rights2[j].getProtectedAttrName().equalsIgnoreCase("[No Self Rights Assignment]") || schemaDef.isAttributeDefined(rights2[j].getProtectedAttrName())) continue;
                                D.log("--  Discarding page: " + pageList[i] + " in book: " + this.m_ns.getUnrootedName(bookOE) + " attribute undefined: " + rights2[j].getProtectedAttrName());
                                add = false;
                                break;
                            }
                        }
                        if (!add) continue;
                        pagesV.addElement(pageList[i]);
                    }
                    pageList = null;
                    if (pagesV.size() > 0) {
                        pageList = pagesV.toArray(new String[pagesV.size()]);
                        rbsBook.setPageMembership(pageList);
                        update = true;
                    } else {
                        rbsBook.setPageMembership(null);
                        rbsBook.setRights(null);
                        update = true;
                    }
                }
                if (pageList == null) break block42;
                RBSRights[] pageRights = FwUtils.getPagesRights(pageList, this.treeOE);
                if (pageRights == null || pageRights.length <= 0) break block43;
                rbsBook.setRights(pageRights);
                update = true;
                break block43;
            }
            String[] objectTypes = bookClassObject.getObjectClassType();
            if (objectTypes.length > 0 && objectTypes[0].equals("*") && (rights = bookClassObject.getRights()) != null && rights.length > 0) {
                rbsBook.setRights(rights);
                update = true;
                for (int i = 0; i < rights.length; ++i) {
                    if (rights[i].getProtectedAttrName().equalsIgnoreCase("[Entry Rights]") || rights[i].getProtectedAttrName().equalsIgnoreCase("[All Attributes Rights]") || rights[i].getProtectedAttrName().equalsIgnoreCase("[No Self Rights Assignment]") || schemaDef.isAttributeDefined(rights[i].getProtectedAttrName())) continue;
                    D.log("--  Discarding book: " + this.m_ns.getUnrootedName(bookOE) + " attribute undefined: " + rights[i].getProtectedAttrName());
                    addToRole = false;
                    break;
                }
            }
        }
        if (addToRole && (roleList = bookClassObject.getRoleList()) != null && roleList.length > 0) {
            Vector<RBSRole> rolesV = new Vector<RBSRole>();
            for (int j = 0; j < roleList.length; ++j) {
                NSObject roleObj = (NSObject)this.rbsRoleNSObjectTable.get(roleList[j]);
                if (roleObj != null) {
                    rolesV.add(new RBSRole(roleObj));
                    continue;
                }
                ObjectEntry oe = null;
                try {
                    oe = this.m_ns.getObjectEntry(this.rbsCollectionOE, roleList[j]);
                }
                catch (SPIException e) {
                    continue;
                }
                rolesV.add(new RBSRole(oe));
            }
            if (rolesV.size() > 0) {
                RBSRole[] currentRoles = rbsBook.getContentMembership();
                if (currentRoles == null) {
                    Object[] roles = new RBSRole[rolesV.size()];
                    rolesV.copyInto(roles);
                    rbsBook.setContentMembership((RBSRole[])roles, this.dynamicGroupSearchType);
                    update = true;
                } else {
                    boolean updateRole = false;
                    for (int i = 0; i < rolesV.size(); ++i) {
                        boolean add = true;
                        RBSRole newRole = (RBSRole)rolesV.elementAt(i);
                        ObjectEntry newRoleOE = newRole.getObjectEntry();
                        String newRoleName = this.m_ns.getUnrootedName(newRoleOE);
                        RBSRole oldRole = null;
                        for (int j = 0; j < currentRoles.length; ++j) {
                            oldRole = currentRoles[j];
                            ObjectEntry oldRoleOE = oldRole.getObjectEntry();
                            String oldRoleName = this.m_ns.getUnrootedName(oldRoleOE);
                            if (!newRoleName.equalsIgnoreCase(oldRoleName)) continue;
                            add = false;
                            break;
                        }
                        if (!add) continue;
                        updateRole = true;
                        rolesV.add(oldRole);
                    }
                    if (updateRole) {
                        Object[] roles = new RBSRole[rolesV.size()];
                        rolesV.copyInto(roles);
                        rbsBook.setContentMembership((RBSRole[])roles, this.dynamicGroupSearchType);
                        update = true;
                    }
                }
            }
        }
        if (update) {
            rbsBook.update();
        }
        if ((removeRoleList = bookClassObject.getUnassignRoleList()) != null && (rbsRoles = (rbsBook = new RBSBook(bookObj)).getContentMembership()) != null) {
            Vector<RBSRole> currentRoleV = new Vector<RBSRole>();
            for (int j = 0; j < rbsRoles.length; ++j) {
                currentRoleV.add(rbsRoles[j]);
            }
            Vector<ObjectEntry> removeRoleV = new Vector<ObjectEntry>();
            for (int i = 0; i < removeRoleList.length; ++i) {
                String roleName = removeRoleList[i];
                if (this.isLDAP) {
                    roleName = "cn=".concat(roleName);
                }
                try {
                    ObjectEntry roleOE = this.m_ns.getObjectEntry(this.rbsCollectionOE, roleName);
                    removeRoleV.add(roleOE);
                    continue;
                }
                catch (Exception exc) {
                    // empty catch block
                }
            }
            if (removeRoleV.size() > 0) {
                block15: for (int j = 0; j < removeRoleV.size(); ++j) {
                    ObjectEntry roleOE = (ObjectEntry)removeRoleV.get(j);
                    String roleName = this.m_ns.getUnrootedName(roleOE);
                    for (int i = 0; i < currentRoleV.size(); ++i) {
                        RBSRole rbsRole1 = (RBSRole)currentRoleV.get(i);
                        String roleName1 = this.m_ns.getUnrootedName(rbsRole1.getObjectEntry());
                        if (!roleName.equalsIgnoreCase(roleName1)) continue;
                        currentRoleV.remove(i);
                        continue block15;
                    }
                }
                rbsRoles = null;
                if (currentRoleV.size() > 0) {
                    rbsRoles = new RBSRole[currentRoleV.size()];
                    currentRoleV.copyInto(rbsRoles);
                }
                rbsBook.setContentMembership((RBSRole[])rbsRoles, this.dynamicGroupSearchType);
                rbsBook.update();
            }
        }
    }

    private void createAllTheCategories() throws SPIException, SnapinVetoException, ComponentCreationException, NamespaceException, IOException, JDOMException {
        Vector categoryList = this.moduleClassObject.getCategories();
        for (int i = 0; i < categoryList.size(); ++i) {
            CategoryClassObject cList = (CategoryClassObject)categoryList.elementAt(i);
            NSObject categoryObj = this.createRBSCategory(cList);
            this.rbsCategoryNSObjectTable.put(cList.getName(), categoryObj);
        }
    }

    private void createAllTheRoles() throws SPIException, SnapinVetoException, ComponentCreationException, NamespaceException, RBSException, IOException, JDOMException {
        Vector roleList = this.moduleClassObject.getRoles();
        for (int i = 0; i < roleList.size(); ++i) {
            RoleClassObject rList = (RoleClassObject)roleList.elementAt(i);
            NSObject roleObj = this.createRBSRole(rList);
            if (roleObj == null) continue;
            this.rbsRoleNSObjectTable.put(rList.getName(), roleObj);
        }
    }

    private NSObject createRBSRole(RoleClassObject roleClassObject) throws SPIException, SnapinVetoException, ComponentCreationException, NamespaceException, RBSException, IOException, JDOMException {
        String roleName = roleClassObject.getName();
        if (this.isLDAP) {
            roleName = "cn=".concat(roleName);
        }
        NSObject roleObj = null;
        ObjectEntry roleOE = null;
        if (!this.m_ns.doesExist(this.rbsCollectionOE, roleName)) {
            ValueComponent[] vals = new ValueComponent[1];
            ValueComponent[] nameVal = new ValueComponent[1];
            AttributeDefinition objClassAttrDef = this.m_ns.getAttributeDefinition(this.rbsCollectionOE, SchemaUtil.translateNDAPAttr((ObjectEntry)this.rbsCollectionOE, (String)"Object Class"));
            Syntax objClassSyn = objClassAttrDef.getSyntax();
            vals[0] = objClassSyn.createValueComponent((Object)"rbsRole2");
            ObjectAttribute attrObj = new ObjectAttribute(objClassAttrDef, vals);
            AttributeDefinition cnAttrDef = this.m_ns.getAttributeDefinition(this.rbsCollectionOE, SchemaUtil.translateNDAPAttr((ObjectEntry)this.rbsCollectionOE, (String)"CN"));
            Syntax cnSyn = cnAttrDef.getSyntax();
            nameVal[0] = cnSyn.createValueComponent((Object)roleName);
            ObjectAttribute objNameAttr = new ObjectAttribute(cnAttrDef, nameVal);
            Vector<ObjectAttribute> attrOV = new Vector<ObjectAttribute>();
            attrOV.addElement(attrObj);
            attrOV.addElement(objNameAttr);
            if (roleClassObject.getInitialVersion().length() > 0 && InfoFactory.compareVersions(roleClassObject.getInitialVersion(), iManager.getVersionString()) > 0) {
                return null;
            }
            if (roleClassObject.getExpiredVersion().length() > 0 && InfoFactory.compareVersions(roleClassObject.getExpiredVersion(), iManager.getVersionString()) <= 0) {
                return null;
            }
            roleOE = this.m_ns.createObjectEntry(this.rbsCollectionOE, roleName, "rbsRole2");
            roleObj = this.m_ns.createNSObject(roleOE, attrOV);
            this.m_ns.create(roleObj);
            this.updateRBSRole(roleObj, roleClassObject);
        } else {
            roleOE = this.m_ns.getObjectEntry(this.rbsCollectionOE, roleName);
            roleObj = this.m_ns.getDetails(roleOE);
            RBSRole rbsRole = new RBSRole(roleObj);
            String oldVersion = this.getVersionFromParameters(rbsRole.getParameters());
            this.reinstallModule = true;
            if (true || RBSUtil.isUpdateNeeded(oldVersion, roleClassObject.getVersion())) {
                this.updateRBSRole(roleObj, roleClassObject);
            }
        }
        return roleObj;
    }

    private void updateRBSRole(NSObject roleObj, RoleClassObject roleClassObject) throws SPIException, SnapinVetoException, ComponentCreationException, NamespaceException, RBSException, IOException, JDOMException {
        String[] categoryList;
        Element[] authAssignmentElements;
        boolean update = false;
        RBSRole rbsRole = new RBSRole(roleObj);
        if (roleClassObject.getDescData().length() > 0) {
            update = true;
            rbsRole.setDescription(roleClassObject.getDescData());
        }
        if (roleClassObject.getRBSXMLInfo() != null) {
            update = true;
            rbsRole.setrbsXMLInfo(roleClassObject.getRBSXMLInfo());
        }
        if ((authAssignmentElements = roleClassObject.getAuthAssignmentElement()) != null) {
            Element iManagerElement = rbsRole.getrbsXMLInfo("imanager");
            if (iManagerElement == null) {
                iManagerElement = new Element("imanager");
                for (int i = 0; i < authAssignmentElements.length; ++i) {
                    iManagerElement.addContent(authAssignmentElements[i]);
                }
            } else {
                int i;
                List authAssignmentList = iManagerElement.getChildren("auth-assignment");
                if (authAssignmentList != null) {
                    for (i = 0; i < authAssignmentList.size(); ++i) {
                        Element authAssignmentElement = (Element)authAssignmentList.get(i);
                        iManagerElement.removeContent(authAssignmentElement);
                    }
                }
                for (i = 0; i < authAssignmentElements.length; ++i) {
                    iManagerElement.addContent(authAssignmentElements[i]);
                }
            }
            rbsRole.setrbsXMLInfo(iManagerElement);
            update = true;
        }
        if (roleClassObject.getParameters().length() > 0) {
            update = true;
            rbsRole.setParameters(roleClassObject.getParameters());
        }
        if ((categoryList = roleClassObject.getCategoryList()) != null && categoryList.length > 0) {
            Vector<ObjectEntry> newCatOEV = new Vector<ObjectEntry>();
            for (int j = 0; j < categoryList.length; ++j) {
                NSObject categoryObj;
                String categoryName = categoryList[j];
                if (this.isLDAP) {
                    categoryName = "cn=".concat(categoryName);
                }
                if ((categoryObj = (NSObject)this.rbsCategoryNSObjectTable.get(categoryName)) != null) {
                    newCatOEV.add(categoryObj.getObjectEntry());
                    continue;
                }
                ObjectEntry oe = null;
                try {
                    oe = this.m_ns.getObjectEntry(this.rbsCollectionOE, categoryName);
                }
                catch (SPIException e) {
                    continue;
                }
                newCatOEV.add(oe);
            }
            if (newCatOEV.size() > 0) {
                ObjectEntry[] oldCategoryOE = rbsRole.getCategoryMembership();
                if (oldCategoryOE == null) {
                    Object[] categories = new ObjectEntry[newCatOEV.size()];
                    newCatOEV.copyInto(categories);
                    update = true;
                    rbsRole.setCategoryMembership((ObjectEntry[])categories);
                } else {
                    boolean updateNeeded = false;
                    for (int i = 0; i < oldCategoryOE.length; ++i) {
                        String oldName = this.m_ns.getUnrootedName(oldCategoryOE[i]);
                        boolean add = true;
                        for (int j = 0; j < newCatOEV.size(); ++j) {
                            add = true;
                            ObjectEntry oe = (ObjectEntry)newCatOEV.elementAt(j);
                            String newName = this.m_ns.getUnrootedName(oe);
                            if (!newName.equalsIgnoreCase(oldName)) continue;
                            add = false;
                            break;
                        }
                        if (!add) continue;
                        updateNeeded = true;
                        newCatOEV.add(oldCategoryOE[i]);
                    }
                    if (updateNeeded) {
                        Object[] categories = new ObjectEntry[newCatOEV.size()];
                        newCatOEV.copyInto(categories);
                        update = true;
                        rbsRole.setCategoryMembership((ObjectEntry[])categories);
                    }
                }
            }
        }
        if (update) {
            rbsRole.update();
        }
    }

    private void updateRBSCategory(NSObject categoryObj, CategoryClassObject categoryClassObject) throws SPIException, SnapinVetoException, ComponentCreationException, NamespaceException, IOException, JDOMException {
        boolean update = false;
        RBSCategory rbsCategory = new RBSCategory(categoryObj);
        if (categoryClassObject.getDescData().length() > 0) {
            update = true;
            rbsCategory.setDescription(categoryClassObject.getDescData());
        }
        if (categoryClassObject.getRBSXMLInfo() != null) {
            update = true;
            rbsCategory.setrbsXMLInfo(categoryClassObject.getRBSXMLInfo());
        }
        if (categoryClassObject.getAuthAssignmentElement() != null) {
            Element iManagerElement = rbsCategory.getrbsXMLInfo("imanager");
            if (iManagerElement == null) {
                iManagerElement = new Element("imanager").addContent(categoryClassObject.getAuthAssignmentElement());
            } else {
                Element authAssignment = iManagerElement.getChild("auth-assignment");
                if (authAssignment != null) {
                    iManagerElement.removeContent(authAssignment);
                }
                iManagerElement.addContent(categoryClassObject.getAuthAssignmentElement());
            }
            rbsCategory.setrbsXMLInfo(iManagerElement);
            update = true;
        }
        if (categoryClassObject.getParameters().length() > 0) {
            update = true;
            rbsCategory.setParameters(categoryClassObject.getParameters());
        }
        if (update) {
            TaskContext context;
            rbsCategory.update();
            HttpServletRequest req = AuthenticatorServlet.currentRequest();
            if (req != null && (context = eMFrameFactory.getTaskContext(req)) != null) {
                FwUtils.refreshCRTCategories(context);
            }
        }
    }

    private NSObject createRBSCategory(CategoryClassObject categoryClassObject) throws SPIException, SnapinVetoException, ComponentCreationException, NamespaceException, IOException, JDOMException {
        String categoryName = categoryClassObject.getName();
        if (this.isLDAP) {
            categoryName = "cn=".concat(categoryName);
        }
        NSObject categoryObj = null;
        ObjectEntry categoryOE = null;
        if (!this.m_ns.doesExist(this.rbsCollectionOE, categoryName)) {
            ValueComponent[] vals = new ValueComponent[1];
            ValueComponent[] nameVal = new ValueComponent[1];
            AttributeDefinition objClassAttrDef = this.m_ns.getAttributeDefinition(this.rbsCollectionOE, SchemaUtil.translateNDAPAttr((ObjectEntry)this.rbsCollectionOE, (String)"Object Class"));
            Syntax objClassSyn = objClassAttrDef.getSyntax();
            vals[0] = objClassSyn.createValueComponent((Object)"rbsCategory2");
            ObjectAttribute attrObj = new ObjectAttribute(objClassAttrDef, vals);
            AttributeDefinition cnAttrDef = this.m_ns.getAttributeDefinition(this.rbsCollectionOE, SchemaUtil.translateNDAPAttr((ObjectEntry)this.rbsCollectionOE, (String)"CN"));
            Syntax cnSyn = cnAttrDef.getSyntax();
            nameVal[0] = cnSyn.createValueComponent((Object)categoryName);
            ObjectAttribute objNameAttr = new ObjectAttribute(cnAttrDef, nameVal);
            Vector<ObjectAttribute> attrOV = new Vector<ObjectAttribute>();
            attrOV.addElement(attrObj);
            attrOV.addElement(objNameAttr);
            categoryOE = this.m_ns.createObjectEntry(this.rbsCollectionOE, categoryName, "rbsCategory2");
            categoryObj = this.m_ns.createNSObject(categoryOE, attrOV);
            this.m_ns.create(categoryObj);
            this.updateRBSCategory(categoryObj, categoryClassObject);
        } else {
            categoryOE = this.m_ns.getObjectEntry(this.rbsCollectionOE, categoryName);
            categoryObj = this.m_ns.getDetails(categoryOE);
            RBSCategory rbsCategory = new RBSCategory(categoryObj);
            String oldVersion = this.getVersionFromParameters(rbsCategory.getParameters());
            this.reinstallModule = true;
            if (true || RBSUtil.isUpdateNeeded(oldVersion, categoryClassObject.getVersion())) {
                this.updateRBSCategory(categoryObj, categoryClassObject);
            }
        }
        return categoryObj;
    }

    private String getVersionFromParameters(String paramStr) {
        Properties parameters = eMFrameUtils.parseParameters(paramStr, ";");
        return (String)parameters.get("version");
    }

    private void addAllTheBookAddOns() throws SPIException, SnapinVetoException, ComponentCreationException, NamespaceException {
        Vector bookAddOnList = this.moduleClassObject.getBookAddOns();
        for (int i = 0; i < bookAddOnList.size(); ++i) {
            BookAddOnClassObject bAddOnList = (BookAddOnClassObject)bookAddOnList.elementAt(i);
            this.addBookAddOn(bAddOnList);
        }
    }

    private void addBookAddOn(BookAddOnClassObject bAddOnList) throws SPIException, SnapinVetoException, ComponentCreationException, NamespaceException {
        String[] addOnBookPages;
        int j;
        boolean updateBook = false;
        String tempName = bAddOnList.getName();
        String addOnBookName = null;
        String moduleName = null;
        NSObject rbsAddOnBookObj = null;
        int indexOfDelemeter = tempName.indexOf(".");
        if (indexOfDelemeter != -1) {
            addOnBookName = tempName.substring(indexOfDelemeter + 1);
            moduleName = tempName.substring(0, indexOfDelemeter);
        }
        try {
            ObjectEntry moduleOE = this.m_ns.getObjectEntry(this.rbsCollectionOE, moduleName);
            ObjectEntry rbsAddOnBookOE = this.m_ns.getObjectEntry(moduleOE, addOnBookName);
            rbsAddOnBookObj = this.m_ns.getDetails(rbsAddOnBookOE);
        }
        catch (SPIException spie) {
            if (spie instanceof UniqueSPIException && spie.getErrorCode() == -601) {
                return;
            }
            D.log("SPIException: " + addOnBookName + ", " + spie.toString());
            throw spie;
        }
        RBSBook rbsBook = new RBSBook(rbsAddOnBookObj);
        String[] bookObjectTypes = rbsBook.getTargetObjectType();
        String[] addOnTypes = bAddOnList.getObjectClassType();
        for (int i = 0; i < addOnTypes.length; ++i) {
            String addOnType = addOnTypes[i];
            for (j = 0; j < bookObjectTypes.length; ++j) {
                if (addOnType.equals(bookObjectTypes[j])) continue;
                D.log("Object type " + addOnType + " does not exist for book " + addOnBookName);
                return;
            }
        }
        String[] pageList = rbsBook.getPageMemebership();
        Vector<String> bookPagesV = new Vector<String>();
        if (pageList != null && pageList.length > 0) {
            for (j = 0; j < pageList.length; ++j) {
                bookPagesV.add(pageList[j]);
            }
        }
        if ((addOnBookPages = bAddOnList.getPageList()) != null && addOnBookPages.length > 0) {
            for (int j2 = 0; j2 < addOnBookPages.length; ++j2) {
                if (bookPagesV.contains(addOnBookPages[j2])) continue;
                bookPagesV.add(addOnBookPages[j2]);
                updateBook = true;
            }
            if (updateBook) {
                pageList = bookPagesV.toArray(new String[bookPagesV.size()]);
                rbsBook.setPageMembership(pageList);
                RBSRights[] pageRights = FwUtils.getPagesRights(pageList, this.treeOE);
                if (pageRights != null && pageRights.length > 0) {
                    rbsBook.setRights(pageRights);
                }
                rbsBook.update();
            }
        }
    }
}

