/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw.util.infos;

import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.nds.TypedNameFacade;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectEntryEnumeration;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.fw.util.InfoFactory;
import com.novell.emframe.fw.util.infos.InfoLight;
import com.novell.emframe.fw.util.infos.RoleInfo;
import com.novell.emframe.fw.util.infos.TaskInfoLight;
import com.novell.rbs.NSModel;
import com.novell.rbs.RBSCollection;
import com.novell.rbs.RBSRole;
import java.util.ArrayList;
import java.util.Enumeration;

public class RoleInfoLight
extends InfoLight {
    ObjectEntry m_oe;
    ArrayList m_taskInfoLights = null;
    ArrayList m_categories = null;
    AdminNamespace m_ns = null;
    RBSRole m_rbsRole = null;
    String m_fulldn = null;
    boolean m_bAssigned = false;
    MContext m_context;

    public RoleInfoLight(ObjectEntry oe, RBSRole rbsRole, String fulldn, boolean assigned, MContext context) {
        this.m_context = context;
        this.m_bAssigned = assigned;
        this.m_rbsRole = rbsRole;
        this.m_ns = oe.getAdminNamespace();
        this.m_fulldn = fulldn;
        this.m_oe = oe;
        this.m_categories = new ArrayList();
        try {
            ObjectEntry[] categories = NSModel.getDN((ObjectEntry)this.m_oe, null, (String)"rbsCategoryMembership");
            if (categories != null) {
                for (int i = 0; i < categories.length; ++i) {
                    this.m_categories.add(categories[i]);
                }
            }
        }
        catch (Exception e) {
            D.log(e);
        }
    }

    public void addCategory(ObjectEntry oeCat) {
        if (oeCat != null) {
            boolean bExists = false;
            for (int i = 0; i < this.m_categories.size(); ++i) {
                if (!this.m_categories.get(i).equals(oeCat)) continue;
                bExists = true;
                break;
            }
            if (!bExists) {
                this.m_categories.add(oeCat);
            }
        }
    }

    public ArrayList getCategories() {
        return this.m_categories;
    }

    public RBSRole getRBSRole() {
        return this.m_rbsRole;
    }

    public String getId() {
        if (this.id == null) {
            this.id = this.m_oe.getName();
            if (this.id.startsWith("cn=")) {
                this.id = this.id.substring(this.id.indexOf("cn=") + "cn=".length());
            }
        }
        return this.id;
    }

    public ArrayList getContent() {
        if (this.m_taskInfoLights != null) {
            return this.m_taskInfoLights;
        }
        this.m_taskInfoLights = new ArrayList();
        try {
            Enumeration myenum = NSModel.getAttribute((ObjectEntry)this.m_oe, null, (String)"rbsContent");
            if (myenum != null) {
                while (myenum.hasMoreElements()) {
                    TypedNameFacade facade = (TypedNameFacade)((ValueList)myenum.nextElement()).createFacade();
                    ObjectEntry currentOE = this.m_ns.getObjectEntry(this.m_oe.getRoot(), facade.getObject());
                    this.m_taskInfoLights.add(new TaskInfoLight(this, currentOE, facade.getObject(), this.m_bAssigned, this.m_context));
                }
            }
        }
        catch (Exception e) {
            D.log(e);
        }
        return this.m_taskInfoLights;
    }

    public RoleInfo convert(MContext context) {
        return InfoFactory.createRoleInfo(this, context);
    }

    public ObjectEntry getObjectEntry() {
        return this.m_oe;
    }

    public boolean equals(Object obj) {
        return this.m_fulldn.equals(((RoleInfoLight)obj).m_fulldn);
    }

    public static ArrayList getRoles(RBSCollection collection) {
        ArrayList<RoleInfoLight> ret = new ArrayList<RoleInfoLight>();
        try {
            ObjectEntry oe = collection.getObjectEntry();
            AdminNamespace ns = oe.getAdminNamespace();
            ObjectEntryEnumeration children = ns.getChildren(oe);
            while (children.hasMoreElements()) {
                ObjectEntry childOe = (ObjectEntry)children.nextElement();
                if (!childOe.getObjectType().getName().equals("rbsRole2")) continue;
                ret.add(new RoleInfoLight(childOe, null, childOe.getFullName(), false, null));
            }
        }
        catch (Exception e) {
            D.log(e);
        }
        return ret;
    }
}

