/*
 * Decompiled with CFR 0.152.
 */
package com.novell.webaccess.common;

public class Variable {
    public static final int VT_NUMERIC = 0;
    public static final int VT_STRING = 1;
    public static final int VT_DATE = 2;
    private String m_strValue;

    public Variable(String str) {
        this.m_strValue = str;
    }

    public void setStringValue(String str) {
        this.m_strValue = str;
    }

    public String getStringValue() {
        return this.m_strValue;
    }

    public String toString() {
        return this.getStringValue();
    }

    public long getLongValue() {
        Long lValue = new Long(this.m_strValue);
        return lValue;
    }

    public double getDoubleValue() {
        Double dValue = new Double(this.m_strValue);
        return dValue;
    }

    public boolean isDouble() {
        if (!this.isNumeric()) {
            return false;
        }
        return this.m_strValue.indexOf(46) != -1;
    }

    public boolean isNumeric() {
        boolean bDot = false;
        int iLen = this.m_strValue.length();
        if (iLen == 0) {
            return false;
        }
        for (int i = 0; i < iLen; ++i) {
            char ch = this.m_strValue.charAt(i);
            if (i == 0 && ch == '-') continue;
            if (ch == '.') {
                if (bDot) {
                    return false;
                }
                bDot = true;
                continue;
            }
            if (ch != 'E' && ch != 'e' || i == iLen - 2) {
                // empty if block
            }
            if (ch <= '9' && ch >= '0') continue;
            return false;
        }
        return !bDot || iLen != 1;
    }

    public long compare(Variable var) {
        if (this.isNumeric() && var.isNumeric()) {
            try {
                return this.getLongValue() - var.getLongValue();
            }
            catch (NumberFormatException nfe) {
                double d1 = this.getDoubleValue();
                double d2 = var.getDoubleValue();
                if (d1 < d2) {
                    return -1L;
                }
                if (d1 > d2) {
                    return 1L;
                }
                return 0L;
            }
        }
        return this.m_strValue.compareTo(var.getStringValue());
    }

    public static double doArithmetic(Variable vOp1, char chOp, Variable vOp2) {
        double dResult = 0.0;
        if (vOp1 == null) {
            vOp1 = new Variable("0");
        }
        if (vOp2 == null) {
            vOp2 = new Variable("0");
        }
        if (vOp1.isNumeric() && vOp2.isNumeric()) {
            if (chOp == '+') {
                dResult = vOp1.getDoubleValue() + vOp2.getDoubleValue();
            } else if (chOp == '-') {
                dResult = vOp1.getDoubleValue() - vOp2.getDoubleValue();
            }
            if (chOp == '*') {
                dResult = vOp1.getDoubleValue() * vOp2.getDoubleValue();
            } else if (chOp == '/') {
                double dOp1 = vOp1.getDoubleValue();
                double dOp2 = vOp2.getDoubleValue();
                long lOp1 = (long)dOp1;
                long lOp2 = (long)dOp2;
                dResult = (double)lOp1 == dOp1 && (double)lOp2 == dOp2 ? (double)(lOp1 / lOp2) : dOp1 / dOp2;
            } else if (chOp == '%') {
                dResult = vOp1.getDoubleValue() % vOp2.getDoubleValue();
            }
        }
        return dResult;
    }
}

