/*
 * Decompiled with CFR 0.152.
 */
package com.novell.naudit.lcache;

import com.novell.naudit.lcache.ClientConnection;
import com.novell.naudit.lcache.Connection;
import com.novell.naudit.lcache.LogList;
import com.novell.naudit.lcache.MonitorCache;
import com.novell.naudit.security.provider.AuditPAProvider;
import com.novell.naudit.util.Constants;
import com.novell.naudit.util.Log;
import com.novell.naudit.util.LogEventConfig;
import com.novell.naudit.util.Semaphore;
import com.novell.naudit.util.Util;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.FilterInputStream;
import java.io.InterruptedIOException;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.nio.ByteBuffer;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;

public class LCache
extends Thread
implements Constants {
    public final String PRODUCT_SHORT_NAME = "jlcache";
    public final String PRODUCT_NAME = "Nsure Audit Cache";
    public final String PRODUCT_DESCRIPTION = "Provides caching services for log events (Java)";
    public final String PRODUCT_VERSION = "Revision:   1.00";
    private final int START_HEADER = 1972;
    private final int END_HEADER = 1975;
    public static Semaphore logListSem;
    public LogList logList = null;
    public static int LOG_LIST_STRUCT_SIZE;
    public String logCachePrefix = "lc";
    private boolean writeMagic = false;
    public static boolean exiting;

    public boolean addLogApp(Connection connection, String string, String string2, String string3, String string4) {
        if (Log.loglevel >= 3) {
            Log.log("jlcache", "addLogApp(" + string + ", " + string2 + ",...)");
        }
        LogList logList = new LogList();
        logListSem.acquire();
        LogList logList2 = this.logList;
        while (logList2 != null) {
            if (string.equalsIgnoreCase(logList2.appName) && string2.equalsIgnoreCase(logList2.host) && string3.equalsIgnoreCase(logList2.pemCertificate) && string4.equalsIgnoreCase(logList2.pemPrivateKey)) {
                logListSem.release();
                if (connection != null) {
                    connection.logListEntry = logList2;
                }
                return true;
            }
            logList2 = logList2.next;
        }
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            logList.magic = 16795468;
            logList.appName = string;
            logList.host = string2;
            logList.pemCertificate = string3;
            logList.pemPrivateKey = string4;
            logList.certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(Util.parseCertificate(string3).getBytes("UTF-8")));
            logList.certs = new X509Certificate[1];
            logList.certs[0] = logList.certificate;
            logList.pemPrivateKey = string4;
            KeyFactory keyFactory = KeyFactory.getInstance("RSA", new AuditPAProvider());
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(Util.getPrivateKeyDer(string4));
            logList.privateKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
            logList.path = this.getCachePath(logList);
            logList.file = new File(logList.path);
            int n = this.getMagicHeaderSize(string3, string4);
            if (logList.file.exists()) {
                if (logList.file.length() > 0L && logList.file.length() != (long)n) {
                    logList.nextCheck = System.currentTimeMillis();
                } else {
                    this.writeMagic = true;
                }
            } else {
                this.writeMagic = true;
            }
            logList.lockSem = new Semaphore(1);
            logList.handle = new RandomAccessFile(logList.file, "rw");
            if (this.writeMagic) {
                this.writeMagicHeader(logList);
            } else {
                logList.handle.seek(logList.handle.length());
            }
            if (this.logList != null) {
                logList2 = this.logList;
                while (logList2.next != null) {
                    logList2 = logList2.next;
                }
                logList2.next = logList;
            } else {
                this.logList = logList;
            }
            if (connection != null) {
                connection.logListEntry = logList;
            }
        }
        catch (Exception exception) {
            logListSem.release();
            Log.log("jlcache", "Exception adding log application, " + string + ": " + exception.getMessage());
            return false;
        }
        logListSem.release();
        return true;
    }

    public int getMagicHeaderSize(String string, String string2) {
        int n = 0;
        n += LOG_LIST_STRUCT_SIZE + string.length() + string2.length();
        return n += 6;
    }

    public void writeMagicHeader(LogList logList) throws Exception {
        ByteBuffer byteBuffer = ByteBuffer.allocate(LOG_LIST_STRUCT_SIZE - 4);
        RandomAccessFile randomAccessFile = logList.handle;
        int n = Util.getNativeInt(this.getMagicHeaderSize(logList.pemCertificate, logList.pemPrivateKey));
        byteBuffer.put(logList.appName.getBytes("UTF-8"));
        byteBuffer.position(255);
        byteBuffer.put(logList.host.getBytes("UTF-8"));
        randomAccessFile.seek(0L);
        randomAccessFile.writeInt(n);
        randomAccessFile.writeInt(Util.getNativeInt(16795468));
        randomAccessFile.write(byteBuffer.array());
        randomAccessFile.write(logList.pemCertificate.getBytes("UTF-8"));
        randomAccessFile.writeByte(0);
        randomAccessFile.write(logList.pemPrivateKey.getBytes("UTF-8"));
        randomAccessFile.writeByte(0);
    }

    private boolean initLogList() {
        if (Log.loglevel >= 3) {
            Log.log("jlcache", "initLogList()");
        }
        try {
            File file = new File(LogEventConfig.logCacheDir);
            if (file.exists()) {
                File[] fileArray = file.listFiles(new FilenameFilter(){

                    public boolean accept(File file, String string) {
                        return string.toLowerCase().startsWith(LCache.this.logCachePrefix);
                    }
                });
                File file2 = null;
                FilterInputStream filterInputStream = null;
                int n = 0;
                while (n < fileArray.length && !exiting) {
                    block18: {
                        try {
                            file2 = fileArray[n];
                            filterInputStream = new DataInputStream(new FileInputStream(file2));
                            if (Log.loglevel >= 4) {
                                Log.log("jlcache", "Loading cache file: " + file2.getAbsolutePath());
                            }
                            String string = new String();
                            String string2 = new String();
                            String string3 = new String();
                            String string4 = new String();
                            int n2 = Util.getBEIntFromNative(((DataInputStream)filterInputStream).readInt());
                            int n3 = Util.getBEIntFromNative(((DataInputStream)filterInputStream).readInt());
                            byte[] byArray = new byte[n2 - 4 - 4];
                            ((DataInputStream)filterInputStream).readFully(byArray);
                            string = Util.parseString(0, 255, byArray);
                            string2 = Util.parseString(255, 256, byArray);
                            string4 = Util.parseString(LOG_LIST_STRUCT_SIZE - 4, -1, byArray);
                            string3 = Util.parseString(1 + LOG_LIST_STRUCT_SIZE - 4 + string4.length(), -1, byArray);
                            while (filterInputStream.available() > 0) {
                                int n4 = Util.getBEIntFromNative(((DataInputStream)filterInputStream).readInt());
                                byte[] byArray2 = new byte[n4];
                                ((DataInputStream)filterInputStream).readFully(byArray2);
                            }
                            if (n3 == 16795468) {
                                this.addLogApp(null, string, string2, string4, string3);
                            } else {
                                if (Log.loglevel >= 4) {
                                    Log.log("jlcache", "Invalid protocol. Removing invalid cache file: " + file2.getAbsolutePath());
                                }
                                file2.delete();
                                file2 = null;
                            }
                        }
                        catch (OutOfMemoryError outOfMemoryError) {
                            if (filterInputStream != null) {
                                filterInputStream.close();
                            }
                            if (file2 != null) {
                                if (Log.loglevel >= 4) {
                                    Log.log("jlcache", "removing invalid cache file: " + file2.getAbsolutePath());
                                }
                                file2.delete();
                            }
                        }
                        catch (Exception exception) {
                            if (filterInputStream != null) {
                                filterInputStream.close();
                            }
                            if (file2 == null) break block18;
                            if (Log.loglevel >= 4) {
                                Log.log("jlcache", "removing invalid cache file: " + file2.getAbsolutePath());
                            }
                            file2.delete();
                        }
                    }
                    ++n;
                }
                return true;
            }
            Log.log("jlcache", "Cache directory doesn't exist: " + LogEventConfig.logCacheDir);
        }
        catch (Exception exception) {
            Log.log("jlcache", "Exception initiating log list: " + exception.getMessage());
        }
        return false;
    }

    private String getCachePath(LogList logList) throws Exception {
        String string = null;
        byte[] byArray = new byte[]{13, 10};
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        messageDigest.update(logList.appName.getBytes("UTF-8"));
        messageDigest.update(logList.host.getBytes("UTF-8"));
        messageDigest.update(logList.pemCertificate.getBytes("UTF-8"));
        messageDigest.update(logList.pemPrivateKey.getBytes("UTF-8"));
        byte[] byArray2 = messageDigest.digest();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < byArray2.length) {
            stringBuffer.append(Util.byteToHex(byArray2[n]));
            ++n;
        }
        string = LogEventConfig.logCacheDir + Constants.FILE_PATH_SEPARATOR + this.logCachePrefix + stringBuffer.toString();
        return string;
    }

    public void serverStartup() {
        try {
            byte[] byArray = new byte[]{127, 0, 0, 1};
            ServerSocket serverSocket = new ServerSocket(LogEventConfig.logCachePort, 0, InetAddress.getByAddress(byArray));
            while (!exiting) {
                try {
                    new ClientConnection(this, serverSocket.accept()).start();
                }
                catch (InterruptedIOException interruptedIOException) {
                    exiting = true;
                }
                catch (Exception exception) {
                    Log.log("jlcache", "Exception connecting with client: " + exception.getMessage());
                }
            }
            serverSocket.close();
        }
        catch (Exception exception) {
            Log.log("jlcache", "Exception opening listening socket: " + exception.getMessage());
            exiting = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) throws InterruptedException {
        block4: {
            block3: {
                LCache lCache = new LCache();
                try {
                    if (!LogEventConfig.readConfiguration(stringArray)) {
                        Log.log(lCache.PRODUCT_SHORT_NAME, "Error reading configuration file.");
                        Object var4_2 = null;
                        break block3;
                    }
                    logListSem = new Semaphore(1);
                    lCache.initLogList();
                    MonitorCache monitorCache = new MonitorCache(lCache);
                    monitorCache.start();
                    lCache.serverStartup();
                    break block4;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    exiting = true;
                    Thread.sleep(2000L);
                    throw throwable;
                }
            }
            exiting = true;
            Thread.sleep(2000L);
            return;
        }
        Object var4_3 = null;
        exiting = true;
        Thread.sleep(2000L);
    }

    static {
        LOG_LIST_STRUCT_SIZE = 1836;
        if (LogEventConfig.os.toLowerCase().indexOf("windows") != -1) {
            LOG_LIST_STRUCT_SIZE = 1844;
        }
        exiting = false;
    }
}

