/*
 * Decompiled with CFR 0.152.
 */
package com.novell.naudit.logevent;

import com.novell.naudit.logevent.LogEventException;
import com.novell.naudit.logevent.LogHandle;
import com.novell.naudit.logevent.Monitor;
import com.novell.naudit.security.provider.AuditPAProvider;
import com.novell.naudit.util.Constants;
import com.novell.naudit.util.Log;
import com.novell.naudit.util.LogEventConfig;
import com.novell.naudit.util.SLSConnection;
import com.novell.naudit.util.SLSException;
import com.novell.naudit.util.Semaphore;
import com.novell.naudit.util.Util;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.security.KeyFactory;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;

public class LogEvent
implements Constants {
    private final String PRODUCT_NAME = "Nsure Audit Platform Agent";
    private final String PRODUCT_VERSION = "$Revision:   1.40  $";
    private final String PRODUCT_SHORT_NAME = "jlogevent";
    public static boolean initialized = false;
    public static Semaphore cacheSem;
    private LogHandle logHandle = null;
    private long oldLogHandle;
    private static String long_white_space;
    private static String long_non_white_space;
    public static String LETestDefaultKey;

    public LogEvent() throws LogEventException {
        if (!initialized) {
            this.logInitialize();
        }
    }

    public void logOpen(String string, String string2, int n) throws LogEventException {
        Object object;
        Object object2;
        Object object3;
        if (!initialized) {
            this.logInitialize();
        }
        if ((n & 8) != 0) {
            this.logOpenSimple(string, string2, n);
            return;
        }
        this.logHandle = new LogHandle();
        this.logHandle.flags = n;
        this.logHandle.magic = 654645623;
        this.logHandle.timeout = 180;
        this.logHandle.primarySocket = null;
        this.logHandle.foSockets = new SLSConnection[LogEventConfig.logFOCount];
        this.logHandle.cacheSocket = null;
        this.logHandle.lock = new Semaphore(1);
        int n2 = 0;
        while (n2 < this.logHandle.foSockets.length) {
            this.logHandle.foSockets[n2] = null;
            ++n2;
        }
        long l = System.currentTimeMillis();
        this.logHandle.sessionId = (int)(l & 0xFFFFFFFFFFFFFFFFL);
        if (LogEventConfig.logDebug == -1) {
            this.logHandle.flags |= Integer.MIN_VALUE;
        }
        if (LogEventConfig.logSigned == 1) {
            this.logHandle.flags |= 0x20;
        }
        if ((n & 4) != 0) {
            try {
                object3 = new BufferedReader(new FileReader(string));
                object2 = new StringBuffer();
                while (((BufferedReader)object3).ready()) {
                    ((StringBuffer)object2).append(((BufferedReader)object3).readLine() + Util.NEW_LINE);
                }
                ((BufferedReader)object3).close();
                this.logHandle.pemCertificate = ((StringBuffer)object2).toString();
            }
            catch (IOException iOException) {
                this.logHandle.lastError = 14;
                LogEventException logEventException = new LogEventException("Error opening certificate file: " + string + Util.NEW_LINE + iOException.getMessage());
                logEventException.setErrorCode(14);
                throw logEventException;
            }
            try {
                object3 = new BufferedReader(new FileReader(string2));
                object2 = new StringBuffer();
                while (((BufferedReader)object3).ready()) {
                    ((StringBuffer)object2).append(((BufferedReader)object3).readLine());
                }
                ((BufferedReader)object3).close();
                this.logHandle.pemPrivateKey = ((StringBuffer)object2).toString();
            }
            catch (IOException iOException) {
                this.logHandle.lastError = 15;
                object2 = new LogEventException("Error opening private key file: " + string2 + Util.NEW_LINE + iOException.getMessage());
                ((LogEventException)object2).setErrorCode(15);
                throw object2;
            }
        }
        if ((n & 0x10) != 0) {
            try {
                this.logHandle.pemCertificate = Util.pemEncodeCertificate(string);
            }
            catch (Exception exception) {
                this.logHandle.lastError = 14;
                LogEventException logEventException = new LogEventException("Error creating pem encoded certificate: " + Util.NEW_LINE + exception.getMessage());
                logEventException.setErrorCode(14);
                throw logEventException;
            }
            try {
                this.logHandle.pemPrivateKey = Util.pemEncodePrivateKey(string2);
            }
            catch (Exception exception) {
                this.logHandle.lastError = 15;
                LogEventException logEventException = new LogEventException("Error creating pem encoded private key: " + Util.NEW_LINE + exception.getMessage());
                logEventException.setErrorCode(15);
                throw logEventException;
            }
        }
        if (string != null) {
            this.logHandle.pemCertificate = string;
            this.logHandle.pemPrivateKey = string2;
        } else {
            this.logHandle.pemCertificate = "";
            this.logHandle.pemPrivateKey = "";
        }
        try {
            object3 = CertificateFactory.getInstance("X.509");
            this.logHandle.certificate = (X509Certificate)((CertificateFactory)object3).generateCertificate(new ByteArrayInputStream(Util.parseCertificate(this.logHandle.pemCertificate).getBytes("UTF-8")));
            this.logHandle.certs = new X509Certificate[1];
            this.logHandle.certs[0] = this.logHandle.certificate;
            object2 = this.logHandle.certificate.getExtensionValue("2.16.840.1.113719.1.347.10.1");
            this.logHandle.appName = new String((byte[])object2, 4, ((Object)object2).length - 4);
        }
        catch (Exception exception) {
            this.logHandle.lastError = 16;
            object2 = new LogEventException("Error creating certificate: " + Util.NEW_LINE + exception.getMessage());
            ((LogEventException)object2).setErrorCode(16);
            throw object2;
        }
        try {
            object3 = KeyFactory.getInstance("RSA", new AuditPAProvider());
            object2 = new PKCS8EncodedKeySpec(Util.getPrivateKeyDer(this.logHandle.pemPrivateKey));
            this.logHandle.privateKey = ((KeyFactory)object3).generatePrivate((KeySpec)object2);
        }
        catch (Exception exception) {
            object2 = new LogEventException("Error creating certificate: " + Util.NEW_LINE + exception.getMessage());
            ((LogEventException)object2).setErrorCode(17);
            throw object2;
        }
        if ((n & 2) == 0 && !this.prepareCache()) {
            Log.log("jlogevent", "Failed to connect to cache for application " + this.logHandle.appName + ", DISABLING cache mode.");
            n |= 2;
        }
        int n3 = 0;
        object2 = "";
        boolean bl = false;
        try {
            this.logHandle.primarySocket = new SLSConnection(this.logHandle.certs, this.logHandle.privateKey, LogEventConfig.logHost, LogEventConfig.logEnginePort);
            this.logHandle.primarySocket.authenticate();
        }
        catch (SLSException sLSException) {
            n3 = sLSException.getErrorCode();
            object2 = sLSException.getMessage();
            bl = true;
        }
        catch (Exception exception) {
            n3 = 6;
            object2 = exception.getMessage();
            bl = true;
        }
        if (!bl) {
            return;
        }
        this.logHandle.lastError = n3;
        this.logHandle.useCache = true;
        this.logHandle.socketIndex = 1;
        this.logHandle.offlineTime = System.currentTimeMillis() + (long)LogEventConfig.logCheckInterval;
        Log.log("jlogevent", "Failing primary connection for application " + this.logHandle.appName + ".");
        int n4 = 0;
        while (n4 < LogEventConfig.logFOHost.length) {
            object = new ReconnectToServer(this.logHandle);
            if (((ReconnectToServer)object).connectFOServer(n4 + 2)) {
                this.logHandle.socketIndex = n4 + 2;
                this.logHandle.useCache = false;
                Log.log("jlogevent", "Switching application " + this.logHandle.appName + " to failover logging server, " + LogEventConfig.logFOHost[n4] + ".");
                return;
            }
            if (this.logHandle.foSockets[n4] != null) {
                this.logHandle.foSockets[n4].closeConnection();
                this.logHandle.foSockets[n4] = null;
            }
            object = null;
            ++n4;
        }
        if ((n & 2) != 0) {
            object = new LogEventException("Error connecting to log server and cache: " + Util.NEW_LINE + (String)object2);
            ((LogEventException)object).setErrorCode(n3);
            throw object;
        }
    }

    public boolean prepareCache() {
        try {
            cacheSem.acquire();
            int n = 0;
            while (n < 15) {
                try {
                    this.logHandle.cacheSocket = new Socket("127.0.0.1", LogEventConfig.logCachePort);
                    break;
                }
                catch (Exception exception) {
                    if (n == 0) {
                        this.logLoadCache();
                        Thread.sleep(10000L);
                    }
                    ++n;
                    this.logHandle.cacheSocket = null;
                }
            }
            if (this.logHandle.cacheSocket == null) {
                cacheSem.release();
                Log.log("jlogevent", "Unable to connect to lcache");
                return false;
            }
            cacheSem.release();
            DataInputStream dataInputStream = new DataInputStream(this.logHandle.cacheSocket.getInputStream());
            DataOutputStream dataOutputStream = new DataOutputStream(this.logHandle.cacheSocket.getOutputStream());
            int n2 = Util.getBEInt(dataInputStream.readInt());
            if (n2 < 1) {
                this.logHandle.cacheSocket.close();
                return false;
            }
            byte[] byArray = this.logHandle.appName.getBytes("UTF-8");
            byte[] byArray2 = LogEventConfig.logHost.getBytes("UTF-8");
            byte[] byArray3 = this.logHandle.pemCertificate.getBytes("UTF-8");
            byte[] byArray4 = this.logHandle.pemPrivateKey.getBytes("UTF-8");
            int n3 = byArray.length + byArray2.length + byArray3.length + byArray4.length + 4;
            dataOutputStream.writeInt(Util.getLEInt(n3));
            dataOutputStream.write(byArray);
            dataOutputStream.writeByte(0);
            dataOutputStream.write(byArray2);
            dataOutputStream.writeByte(0);
            dataOutputStream.write(byArray3);
            dataOutputStream.writeByte(0);
            dataOutputStream.write(byArray4);
            dataOutputStream.writeByte(0);
            dataOutputStream.flush();
            byte by = dataInputStream.readByte();
            if ((by & 1) == 0) {
                this.logHandle.cacheSocket.close();
                return false;
            }
            this.logHandle.cacheOut = dataOutputStream;
            this.logHandle.cacheIn = dataInputStream;
        }
        catch (Exception exception) {
            Log.log("jlogevent", "Exception while preparing cache: " + exception.getMessage());
            return false;
        }
        return true;
    }

    private void logLoadCache() {
        String string = System.getProperty("file.separator");
        String[] stringArray = new String[9];
        String string2 = System.getProperty("JAVA_HOME");
        if (string2 == null) {
            string2 = System.getProperty("java.home");
        }
        stringArray[0] = string2 + string + "bin" + string + "java";
        stringArray[1] = "-classpath";
        stringArray[2] = System.getProperty("java.class.path");
        stringArray[3] = "com.novell.naudit.lcache.LCache";
        stringArray[4] = "-port:" + LogEventConfig.logCachePort;
        stringArray[5] = "-slsport:" + LogEventConfig.logEnginePort;
        stringArray[6] = "-int:" + LogEventConfig.logCheckInterval;
        stringArray[7] = LogEventConfig.logCacheEncrypt ? "-s" : "-c";
        stringArray[8] = "-dir:" + LogEventConfig.logCacheDir;
        try {
            Runtime.getRuntime().exec(stringArray);
        }
        catch (Exception exception) {
            Log.log("jlogevent", "Exception startin lcache: " + exception.getMessage());
        }
    }

    public void logOpenSimple(String string, String string2, long l) {
    }

    public void logClose() {
        try {
            if (this.logHandle.primarySocket != null) {
                this.logHandle.primarySocket.closeConnection();
            }
            if (this.logHandle.foSockets != null) {
                int n = 0;
                while (n < this.logHandle.foSockets.length) {
                    if (this.logHandle.foSockets[n] != null) {
                        this.logHandle.foSockets[n].closeConnection();
                        this.logHandle.foSockets[n] = null;
                    }
                    ++n;
                }
            }
            this.closeCache();
        }
        catch (Exception exception) {}
    }

    private void closeCache() throws IOException {
        if (!this.sendCommandRequest(this.logHandle, 1, 81, 0)) {
            return;
        }
        this.flushClient(this.logHandle, 1);
        if (this.logHandle.cacheSocket != null && this.logHandle.cacheSocket.isConnected()) {
            this.logHandle.cacheSocket.close();
        }
    }

    public int logGetError() {
        return this.logHandle.lastError;
    }

    public boolean logEventDirect(String string, int n, int n2, int n3, int n4, String string2, String string3, int n5, int n6, int n7, int n8, byte[] byArray) {
        return this.logEventExt(string, n, n2, n3, n4, null, 0, null, 0, null, string2, string3, null, n5, n6, 0, n7, n8, byArray);
    }

    public boolean logEventExt(String string, int n, int n2, int n3, int n4, String string2, int n5, String string3, int n6, String string4, String string5, String string6, String string7, int n7, int n8, int n9, int n10, int n11, byte[] byArray) {
        Object object;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        byte[] byArray5 = null;
        byte[] byArray6 = null;
        byte[] byArray7 = null;
        byte[] byArray8 = null;
        int n20 = 0;
        boolean bl = false;
        try {
            byte[] byArray9;
            if (LogEventConfig.dropAllEvents) {
                return true;
            }
            if (this.logHandle == null) {
                return false;
            }
            if (n2 == 8 && (n4 & Integer.MIN_VALUE) != 0) {
                return true;
            }
            if (string5 != null && (string5 = string5.trim()).length() <= 0) {
                string5 = null;
            }
            if (string6 != null && (string6 = string6.trim()).length() <= 0) {
                string6 = null;
            }
            if (string7 != null && (string7 = string7.trim()).length() <= 0) {
                string7 = null;
            }
            if (string2 != null && (string2 = string2.trim()).length() <= 0) {
                string2 = null;
            }
            if (string3 != null && (string3 = string3.trim()).length() <= 0) {
                string3 = null;
            }
            if (string4 != null && (string4 = string4.trim()).length() <= 0) {
                string4 = null;
            }
            if ((n4 & 1) != 0 && !this.logHandle.useCache) {
                n12 |= 0x20;
            }
            if (string5 != null) {
                n12 |= 1;
                byArray3 = string5.getBytes("UTF-8");
                n14 = byArray3.length + 1;
                if (n14 > 255) {
                    if ((n4 & 0x40) != 0) {
                        this.logHandle.lastError = 1;
                        return false;
                    }
                    string5 = new String(byArray3, 0, 255, "UTF-8").trim();
                    n14 = (byArray3 = string5.getBytes("UTF-8")).length;
                    if (n14 < 255) {
                        ++n14;
                    }
                }
            } else {
                n14 = 0;
            }
            if (string6 != null) {
                n12 |= 2;
                byArray4 = string6.getBytes("UTF-8");
                n15 = byArray4.length + 1;
                if (n15 > 255) {
                    if ((n4 & 0x40) != 0) {
                        this.logHandle.lastError = 1;
                        return false;
                    }
                    string6 = new String(byArray4, 0, 255, "UTF-8").trim();
                    n15 = (byArray4 = string6.getBytes("UTF-8")).length;
                    if (n15 < 255) {
                        ++n15;
                    }
                }
            } else {
                n15 = 0;
            }
            if (string7 != null) {
                n12 |= 0x400;
                byArray5 = string7.getBytes("UTF-8");
                n16 = byArray5.length + 1;
                if (n16 > 255) {
                    if ((n4 & 0x40) != 0) {
                        this.logHandle.lastError = 1;
                        return false;
                    }
                    string7 = new String(byArray5, 0, 255, "UTF-8").trim();
                    n16 = (byArray5 = string7.getBytes("UTF-8")).length;
                    if (n16 < 255) {
                        ++n16;
                    }
                }
            } else {
                n16 = 0;
            }
            if (string2 != null) {
                n12 |= 0x80;
                byArray6 = string2.getBytes("UTF-8");
                n17 = byArray6.length + 1;
                if (n17 > 255) {
                    if ((n4 & 0x40) != 0) {
                        this.logHandle.lastError = 1;
                        return false;
                    }
                    string2 = new String(byArray6, 0, 255, "UTF-8").trim();
                    n17 = (byArray6 = string2.getBytes("UTF-8")).length;
                    if (n17 < 255) {
                        ++n17;
                    }
                }
            } else {
                n17 = 0;
            }
            if (string3 != null) {
                n12 |= 0x100;
                byArray7 = string3.getBytes("UTF-8");
                n18 = byArray7.length + 1;
                if (n18 > 255) {
                    if ((n4 & 0x40) != 0) {
                        this.logHandle.lastError = 1;
                        return false;
                    }
                    string3 = new String(byArray7, 0, 255, "UTF-8").trim();
                    n18 = (byArray7 = string3.getBytes("UTF-8")).length;
                    if (n18 < 255) {
                        ++n18;
                    }
                }
            } else {
                n18 = 0;
            }
            if (string4 != null) {
                n12 |= 0x200;
                byArray8 = string4.getBytes("UTF-8");
                n19 = byArray8.length + 1;
                if (n19 > 255) {
                    if ((n4 & 0x40) != 0) {
                        this.logHandle.lastError = 1;
                        return false;
                    }
                    string4 = new String(byArray8, 0, 255, "UTF-8").trim();
                    n19 = (byArray8 = string4.getBytes("UTF-8")).length;
                    if (n19 < 255) {
                        ++n19;
                    }
                }
            } else {
                n19 = 0;
            }
            if (n11 > 0) {
                n12 |= 0x10;
                if (n11 > 3072) {
                    if (LogEventConfig.allowBigData) {
                        n12 |= 0x40;
                        bl = true;
                        if (n11 > LogEventConfig.logMaxBigData) {
                            if ((n4 & 0x40) != 0) {
                                this.logHandle.lastError = 2;
                                return false;
                            }
                            n11 = LogEventConfig.logMaxBigData;
                        }
                    } else {
                        if ((n4 & 0x40) != 0) {
                            this.logHandle.lastError = 2;
                            return false;
                        }
                        n11 = 3072;
                    }
                }
            }
            if (string != null && (n13 = (byArray2 = string.getBytes("UTF-8")).length + 1 + this.logHandle.appName.length()) > 255) {
                if ((n4 & 0x40) != 0) {
                    this.logHandle.lastError = 3;
                    return false;
                }
                string = new String(byArray2, 0, 255 - this.logHandle.appName.length(), "UTF-8").trim();
                n13 = (byArray2 = string.getBytes("UTF-8")).length + this.logHandle.appName.length();
                if (n13 < 255) {
                    ++n13;
                }
            }
            object = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)object);
            int n21 = 0;
            int n22 = 20;
            int n23 = 84;
            dataOutputStream.writeInt(Util.getLEInt(n12));
            dataOutputStream.writeInt(Util.getLEInt(n13));
            dataOutputStream.writeInt(Util.getLEInt(n14));
            dataOutputStream.writeInt(Util.getLEInt(n15));
            dataOutputStream.writeInt(Util.getLEInt(n11));
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(Util.getLEInt((int)(System.currentTimeMillis() / 1000L)));
            dataOutputStream.writeInt(Util.getLEInt(this.logHandle.sequence));
            ++this.logHandle.sequence;
            dataOutputStream.writeInt(Util.getLEInt(n));
            dataOutputStream.writeInt(Util.getLEInt(n2));
            dataOutputStream.writeInt(Util.getLEInt(n3));
            dataOutputStream.writeInt(Util.getLEInt(n7));
            dataOutputStream.writeInt(Util.getLEInt(n8));
            dataOutputStream.writeInt(Util.getLEInt(n10));
            dataOutputStream.writeInt(Util.getLEInt(n17));
            dataOutputStream.writeInt(Util.getLEInt(n18));
            dataOutputStream.writeInt(Util.getLEInt(n19));
            dataOutputStream.writeInt(Util.getLEInt(n16));
            dataOutputStream.writeInt(Util.getLEInt(n9));
            dataOutputStream.writeInt(Util.getLEInt(n5));
            dataOutputStream.writeInt(Util.getLEInt(n6));
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(Util.getLEInt(this.logHandle.sessionId));
            dataOutputStream.write(this.logHandle.appName.getBytes("UTF-8"));
            dataOutputStream.write(byArray2, 0, (n13 -= this.logHandle.appName.length()) - 1);
            dataOutputStream.writeByte(0);
            if (string2 != null) {
                dataOutputStream.write(byArray6, 0, n17 - 1);
                dataOutputStream.writeByte(0);
            }
            if (string3 != null) {
                dataOutputStream.write(byArray7, 0, n18 - 1);
                dataOutputStream.writeByte(0);
            }
            if (string4 != null) {
                dataOutputStream.write(byArray8, 0, n19 - 1);
                dataOutputStream.writeByte(0);
            }
            if (string5 != null) {
                dataOutputStream.write(byArray3, 0, n14 - 1);
                dataOutputStream.writeByte(0);
            }
            if (string6 != null) {
                dataOutputStream.write(byArray4, 0, n15 - 1);
                dataOutputStream.writeByte(0);
            }
            if (string7 != null) {
                dataOutputStream.write(byArray5, 0, n16 - 1);
                dataOutputStream.writeByte(0);
            }
            if (n11 > 0 && !bl) {
                dataOutputStream.write(byArray, 0, n11);
            }
            byte[] byArray10 = ((ByteArrayOutputStream)object).toByteArray();
            n20 = ((ByteArrayOutputStream)object).size();
            this.logHandle.lock.acquire();
            if ((this.logHandle.flags & 0x20) != 0) {
                n12 |= 4;
                this.logHandle.signatureContext = Signature.getInstance("MD5withRSA");
                this.logHandle.signatureContext.initSign(this.logHandle.privateKey);
                this.logHandle.signatureContext.update(this.logHandle.signature);
                this.logHandle.signatureContext.update(byArray10, 4, n20 - 4);
                if (bl) {
                    this.logHandle.signatureContext.update(byArray, 0, n11);
                }
                this.logHandle.signature = this.logHandle.signatureContext.sign();
                this.logHandle.signatureSize = this.logHandle.signature.length;
                dataOutputStream.write(this.logHandle.signature);
                n20 += this.logHandle.signatureSize;
                byArray10 = ((ByteArrayOutputStream)object).toByteArray();
            }
            dataOutputStream.close();
            byte[] byArray11 = Util.getLEBytes(this.logHandle.signatureSize);
            byArray10[n22] = byArray11[3];
            byArray10[n22 + 1] = byArray11[2];
            byArray10[n22 + 2] = byArray11[1];
            byArray10[n22 + 3] = byArray11[0];
            int n24 = Util.getLocalIPAddress(this.logHandle.primarySocket);
            if (n24 != 0) {
                byArray9 = Util.getLEBytes(n24);
                byArray10[n23] = byArray9[3];
                byArray10[n23 + 1] = byArray9[2];
                byArray10[n23 + 2] = byArray9[1];
                byArray10[n23 + 3] = byArray9[0];
            }
            byArray9 = Util.getLEBytes(n12);
            byArray10[n21] = byArray9[3];
            byArray10[n21 + 1] = byArray9[2];
            byArray10[n21 + 2] = byArray9[1];
            byArray10[n21 + 3] = byArray9[0];
            if (!this.sendEvent(byArray10, n20, n11, bl, byArray, false)) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        if ((n4 & 1) != 0) {
            if (this.logHandle.socketIndex == 1) {
                this.logHandle.lastError = 13;
                this.logHandle.lock.release();
                return false;
            }
            byte by = 0;
            try {
                by = this.getClientByte(this.logHandle, this.logHandle.socketIndex);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!(by & true)) {
                this.logHandle.lastError = 12;
                this.logHandle.lock.release();
                return false;
            }
        }
        if (0L < this.logHandle.offlineTime && this.logHandle.offlineTime < System.currentTimeMillis()) {
            this.logHandle.lock.release();
            Log.log("jlogevent", "Attempting to re-establish connection to secure log server for application " + this.logHandle.appName + ".");
            object = new ReconnectToServer(this.logHandle);
            if ((this.logHandle.flags & 1) == 0) {
                ((ReconnectToServer)object).reconnect();
            } else {
                ((Thread)object).start();
            }
        } else {
            this.logHandle.lock.release();
        }
        return true;
    }

    private boolean sendEvent(byte[] byArray, int n, int n2, boolean bl, byte[] byArray2, boolean bl2) {
        boolean bl3 = true;
        try {
            bl3 = bl ? this.sendCommandRequest(this.logHandle, this.logHandle.socketIndex, 86, n + n2) : this.sendCommandRequest(this.logHandle, this.logHandle.socketIndex, 86, n);
            if (bl3) {
                bl3 = this.sendClient(this.logHandle, this.logHandle.socketIndex, byArray, 0, n);
                if (bl) {
                    bl3 = this.sendClient(this.logHandle, this.logHandle.socketIndex, byArray2, 0, n2);
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        if (!bl3 || !this.flushClient(this.logHandle, this.logHandle.socketIndex)) {
            switch (this.logHandle.socketIndex) {
                case 0: {
                    this.logHandle.offlineTime = System.currentTimeMillis() + (long)LogEventConfig.logCheckInterval;
                    if (this.logHandle.foSockets != null && this.logHandle.foSockets.length > 0) {
                        ReconnectToServer reconnectToServer = new ReconnectToServer(this.logHandle);
                        int n3 = 0;
                        while (n3 < this.logHandle.foSockets.length) {
                            if (this.logHandle.foSockets[n3] != null) {
                                this.logHandle.foSockets[n3].closeConnection();
                                this.logHandle.foSockets[n3] = null;
                            }
                            if (reconnectToServer.connectFOServer(n3 + 2)) {
                                this.logHandle.socketIndex = n3 + 2;
                                Log.log("jlogevent", "Switching application " + this.logHandle.appName + " to failover log server, " + LogEventConfig.logFOHost[n3] + ".");
                                return this.sendEvent(byArray, n, n2, bl, byArray2, bl2);
                            }
                            ++n3;
                        }
                        reconnectToServer = null;
                    }
                    this.logHandle.socketIndex = 1;
                    this.logHandle.useCache = true;
                    Log.log("jlogevent", "Switching application " + this.logHandle.appName + " to cache.");
                    return this.sendEvent(byArray, n, n2, bl, byArray2, bl2);
                }
                case 1: {
                    if (bl2 || (this.logHandle.flags & 2) != 0) {
                        Log.log("jlogevent", "All log channels have failed. Stopping logging of events for application " + this.logHandle.appName + ".");
                        this.logHandle.lastError = 11;
                        this.logHandle.lock.release();
                        return false;
                    }
                    if (!this.prepareCache()) {
                        Log.log("jlogevent", "Failed to connect to cache for application %s, DISABLING cache mode.");
                    }
                    return this.sendEvent(byArray, n, n2, bl, byArray2, true);
                }
            }
            this.logHandle.offlineTime = System.currentTimeMillis() + (long)LogEventConfig.logCheckInterval;
            ++this.logHandle.socketIndex;
            int n4 = this.logHandle.socketIndex;
            while (n4 < this.logHandle.foSockets.length + 2) {
                ReconnectToServer reconnectToServer;
                if (this.logHandle.foSockets[n4] != null) {
                    this.logHandle.foSockets[n4].closeConnection();
                    this.logHandle.foSockets[n4] = null;
                }
                if ((reconnectToServer = new ReconnectToServer(this.logHandle)).connectFOServer(n4)) {
                    this.logHandle.socketIndex = n4;
                    Log.log("jlogevent", "Switching application " + this.logHandle.appName + " to failover log server, " + LogEventConfig.logFOHost[n4 - 2] + ".");
                    return this.sendEvent(byArray, n, n2, bl, byArray2, bl2);
                }
                reconnectToServer = null;
                ++n4;
            }
            this.logHandle.socketIndex = 1;
            this.logHandle.useCache = true;
            Log.log("jlogevent", "Switching application " + this.logHandle.appName + " from failover log server to cache..");
            return this.sendEvent(byArray, n, n2, bl, byArray2, bl2);
        }
        return true;
    }

    private byte getClientByte(LogHandle logHandle, int n) throws Exception {
        switch (n) {
            case 0: {
                return logHandle.primarySocket.getByte();
            }
            case 1: {
                return logHandle.cacheIn.readByte();
            }
        }
        return logHandle.foSockets[n - 2].getByte();
    }

    private int getClientInt(LogHandle logHandle, int n) throws Exception {
        switch (n) {
            case 0: {
                return logHandle.primarySocket.getInt();
            }
            case 1: {
                return logHandle.cacheIn.readInt();
            }
        }
        return logHandle.foSockets[n - 2].getInt();
    }

    private boolean sendClient(LogHandle logHandle, int n, byte[] byArray) {
        try {
            switch (n) {
                case 0: {
                    logHandle.primarySocket.sendData(byArray);
                    break;
                }
                case 1: {
                    logHandle.cacheOut.write(byArray);
                    break;
                }
                default: {
                    logHandle.foSockets[n - 2].sendData(byArray);
                    break;
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private boolean sendClient(LogHandle logHandle, int n, byte[] byArray, int n2, int n3) {
        try {
            switch (n) {
                case 0: {
                    logHandle.primarySocket.sendData(byArray, n2, n3);
                    break;
                }
                case 1: {
                    logHandle.cacheOut.write(byArray, n2, n3);
                    break;
                }
                default: {
                    logHandle.foSockets[n - 2].sendData(byArray, n2, n3);
                    break;
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private boolean sendClient(LogHandle logHandle, int n, int n2) {
        try {
            switch (n) {
                case 0: {
                    logHandle.primarySocket.sendData(n2);
                    break;
                }
                case 1: {
                    logHandle.cacheOut.writeInt(n2);
                    break;
                }
                default: {
                    logHandle.foSockets[n - 2].sendData(n2);
                    break;
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private boolean sendCommandRequest(LogHandle logHandle, int n, int n2, int n3) {
        try {
            n2 = Util.getLEInt(n2);
            if (n3 != 0) {
                n3 = Util.getLEInt(n3);
            }
            switch (n) {
                case 0: {
                    logHandle.primarySocket.sendData(n2);
                    logHandle.primarySocket.sendData(n3);
                    break;
                }
                case 1: {
                    logHandle.cacheOut.writeInt(n2);
                    logHandle.cacheOut.writeInt(n3);
                    break;
                }
                default: {
                    logHandle.foSockets[n - 2].sendData(n2);
                    logHandle.foSockets[n - 2].sendData(n3);
                    break;
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private boolean flushClient(LogHandle logHandle, int n) {
        try {
            switch (n) {
                case 0: {
                    logHandle.primarySocket.flushData();
                    break;
                }
                case 1: {
                    this.logHandle.cacheOut.flush();
                    break;
                }
                default: {
                    logHandle.foSockets[n - 2].flushData();
                    break;
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public boolean logEventText(String string, int n, int n2, int n3, String string2, String string3) {
        return this.logEventExt(string, n, n2, 0, n3, null, 0, null, 0, null, string2, string3, null, 0, 0, 0, 0, 0, null);
    }

    public boolean logEventNameValue(String string, int n, int n2, int n3, String string2, int n4) {
        return this.logEventExt(string, n, n2, 0, n3, null, 0, null, 0, null, string2, null, null, n4, 0, 0, 0, 0, null);
    }

    public boolean logEventLong(String string, int n, int n2, int n3, int n4, int n5) {
        return this.logEventExt(string, n, n2, 0, n3, null, 0, null, 0, null, null, null, null, n4, n5, 0, 0, 0, null);
    }

    public boolean logEventRaw(String string, int n, int n2, int n3, int n4, int n5, byte[] byArray) {
        return this.logEventExt(string, n, n2, 0, n3, null, 0, null, 0, null, null, null, null, 0, 0, 0, n4, n5, byArray);
    }

    public boolean logAddMonitor(int n) {
        try {
            if (!this.sendCommandRequest(this.logHandle, 0, 68, n)) {
                this.logHandle.lastError = 6;
                return false;
            }
            this.flushClient(this.logHandle, 0);
            byte by = this.getClientByte(this.logHandle, 0);
            return (by & 1) != 0;
        }
        catch (Exception exception) {
            this.logHandle.lastError = 6;
            return true;
        }
    }

    public boolean logRemoveMonitor(int n) {
        try {
            if (!this.sendCommandRequest(this.logHandle, 0, 88, n)) {
                this.logHandle.lastError = 6;
                return false;
            }
            this.flushClient(this.logHandle, 0);
            byte by = this.getClientByte(this.logHandle, 0);
            return (by & 1) != 0;
        }
        catch (Exception exception) {
            this.logHandle.lastError = 6;
            return true;
        }
    }

    public boolean logRemoveMonitorList() {
        if (!this.sendCommandRequest(this.logHandle, 0, 83, 0)) {
            this.logHandle.lastError = 6;
            return false;
        }
        this.flushClient(this.logHandle, 0);
        try {
            byte by = this.getClientByte(this.logHandle, 0);
            return (by & 1) != 0;
        }
        catch (Exception exception) {
            this.logHandle.lastError = 6;
            return true;
        }
    }

    public Monitor logRequestMonitors() {
        if (!this.sendCommandRequest(this.logHandle, 0, 77, 0)) {
            this.logHandle.lastError = 6;
            return null;
        }
        this.flushClient(this.logHandle, 0);
        try {
            Monitor monitor = null;
            Monitor monitor2 = null;
            int n = this.logHandle.primarySocket.getInt();
            int n2 = 0;
            while (n2 < n) {
                int n3 = this.logHandle.primarySocket.getInt();
                int n4 = this.logHandle.primarySocket.getInt();
                if (monitor == null) {
                    monitor2 = monitor = new Monitor(n3, n4);
                } else {
                    Monitor monitor3 = new Monitor(n3, n4);
                    monitor2.setNext(monitor3);
                    monitor2 = monitor3;
                }
                ++n2;
            }
            return monitor;
        }
        catch (Exception exception) {
            this.logHandle.lastError = 6;
            return null;
        }
    }

    public int logRequestMonitorCount() {
        if (!this.sendCommandRequest(this.logHandle, 0, 77, 0)) {
            this.logHandle.lastError = 6;
            return -1;
        }
        this.flushClient(this.logHandle, 0);
        try {
            Object var1_1 = null;
            Object var2_3 = null;
            int n = this.logHandle.primarySocket.getInt();
            int n2 = 0;
            while (n2 < n) {
                int n3 = this.logHandle.primarySocket.getInt();
                int n4 = this.logHandle.primarySocket.getInt();
                ++n2;
            }
            return n;
        }
        catch (Exception exception) {
            this.logHandle.lastError = 6;
            return -1;
        }
    }

    private boolean logInitialize() {
        if (!LogEventConfig.readConfiguration(null)) {
            return false;
        }
        cacheSem = new Semaphore(1);
        initialized = true;
        Log.log("jlogevent", "Using primary Secure Log Server " + LogEventConfig.logHost + ".");
        return true;
    }

    public static void main(String[] stringArray) throws Exception {
        int n = -285278208;
        int n2 = 1;
        int n3 = 2;
        String string = System.getProperty("user.name");
        LogEvent logEvent = new LogEvent();
        logEvent.logOpen(LETestDefaultKey, LETestDefaultKey, 1);
        if (stringArray[0].compareToIgnoreCase("events") == 0) {
            logEvent.logEventDirect("main\\Informational", n + n2, 8, 0, 0, long_non_white_space, string, 0, 90, 0, 0, null);
            logEvent.logEventExt("main\\Informational", n + n2, 8, 0, 0, "Orignator", 1, "Target", 2, "SubTarget", long_non_white_space, "Event 2", "Text3", 0, 90, 3, 0, 0, null);
            logEvent.logEventExt("component" + long_non_white_space, n + n2, 8, 0, 0, "Orignator" + long_non_white_space, 1, "Target" + long_non_white_space, 2, "SubTarget" + long_non_white_space, "text1" + long_non_white_space, "Event 2" + long_non_white_space, "Text3" + long_non_white_space, 0, 90, 3, 0, 0, null);
            logEvent.logEventDirect("main\\Informational", n + n2, 8, 0, 0, string, "Event 3\t", 0, 90, 0, 0, null);
            logEvent.logEventDirect("main\\Informational", n + n2, 8, 0, 0, string, "Event 4\r\n", 0, 90, 0, 0, null);
            logEvent.logEventDirect("main\\Informational", n + n2, 8, 0, 0, string, "Event 5 ", 0, 90, 0, 0, null);
            logEvent.logEventDirect("main\\Informational", n + n2, 8, 0, 0, string, "Event 6    ", 0, 90, 0, 0, null);
            Thread.sleep(1000L);
        } else if (stringArray[0].compareToIgnoreCase("addmonitor") == 0) {
            logEvent.logAddMonitor(n + n2);
        } else if (stringArray[0].compareToIgnoreCase("requestmonitor") == 0) {
            int n4 = logEvent.logRequestMonitorCount();
            System.out.println("number of monitors: " + n4);
            Monitor monitor = logEvent.logRequestMonitors();
            while (monitor != null) {
                System.out.println("Monitor: " + monitor.getEventID() + " = " + monitor.getCount());
                monitor = monitor.getNext();
            }
        } else if (stringArray[0].compareToIgnoreCase("removemonitor") == 0) {
            logEvent.logRemoveMonitor(n + n2);
        } else if (stringArray[0].compareToIgnoreCase("removemonitorlist") == 0) {
            logEvent.logRemoveMonitorList();
        } else {
            System.out.println("nothing to do");
        }
        logEvent.logClose();
    }

    static {
        long_white_space = "very large test                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      nonwhitespaceattheend";
        long_non_white_space = "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890";
        LETestDefaultKey = "-----BEGIN RSA PRIVATE KEY-----\r\nMIIBOwIBAAJBAMFtOQpSLdxjE2mbX6wU0KmWauGgApmhl673roxibWyD6/HTfUBB\r\nIqkk68/sCJj1com6koaFUhxQxkgVVocaV58CAwEAAQJBALuzbw/Z8ZEVP+hSk4Pc\r\n6yQ2yF9MtFk7m4N57RNkDIWoylqpHeV0Kqxiaeil0C9jH4sQCGWqhJF0sKfEWrFI\r\ntUkCIQDs5RgYTWpPDivwaQL1OiONgUAXg326vYqw0l36iaDZtQIhANEGsCUwVpIJ\r\nzVeR81lZqYVNM2xZRN9Ki5x2z6R0tTCDAiA9mtooP8Gcq2/LxlNJmIP0YZ9cPgqt\r\nTGtLznk4FSBqXQIhAMysK9Z+WoZtKrBQrWQUM7XfPjcdwh6Ss9nlTLTPwotZAiBG\r\n66bDzC6iAhnveZBZYoUrbTqeB6LgwWQAxC5jj45miQ==\r\n-----END RSA PRIVATE KEY-----\r\n-----BEGIN CERTIFICATE-----\r\nMIIBlDCCAT6gAwIBAgIDAP/xMA0GCSqGSIb3DQEBBAUAMCoxCzAJBgNVBAYTAlVT\r\nMRswGQYDVQQDExJOb3ZlbGwgTlN1cmUgQXVkaXQwHhcNMDMwMzMxMTY0MzUwWhcN\r\nMTMwMzI4MTY0MzUwWjAeMQswCQYDVQQGEwJVUzEPMA0GA1UEAxMGbGV0ZXN0MFww\r\nDQYJKoZIhvcNAQEBBQADSwAwSAJBAMFtOQpSLdxjE2mbX6wU0KmWauGgApmhl673\r\nroxibWyD6/HTfUBBIqkk68/sCJj1com6koaFUhxQxkgVVocaV58CAwEAAaNZMFcw\r\nDgYDVR0PAQH/BAQDAgWgMBgGA1UdEQQRMA+BDWFyZ2xAYmxhaC5jb20wEQYJYIZI\r\nAYb4QgEBBAQDAgWgMBgGDGCGSAGG+DcBglsKAQQIFgZsZXRlc3QwDQYJKoZIhvcN\r\nAQEEBQADQQCIJ9xYG9WoLo4TOyrhfAZ0uf8DT5NnF47tvHA3IsNQsoqq77Z5YJxz\r\nThCSyKzkdeE8gSu5D/0ETruzQg1/X0WQ\r\n-----END CERTIFICATE-----\r\n";
    }

    class ReconnectToServer
    extends Thread {
        LogHandle handle = null;

        public ReconnectToServer(LogHandle logHandle) {
            this.handle = logHandle;
        }

        public void run() {
            this.reconnect();
        }

        /*
         * Unable to fully structure code
         */
        public boolean reconnect() {
            block8: {
                block9: {
                    try {
                        var1_1 = this.handle.socketIndex;
                        LogEvent.access$000((LogEvent)LogEvent.this).primarySocket = new SLSConnection(this.handle.certs, this.handle.privateKey, LogEventConfig.logHost, LogEventConfig.logEnginePort);
                        LogEvent.access$000((LogEvent)LogEvent.this).primarySocket.authenticate();
                        Log.log("jlogevent", "Application " + LogEvent.access$000((LogEvent)LogEvent.this).appName + " reconnected to Secure Logging Server.");
                        this.handle.offlineTime = 0L;
                        this.handle.socketIndex = 0;
                        if (var1_1 != 0 && var1_1 != 1) {
                            LogEvent.access$000((LogEvent)LogEvent.this).lock.acquire();
                            if (LogEvent.access$000((LogEvent)LogEvent.this).foSockets[var1_1 - 2] != null) {
                                LogEvent.access$000((LogEvent)LogEvent.this).foSockets[var1_1 - 2].closeConnection();
                                LogEvent.access$000((LogEvent)LogEvent.this).foSockets[var1_1 - 2] = null;
                            }
                            LogEvent.access$000((LogEvent)LogEvent.this).lock.release();
                        }
                        break block8;
                    }
                    catch (Exception var1_2) {
                        if (this.handle.socketIndex != 1) break block9;
                        var2_3 = 0;
                        ** while (var2_3 < LogEvent.access$000((LogEvent)LogEvent.this).foSockets.length)
                    }
lbl-1000:
                    // 1 sources

                    {
                        if (LogEvent.access$000((LogEvent)LogEvent.this).foSockets[var2_3] != null) {
                            LogEvent.access$000((LogEvent)LogEvent.this).foSockets[var2_3].closeConnection();
                            LogEvent.access$000((LogEvent)LogEvent.this).foSockets[var2_3] = null;
                        }
                        if (this.connectFOServer(var2_3 + 2)) {
                            LogEvent.access$000((LogEvent)LogEvent.this).socketIndex = var2_3 + 2;
                            Log.log("jlogevent", "Switching application " + LogEvent.access$000((LogEvent)LogEvent.this).appName + " to failover log server, " + LogEventConfig.logFOHost[var2_3] + ".");
                            break;
                        }
                        if (LogEvent.access$000((LogEvent)LogEvent.this).foSockets[var2_3] != null) {
                            LogEvent.access$000((LogEvent)LogEvent.this).foSockets[var2_3].closeConnection();
                            LogEvent.access$000((LogEvent)LogEvent.this).foSockets[var2_3] = null;
                        }
                        ++var2_3;
                        continue;
                    }
                }
                LogEvent.access$000((LogEvent)LogEvent.this).offlineTime = System.currentTimeMillis() + (long)LogEventConfig.logCheckInterval;
                return false;
            }
            return true;
        }

        public boolean connectFOServer(int n) {
            try {
                if (((LogEvent)LogEvent.this).logHandle.foSockets[n - 2] != null) {
                    ((LogEvent)LogEvent.this).logHandle.foSockets[n - 2].closeConnection();
                }
                ((LogEvent)LogEvent.this).logHandle.foSockets[n - 2] = new SLSConnection(this.handle.certs, this.handle.privateKey, LogEventConfig.logFOHost[n - 2], LogEventConfig.logEnginePort);
                ((LogEvent)LogEvent.this).logHandle.foSockets[n - 2].authenticate();
            }
            catch (Exception exception) {
                return false;
            }
            return true;
        }
    }
}

