/*
 * Decompiled with CFR 0.152.
 */
package com.novell.naudit.security.asn1;

import com.novell.naudit.security.asn1.ASN1OctetString;
import com.novell.naudit.security.asn1.ASN1OutputStream;
import com.novell.naudit.security.asn1.ASN1Sequence;
import com.novell.naudit.security.asn1.ASN1Set;
import com.novell.naudit.security.asn1.BERConstructedOctetString;
import com.novell.naudit.security.asn1.BEROutputStream;
import com.novell.naudit.security.asn1.BERSequence;
import com.novell.naudit.security.asn1.DEREncodable;
import com.novell.naudit.security.asn1.DEROutputStream;
import com.novell.naudit.security.asn1.DERTaggedObject;
import java.io.IOException;
import java.util.Enumeration;

public class BERTaggedObject
extends DERTaggedObject {
    public BERTaggedObject(int n, DEREncodable dEREncodable) {
        super(n, dEREncodable);
    }

    public BERTaggedObject(boolean bl, int n, DEREncodable dEREncodable) {
        super(bl, n, dEREncodable);
    }

    public BERTaggedObject(int n) {
        super(false, n, new BERSequence());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void encode(DEROutputStream dEROutputStream) throws IOException {
        if (dEROutputStream instanceof ASN1OutputStream || dEROutputStream instanceof BEROutputStream) {
            dEROutputStream.write(0xA0 | this.tagNo);
            dEROutputStream.write(128);
            if (!this.empty) {
                if (!this.explicit) {
                    if (this.obj instanceof ASN1OctetString) {
                        Enumeration enumeration;
                        if (this.obj instanceof BERConstructedOctetString) {
                            enumeration = ((BERConstructedOctetString)this.obj).getObjects();
                        } else {
                            ASN1OctetString aSN1OctetString = (ASN1OctetString)this.obj;
                            BERConstructedOctetString bERConstructedOctetString = new BERConstructedOctetString(aSN1OctetString.getOctets());
                            enumeration = bERConstructedOctetString.getObjects();
                        }
                        while (enumeration.hasMoreElements()) {
                            dEROutputStream.writeObject(enumeration.nextElement());
                        }
                    } else if (this.obj instanceof ASN1Sequence) {
                        Enumeration enumeration = ((ASN1Sequence)this.obj).getObjects();
                        while (enumeration.hasMoreElements()) {
                            dEROutputStream.writeObject(enumeration.nextElement());
                        }
                    } else {
                        if (!(this.obj instanceof ASN1Set)) throw new RuntimeException("not implemented: " + this.obj.getClass().getName());
                        Enumeration enumeration = ((ASN1Set)this.obj).getObjects();
                        while (enumeration.hasMoreElements()) {
                            dEROutputStream.writeObject(enumeration.nextElement());
                        }
                    }
                } else {
                    dEROutputStream.writeObject(this.obj);
                }
            }
            dEROutputStream.write(0);
            dEROutputStream.write(0);
            return;
        } else {
            super.encode(dEROutputStream);
        }
    }
}

