/*
 * Decompiled with CFR 0.152.
 */
package com.novell.naudit.util;

import com.novell.naudit.util.Constants;
import com.novell.naudit.util.Log;
import com.novell.naudit.util.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.Properties;

public class LogEventConfig
implements Constants {
    public static String LOGEVENT_CONFIG_FILE;
    public static String LOGEVENT_CONFIG_FILE_WINNT;
    public static String LOGEVENT_CONFIG_FILE_WINDOWS;
    public static String NAUDIT_TEMP_DIR;
    public static String os;
    public static final int CONTINUE_LOGGING = 0;
    public static final int STOP_LOGGING = 1;
    public static final int DROP_CACHE = 2;
    public static String logHost;
    public static String[] logFOHost;
    public static int logFOCount;
    public static String logCacheCredentials;
    public static String logCacheDir;
    public static int logCachePort;
    public static int logEnginePort;
    public static boolean allowUnload;
    public static boolean allowSSL;
    public static boolean logCacheEncrypt;
    public static boolean allowBigData;
    public static boolean logLocal;
    public static int logCheckInterval;
    public static int logDebug;
    public static int logSigned;
    public static int logMaxBigData;
    public static boolean dropAllEvents;
    public static long logMaxCacheSize;
    public static int logCacheLimitAction;

    public static boolean readConfiguration(String[] stringArray) {
        try {
            if (stringArray == null || stringArray.length < 1) {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(LOGEVENT_CONFIG_FILE)));
                while (bufferedReader.ready()) {
                    String string;
                    String string2 = bufferedReader.readLine().trim();
                    if (string2.startsWith("LogHost=")) {
                        string = string2.substring(8).trim();
                        if (string.equalsIgnoreCase("Not Configured")) {
                            dropAllEvents = true;
                            continue;
                        }
                        String[] stringArray2 = string.split(",");
                        logHost = stringArray2[0];
                        if (stringArray2.length <= 1) continue;
                        logFOHost = new String[stringArray2.length - 1];
                        int n = 1;
                        while (n < stringArray2.length) {
                            LogEventConfig.logFOHost[n - 1] = stringArray2[n];
                            ++logFOCount;
                            ++n;
                        }
                        continue;
                    }
                    if (string2.startsWith("LogCacheDir=")) {
                        logCacheDir = string2.substring(12);
                        continue;
                    }
                    if (string2.startsWith("LogEnginePort=")) {
                        logEnginePort = Integer.parseInt(string2.substring(14));
                        continue;
                    }
                    if (string2.startsWith("LogCachePort=")) {
                        logCachePort = Integer.parseInt(string2.substring(13));
                        continue;
                    }
                    if (string2.startsWith("LogCacheUnload=")) {
                        if (Character.toLowerCase(string2.charAt(15)) != 'n') continue;
                        allowUnload = false;
                        continue;
                    }
                    if (string2.startsWith("LogCacheSecure=")) {
                        if (Character.toLowerCase(string2.charAt(15)) == 'y') {
                            logCacheEncrypt = true;
                            continue;
                        }
                        logCacheEncrypt = false;
                        continue;
                    }
                    if (string2.startsWith("LogReconnectInterval=")) {
                        logCheckInterval = Integer.parseInt(string2.substring(21));
                        continue;
                    }
                    if (string2.startsWith("LogDebug=")) {
                        string = string2.substring(9).trim();
                        if (string.equalsIgnoreCase("never")) {
                            logDebug = -1;
                            continue;
                        }
                        if (string.equalsIgnoreCase("always")) {
                            logDebug = 1;
                            continue;
                        }
                        if (!string.equalsIgnoreCase("server")) continue;
                        logDebug = 0;
                        continue;
                    }
                    if (string2.startsWith("LogSigned=")) {
                        string = string2.substring(10).trim();
                        if (string.equalsIgnoreCase("never")) {
                            logSigned = -1;
                            continue;
                        }
                        if (string.equalsIgnoreCase("always")) {
                            logSigned = 1;
                            continue;
                        }
                        if (!string.equalsIgnoreCase("server")) continue;
                        logSigned = 0;
                        continue;
                    }
                    if (string2.startsWith("LogLocal=")) {
                        if (Character.toLowerCase(string2.charAt(9)) != 'y') continue;
                        logLocal = true;
                        continue;
                    }
                    if (string2.startsWith("LogMaxBigData=")) {
                        logMaxBigData = Integer.parseInt(string2.substring(14));
                        allowBigData = true;
                        continue;
                    }
                    if (string2.startsWith("LogMaxCacheSize=")) {
                        logMaxCacheSize = Long.parseLong(string2.substring(16));
                        continue;
                    }
                    if (string2.startsWith("LogCacheLimitAction=stop logging")) {
                        logCacheLimitAction = 1;
                        continue;
                    }
                    if (!string2.startsWith("LogCacheLimitAction=drop cache")) continue;
                    logCacheLimitAction = 2;
                }
                bufferedReader.close();
            } else {
                int n = 0;
                while (n < stringArray.length) {
                    if (stringArray[n].startsWith("-dir:")) {
                        logCacheDir = stringArray[n].substring(5);
                    } else if (stringArray[n].startsWith("-s")) {
                        logCacheEncrypt = true;
                    } else if (stringArray[n].startsWith("-c")) {
                        logCacheEncrypt = false;
                    } else if (stringArray[n].startsWith("-int:")) {
                        logCheckInterval = Integer.parseInt(stringArray[n].substring(5));
                        logCheckInterval *= 1000;
                    } else if (stringArray[n].startsWith("-port:")) {
                        logCachePort = Integer.parseInt(stringArray[n].substring(6));
                    } else if (stringArray[n].startsWith("-slsport:")) {
                        logEnginePort = Integer.parseInt(stringArray[n].substring(9));
                    } else if (stringArray[n].startsWith("-n")) {
                        allowUnload = false;
                    }
                    ++n;
                }
            }
            Util.makePath(logCacheDir);
            return true;
        }
        catch (Exception exception) {
            Log.log("LogEventConfig", "Exception reading configuration information: " + exception.getMessage());
            return false;
        }
    }

    static {
        block16: {
            LOGEVENT_CONFIG_FILE = "/etc/logevent.conf";
            LOGEVENT_CONFIG_FILE_WINNT = "c:\\WINNT\\logevent.cfg";
            LOGEVENT_CONFIG_FILE_WINDOWS = "c:\\Windows\\logevent.cfg";
            NAUDIT_TEMP_DIR = "/var/opt/novell/naudit/cache";
            os = System.getProperty("os.name");
            if (os.toLowerCase().indexOf("windows") != -1) {
                NAUDIT_TEMP_DIR = "/Program Files/Novell/Nsure Audit/cache";
            } else if (os.toLowerCase().indexOf("netware") != -1) {
                NAUDIT_TEMP_DIR = "sys:/etc/logcache";
            } else if (os.toLowerCase().indexOf("solaris") != -1) {
                NAUDIT_TEMP_DIR = "/opt/NOVLnaudit/cache";
            }
            if (os.toLowerCase().indexOf("windows") != -1) {
                try {
                    Process process = Runtime.getRuntime().exec("cmd /start /c set");
                    Properties properties = new Properties();
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    String string = null;
                    String string2 = null;
                    while ((string2 = bufferedReader.readLine()) != null) {
                        int n;
                        if (!string2.startsWith("SystemRoot") || (n = string2.indexOf("=")) == -1) continue;
                        string = string2.substring(++n).trim();
                        break;
                    }
                    LOGEVENT_CONFIG_FILE = string != null ? string + "\\logevent.cfg" : null;
                }
                catch (Exception exception) {
                    LOGEVENT_CONFIG_FILE = null;
                }
                if (LOGEVENT_CONFIG_FILE == null) {
                    try {
                        if (new File(LOGEVENT_CONFIG_FILE_WINNT).exists()) {
                            LOGEVENT_CONFIG_FILE = LOGEVENT_CONFIG_FILE_WINNT;
                            break block16;
                        }
                        if (new File(LOGEVENT_CONFIG_FILE_WINDOWS).exists()) {
                            LOGEVENT_CONFIG_FILE = LOGEVENT_CONFIG_FILE_WINDOWS;
                            break block16;
                        }
                        throw new Exception("Can't find logevent.cfg");
                    }
                    catch (Exception exception) {
                        Log.log("LogEventConfig", "Can't find logevent.cfg: " + exception.getMessage());
                    }
                }
            } else if (os.toLowerCase().indexOf("netware") != -1) {
                LOGEVENT_CONFIG_FILE = "sys:/etc/logevent.cfg";
            }
        }
        logHost = "127.0.0.1";
        logFOHost = new String[0];
        logFOCount = 0;
        logCacheDir = NAUDIT_TEMP_DIR;
        logCachePort = 288;
        logEnginePort = 289;
        allowUnload = true;
        allowSSL = true;
        logCacheEncrypt = false;
        allowBigData = false;
        logLocal = false;
        logCheckInterval = 120000;
        logDebug = 0;
        logSigned = 0;
        logMaxBigData = 0;
        dropAllEvents = false;
        logMaxCacheSize = -1L;
        logCacheLimitAction = 0;
    }
}

